/*
 * arch/ppc/common/misc-simple.c
 *
 * Misc. bootloader code for many machines.  This assumes you have are using
 * a 6xx/7xx/74xx CPU in your machine.  This assumes the chunk of memory
 * below 8MB is free.  Finally, it assumes you have a NS16550-style uart for
 * your serial console.  If a machine meets these requirements, it can quite
 * likely use this code during boot.
 *
 * Author: Matt Porter <mporter@mvista.com>
 * Derived from arch/ppc/boot/prep/misc.c
 *
 * 2001 (c) MontaVista, Software, Inc.  This file is licensed under
 * the terms of the GNU General Public License version 2.  This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/types.h>
#include <linux/elf.h>
#include <linux/config.h>

#include <asm/page.h>
#include <asm/processor.h>
#include <asm/mmu.h>
#include <asm/bootinfo.h>
#ifdef CONFIG_EBONY
#include <platforms/ebony.h>
#endif /* CONFIG_EBONY */
extern unsigned long timebase_period_ns;

#include "mpc10x.h"
#include "nonstdio.h"
#include "zlib.h"

/* Default cmdline */
#ifdef CONFIG_CMDLINE
#define CMDLINE CONFIG_CMDLINE
#else
#define CMDLINE ""
#endif

/* The linker tells us where the image is. */
extern char __image_begin, __image_end;
extern char __ramdisk_begin, __ramdisk_end;
extern char _end[];

/* Keyboard (and VGA console)? */
#ifdef CONFIG_VGA_CONSOLE
#define HAS_KEYB 1
#else
#define HAS_KEYB 0
#endif

/* Will / Can the user give input? */
#if (defined(CONFIG_SERIAL_CONSOLE) || defined(CONFIG_VGA_CONSOLE)) \
	&& !defined(CONFIG_GEMINI)
#define INTERACTIVE_CONSOLE	1
#endif

#ifdef FLASH_BOOT_IMAGE
#include "buffalo/firminfo.h"
#include "buffalo/ls_hwctl.h"
#define printk _printk
#define KERNEL_IMAGE_ADDRESS  0xffc00000
#define KERNEL_IMG_SIZE_MAX   0x00400000
#endif //#ifdef FLASH_BOOT_IMAGE
char *avail_ram;
char *end_avail;
char *zimage_start;
char cmd_preset[] = CMDLINE;
char cmd_buf[256];
char *cmd_line = cmd_buf;
int keyb_present = HAS_KEYB;
int zimage_size;

//unsigned long com_port;
unsigned long initrd_size = 0;

/* The linker tells us various locations in the image */
extern char __image_begin, __image_end;
extern char __ramdisk_begin, __ramdisk_end;
extern char _end[];
/* Original location */
extern unsigned long start;

extern int CRT_tstc(void);
extern unsigned long mpc10x_get_mem_size(int map);
extern unsigned long serial_init(void);
extern void serial_close(unsigned long com_port);
extern void gunzip(void *, int, unsigned char *, int *);
extern void serial_fixups(void);

unsigned long initrd_start = 0, initrd_end = 0;
extern unsigned long in_ledw(volatile unsigned long *addr);
extern void out_ledw(volatile unsigned long *addr, unsigned long val);


#ifdef FLASH_BOOT_IMAGE
struct firminfo* image_addr = (struct firminfo*)KERNEL_IMAGE_ADDRESS;

// `FbNTvZ
unsigned long checksum_check(unsigned char* addr,unsigned long size)
{
	long* laddr = (long*)addr;
	unsigned long sum = 0,remain = 0;
	int i;
	while(size>=4) {
		sum += *laddr;
		laddr++;
		size -= 4;
	}
	addr = (unsigned char*)laddr;
	for(i=0;i<4;++i) {
		remain = remain << 8;
		if(size>i) remain += *addr;
		addr++;
		}
	sum += remain;
	return sum;
}
#endif  //#ifdef FLASH_BOOT_IMAGE


//struct bi_record *
void
decompress_kernel(unsigned long load_addr, int num_words, unsigned long cksum)
{
#ifdef INTERACTIVE_CONSOLE
	char ch;
#endif
	int timer = 0;
	struct bi_record *rec;
	unsigned long initrd_loc, TotalMemory = 0;

#ifdef FLASH_BOOT_IMAGE
	struct firminfo* info;
#endif

//	serial_fixups();
//	com_port = serial_init(0, NULL);
//	com_port = serial_init();
//	com_port = 0x80004600;

#ifdef FLASH_BOOT_IMAGE

#if defined(CONFIG_HGLAN) || defined(CONFIG_HTGL)
	if (check_pci_device(11, VID_REALTEK, DID_RTL8110S, 0) != 0)
		if (check_pci_device(11, VID_REALTEK, DID_RTL8110S_NULL, 0) != 0)
			if (check_pci_device(11, 0xEC10, 0x6981, 0) != 0) {
				puts("not found RTL8110S!\n");
				while(1) outb(0x80004500, 0x6F);
			}
#else // HD-HLAN HD-LAN
	if (check_pci_device(11, VID_ADMTEK, DID_AN983B, 0) != 0)
			while(1) outb(0x80004500, 0x6F);
#endif // CONFIG_HLAN

#if defined(CONFIG_HTGL)
	if (check_pci_device(12, VID_ITE, DID_IT8211F, 0) != 0)
		while(1) outb(0x80004500, 0x6F);
	if (check_pci_device(13, VID_ITE, DID_IT8211F, 0) != 0)
		while(1) outb(0x80004500, 0x6F);

#else // HD-LAN/HD-HLAN/HD-HGLAN
	if (check_pci_device(12, VID_SiI, DID_SiI680, 0) != 0)
		while(1) outb(0x80004500, 0x6F);
#endif

#if defined(CONFIG_HGLAN) || defined(CONFIG_HLAN) || defined(CONFIG_HTGL)
	if ((check_pci_device(14, VID_NEC, DID_720101_U1, 0) != 0) ||
	    (check_pci_device(14, VID_NEC, DID_720101_U2, 2) != 0))
		while(1) outb(0x80004500, 0x6F);
#endif

#endif // FLASH_BOOT_IMAGE

#ifdef CONFIG_EBONY
	timebase_period_ns = 3;
	mtdcr(DCRN_MALCR(DCRN_MAL_BASE), MALCR_MMSR);			/* reset MAL */
	while (mfdcr(DCRN_MALCR(DCRN_MAL_BASE)) & MALCR_MMSR) {};	/* wait for reset */
	*(volatile unsigned long *)EBONY_EMAC0_MR0 = 0x20000000;	/* reset EMAC */
	__asm__ __volatile__("eieio");			/* enforce ordering */
#endif

#ifdef CONFIG_LOPEC
	/*
	 * This should work on any board with an MPC10X which is properly
	 * initalized.
	 */
	TotalMemory = mpc10x_get_mem_size(MPC10X_MEM_MAP_B);
#endif

	/* assume the chunk below 8M is free */
	avail_ram = (char *)0x00400000;
	end_avail = (char *)0x00800000;

	/*
	 * Reveal where we were loaded at and where we
	 * were relocated to.
	 */
	puts("loaded at:     "); puthex(load_addr);
	puts(" "); puthex((unsigned long)(load_addr + (4*num_words)));
	puts("\n");
	if ( (unsigned long)load_addr != (unsigned long)&start )
	{
		puts("relocated to:  "); puthex((unsigned long)&start);
		puts(" ");
		puthex((unsigned long)((unsigned long)&start + (4*num_words)));
		puts("\n");
	}

#ifdef FLASH_BOOT_IMAGE
  {
	int              i = 0;
	info = image_addr;
	_printk("\n******* Product Information *******\n");
	_printk("----------------------------------\n");

	_printk("Product Name: ");
	while(i<32 && info->firmname[i]!=0) {putc(info->firmname[i]);i++;}
	_printk("\n          VER: %d.%02d\n"  ,info->ver_major,info->ver_minor);
	_printk("         Date: %d/%d/%d %d:%d:%d\n",info->year+1900,info->mon,info->day,
												info->hour,info->min,info->sec);
	_printk("----------------------------------\n");
	
	_printk("Firmware check:");
	if (info->size < sizeof(struct firminfo*) 
			|| info->size > KERNEL_IMG_SIZE_MAX
			||  info->kernel_size < 1
			|| info->kernel_size>KERNEL_IMG_SIZE_MAX
			||  info->kernel_offset < sizeof(struct firminfo*)
			||  info->kernel_offset > KERNEL_IMG_SIZE_MAX
			||  (info->kernel_offset + info->kernel_size) > KERNEL_IMG_SIZE_MAX) {
		_printk("Fail!:invalid Firmware size\n");
#if defined(CONFIG_LAN)
		while(1) outb(0x80004500, 0x29);
#else // HD-HLAN/HD-HGLAN/HD-HTGL
		while(1) outb(0x80004500, 0x6B);
#endif
	}
	
	if (info->initrd_size < 1
			|| info->initrd_size > KERNEL_IMG_SIZE_MAX
			|| info->initrd_offset < (info->kernel_offset + info->kernel_size)
			|| info->initrd_offset > KERNEL_IMG_SIZE_MAX
			|| (info->initrd_offset + info->initrd_size) > KERNEL_IMG_SIZE_MAX) {
		_printk("Warning:invalid data size\n");
	}

	if (checksum_check((unsigned char*)info,info->size) != 0) {
		_printk("Fail!:checksum error %08X\n",checksum_check((unsigned char*)info,info->size));
		// warn_count = 2;
		//timer_proc = warning_led;
#if defined(CONFIG_LAN)
		while(1) outb(0x80004500, 0x2A);
#else // HD-HLAN/HD-HGLAN/HD-HTGL
		while(1) outb(0x80004500, 0x6B);
#endif
	}

	_printk("done.\n");
	zimage_start = (char*)info + info->kernel_offset;
	zimage_size  = (int)info->kernel_size;
	if (info->initrd_size > 0) {
		initrd_start = (unsigned long)((char*)info + info->initrd_offset);
		initrd_end   = initrd_start + info->initrd_size;
		if(initrd_start > 0xffc00000 && initrd_end<0xffefffff) {
			avail_ram = (char *)PAGE_ALIGN((unsigned long)_end);
			memcpy ((void *)avail_ram, (void *)initrd_start, info->initrd_size);
			initrd_start = (unsigned long)avail_ram;
			initrd_end = initrd_start + info->initrd_size;
		}
	} else {
		initrd_start = 0;
		initrd_end   = 0;
	}
  }
#else
	/* we have to subtract 0x10000 here to correct for objdump including
	   the size of the elf header which we strip -- Cort */
	puts("\n******* Kernel Information *******\n");
	zimage_start = (char *)(load_addr - 0x10000 + ZIMAGE_OFFSET);
	zimage_size = ZIMAGE_SIZE;

	if ( INITRD_OFFSET )
		initrd_start = load_addr - 0x10000 + INITRD_OFFSET;
	else
		initrd_start = 0;
	initrd_end = INITRD_SIZE + initrd_start;

	/*
	 * Find a place to stick the zimage and initrd and
	 * relocate them if we have to. -- Cort
	 */
	avail_ram = (char *)PAGE_ALIGN((unsigned long)_end);
	puts("zimage at:     "); puthex((unsigned long)zimage_start);
	puts(" "); puthex((unsigned long)(zimage_size+zimage_start)); puts("\n");
	if ( (unsigned long)zimage_start <= 0x00800000 )
	{
		memcpy( (void *)avail_ram, (void *)zimage_start, zimage_size );
		zimage_start = (char *)avail_ram;
		puts("relocated to:  "); puthex((unsigned long)zimage_start);
		puts(" ");
		puthex((unsigned long)zimage_size+(unsigned long)zimage_start);
		puts("\n");

		/* relocate initrd */
		if ( initrd_start )
		{
			puts("initrd at:     "); puthex(initrd_start);
			puts(" "); puthex(initrd_end); puts("\n");
			avail_ram = (char *)PAGE_ALIGN(
				(unsigned long)zimage_size+(unsigned long)zimage_start);
			memcpy ((void *)avail_ram, (void *)initrd_start, INITRD_SIZE );
			initrd_start = (unsigned long)avail_ram;
			initrd_end = initrd_start + INITRD_SIZE;
			puts("relocated to:  "); puthex(initrd_start);
			puts(" "); puthex(initrd_end); puts("\n");
		}
	} else if ( initrd_start ) {
		if ((unsigned long)zimage_start >= 0xffc00000) {	//	Flash rom boot
			memcpy( (void *)avail_ram, (void *)zimage_start, zimage_size );
			zimage_start = (char *)avail_ram;
			puts("relocated to:  "); puthex((unsigned long)zimage_start);
			puts(" ");
			puthex((unsigned long)zimage_size+(unsigned long)zimage_start);
			puts("\n");

			puts("initrd at:     "); puthex(initrd_start);
			puts(" "); puthex(initrd_end); puts("\n");

			avail_ram = (char *)PAGE_ALIGN(
				(unsigned long)zimage_size+(unsigned long)zimage_start);
			{
				int i;
				unsigned long image_size = INITRD_SIZE;
				unsigned long copy_size;
				unsigned long addr = initrd_start;
				#define	DATA_SIZE 0x100000
				
				for (image_size = INITRD_SIZE; image_size > 0;) {
					copy_size = image_size > DATA_SIZE?DATA_SIZE:image_size;
					memcpy ((void *)avail_ram, (void *)addr, copy_size);
					image_size -= copy_size;
					addr += copy_size;
					avail_ram += copy_size;
				}
				avail_ram = (char *)PAGE_ALIGN(
					(unsigned long)zimage_size+(unsigned long)zimage_start);
			}

			initrd_start = (unsigned long)avail_ram;
			initrd_end = initrd_start + INITRD_SIZE;
			puts("relocated to:  "); puthex(initrd_start);
			puts(" "); puthex(initrd_end); puts("\n");
		} else {
			puts("initrd at:     "); puthex(initrd_start);
			puts(" "); puthex(initrd_end); puts("\n");
		}
	}
	
#endif
	
	avail_ram = (char *)0x00400000;
	end_avail = (char *)0x00800000;

	/* Display standard Linux/PPC boot prompt for kernel args */
//	memcpy (cmd_line, cmd_preset, sizeof(cmd_preset));

	timer = 0;
	while (timer++ < 1500)
		udelay(10000);  /* 10 msec */
	puts("\n");

	puts("Now Loading...");
	gunzip(0, 0x400000, zimage_start, &zimage_size);
	puts("done.\n");
#if defined(CONFIG_HLAN) || defined(CONFIG_HGLAN) || defined(CONFIG_HTGL)
	// kernel load done.
	outb(0x80004500, 0x49); // send signal
	outb(0x80004500, 0x49); // send signal
	outb(0x80004500, 0x49); // send signal
	outb(0x80004500, 0x49); // send signal
#endif
#if defined(CONFIG_HGLAN)
	// full speed 
	udelay(10000);  /* 10 msec */
	outb(0x80004500, 0x5D); // send signal
	outb(0x80004500, 0x5D); // send signal
	outb(0x80004500, 0x5D); // send signal
	outb(0x80004500, 0x5D); // send signal
#endif
#if defined(CONFIG_HTGL)
	// LINK/ACT led controll
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x39); // 9
	outb(0x80004500, 0x31); // 1
	outb(0x80004500, 0x39); // 9
	outb(0x80004500, 0x30); // 0
	outb(0x80004500, 0x92); // 1000Mbps down
	outb(0x80004500, 0x92); // 1000Mbps down

	udelay(10000);  /* 10 msec */
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x39); // 9
	outb(0x80004500, 0x30); // 0
	outb(0x80004500, 0x39); // 9
	outb(0x80004500, 0x30); // 0
	outb(0x80004500, 0x90); // 100Mbps down
	outb(0x80004500, 0x90); // 100Mbps down

	udelay(10000);  /* 10 msec */
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x61); // a
	outb(0x80004500, 0x38); // 8
	outb(0x80004500, 0x46); // F
	outb(0x80004500, 0x39); // 9
	outb(0x80004500, 0x30); // 0
	outb(0x80004500, 0x8E); // 10Mbps down
	outb(0x80004500, 0x8E); // 10Mbps down

	udelay(10000);  /* 10 msec */
	outb(0x80004500, 0x5F); // _
	outb(0x80004500, 0x5F); // _
#endif

	puts("Now Booting\n");

#if 0
	/*
	 * We link ourself to 0x00800000.  When we run, we relocate
	 * ourselves there.  So we just need __image_begin for the
	 * start. -- Tom
	 */
	zimage_start = (char *)(unsigned long)(&__image_begin);
	zimage_size = (unsigned long)(&__image_end) -
			(unsigned long)(&__image_begin);

	initrd_size = (unsigned long)(&__ramdisk_end) -
		(unsigned long)(&__ramdisk_begin);

	/*
	 * The zImage and initrd will be between start and _end, so they've
	 * already been moved once.  We're good to go now. -- Tom
	 */
	avail_ram = (char *)PAGE_ALIGN((unsigned long)_end);
	puts("zimage at:     "); puthex((unsigned long)zimage_start);
	puts(" "); puthex((unsigned long)(zimage_size+zimage_start));
	puts("\n");

	if ( initrd_size ) {
		puts("initrd at:     ");
		puthex((unsigned long)(&__ramdisk_begin));
		puts(" "); puthex((unsigned long)(&__ramdisk_end));puts("\n");
	}

	avail_ram = (char *)0x00400000;
	end_avail = (char *)0x00800000;
	puts("avail ram:     "); puthex((unsigned long)avail_ram); puts(" ");
	puthex((unsigned long)end_avail); puts("\n");

	if (keyb_present)
		CRT_tstc();  /* Forces keyboard to be initialized */
#ifdef CONFIG_GEMINI
	/*
	 * If cmd_line is empty and cmd_preset is not, copy cmd_preset
	 * to cmd_line.  This way we can override cmd_preset with the
	 * command line from Smon.
	 */

	if ( (cmd_line[0] == '\0') && (cmd_preset[0] != '\0'))
		memcpy (cmd_line, cmd_preset, sizeof(cmd_preset));
#endif

	/* Display standard Linux/PPC boot prompt for kernel args */
	puts("\nLinux/PPC load: ");
	cp = cmd_line;
	memcpy (cmd_line, cmd_preset, sizeof(cmd_preset));
	while ( *cp ) putc(*cp++);

#ifdef INTERACTIVE_CONSOLE
	/*
	 * If they have a console, allow them to edit the command line.
	 * Otherwise, don't bother wasting the five seconds.
	 */

	/* discard any leftover characters */
	while (tstc())
		(void) getc();

	while (timer++ < 5*1000) {
		if (tstc()) {
			while ((ch = getc()) != '\n' && ch != '\r') {
				/* Test for backspace/delete */
				if (ch == '\b' || ch == '\177') {
					if (cp != cmd_line) {
						cp--;
						puts("\b \b");
					}
				/* Test for ^x/^u (and wipe the line) */
				} else if (ch == '\030' || ch == '\025') {
					while (cp != cmd_line) {
						cp--;
						puts("\b \b");
					}
				} else {
					*cp++ = ch;
					putc(ch);
				}
			}
			break;  /* Exit 'timer' loop */
		}
		udelay(1000);  /* 1 msec */
	}
	*cp = 0;
#endif
	puts("\n");

	puts("Uncompressing Linux...");
	gunzip(0, 0x400000, zimage_start, &zimage_size);
	puts("done.\n");

	/* get the bi_rec address */
	rec = bootinfo_addr(zimage_size);

	puts("Now Booting\n");

	/* We need to make sure that the initrd and bi_recs do not
	 * overlap. */
	if ( initrd_size ) {
		unsigned long rec_loc = (unsigned long) rec;
		initrd_loc = (unsigned long)(&__ramdisk_begin);
		/* If the bi_recs are in the middle of the current
		 * initrd, move the initrd to the next MB
		 * boundary. */
		if ((rec_loc > initrd_loc) &&
				((initrd_loc + initrd_size) > rec_loc)) {
			initrd_loc = _ALIGN((unsigned long)(zimage_size)
					+ (2 << 20) - 1, (2 << 20));
		 	memmove((void *)initrd_loc, &__ramdisk_begin,
				 initrd_size);
	         	puts("initrd moved:  "); puthex(initrd_loc);
		 	puts(" "); puthex(initrd_loc + initrd_size);
		 	puts("\n");
		}
	}

	bootinfo_init(rec);
	if ( TotalMemory )
		bootinfo_append(BI_MEMSIZE, sizeof(int), (void*)&TotalMemory);

	bootinfo_append(BI_CMD_LINE, strlen(cmd_line)+1, (void*)cmd_line);

	/* add a bi_rec for the initrd if it exists */
	if (initrd_size) {
		unsigned long initrd[2];

		initrd[0] = initrd_loc;
		initrd[1] = initrd_size;

		bootinfo_append(BI_INITRD, sizeof(initrd), &initrd);
	}
	puts("Now booting the kernel\n");
	serial_close(com_port);

	return rec;
#endif

}

#if 0
/* Allow decompress_kernel to be hooked into.  This is the default. */
void * __attribute__ ((weak))
load_kernel(unsigned long load_addr, int num_words, unsigned long cksum)
{
	return decompress_kernel(load_addr, num_words, cksum);
}
#endif

// PCIRtBO[VԂɃANZXAhX
#define PCI_CONFIG_ADDR		0xFEC00000
#define PCI_CONFIG_DATA		0xFEE00000

int check_pci_device(int idsel, unsigned short vid, unsigned short did, int fn) 
{
/*  w肵IDSELPCIfoCXVnedorIDDeviceIDmFB
 *  v0, sv-1Ԃ
 */ 

	unsigned int offset;
	unsigned long base, in_reg;

	base = (0x80 << 24) + (idsel << 11) + (fn << 8);

	out_ledw((unsigned long *)PCI_CONFIG_ADDR, base);
	in_reg = in_ledw((unsigned long *)PCI_CONFIG_DATA);

	if ((did == (unsigned short)(in_reg >> 16)) && 
		(vid == (unsigned short)(in_reg & 0x0000ffff)))
		return 0;
	else
		return -1;
}

// input DWORD data (little endian)
inline unsigned long in_ledw(volatile unsigned long *addr)
{ 
	unsigned long ret;

	__asm__ __volatile__("lwbrx %0,0,%1; eieio" : "=r" (ret) :
			     "r" (addr), "m" (*addr));
	return ret;
}

// output DWORD data (little endian)
inline void out_ledw(volatile unsigned long *addr, unsigned long val)
{ 
	__asm__ __volatile__("stwbrx %1,0,%2; eieio" : "=m" (*addr) :
			     "r" (val), "r" (addr));
}
