/*
 * COM1 NS16550 support
 */

#include <linux/config.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#include <asm/serial.h>

#include "../../platforms/linkstation/sandpoint_serial.h"

//#define SERIAL_BAUD	9600
#define SERIAL_BAUD0	57600
#define SERIAL_BAUD1	9600
#define COM_CONSOLE 0
#define COM_AVR     1

extern void outb(int port, unsigned char val);
extern unsigned char inb(int port);
extern unsigned long ISA_io;

struct serial_state rs_table[RS_TABLE_SIZE] = {
	SERIAL_PORT_DFNS	/* Defined in <asm/serial.h> */
};

static int shift;

//unsigned long serial_init(int chan, void *ignored)
unsigned long serial_init(void)
{
	return ((unsigned long)SANDPOINT_SERIAL_1);

#if 0
	unsigned long com_port;
	unsigned char lcr, dlm;
#if 0
	/* We need to find out which type io we're expecting.  If it's
	 * 'SERIAL_IO_PORT', we get an offset from the isa_io_base.
	 * If it's 'SERIAL_IO_MEM', we can the exact location.  -- Tom */
	switch (rs_table[chan].io_type) {
		case SERIAL_IO_PORT:
			com_port = rs_table[chan].port;
			break;
		case SERIAL_IO_MEM:
			com_port = (unsigned long)rs_table[chan].iomem_base;
			break;
		default:
			/* We can't deal with it. */
			return -1;
	}
#endif
	if (chan == 0)
		com_port = (unsigned long)SANDPOINT_SERIAL_0;
	else
		com_port = (unsigned long)SANDPOINT_SERIAL_1;

	/* How far apart the registers are. */
	shift = rs_table[chan].iomem_reg_shift;

	/* save the LCR */
	lcr = inb(com_port + UART_LCR);
	/* Access baud rate */
	dlm = inb(com_port + UART_DLM);
	/*
	 * Test if serial port is unconfigured.
	 * We assume that no-one uses less than 110 baud or
	 * less than 7 bits per character these days.
	 *  -- paulus.
	 */

	if ((dlm <= 4) && (lcr & 2))
		/* port is configured, put the old LCR back */
		outb(com_port + UART_LCR, lcr);
	else {
#if 0
		/* Input clock. */
		outb(com_port + (UART_DLL << shift),
		     (BASE_BAUD / SERIAL_BAUD) & 0xFF);
		outb(com_port + (UART_DLM << shift),
		     (BASE_BAUD / SERIAL_BAUD) >> 8);
		/* 8 data, 1 stop, no parity */
		outb(com_port + (UART_LCR << shift), 0x03);
		/* RTS/DTR */
		outb(com_port + UART_MCR, 0x00);
	}
	/* Clear & enable FIFOs */
	outb(com_port + UART_FCR, 0x07);
#endif
		outb(com_port + UART_LCR, 0x00);
		outb(com_port + UART_IER, 0x07);

		/* Access baud rate */
		outb(com_port + UART_LCR, 0x80);

		/* 4pin DUART mode */
		outb(com_port + UART_DCR, 0x01);

		/*  Input clock. */
		if (isConsole == COM_CONSOLE) {
			/*  Input clock. */
			outb(com_port + UART_DLL, (BASE_BAUD / SERIAL_BAUD0) & 0xff);
			outb(com_port + UART_DLM, ((BASE_BAUD / SERIAL_BAUD0) & 0xff00) >> 8);
			/* 8 data, 1 stop, non parity */
			outb(com_port + UART_LCR, 0x03);
		} else if (isConsole == COM_AVR) {
			/*  Input clock. */
			outb(com_port + UART_DLL, (BASE_BAUD / SERIAL_BAUD1) & 0xff);
			outb(com_port + UART_DLM, ((BASE_BAUD / SERIAL_BAUD1) & 0xff00) >> 8);
			/* 8 data, 1 stop, even parity */
			outb(com_port + UART_LCR, 0x1b);
		}
		outb(com_port + UART_MCR, 0x00);
	}
	/* Clear & enable FIFOs */
	outb(com_port + UART_FCR, 0x07);

	return (com_port);
#endif
}

void
serial_putc(unsigned long com_port, unsigned char c)
{
	while ((inb(com_port + UART_LSR) & UART_LSR_THRE) == 0)
		;
	outb(com_port, c);
}

unsigned char
serial_getc(unsigned long com_port)
{
	while ((inb(com_port + UART_LSR) & UART_LSR_DR) == 0)
		;
	return inb(com_port);
}

int
serial_tstc(unsigned long com_port)
{
	return ((inb(com_port + UART_LSR) & UART_LSR_DR) != 0);
}
