/*
 *  FAN Control Driver for EMC6D102
 *
 *  Copyright (C) 2004 BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <asm/io.h>

#include "i2c_export.h"
#include "buffalo/emc6d102.h"

rwlock_t mfan_lock;

long __init init_fan_control(void)
{
	unsigned char config[]=
	{ // address , data
	  0x1d,     0x00,    //Zone2pxItZbg
	  0x1e,     0x00,    //Zone1pxItZbg
	  0x1f,     0x00,    //Zone3pxItZbg
	  0x44,     0x00,    //2.5V sence Low Limit  ݒ
	  0x45,     0xFF,    //2.5V sence High Limit ݒ
	  0x46,     0x00,    //1.8V sence Low Limit  ݒ
	  0x47,     0xFF,    //1.8V sence High Limit ݒ
	  0x48,     0x00,    //3.3V sence Low Limit  ݒ
	  0x49,     0xFF,    //3.3V sence High Limit ݒ
	  0x4a,     0x00,    //5.0V sence Low Limit  ݒ
	  0x4b,     0xFF,    //5.0V sence High Limit ݒ
	  0x4c,     0x00,    // 12V sence Low Limit  ݒ
	  0x4d,     0xFF,    // 12V sence High Limit ݒ
	  0x4e,     0x81,    //Zone1 temp. sence Low Limit  ݒ
	  0x4f,     0x7F,    //Zone1 temp. sence High Limit ݒ
	  0x50,     0x81,    //Zone2 temp. sence Low Limit  ݒ
	  0x51,     0x7F,    //Zone2 temp. sence High Limit ݒ
	  0x52,     0x81,    //Zone3 temp. sence Low Limit  ݒ
	  0x53,     0x7F,    //Zone3 temp. sence High Limit ݒ
	  0x54,     0xC8,    //Tach1 RPM Minimum Limit LSB 120rpm
	  0x55,     0xAF,    //Tach1 RPM Minimum Limit MSB 120rpm
	  0x56,     0xFF,    //Tach2 RPM Minimum Limit LSB ݒ
	  0x57,     0xFF,    //Tach2 RPM Minimum Limit MSB ݒ
	  0x58,     0xFF,    //Tach3 RPM Minimum Limit LSB ݒ
	  0x59,     0xFF,    //Tach3 RPM Minimum Limit MSB ݒ
	  0x5a,     0xFF,    //Tach4 RPM Minimum Limit LSB ݒ
	  0x5b,     0xFF,    //Tach4 RPM Minimum Limit MSB ݒ
	  0x5c,     0x22,    //PWM1 conf. Zone2auto notINV spinup250ms
	  0x5d,     0x82,    //PWM2 conf. ݒ
	  0x5e,     0x82,    //PWM3 conf. ݒ
	  0x5f,     0x90,    //Zone1TempRange&PWMFreq. 16C 11Hz
	  0x60,     0x90,    //Zone2TempRange&PWMFreq. 16C 11Hz
	  0x61,     0x90,    //Zone3TempRange&PWMFreq. 16C 11Hz
	  0x62,     0xE0,    //PWM Duty MinLimit & PWM1 Ramp. allPWM MinDuty, PWM1Ramp OFF
	  0x63,     0x00,    //PWM2/3 Ramp ݒ
	  0x64,     0x01,    //PWM1 MinDuty 0.4%
	  0x65,     0x00,    //PWM2 MinDuty ݒ
	  0x66,     0x00,    //PWM3 MinDuty ݒ
	  0x67,     0x81,    //Zone1 Low Temp Limit ݒ
	  0x68,     0x20,    //Zone1 Low Temp Limit 32C
	  0x69,     0x81,    //Zone1 Low Temp Limit ݒ
	  0x6a,     0x7F,    //Zone1 Absolute Temp Limit ݒ
	  0x6b,     0x32,    //Zone1 Absolute Temp Limit 32C
	  0x6c,     0x7F,    //Zone1 Absolute Temp Limit ݒ
	  0x6d,     0x30,    //Zone1/2 Hysteresis Zone1 2C Zone2 ݒ
	  0x6e,     0x00,    //Zone3 Hysteresis Zone3 ݒ
	  0x7c,     0x40,    //Sleep, Continuous, INT disable, 32sample Avereage
	  0x7e,     0x00,    //Voltage INT conf All Disable
	  0x7f,     0x10,    //TACH/PWM mode, spinup reduction ON
	  0x80,     0x00,    //Fan tach INT conf All Disable
	  0x81,     0xA4,    //PWM1=TACH1, PWM2=TACH2, PWM3=TACH3, PWM3=TACH4
	  0x82,     0x00,    //Temp INT conf All disable
	  0x90,     0xCC,    //SLOW=0, 5degs, Mode2, Bit[4]=0, 800ms
	  0x91,     0xC4,    //SLOW=0, 5degs, Mode1, Bit[4]=0, 800ms
	  0x92,     0xC4,    //SLOW=0, 5degs, Mode1, Bit[4]=0, 800ms
	  0x93,     0xC4,    //SLOW=0, 5degs, Mode1, Bit[4]=0, 800ms
	  0x94,     0x0C,    //ڍזmF
	  0x95,     0x0C,    //ڍזmF
	  0x96,     0x0C,    //ڍזmF
	  0x40,     0x01,    //START bit̂1 102FANRg[Jn	
	  0x62,     0xE8     //Ramp ON 35s
	};
	unsigned int i, data_count;
	
	printk("FAN Control EMC6D102 initialized\n");
	
	data_count = (sizeof(config) / sizeof(char));

	for (i = 0; i < data_count; i += 2)
		I2C_do_transaction(0, I2C_MASTER_XMIT, 0x2c, (unsigned char)config[i],
		                   1, &config[i+1], I2C_STOP, 5, 0);
	read_unlock_irq(&mfan_lock);
	return 0;
}

unsigned char melco_get_register(unsigned char address)
{
	unsigned char val;
	unsigned char buf[2];
	int limit = 0;
	I2C_Status status;

	buf[0] = address;
	
	do {
		read_lock_irq(&mfan_lock);
		status = I2C_do_transaction(0, I2C_MASTER_RCV, 0x2c, (unsigned char)buf[0], 
		                            1, &buf[1], I2C_STOP, 5, 0);
		read_unlock_irq(&mfan_lock);
		limit++;
	} while (status != I2C_SUCCESS && limit < 100);
	
	val = buf[1];
	return val;
}

unsigned char melco_set_register(unsigned char address,unsigned char data)
{
	unsigned char buf[2];
	buf[0] = address;
	buf[1] = data;

	read_lock_irq(&mfan_lock);
	I2C_do_transaction(0, I2C_MASTER_XMIT, 0x2c, (unsigned char)buf[0], 1, 
	                   &buf[1], I2C_STOP, 5, 0);
	read_unlock_irq(&mfan_lock);
	return 0;
}