/*
 *  LinkStation HW Control Driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#include <linux/delay.h>
#include <buffalo/ls_hwctl.h>
#include <linux/config.h>

// PWR,DISK_FULL/STATUS,DIAG LED controll
void blink_led(unsigned char state)
{
#ifdef CONFIG_HTGL
	switch (state)
	{
		case FLASH_CLEAR_START:
		case FLASH_UPDATE_START:
			out_b(AVR_PORT, 0x61);
			out_b(AVR_PORT, 0x61);
			out_b(AVR_PORT, 0x38);
			out_b(AVR_PORT, 0x30);
			out_b(AVR_PORT, 0x34);
			out_b(AVR_PORT, 0x31);
			mdelay(10);
			out_b(AVR_PORT, 0x61);
			out_b(AVR_PORT, 0x61);
			out_b(AVR_PORT, 0x38);
			out_b(AVR_PORT, 0x31);
			out_b(AVR_PORT, 0x34);
			out_b(AVR_PORT, 0x31);
			mdelay(10);
			out_b(AVR_PORT, 0x71);
			out_b(AVR_PORT, 0x71);
//			out_b(AVR_PORT, 0x71);
//			out_b(AVR_PORT, 0x71);
			mdelay(10);
			out_b(AVR_PORT, 0x73);
			out_b(AVR_PORT, 0x73);
//			out_b(AVR_PORT, 0x73);
//			out_b(AVR_PORT, 0x73);
			mdelay(10);
			break;
		case FLASH_CLEAR_END:
		case FLASH_UPDATE_END:
			out_b(AVR_PORT, 0x70);
			out_b(AVR_PORT, 0x70);
//			out_b(AVR_PORT, 0x70);
//			out_b(AVR_PORT, 0x70);
			mdelay(10);
			out_b(AVR_PORT, 0x72);
			out_b(AVR_PORT, 0x72);
//			out_b(AVR_PORT, 0x72);
//			out_b(AVR_PORT, 0x72);
			mdelay(10);
			break;
		case RAID_RESYNC_START:
			break;
		case RAID_RESYNC_END:
			break;
		default:
			out_b(AVR_PORT, state);
			out_b(AVR_PORT, state);
			out_b(AVR_PORT, state);
			out_b(AVR_PORT, state);
			break;
	}
#else
	out_b(AVR_PORT, state);
	out_b(AVR_PORT, state);
	out_b(AVR_PORT, state);
	out_b(AVR_PORT, state);
#endif

}


// output BYTE data
inline void out_b(volatile unsigned char *addr, int val)
{
	__asm__ __volatile__("stb%U0%X0 %1,%0; eieio" : "=m" (*addr) : "r" (val));
}

// ---------------------------------------------------------------
