/*
 * arch/ppc/platforms/powerk2.h
 *
 * Definitions for IBM NP4GS3-PowerK2 board support
 *
 *
 * "Portions of this file are partially based on earlier efforts by Ralph
 * Blach, John F Davis and Burt Silverman from IBM Corp"
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#define NP1  20 /* Network Processor Slot 1  */
#define NP2  18 /* Network Processor Slot 2  */
#define PLX1 19 /* PLX9030 Bridge    Slot 1  */
#define PLX2 17 /* PLX9030 Bridge    Slot 2  */
#define PLXI 16 /* PLX9030 Bridge Interposer */

#define LAS0SIZE 0x10000 /* K2 to PCI memory */
#define LAS1SIZE 0x20000 /* EPPC to Interposer Flash */
#define LAS2SIZE 0x10000 /* EPPC to LAS0 area */
#define LAS3SIZE 0x20000 /* Unused, but fix VxWorks usage of large I/O space */

#define PCI9030_CNTRL     ( 0x50 )        /* PCI Target Response and COntrol */
#define CNTRL_DELREAD      (0x00004000)
#define GPIOC      0x54
#define CS2             0x40
#define CS3             0x200
#define GPIO4           (~0x1000)
#define GPIO4OUT        0x2000
#define SMACK_ADRS 0x200
#define SMACKBLADERESETENABLE      0x08
#define SMACK_SIZE 0x80
#define CSENABLE   0x1

/* Function prototypes */
void powerk2_pcibios_fixup_resources(struct pci_dev *dev);

