/*
 *  Flash Rom Disk Driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include "buffalo/firminfo.h"

static int flashd_read_proc(char *page, char **start, off_t off,
                            int count, int *eof, void *data)
{
	int              i;
	int              len  = 0;
	char*            buf  = page;
	struct firminfo* info;

	info = (struct firminfo*)0xFFC00000;

	len += sprintf(buf+len,"PRODUCTNAME=");
	i=0;
	while(i<FIRMNAME_MAX+1 && info->firmname[i] != 0)
	{
		*(buf+len) = info->firmname[i];len++;i++;
	}

	len += sprintf(buf+len,"\n");
	len += sprintf(buf+len,"VERSION=%d.%02d\n",info->ver_major,info->ver_minor);
	len += sprintf(buf+len,"SUBVERSION=");
	
	i=0;
	while(i<FIRMNAME_MAX+1 && info->subver[i] != 0) 
	{
		*(buf+len) = info->subver[i];len++;i++;
	}
	len += sprintf(buf+len,"\n");
	len += sprintf(buf+len,"PRODUCTID=0x%08lX\n",info->firmid);
	len += sprintf(buf+len,"BUILDDATE=%d/%d/%d %d:%d:%d\n",
	                        info->year+1900,info->mon,info->day,
	                        info->hour,info->min,info->sec);
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	return len;
}

/* This is the registration and initialization section of the Flash ROM disk driver */
int __init flashd_init (void)
{
	create_proc_read_entry("linkstation", 0, NULL, flashd_read_proc, NULL);
	return 0;
}

void flashd_exit(void)
{
	remove_proc_entry("linkstation", NULL);
}

module_init(flashd_init);
module_exit(flashd_exit);

