/*
 *  LinkStation RTC driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#include <linux/module.h>
#include <linux/config.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>
#include <linux/reboot.h>
#include <linux/smp_lock.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <linux/rtc.h>
#include <asm/uaccess.h>

#include "buffalo/5c372.h"

#define	ATOI(x)	((x) - '0')
#define	TIME_FORMAT_LEN	15


/********************************/
ssize_t mel_rtc_read(struct file *file, char *buf, size_t count, loff_t *ppos)
{
	struct rtc_time tm;
	__cli();
	tm = melco_get_rtc2();
	printk("%04d/%02d/%02d %02d:%02d:%02d\n", tm.tm_year, tm.tm_mon, tm.tm_mday,
														tm.tm_hour, tm.tm_min, tm.tm_sec);
	__sti();
	return 0;
}

/********************************/
ssize_t mel_rtc_write(struct file *filp, const char *buf, size_t count, loff_t *offp)
{
	struct rtc_time tm;

	if (count != TIME_FORMAT_LEN) {
		printk("invalid format\n");
		return -EINVAL;
	}
	tm.tm_year = ATOI(buf[0]) * 1000 + ATOI(buf[1]) * 100 + ATOI(buf[2]) * 10 + ATOI(buf[3]);
	tm.tm_mon = ATOI(buf[4]) * 10 + ATOI(buf[5]);
	tm.tm_mday = ATOI(buf[6]) * 10 + ATOI(buf[7]);
	tm.tm_hour = ATOI(buf[8]) * 10 + ATOI(buf[9]);
	tm.tm_min = ATOI(buf[10]) * 10 + ATOI(buf[11]);
	tm.tm_sec = ATOI(buf[12])  * 10 + ATOI(buf[13]);

	__cli();
	melco_set_rtc2(tm);
	__sti();
	return count;
}

/********************************/
static int mel_rtc_read_proc(char *page, char **start, off_t off,
                         int count, int *eof, void *data)
{
	char *p = page;
	int len;
	struct rtc_time tm;
	
	__cli();
	tm = melco_get_rtc2();
	p += sprintf(p, "%04d/%2d/%2d %02d:%02d:%02d\n", tm.tm_year, tm.tm_mon, tm.tm_mday,
												tm.tm_hour, tm.tm_min, tm.tm_sec);
	__sti();
	len = (int) (p - page);
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	return len;
}

/********************************/
static int mel_rtc_open(struct inode *inode, struct file *file)
{

	MOD_INC_USE_COUNT;

	return 0;
}


/********************************/
static int mel_rtc_release(struct inode *inode, struct file *file)
{
	MOD_DEC_USE_COUNT;
	return 0;
}

/********************************/
static int mel_rtc_ioctl(struct inode *inode, struct file *file,
	unsigned int cmd, unsigned long arg)
{
	switch (cmd) {
	default:
		return -ENOIOCTLCMD;
/*	case MEL_RTC_GET_TIME:
		return 0;
	case MEL_RTC_SET_TIME:
		return 0;*/
	}
}

/********************************/
static struct file_operations mel_rtc_fops = {
	owner:		THIS_MODULE,
	read:		mel_rtc_read,
	write:		mel_rtc_write,
	ioctl:		mel_rtc_ioctl,
	open:		mel_rtc_open,
	release:	mel_rtc_release,
};

/********************************/
static struct miscdevice mel_rtc_miscdev = {
	minor:		RTC_MINOR,
	name:		"mel_rtc",
	fops:		&mel_rtc_fops,
};

static const char banner[] __initdata = KERN_INFO "BUFFALO INC. RTC driver ver 1.00\n";

/*******************************/
static int __init mel_rtc_init(void)
{
	int ret;

	ret = misc_register(&mel_rtc_miscdev);

	if (ret)
		return ret;
	
	create_proc_read_entry ("driver/rtc", 0, 0, mel_rtc_read_proc, NULL);

	printk(banner);

	return 0;
}

/********************************/
static void __exit mel_rtc_exit(void)
{
	remove_proc_entry("driver/rtc", NULL);
	misc_deregister(&mel_rtc_miscdev);
}

module_init(mel_rtc_init);
module_exit(mel_rtc_exit);
