/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2002 Motorola Semiconductors HK Ltd
 * Copyright (C) 2003 MontaVista Software Inc. <source@mvista.com>
 *
 */
#ifndef PWM_H
#define PWM_H

#include <linux/timer.h>
#include <linux/sched.h>

#include "mx1ads-pwm_ioctl.h"

#ifdef U32
#undef U32
#endif
#define U32			unsigned int

#ifdef U16
#undef U16
#endif
#define U16			unsigned short

#ifdef U8
#undef U8
#endif
#define U8			unsigned char

#define MOD_NAME        	"pwm"
#define DEV_IRQ_NAME		MOD_NAME
#define DEV_IRQ_ID		MOD_NAME
#define AITC_PWM_INT		34

#define MAX_ID 			0x14

#define	_reg(REG)		(*((volatile unsigned long *)(REG)))

#define	PWM_FIFO_AV		0x20
#define	PWM_IRQ_AV		0x80

typedef struct timer_list timer_blk_t;

typedef struct timerStruct {
	timer_blk_t *timer_blk_ptr;
	int period;
	void (*timer_func) (unsigned long);
	int stop_flag;
} pwm_timer_t;

/* functions and interface */
static int pwm_open(struct inode *inode, struct file *filp);
static int pwm_release(struct inode *inode, struct file *filp);
static ssize_t pwm_read(struct file *, char *, size_t, loff_t * l);
static int pwm_ioctl(struct inode *inode,
		     struct file *filp, unsigned int cmd, unsigned long arg);
static ssize_t pwm_write(struct file *filp,
			 const char *buf, size_t count, loff_t * f_pos);
static int pwm_fasync(int fd, struct file *filp, int mode);

int pwm_create_timer(pwm_timer_t * timer);
int pwm_start_timer(pwm_timer_t * timer);
int pwm_stop_timer(pwm_timer_t * timer);
void pwm_int_func(unsigned long dummy);
static int pwm_init_hw(void);

void pwm_stop(void);

extern pwm_timer_t pwm_timer;

#endif				/*PWM_H */
