/*
 *  Author: MontaVista Software, Inc. <source@mvista.com>
 *  2003 (c) MontaVista Software, Inc. This file is licensed under
 *  the terms of the GNU General Public License version 2. This program
 *  is licensed "as is" without any warranty of any kind, whether express
 *  or implied.
 *		
 */
#ifndef SPI_H_INC
#define SPI_H_INC

#define MOD_NAME "SPI_touchscreen"

#define USE_SPI_ONE
#define USE_SPI1

#define SPI_RATE_512  (7<<13)
#define SPI_RATE_256  (6<<13)
#define SPI_RATE_128  (5<<13)
#define SPI_RATE_64   (4<<13)
#define SPI_RATE_32   (3<<13)
#define SPI_RATE_16   (2<<13)
#define SPI_RATE_8    (1<<13)
#define SPI_RATE_4    (0<<13)

#define SPI_RDY_IGNORE ( 0<<11)
#define SPI_RDY_01     ( 1<<11)
#define SPI_RDY_10     ( 2<<11)
#define SPI_RDY_11     ( 3<<11)

#define SPI_SLAVE   	(0<<10)
#define SPI_MASTER 	(1<<10)

#define SPI_EN		(1<<9)

#define SPI_XCH		(1<<8)
#define SPI_NO_XCH      (0<<8)

#define SPI_SS_ACTIVE_LOW  (1<<7)
#define SPI_SS_ACTIVE_HIGH (0<<7)

#define SPI_SS_STAY_LOW_BETWEEN_BURSTS (1<<6)
#define SPI_SS_INSERT_PULSES           (0<<6)
#define SPI_RX_AFTER_BITCOUNT          (1<<6)
#define SPI_RX_AFTER_SS                (0<<6)

#define SPI_PHA0                       (0<<5)
#define SPI_PHA1                       (1<<5)

#define SPI_CLK_ACTIVE_HIGH            (0<<4)
#define SPI_CLK_ACTIVE_LOW             (1<<4)

/*
#define MOD_NAME	"touchscreen"
#define DCT_IRQ_NAME	"PenDevice"
#define DCT_IRQ_ID      "PenDevice"
*/

#ifdef USE_SPI_ONE
#define SPI_IRQ			IRQ_CSPI
#else
#define SPI_IRQ			40
#endif

#define SPI_BASE SPI1_BASE
#define SPI_REG( offset ) IO32_RAW( ( IO_ADDRESS( SPI_BASE ) + (offset) ) )

/* FIXME - remove these defines out */
#define REG_PD_ICR2			(*((volatile __u32*)(IO_ADDRESS(0x0021C32C))))
#define TOUCH_INT_NEG_POLARITY		0x40000000
#define TPNL_IRQ			62	//this is for Port D
// #define TPNL_IRQ                     41
#define TPNL_INTR_MODE			SA_INTERRUPT|SA_SHIRQ
#define TPNL_PEN_UPVALUE		-999

#define SPI_RR_INT		0x00000008
#define SPI_TF_INT		0x00000004
#define SPI_TH_INT		0x00000002
#define SPI_TE_INT		0x00000001

/*****Copy from ASP driver****************/
#define QT_IPAQ

typedef struct {
#ifdef QT_IPAQ
	unsigned short pressure;
#else
	unsigned char pressure;
#endif
	unsigned short x;
	unsigned short y;
#ifdef QT_IPAQ
	unsigned short pad;
#endif
} ts_event_t;

typedef struct touchpannel_tag {
	int auto_zero_value;
	int pen_up_value;
} TCHPNL_S;

#define  MAX_ID 	0x14

#ifdef QT_IPAQ
#define PENUP		0x0
#define PENDOWN		0xffff
#else
#define PENUP		0x0
#define PENDOWN		0xff
#endif

#endif
