/*******************************************************************************************************

	sim-dbmx1.h
	SmartCard Interface Module Linux Driver for DragonBall MX1
	header file

	Author: MontaVista Software, Inc. <source@mvista.com>
	Copyright (c) 2003 MontaVista Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*******************************************************************************************************/

#ifndef __LINUX_SIM_DBMX1_H
#define __LINUX_SIM_DBMX1_H

#include <linux/types.h>

#define MX1SIM_MAX_ATR 33	/*maximal length of Answer to Reset */

#define MX1SIM_IOC_POWER 1

#define MX1SIM_POWER_ON 1	/* IOW: turn power on IOR: power is turned on */
#define MX1SIM_POWER_RESET (1<<1)	/*IOW: do reset IOR: reset occured, waiting to send ATR via read() */

#define MX1SIM_IOW_POWER       _IOW('s',MX1SIM_IOC_POWER,int)
#define MX1SIM_IOR_POWER       _IOR('s',MX1SIM_IOC_POWER,int)

#define MX1SIM_IOC_PRESENCE 2

#define MX1SIM_PRESENCE_EN 1	/* IOW: enable presence detect */
#define MX1SIM_REMOVAL_ON_RISING_EDGE (1<<1)	/* IOW: enable removal detect on rising edge */
#define MX1SIM_CARD_PRESENT 1	/* IOR: card present */
#define MX1SIM_CARD_REMOVED (1<<1)	/* IOR: card has been removed when power was on */
#define MX1SIM_PRESENCE_DETECT_DISABLED (1<<2)	/* IOR: presence detect disabled */

#define MX1SIM_IOW_PRESENCE    _IOW('s',MX1SIM_IOC_PRESENCE,int)
#define MX1SIM_IOR_PRESENCE    _IOR('s',MX1SIM_IOC_PRESENCE,int)

#define MX1SIM_IOC_SETTINGS  3

struct mx1sim_settings_struct {
	char clk_stop_pol;	/* clock stop polarity */
	char anack_en;		/* anack en */
	char onack_en;		/* onack en */
	char tx_nack_thresh;	/* tx nack threshold */
	char baud;		/* baud sel */
	char div;		/* divisor sel */
	char clk;		/* clk sel */
	char open_drain_en;	/* open-drain */
	char bidir_en;		/* bidirectional */
	unsigned char tx_guard;	/* tx guard */
	char rcv_1_stop_en;	/* rcv 1 (1) or 2 (0) stop bits */
	unsigned int char_wait;	/* char wait time */
	char inv_en;		/* format direct (0)/inverse(1) */
};

#define MX1SIM_IOR_SETTINGS  _IOR('s',MX1SIM_IOC_SETTINGS,struct mx1sim_settings_struct)
#define MX1SIM_IOW_SETTINGS  _IOW('s',MX1SIM_IOC_SETTINGS,struct mx1sim_settings_struct)

#endif				/* __LINUX_SIM_DBMX1_H */
