/*
 *  linux/drivers/ide/it8212.c	Version 0.01	January 27, 2003
 *
 *  Copyright (C) 1998-2000	Andre Hedrick <andre@linux-ide.org>
 *  May be copied or modified under the terms of the GNU General Public License
 *
 *  Portions Copyright (C) 2003 Integrated Technology Express , Inc.
 *  Author: Liangyao Li <liangyao.li@iteusa.com>
 *  Released under terms of General Public License
 *
 *  Jan 27, 2003 Liangyao Li
 *		initial version.
 */

#ifndef _IT8212_H_
#define _IT8212_H_


/************************************************************************
 * Debug macro definition
 ************************************************************************/

#ifdef IT8212_DEBUG
//#define ITE_DBG(format, arg...)		print(__FUNCTION__ ": " format , ## arg)
#define ITE_DBG(format, arg...)		printk(format , ## arg)
#define ITE_KDBG(format, arg...)	printk("%s: " format, __FUNCTION__, ## arg)
//#define ITE_KDBG(format, arg...)	printk(KERN_DEBUG __FUNCTION__ ": " format , ## arg)
#else
#define ITE_DBG(format, arg...)
#define ITE_KDBG(format, arg...)
#endif


/************************************************************************
 * PCI Configuration Registers for those not in the /include/linux/pci.h
 ************************************************************************/

#define IT8212_PCI_BaseClassCode				0x0b
#define IT8212_PCI_IdeIoCONFIG					0x40
#define IT8212_PCI_IdeDrivingCURRENT			0x42
#define IT8212_PCI_IdeVirtualChannelEXIST		0x43
#define IT8212_PCI_PciBurstTHRESHOLD			0x44
#define IT8212_PCI_Pll1CONTROL					0x48
#define IT8212_PCI_Pll2CONTROL					0x49
#define IT8212_PCI_IdeBusSkewCONTROL			0x4c
#define IT8212_PCI_PciModeCONTROL				0x50
#define IT8212_PCI_RaidCONTROL					0x51
#define IT8212_PCI_RaidTransferSectorCOUNT		0x52
#define IT8212_PCI_PciModePrimPioDmaTIMING		0x54
#define IT8212_PCI_PciModePrimDrive0UdmaTIMING	0x56
#define IT8212_PCI_PciModePrimDrive1UdmaTIMING	0x57
#define IT8212_PCI_PciModeSecPioDmaTIMING		0x58
#define IT8212_PCI_PciModeSecDrive0UdmaTIMING	0x5a
#define IT8212_PCI_PciModeSecDrive1UdmaTIMING	0x5b
#define IT8212_PCI_TestMODE						0x5c
#define IT8212_PCI_CpuNmiCONTROL				0x5d
#define IT8212_PCI_CpuCONTROL					0x5e
#define IT8212_PCI_CapIDENTIFIER				0x80
#define IT8212_PCI_NextItemPOINTER				0x81
#define IT8212_PCI_PowerManageCAP				0x82
#define IT8212_PCI_PowerManageControlSTATUS		0x84
#define IT8212_PCI_BridgeSUPPORT				0x86
#define IT8212_PCI_DATA							0x87


/************************************************************************
 * PCI I/O Bus Master Registers
 ************************************************************************/

#define IT8212_PCI_BusMasterPrimChannelIdeCOMMAND		0x00
#define IT8212_PCI_BusMasterPrimChannelIdeSTATUS		0x02
#define IT8212_PCI_BusMasterPrimChannelDesTablePOINTER	0x04
#define IT8212_PCI_BusMasterSecChannelIdeCOMMAND		0x08
#define IT8212_PCI_BusMasterSecChannelIdeSTATUS			0x0a
#define IT8212_PCI_BusMasterSecChannelDesTablePOINTER	0x0c


/************************************************************************
 * Transfer Mode Timing Configuration Setting
 ************************************************************************/

#define NofCHANNEL	2
#define PrimCHANNEL	0
#define SecCHANNEL	1


#define NofDRIVE	MAX_DRIVES
#define DRIVE0		0
#define DRIVE1		1


#define ModeINDEX	0
#define ClockINDEX	1
#define TimingINDEX	2


#define CLOCK66	0
#define CLOCK50	1


u8 udmaConfigValue[][3] =		//UDMA mode#, clock setting, reg0x56/57/5a/5b setting
{
	{XFER_UDMA_0, CLOCK66, 0x44},			// UDMA0 config value
	{XFER_UDMA_1, CLOCK50, 0x31},			// UDMA1
	{XFER_UDMA_2, CLOCK66, 0x31},			// UDMA2
	{XFER_UDMA_3, CLOCK66, 0x21},			// UDMA3
	{XFER_UDMA_4, CLOCK66, 0x11},			// UDMA4
	{XFER_UDMA_5, CLOCK50, 0x11 | 0x80},	// UDMA5
	{XFER_UDMA_6, CLOCK66, 0x11 | 0x80}		// UDMA6
};


#define XFER_UDMA_2_INDEX	2
#define XFER_UDMA_5_INDEX	5
#define XFER_UDMA_6_INDEX	6


u8 dmaConfigValue[][4] =		// MW DMA mode#, clock setting, reg0x54/58 setting (clock66, clock50)
{
	{XFER_MW_DMA_0, CLOCK66, 0x88, 0x66},	// MW DMA0 config value
	{XFER_MW_DMA_1, CLOCK66, 0x32, 0x22},	// MW DMA1
	{XFER_MW_DMA_2, CLOCK66, 0x31, 0x21}	// MW DMA2
};


#define XFER_MW_DMA_2_INDEX	2


u8 pioConfigValue[][4] =		// PIO mode#, clock setting, reg0x54/58 setting (clock66, clock50)
{
	{XFER_PIO_0, CLOCK66, 0xaa, 0x88},		// PIO0 config value
	{XFER_PIO_1, CLOCK66, 0xa3, 0x82},		// PIO1
	{XFER_PIO_2, CLOCK66, 0xa1, 0x81},		// PIO2
	{XFER_PIO_3, CLOCK66, 0x33, 0x32},		// PIO3
	{XFER_PIO_4, CLOCK66, 0x31, 0x21}		// PIO4
};


#define XFER_PIO_2_INDEX	2
#define XFER_PIO_3_INDEX	3
#define XFER_PIO_4_INDEX	4


#define UDMA_MODE		0
#define DMA_MODE		1
#define PIO_MODE		2
#define UdmaMaskINDEX	UDMA_MODE
#define DmaMaskINDEX	DMA_MODE
#define ClockMaskINDEX	PIO_MODE + 1


u8 modeControlMaskVerBX[NofCHANNEL][NofDRIVE][4] =	// PCI mode control reg mask for BX version
{
	{
		{0xe7, 0x18, 0x00, 0xfd},		// udma mask, dma mask, pio mask, clock mask
		{0xe7, 0x18, 0x00, 0xfd}
	},
	{
		{0x9f, 0x60, 0x00, 0xfb},
		{0x9f, 0x60, 0x00, 0xfb}
	}
};


u8 modeControlMask[NofCHANNEL][NofDRIVE][4] =	// PCI mode control reg mask for non-BX versions
{
	{
		{0xf7, 0x08, 0x00, 0xfd},		// udma mask, dma mask, pio mask, clock mask
		{0xef, 0x10, 0x00, 0xfd}
	},
	{
		{0xdf, 0x20, 0x00, 0xfb},
		{0xbf, 0x40, 0x00, 0xfb}
	}
};


#endif /* _IT8212_H_ */
