/******************************************************************************

	mx1ads-cam.h
	driver for Motorola MX1ADS on-board CMOS Image Sensor
	header file

	Author: MontaVista Software, Inc. <source@mvista.com>
	Copyright (c) 2003 MontaVista Software, Inc.

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

********************************************************************************/
#ifndef MX1ADS_CAM_H
#define MX1ADS_CAM_H

#include <linux/videodev.h>

#define MX1CAM_MAX_WIDTH  320	/*maximal WOI width */
#define MX1CAM_MAX_HEIGHT  240	/*maximal WOI height */
#define MX1CAM_VFRAME_HEIGHT_DIFF 1	/*virtual frame height must be larger than WOI height at least by 1 */
#define MX1CAM_VFRAME_WIDTH_DIFF 6	/*virtual frame width must be larger than WOI width at least by 6 */
#define MX1CAM_MAX_VFRAME_WTH 0x1FFF	/*maximal virtual frame width */
#define MX1CAM_MAX_VFRAME_HGT 0x1FFF	/*maximal virtual frame height */
#define MX1CAM_MAX_GAIN 0x3F	/*maximal gain value */

struct mx1cam_pict_struct {
	unsigned int x;
	unsigned int y;
	unsigned int width;
	unsigned int height;
	unsigned int sensitivity;
	unsigned int decimation;
};

struct mx1cam_vframe_struct {
	unsigned int width;
	unsigned int height;
};

struct mx1cam_gain_struct {
	unsigned int global;
	unsigned int green_gr;
	unsigned int red;
	unsigned int blue;
	unsigned int green_bg;
};

struct mx1cam_i2creg_struct {
	unsigned char reg;
	unsigned char val;
};

#define MX1CAM_IOC_SET_I2C_REG  _IOW ('v', BASE_VIDIOCPRIVATE+0, struct mx1cam_i2creg_struct)
#define MX1CAM_IOC_GET_I2C_REG  _IOWR ('v', BASE_VIDIOCPRIVATE+1, struct mx1cam_i2creg_struct)
#define MX1CAM_IOC_SET_VFRAME _IOW ('v', BASE_VIDIOCPRIVATE+2, struct mx1cam_vframe_struct)
#define MX1CAM_IOC_GET_VFRAME _IOR ('v', BASE_VIDIOCPRIVATE+3, struct mx1cam_vframe_struct)
#define MX1CAM_IOC_SET_GAIN _IOW ('v', BASE_VIDIOCPRIVATE+4, struct mx1cam_gain_struct)
#define MX1CAM_IOC_GET_GAIN _IOR ('v', BASE_VIDIOCPRIVATE+5, struct mx1cam_gain_struct)
#define MX1CAM_IOC_SET_PICT _IOW ('v', BASE_VIDIOCPRIVATE+6, struct mx1cam_pict_struct)
#define MX1CAM_IOC_GET_PICT _IOR ('v', BASE_VIDIOCPRIVATE+7, struct mx1cam_pict_struct)
#define MX1CAM_IOC_CAPTURE _IOW ('v', BASE_VIDIOCPRIVATE+8, int)

#endif
