
/********************************************************************************
*                  QLOGIC LINUX SOFTWARE
*
* QLogic QLA2x00 device driver for Linux 2.4.x
*
* QLogic Coporation
* Copyright (C) 2003 
* (www.qlogic.com)
*
******************************************************************************/


void
qla2300_dump_isp(scsi_qla_host_t *ha, int have_lock)
{
	int rval;
	uint32_t     i;
	uint32_t     cnt, timer;
	uint32_t     risc_address;
	uint16_t     risc_code_size;
	uint16_t     mb0, mb2;

	uint16_t	data, stat;
	device_reg_t	*reg;
	uint16_t	*dmp_reg;
	unsigned long flags;

	reg = ha->iobase;

	if ( have_lock) {
		save_flags(flags); cli();
	}
	else {
		spin_lock_irqsave(&ha->hardware_lock, flags);
	}

	printk("\n\n[==>BEG]\n");

	printk("HCCR Register:\n");
	printk("%04x\n\n", RD_REG_WORD(&reg->host_cmd));

	WRT_REG_WORD(&reg->host_cmd, HC_PAUSE_RISC); 
	SYS_DELAY(100);

	printk("PBIU Registers:\n");
	dmp_reg = (uint16_t *)(reg + 0);
	for (i = 0; i < 8; i++) 
		printk("%04x ", RD_REG_WORD(dmp_reg++));

	printk("\n\n");

	printk("ReqQ-RspQ-Risc2Host Status registers:\n");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x10);
	for (i = 0; i < 8; i++) 
		printk("%04x ", RD_REG_WORD(dmp_reg++));

	printk("\n\n");

	printk("Mailbox Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x40);
	for (i = 0; i < 32; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x40);
	printk("Auto Request Response DMA Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 32; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x50); 
	printk("DMA Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 48; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x00); 
	printk("RISC Hardware Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0xA0);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2000); 
	printk("RISC GP0 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2200); 
	printk("RISC GP1 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2400); 
	printk("RISC GP2 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2600); 
	printk("RISC GP3 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2800); 
	printk("RISC GP4 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2A00); 
	printk("RISC GP5 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2C00); 
	printk("RISC GP6 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->pcr, 0x2E00); 
	printk("RISC GP7 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 16; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x10); 
	printk("Frame Buffer Hardware Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 64; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x20); 
	printk("FPM B0 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 64; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, 0x30); 
	printk("FPM B1 Registers:");
	dmp_reg = (uint16_t *)((uint8_t *)reg + 0x80);
	for (i = 0; i < 64; i++) {
		if ((i % 8) == 0)
			printk("\n");
		printk("%04x ", RD_REG_WORD(dmp_reg++));
	}

	printk("\n\n");

	WRT_REG_WORD(&reg->ctrl_status, CSR_ISP_SOFT_RESET);

	data = RD_REG_WORD(&reg->ctrl_status);
	for (i = 6000000; i && data & CSR_ISP_SOFT_RESET; i--) {
		SYS_DELAY(5);
		data = RD_REG_WORD(&reg->ctrl_status);
	}
	if (ha->device_id == QLA2312_DEVICE_ID) {
		SYS_DELAY(10);
	} else {
		data = RD_REG_WORD(&reg->mailbox0);
		for (i = 6000000; i && data == MBS_BUSY; i--) {
			SYS_DELAY(5);
			data = RD_REG_WORD(&reg->mailbox0);
		}
	}

	rval = QLA2X00_SUCCESS;
	mb0 = mb2 = 0;
	printk("Code RAM Dump:");
	risc_address      = 0x800;
	risc_code_size    = 0xffff - 0x800 + 1;
	WRT_REG_WORD(&reg->mailbox0, MBC_READ_RAM_WORD);
	clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);
	for (cnt = 0; cnt < risc_code_size && rval == QLA2X00_SUCCESS; cnt++) {
		if ((cnt % 8) == 0)
			printk("\n%04x: ", cnt + 0x0800);
		WRT_REG_WORD(&reg->mailbox1, (uint16_t)risc_address++);
		WRT_REG_WORD(&reg->host_cmd, HC_SET_HOST_INT);

		for (timer = 6000000; timer != 0; timer--) {
			/* Check for pending interrupts. */
			if ((stat = RD_REG_WORD(&reg->host_status_lo)) & HOST_STATUS_INT) {
				stat &= 0xff;

				if (stat == 0x1 || stat == 0x2) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					/* Release mailbox registers. */
					WRT_REG_WORD(&reg->semaphore, 0);
					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				} else if (stat == 0x10 || stat == 0x11) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				}

				/* clear this intr; it wasn't a mailbox intr */
				WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
			}

			mdelay(5);
		}

		if (test_and_clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags)) {
			rval = mb0 & MBS_MASK;
			printk("%04x ", mb2);
		} else {
			rval = QLA2X00_FUNCTION_FAILED;
		}
	}

	printk("\n\n");

	mb0 = mb2 = 0;
	printk("Stack RAM Dump:");
	risc_address      = 0x10000;
	risc_code_size    = 0x107ff - 0x10000 + 1;
	WRT_REG_WORD(&reg->mailbox0, 0xf /* MBC_READ_RAM_EXTENDED */);
	clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

	for (cnt = 0; cnt < risc_code_size && rval == QLA2X00_SUCCESS; cnt++) {
		if ((cnt % 8) == 0)
			printk("\n%05x: ", cnt + 0x10000);
		WRT_REG_WORD(&reg->mailbox1, LSW(risc_address));
		WRT_REG_WORD(&reg->mailbox8, MSW(risc_address++));
		WRT_REG_WORD(&reg->host_cmd, HC_SET_HOST_INT);

		for (timer = 6000000; timer != 0; timer--) {
			/* Check for pending interrupts. */
			if ((stat = RD_REG_WORD(&reg->host_status_lo)) & HOST_STATUS_INT) {
				stat &= 0xff;

				if (stat == 0x1 || stat == 0x2) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					/* Release mailbox registers. */
					WRT_REG_WORD(&reg->semaphore, 0);
					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				} else if (stat == 0x10 || stat == 0x11) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				}

				/* clear this intr; it wasn't a mailbox intr */
				WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
			}

			mdelay(5);
		}

		if (test_and_clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags)) {
			rval = mb0 & MBS_MASK;
			printk("%04x ", mb2);
		} else {
			rval = QLA2X00_FUNCTION_FAILED;
		}
	}

	printk("\n\n");

	mb0 = mb2 = 0;
	printk("Data RAM Dump:");
	risc_address      = 0x10800;
	risc_code_size    = 0x1ffff - 0x10800 + 1;
	WRT_REG_WORD(&reg->mailbox0, 0xf /* MBC_READ_RAM_EXTENDED */);
	clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

	for (cnt = 0; cnt < risc_code_size && rval == QLA2X00_SUCCESS; cnt++) {
		if ((cnt % 8) == 0)
			printk("\n%05x: ", cnt + 0x10800);
		WRT_REG_WORD(&reg->mailbox1, LSW(risc_address));
		WRT_REG_WORD(&reg->mailbox8, MSW(risc_address++));
		WRT_REG_WORD(&reg->host_cmd, HC_SET_HOST_INT);

		for (timer = 6000000; timer != 0; timer--) {
			/* Check for pending interrupts. */
			if ((stat = RD_REG_WORD(&reg->host_status_lo)) & HOST_STATUS_INT) {
				stat &= 0xff;

				if (stat == 0x1 || stat == 0x2) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					/* Release mailbox registers. */
					WRT_REG_WORD(&reg->semaphore, 0);
					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				} else if (stat == 0x10 || stat == 0x11) {
					set_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags);

					mb0 = RD_REG_WORD(&reg->mailbox0);
					mb2 = RD_REG_WORD(&reg->mailbox2);

					WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
					break;
				}

				/* clear this intr; it wasn't a mailbox intr */
				WRT_REG_WORD(&reg->host_cmd, HC_CLR_RISC_INT);
			}

			mdelay(5);
		}

		if (test_and_clear_bit(MBX_INTERRUPT, &ha->mbx_cmd_flags)) {
			rval = mb0 & MBS_MASK;
			printk("%04x ", mb2);
		} else {
			rval = QLA2X00_FUNCTION_FAILED;
		}
	}

	printk("\n[<==END] ISP DEBUG DUMP\n");

	if ( have_lock ) {
		restore_flags(flags);
	}
	else {
		spin_unlock_irqrestore(&ha->hardware_lock, flags);
	}

	return;
}
