/*
 * include/asm-arm/arch-ebsa285/hrtime.h
 *
 * HRT hooks for EBSA285 based targets
 *
 * Author: George G. Davis <gdavis@mvista.com>
 *
 * Copyright 2003 (c) MontaVista, Software, Inc. 
 * 
 * This file is licensed under  the terms of the GNU General Public 
 * License version 2. This program is licensed "as is" without any 
 * warranty of any kind, whether express or implied.
 */


#ifndef __ASM_ARCH_HRTIME_H_
#define __ASM_ARCH_HRTIME_H_
#ifdef CONFIG_HIGH_RES_TIMERS

#include <linux/config.h>
#include <linux/types.h>
#include <linux/sc_math.h>
#include <linux/timex.h>


int schedule_hr_timer_int(unsigned, int);
int get_arch_cycles(unsigned);


/* Sigh, we really want to use CLOCK_TICK_RATE from include/asm/arch/timex.h:
 *
 *	#define CLOCK_TICK_RATE         (mem_fclk_21285 / 16)
 *
 * But due to that run time calculation above, it results in:
 *
 *	kernel/kernel.o(.text+0x121e8): In function `do_timer_gettime':
 *	: undefined reference to `__divdi3'
 *	kernel/kernel.o(.text+0x12254): In function `do_timer_gettime':
 *	: undefined reference to `__divdi3'
 *	kernel/kernel.o(.text+0x128e4): In function `get_wall_time':
 *	: undefined reference to `__divdi3'
 *	kernel/kernel.o(.text+0x132dc): In function `do_clock_nanosleep':
 *	: undefined reference to `__divdi3'
 *	kernel/kernel.o(.text.init+0x900): In function `init_posix_timers':
 *	: undefined reference to `__divdi3'
 *	make: *** [vmlinux] Error 1
 *
 * So for now we just ignore the fact that we may not get the right tick
 * rate and just assume a constant 50MHz clock source until we figure
 * out how to resolve the above. It is after all a 50MHz clock source
 * on the Netwinder anyway.
 */

#if	0
#define HR_CLOCK_TICK_RATE	(CLOCK_TICK_RATE)
#define HR_LATCH		(LATCH)
#else
#define HR_CLOCK_TICK_RATE	(50000000 / 16)
#define HR_LATCH		(HR_CLOCK_TICK_RATE / HZ)
#endif

#define hr_time_resolution	1000
#define arch_cycles_per_jiffy	(HR_CLOCK_TICK_RATE / HZ)
#define schedule_jiffies_int(x)	(get_arch_cycles(x) >= arch_cycles_per_jiffy)

#define SC_ARCH2NSEC		22
#define SC_NSEC2ARCH		32

#define scaled_nsec_per_arch_cycle	\
	(SC_n(SC_ARCH2NSEC, NSEC_PER_SEC) / HR_CLOCK_TICK_RATE)

#define scaled_arch_cycles_per_nsec	\
	(SC_n(SC_NSEC2ARCH, HR_CLOCK_TICK_RATE) / NSEC_PER_SEC)

#define arch_cycle_to_nsec(cycles)	\
	mpy_sc_n(SC_ARCH2NSEC, (cycles), scaled_nsec_per_arch_cycle)

#define nsec_to_arch_cycle(nsec)	\
	mpy_sc_n(SC_NSEC2ARCH, (nsec), scaled_arch_cycles_per_nsec)

#endif	// CONFIG_HIGH_RES_TIMERS
#endif	// __ASM_ARCH_HRTIME_H_
