/*
 *  linux/include/asm-arm/arch-integrator/uncompress.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/config.h>
#include <linux/types.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/hardware/serial_amba.h>

#define AMBA_UART_DR	(*(volatile unsigned char *)0x16000000)
#define AMBA_UART_LCRH	(*(volatile unsigned char *)0x16000008)
#define AMBA_UART_LCRM	(*(volatile unsigned char *)0x1600000c)
#define AMBA_UART_LCRL	(*(volatile unsigned char *)0x16000010)
#define AMBA_UART_CR	(*(volatile unsigned char *)0x16000014)
#define AMBA_UART_FR	(*(volatile unsigned char *)0x16000018)

/*
 * This does not append a newline
 */
static void puts(const char *s)
{
	/* Do nothing if the UART is not enabled. */
	if (!(AMBA_UART_CR & AMBA_UARTCR_UARTEN))
		return;

	while (*s) {
		while (AMBA_UART_FR & AMBA_UARTFR_TXFF)
			barrier();

		AMBA_UART_DR = *s;

		if (*s == '\n') {
			while (AMBA_UART_FR & AMBA_UARTFR_TXFF)
				barrier();

			AMBA_UART_DR = '\r';
		}
		s++;
	}
	while (AMBA_UART_FR & AMBA_UARTFR_BUSY);
}

/* Use arch_decomp_setup() to kludge a default tagged
 * parameter list if none exists.
 */
static inline void arch_decomp_setup(void)
{
	struct tag *t = (struct tag *) 0x00000100;
	u32 temp;

	/* Kludge to support booting the kernel w/o a decent boot loader. */
	if (t->hdr.tag != ATAG_CORE) {
		/* Setup default tagged parameters list if none exists. */
		t->hdr.tag = ATAG_CORE;
		t->hdr.size = tag_size(tag_core);
		t->u.core.flags = 0;
		t->u.core.pagesize = PAGE_SIZE;
		t->u.core.rootdev = RAMDISK_MAJOR << 8 | 0;
		t = tag_next(t);

		/* Fall through to append memory tag below. */
	} else do {
		/* Look for memory tag and exit if one exists. */
		if (t->hdr.tag == ATAG_MEM)
			return;
		t = tag_next(t);
	} while (t->hdr.size);

	/* Append memory tag to tagged parameters list. */
	t->hdr.tag = ATAG_MEM;
	t->hdr.size = tag_size(tag_mem32);
	t->u.mem.start = PHYS_OFFSET;
	temp = *((volatile u32 *)(INTEGRATOR_HDR_SDRAM));
	temp &= INTEGRATOR_HDR_SDRAM_MEMSIZE_MASK;
	temp >>= INTEGRATOR_HDR_SDRAM_MEMSIZE_SHIFT;
	t->u.mem.size  = (16 * 1024 * 1024) << temp;
	t = tag_next(t);

	/* end of list marker */
	t->hdr.tag = ATAG_NONE;
	t->hdr.size = 0;
}

/*
 * nothing to do
 */
#define arch_decomp_wdog()
