/*
 *  linux/include/asm-arm/mx1ads/dma.h
 *
 *  Copyright (C) 1997,1998 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

#define MAX_DMA_ADDRESS		0xffffffff

#define MAX_DMA_CHANNELS         11
#define MAX_DMA_2D_REGSET        2

/* MX1 DMA module registers' address */
#define    MX1_DMA_BASE        IO_ADDRESS(0x00209000)
#define    MX1_DMA_DCR            (MX1_DMA_BASE + 0x00)        /* DMA control register */
#define    MX1_DMA_DISR        (MX1_DMA_BASE + 0x04)        /* DMA interrupt status register */
#define    MX1_DMA_DIMR        (MX1_DMA_BASE + 0x08)        /* DMA interrupt mask register */
#define    MX1_DMA_DBTOSR        (MX1_DMA_BASE + 0x0C)        /* DMA burst time-out status register */
#define    MX1_DMA_DRTOSR        (MX1_DMA_BASE + 0x10)        /* DMA request time-out status register */
#define    MX1_DMA_DSESR        (MX1_DMA_BASE + 0x14)        /* DMA transfer error status register */
#define    MX1_DMA_DBOSR        (MX1_DMA_BASE + 0x18)        /* DMA buffer overflow status register */
#define    MX1_DMA_DBTOCR        (MX1_DMA_BASE + 0x1C)        /* DMA burst time-out control register */
#define    MX1_DMA_WSRA        (MX1_DMA_BASE + 0x40)        /* W-size register A */
#define    MX1_DMA_XSRA        (MX1_DMA_BASE + 0x44)        /* X-size register A */
#define    MX1_DMA_YSRA        (MX1_DMA_BASE + 0x48)        /* Y-size register A */
#define    MX1_DMA_WSRB        (MX1_DMA_BASE + 0x4C)        /* W-size register B */
#define    MX1_DMA_XSRB        (MX1_DMA_BASE + 0x50)        /* X-size register B */
#define    MX1_DMA_YSRB        (MX1_DMA_BASE + 0x54)        /* Y-size register B */

#define    MX1_DMA_SAR0        (MX1_DMA_BASE + 0x80)        /* source address register 0 */
#define    MX1_DMA_DAR0        (MX1_DMA_BASE + 0x84)        /* destination address register 0 */
#define    MX1_DMA_CNTR0        (MX1_DMA_BASE + 0x88)        /* count register 0 */
#define    MX1_DMA_CCR0        (MX1_DMA_BASE + 0x8C)        /* channel control register 0 */
#define    MX1_DMA_RSSR0        (MX1_DMA_BASE + 0x90)        /* request source select register 0 */
#define    MX1_DMA_BLR0        (MX1_DMA_BASE + 0x94)        /* burst length register 0 */
#define    MX1_DMA_RTOR0        (MX1_DMA_BASE + 0x98)        /* request time-out register 0 */
#define    MX1_DMA_BUCR0        (MX1_DMA_BASE + 0x98)        /* bus utilization control register 0 */

/* register set 1 to 10 are offseted by 0x40 each = 0x10 pointers away */
#define    DMA_REG_SET_OFS        0x10

typedef    volatile unsigned long    VU32;
typedef    VU32                            *P_VU32;

/* MX1 DMA module registers */
#define    _reg_DMA_DCR        (*((P_VU32)MX1_DMA_DCR))
#define    _reg_DMA_DISR        (*((P_VU32)MX1_DMA_DISR))
#define    _reg_DMA_DIMR        (*((P_VU32)MX1_DMA_DIMR))
#define    _reg_DMA_DBTOSR    (*((P_VU32)MX1_DMA_DBTOSR))
#define    _reg_DMA_DRTOSR    (*((P_VU32)MX1_DMA_DRTOSR))
#define    _reg_DMA_DSESR        (*((P_VU32)MX1_DMA_DSESR))
#define    _reg_DMA_DBOSR        (*((P_VU32)MX1_DMA_DBOSR))
#define    _reg_DMA_DBTOCR    (*((P_VU32)MX1_DMA_DBTOCR))    
#define    _reg_DMA_WSRA        (*((P_VU32)MX1_DMA_WSRA))
#define    _reg_DMA_XSRA        (*((P_VU32)MX1_DMA_XSRA))
#define    _reg_DMA_YSRA        (*((P_VU32)MX1_DMA_YSRA))
#define    _reg_DMA_WSRB        (*((P_VU32)MX1_DMA_WSRB))
#define    _reg_DMA_XSRB        (*((P_VU32)MX1_DMA_XSRB))
#define    _reg_DMA_YSRB        (*((P_VU32)MX1_DMA_YSRB))
#define    _reg_DMA_SAR0        (*((P_VU32)MX1_DMA_SAR0))
#define    _reg_DMA_DAR0        (*((P_VU32)MX1_DMA_DAR0))
#define    _reg_DMA_CNTR0        (*((P_VU32)MX1_DMA_CNTR0))
#define    _reg_DMA_CCR0        (*((P_VU32)MX1_DMA_CCR0))
#define    _reg_DMA_RSSR0        (*((P_VU32)MX1_DMA_RSSR0))
#define    _reg_DMA_BLR0        (*((P_VU32)MX1_DMA_BLR0))
#define    _reg_DMA_RTOR0        (*((P_VU32)MX1_DMA_RTOR0))
#define    _reg_DMA_BUCR0        (*((P_VU32)MX1_DMA_BUCR0))

/* DMA error type definition */
#define    MX1_DMA_ERR_BTO    0    /* burst time-out */
#define    MX1_DMA_ERR_RTO    1    /* request time-out */
#define    MX1_DMA_ERR_TE        2    /* transfer error */
#define    MX1_DMA_ERR_BO        3    /* buffer overflow */

#endif /* _ASM_ARCH_DMA_H */

