/*
 * linux/include/asm-arm/arch-s3c2800/time.h
 *
 * Copyright (C) SAMSUNG ELECTRONICS 
 *                      SW.LEE <hitchcar@sec.samsung.com>
 * 2003 (c) MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <asm/system.h>
#include <asm/leds.h>

extern unsigned long (*gettimeoffset)(void);

static unsigned long last_TMCNT2;

/*
 * Returns microsecond since last clock interrupt.
 * Note that interrupts will have been disabled by do_gettimeoffset()
 * IRQs are disabled before entering here from do_gettimeofday() 
 */
static unsigned long s3c2800_gettimeoffset(void)
{
        unsigned long elapsed,usec;

	/*
	 * tick is microsecond unit
	 * long tick = (1000000 + HZ/2) / HZ;	 timer interrupt period 
	 * kernel/timer.c 
	 */

	elapsed = last_TMCNT2 - rTMCNT2;
	
	/*
	 *  A SIMPLE RATIO 
	 * (elapsed / rTMCNT2) =  ( usec / tick )
	 */
 
	/*
	 * IF YOU WANT TO  USE LATCH 
         * SEE arch-s3c2800/timex.h
         * it gave me troubles  
         */

	usec = (elapsed * tick) / last_TMCNT2;

        return usec;
}


/*
 * IRQ handler for the timer
 */
static void s3c2800_timer_interrupt(int irq, void *dev_id,
				    struct pt_regs *regs)
{
	long flags;

	if (0) printk("s3c2800_timer_interrupt()\n");
	do_leds();
	save_flags_cli( flags );
	do_timer(regs);
	restore_flags( flags );     
	do_set_rtc();
	do_profile(regs);
}

/*
 * Set up timer interrupt, and return the current time in seconds.
 */

static inline void setup_timer(void)
{
	gettimeoffset = s3c2800_gettimeoffset;

	if (0) printk("setup_timer()\n");

	timer_irq.handler = s3c2800_timer_interrupt;

	rTMDMASEL = 0;

#define SYS_TIMER2_PRESCALER	125
#define SYS_TIMER2_COUNT	1015

#define SYS_TIMER2_MUX_1_4      0x0	/* 1/4  */
#define SYS_TIMER2_INT_DMA_ENA	0x2
#define SYS_TIMER2_COUNT_ENA	0x1

	/* pclk 50750000 / (125 * 4 * 1015) = 100 = 10ms */

	rTMCON2 = SYS_TIMER2_MUX_1_4 | SYS_TIMER2_INT_DMA_ENA;
	rTMDATA2 = SYS_TIMER2_COUNT | (SYS_TIMER2_PRESCALER << 16);

	/* be cautious, TMCNT2 be below 2^16=65535 [15:0] */
//        last_TMCNT2 = (RESCHED_PERIOD * PCLK) /
//		((SYS_TIMER2_PRESCALER+1) * 4 * SYS_TIMER2_COUNT * 1000);

        last_TMCNT2 = SYS_TIMER2_COUNT;

	printk("setup_timer: PCLK %x (%d), last_TMCNT2 0x%x\n",
	       PCLK, PCLK, last_TMCNT2);

 	/* rTMCNTB2 =  X second * (frequency/second) */
// 	rTMCNT2 = last_TMCNT2;

	/* setup up irq function */
	setup_arm_irq(IRQ_TIMER2, &timer_irq);

	/* start timer 2 */
	rTMCON2 |= SYS_TIMER2_COUNT_ENA;

	if (0) printk("setup_timer() done\n");
}
