/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001 Metro Link, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 */
#ifndef	_UIRT_H
#define	_UIRT_H


#define	NUM_UIRT		1
#define	KEYBOARD_DEV		0

#define	PULSES_PER_KEY		24
#define	RCV_THRESHOLD		3
#define UIRT_MAX_PULSES		64
#define	UIRT_MAX_SAMPLES	64
#define	IN_QUEUE_SIZE		16
#define	OUT_QUEUE_SIZE		16

struct uirt_port {
	void *dev;
	int port;
	int irq;
	unsigned int rx_count;
	u16 rx_pulses[UIRT_MAX_SAMPLES];
	unsigned int tx_count;
	u16 tx_pulses[UIRT_MAX_PULSES];
	int savedcode;
	int savedcount;
	unsigned long recv_time;
	int users;
#ifndef	XILLEON_IR_KEYBOARD
	struct semaphore semaphore;
	char in_queue[IN_QUEUE_SIZE];
	int in_head, in_tail;
	wait_queue_head_t in_waiters;
#if 0
	char out_queue[OUT_QUEUE_SIZE];
	int out_head, out_tail;
	wait_queue_head_t out_waiters;
#endif
#endif
};

#endif
