/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Definitions for IDT 79S334 evaluation board.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2000,2001 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef _79S334_H_
#define _79S334_H_

#define IDT_BUS_FREQ   75 // MHz
#define IDT_CLOCK_MULT 2

/* NVRAM */
#define NVRAM_BASE         0x12000000
#define NVRAM_ENVSIZE_OFF  4
#define NVRAM_ENVSTART_OFF 0x40

/* LCD 4-digit display */
#define LCD_CLEAR          0x14000400
#define LCD_DIGIT0         0x1400000f
#define LCD_DIGIT1         0x14000008
#define LCD_DIGIT2         0x14000007
#define LCD_DIGIT3         0x14000003

/* Interrupts routed on 79S334A board (see rc32334.h) */
#define RC32334_SCC8530_IRQ  2
#define RC32334_PCI_INTA_IRQ 3
#define RC32334_PCI_INTB_IRQ 4
#define RC32334_PCI_INTC_IRQ 6
#define RC32334_PCI_INTD_IRQ 7

#define RAM_SIZE	(32*1024*1024)

#include <asm/rc32300/rc32334.h>

#endif /* _79S334_H_ */
