/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Definitions for Dallas DS1501 RTC present on IDT 79EB355 board.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2002 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef _DS1553RTC_H_
#define _DS1553RTC_H_

/* Image of DS1553 registers */
typedef struct {
        u8 flags;
        u8 unused;
        u8 alarm_secs;
	u8 alarm_mins;
	u8 alarm_hours;
	u8 alarm_date;
	u8 interrupts;
	u8 watchdog;
	u8 control;
	u8 secs;
	u8 mins;
	u8 hours;
	u8 weekday;
	u8 date;
	u8 month;
	u8 year;
} ds1553_regs_t;

#define rtc ((ds1553_regs_t*)KSEG1ADDR(RTC_BASE))

/*
 * Control register bit definitions
 */
#define TDC_ENA_READ    0x80
#define TDC_DIS_READ    0x7f
#define TDC_ENA_WRITE   0x40
#define TDC_DIS_WRITE   0xBf
#define TDS_STOP    	0x80

#endif /* _DS1553RTC_H */

