/*
 * include/asm-mips/vr4181a/vr4181a_ecu.h
 *
 * Include file for NEC VR4181A ECU.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#ifndef __NEC_VR4181A_ECU_H
#define __NEC_VR4181A_ECU_H

#include <linux/types.h>

#include <asm/vr4181a/vr4181a.h>

/*
 * ECU Registers offset
 */
#define ECUINDX0	0xd000
#define ECUDATA0	0xd004
#define ECUINT0		0xd008
#define ECUINTMSK0	0xd00c
#define ECUIDE0		0xd010
 #define IDE_IREQ	0x04
 #define IDE_RESET	0x02
 #define IDE_CS_EN	0x01

 #define CF_IREQ	0x00
 #define CF_RESET	0x00
 #define CF_CS_EN	0x00

#define ECUINDX1	0xd020
#define ECUDATA1	0xd024
#define ECUINT1		0xd028
#define ECUINTMSK1	0xd02c

/*
 * ExCA Registers offset
 */
#define ID_REV_REG			0x00
 #define INTERFACE_TYPE			0xc0
 #define REVISION			0x0f

#define IF_STAT_REG			0x01
 #define POWER_STATUS			0x40
 #define POWER_ON			0x40
 #define POWER_OFF			0x00

 #define CARD_STATUS			0x20
 #define CARD_READY			0x20
 #define CARD_BUSY			0x00

 #define WRITE_PROTECT			0x10
 #define WRITE_PROTECT_ON		0x10
 #define WRITE_PROTECT_OFF		0x00

 #define CARD_DETECT			0x0c
 #define CARD_ACTIVE			0x0c
 #define CARD_INACTIVE			0x00

 #define STATUS_CHANGE			0x01
 #define STATUS_CHANGE_ACTIVE		0x01
 #define STATUS_CHANGE_INACTIVE		0x00

 #define BATTRY_VOLTAGE_DETECT		0x01
 #define BATTRY_VOLTAGE_GOOD		0x01
 #define BATTRY_VOLTAGE_DEAD		0x00

#define PWRRSETDRV			0x02
 #define POWER_OUTPUT			0x80
 #define POWER_OUTPUT_ENABLE		0x80
 #define POWER_OUTPUT_PROHIBIT		0x00

 #define POWER				0x10
 #define POWER_ENABLE			0x10
 #define POWER_PROHIBIT			0x00

#define ITGENCTREG			0x03
 #define CARD_RESET			0x40
 #define CARD_RESET_INACTIVE		0x40
 #define CARD_RESET_ACTIVE		0x00

 #define CARD_TYPE			0x20
 #define IO_CARD			0x20
 #define MEMORY_CARD			0x00

#define CDSTCHGREG			0x04
 #define CARD_DETECT_CHANGE		0x08
 #define CARD_STATUS_CHANGE		0x04
 #define STATUS_CHANGE_CHANGE		0x01

#define CRDSTATREG			0x05
 #define CARD_DETECT_ENABLE		0x08
 #define CARD_STATUS_ENABLE		0x04
 #define STATUS_CHANGE_ENABLE		0x01

#define ADWINENREG				0x06
 #define IO_WINDOW_ENABLE(n)			(0x40 << (n))
 #define MEMORY_WINDOW_ENABLE(n)		(0x01 << (n))

#define IOCTRL_REG				0x07
 #define IO_WINDOW(n)				((n) == 0 ? 0x0f : 0xf0)
 #define IO_WINDOW_ACCESS(n)			((n) == 0 ? 0x0c : 0xc0)
 #define IO_WINDOW_ACCESS_ADD_WAIT(n)		((n) == 0 ? 0x0c : 0xc0)
 #define IO_WINDOW_ACCESS_NO_WAIT(n)		((n) == 0 ? 0x00 : 0x00)
 #define IO_WINDOW_DATA_WIDTH(n)		((n) == 0 ? 0x03 : 0x30)
 #define IO_WINDOW_DATA_WIDTH_WITH_SIGNAL(n)	((n) == 0 ? 0x02 : 0x20)
 #define IO_WINDOW_DATA_WIDTH_16BIT(n)		((n) == 0 ? 0x01 : 0x10)
 #define IO_WINDOW_DATA_WIDTH_8BIT(n)		((n) == 0 ? 0x00 : 0x00)

#define IOADSLBREG(n)				((n) == 0 ? 0x08 : 0x0c)
#define IOADSHBREG(n)				((n) == 0 ? 0x09 : 0x0d)
#define IOSLBREG(n)				((n) == 0 ? 0x0a : 0x0e)
#define IOSHBREG(n)				((n) == 0 ? 0x0b : 0x0f)

#define SYSMEMSLREG(n)				(0x10 + (0x8 * (n)))
#define MEMWID_REG(n)				(0x11 + (0x8 * (n)))
 #define MEMORY_CARD_DATA_WIDTH			0x80
 #define MEMORY_CARD_DATA_WIDTH_16BIT		0x80
 #define MEMORY_CARD_DATA_WIDTH_8BIT		0x00

 #define MEMORY_CARD_ACCESS			0x40
 #define MEMORY_CARD_ACCESS_NO_WAIT		0x40
 #define MEMORY_CARD_ACCESS_ADD_WAIT		0x00

 #define MEMORY_WINDOW_START_MASK		0x3fff

#define SYSMEMELREG(n)				(0x12 + (0x8 * (n)))
#define MEMSEL_REG(n)				(0x13 + (0x8 * (n)))
 #define MEMORY_CARD_ACCESS_WAIT_VALUE		0xc0
 #define MEMORY_CARD_ACCESS_ADD_4WAIT		0xc0
 #define MEMORY_CARD_ACCESS_ADD_3WAIT		0x80
 #define MEMORY_CARD_ACCESS_ADD_2WAIT		0x40
 #define MEMORY_CARD_ACCESS_ADD_1WAIT		0x00

 #define MEMORY_WINDOW_STOP_MASK		0x3fff

#define MEMOFFHREG(n)				(0x15 + (0x8 * (n)))
 #define MEMORY_CARD_WRITE			0x80
 #define MEMORY_CARD_WRITE_PROHIBIT		0x80
 #define MEMORY_CARD_WRITE_ENABLE		0x00

 #define ACCESS_MEMORY				0x40
 #define ATTRIBUTE_MEMORY			0x40
 #define COMMON_MEMORY				0x00

#define DTGENCLREG				0x16

#define GLOCTRLREG				0x1e

#define VOLTSENREG				0x1f
 #define VOLTAGE_SENSE				0x03
 #define VOLTAGE_SENSE_33V			0x02

#define VOLTSELREG				0x2f
 #define VCC_SELECT				0x03
 #define VCC_33V				0x02

static inline uint8_t exca_readb(int slot, uint8_t offset)
{
	switch (slot) {
	case 0:
		vr4181a_writeb(offset, ECUINDX0);
		vr4181a_write_fixed;
		return vr4181a_readb(ECUDATA0);
	case 1:
		vr4181a_writeb(offset, ECUINDX1);
		vr4181a_write_fixed;
		return vr4181a_readb(ECUDATA1);
	default:
		break;
	}

	return 0;
}

static inline void exca_writeb(int slot, uint8_t offset, uint8_t val)
{
	switch (slot) {
	case 0:
		vr4181a_writeb(offset, ECUINDX0);
		vr4181a_write_fixed;
		vr4181a_writeb(val, ECUDATA0);
		vr4181a_write_fixed;
		break;
	case 1:
		vr4181a_writeb(offset, ECUINDX1);
		vr4181a_write_fixed;
		vr4181a_writeb(val, ECUDATA1);
		vr4181a_write_fixed;
		break;
	default:
		break;
	}
}

static inline uint16_t exca_readw(int slot, uint8_t offset)
{
	uint16_t val = 0;

	switch (slot) {
	case 0:
		vr4181a_writeb(offset + 1, ECUINDX0);
		vr4181a_write_fixed;
		val = vr4181a_readb(ECUDATA0);
		val <<= 8;
		vr4181a_writeb(offset, ECUINDX0);
		vr4181a_write_fixed;
		val |= vr4181a_readb(ECUDATA0);
		break;
	case 1:
		vr4181a_writeb(offset + 1, ECUINDX1);
		vr4181a_write_fixed;
		val = vr4181a_readb(ECUDATA1);
		val <<= 8;

		vr4181a_writeb(offset, ECUINDX1);
		vr4181a_write_fixed;
		val |= vr4181a_readb(ECUDATA1);
		break;
	default:
		break;
	}

	return val;
}

static inline void exca_writew(int slot, uint8_t offset, uint16_t val)
{
	switch (slot) {
	case 0:
		vr4181a_writeb(offset, ECUINDX0);
		vr4181a_write_fixed;
		vr4181a_writeb((uint8_t)val, ECUDATA0);
		vr4181a_write_fixed;
		vr4181a_writeb(offset + 1, ECUINDX0);
		vr4181a_write_fixed;
		vr4181a_writeb((uint8_t)(val >> 8), ECUDATA0);
		vr4181a_write_fixed;
		break;
	case 1:
		vr4181a_writeb(offset, ECUINDX1);
		vr4181a_write_fixed;
		vr4181a_writeb((uint8_t)val, ECUDATA1);
		vr4181a_write_fixed;
		vr4181a_writeb(offset + 1, ECUINDX1);
		vr4181a_write_fixed;
		vr4181a_writeb((uint8_t)(val >> 8), ECUDATA1);
		vr4181a_write_fixed;
		break;
	default:
		break;
	}
}

#endif /* __NEC_VR4181A_ECU_H */
