/*
 *  Flash Rom Disk Driver
 *
 *  Copyright (C) 2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#ifndef _BUFFALO_FLASH_
#define _BUFFALO_FLASH_

#define ATTACH_FLASH_ADDRESS 0xFFC00000

int flash_erase(unsigned long addr ,int num, int block);
int flash_write(unsigned long addr ,unsigned char* buf,int size);

#define FLASH_CMDA(x)	\
	*(volatile char*)(ATTACH_FLASH_ADDRESS + 0xaaa) = x;
#define FLASH_CMD5(x)	\
	*(volatile char*)(ATTACH_FLASH_ADDRESS + 0x555) = x;
#define FLASH_START (volatile char*)(ATTACH_FLASH_ADDRESS)

#define FLASH_COMMAND_CLEAR FLASH_CMDA(0xf0)
#define FLASH_COMMAND_READY FLASH_CMDA(0xaa);FLASH_CMD5(0x55)

// erase funtion --------------------
#define BIT(x) 1<<x
int flash_state(volatile unsigned char* addr ,unsigned char target)
{
	unsigned long time = jiffies;
	unsigned char data;
	do {
		data = *addr;
		if((data & BIT(7))==(target & BIT(7))) return 0;
		if(data & BIT(5)) {
			data = *addr;
			if((data & BIT(7))==(target & BIT(7))) 
				return 0;
			else
				return -1;
		}
	} while(jiffies-time<5000); // 5sec wait
	return -1;
}

// erase funtion --------------------
int flash_erase(unsigned long addr ,int num, int block)
{
	volatile unsigned char* baddr;
	volatile unsigned char* caddr;
	unsigned char c;
	addr  = addr & 0xffff0000;// div 64K
	baddr = (char*)addr;
	int i;

	while (num > 0) {
		// erase
		FLASH_COMMAND_CLEAR;
		FLASH_COMMAND_READY;
		FLASH_CMDA(0x80);
		FLASH_COMMAND_READY;
		*(baddr) = 0x30;
		if (flash_state(baddr,0xff)) {
			printk("Flash Erase fail?!\n");
		}
		FLASH_COMMAND_CLEAR;

		// verify
		caddr = baddr;
		for (i=0;i<block;++i) {
			c = *caddr;
			if (c != (unsigned char)0xff) {
				printk("verify fail! %p = %02X\n",caddr,c);
				return -1;
			}
			caddr++;
		}
		num--;
		baddr += block;
	}

	return 0;
}

// write funtion --------------------
int flash_write(unsigned long addr ,unsigned char* buf,int size)
{
	volatile unsigned char* baddr;
	long                    i;
	int                     verify_fail = 0, verify_count = 0;

	baddr = (char*)addr;

	FLASH_COMMAND_CLEAR;
	for(i=0;i<size;++i) {
		FLASH_COMMAND_READY;
		FLASH_CMDA(0xa0);// vO
		*baddr = buf[i];
		if(flash_state(baddr,buf[i])) {
			printk("Flash Write fail?!\n");
		}
		baddr++;
	}
	FLASH_COMMAND_CLEAR;
	baddr = (char*)addr;

	// verify͍ő3܂
	do {
		verify_fail = 0; // verifyG[tONA

		if (verify_count > 0)
			printk("Flash Verify %d times\n", verify_count);

		for(i=0;i<size;++i) {
			// verifyG[́AxCgs
			if(*baddr != buf[i]) {
				printk("Flash Write verify fail %p = %02X\n", *baddr, buf[i]);

				FLASH_COMMAND_CLEAR;
				FLASH_COMMAND_READY;
				FLASH_CMDA(0xa0);
				*baddr = buf[i];

				if(flash_state(baddr,buf[i])) {
					printk("Flash Write retry fail?! %p\n", *baddr);
					FLASH_COMMAND_CLEAR;
				} else {
					printk("Flash Write retry success %p\n", *baddr);
					FLASH_COMMAND_CLEAR;
				}
				verify_fail = 1;
			}
			baddr++;
		}
	} while ((verify_fail == 1) && (verify_count++ < 2));

	return 0;
}

#endif
