/*
 *  Tulip control driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#ifndef _MELCO_ETH_H
#define _MELCO_ETH_H

#define	TULIP_FULL_DUPLEX

#define	OPMODE_SINGLE_CHIP		0
#define	OPMODE_MAC_ONLY_MODE	1

#define	SIOCGPARAMS		SIOCDEVPRIVATE + 3
#define	SIOCSPARAMS		SIOCDEVPRIVATE + 4
#define	MELCO_ETH_IOCTL	SIOCDEVPRIVATE + 5
 #define	MELCO_ETH_IOCTL_SET_PHY_MAC		0x00000001
 #define	MELCO_ETH_IOCTL_GET_PHY_MAC		0x00000002
 #define	MELCO_ETH_IOCTL_SET_MAC			0x00000003
 #define	MELCO_ETH_IOCTL_GET_MAC			0x00000004
 #define	MELCO_ETH_IOCTL_INIT_EEPROM		0x00000005
 #define	MELCO_ETH_IOCTL_ERASE_EEPROM	0x00000006
 #define	MELCO_ETH_IOCTL_RAED_EEPROM		0x00000007
 #define	MELCO_ETH_IOCTL_WRITE_EEPROM	0x00000008

struct eth_mac {
	caddr_t	mac;
	int		len;
	int		status;
};


struct eeprom {
	caddr_t	buf;
	int		len;
	int		status;
};


struct melco_eth_req {
	union {
		char    ifrn_name[IFNAMSIZ];
	} ifr_ifrn;

	__u8			command;
	union {
		struct eth_mac	mac;
		struct eeprom	eeprom;
	}	u;
};

#endif
