/*
 *	Mobile Node IOCTL Control device
 *
 *	Authors:
 *	Henrik Petander		<lpetande@tml.hut.fi>
 *
 *	$Id$
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */

#include <linux/fs.h>
#include <linux/module.h>
#include <net/ipv6.h>
#include <asm/uaccess.h>

#include "debug.h"
#include "util.h"
#include "mdetect.h"
#include "multiaccess_ctl.h"
#include "mipv6_ioctl.h"

static int mipv6_ioctl_mn(struct inode *inode, struct file *file, 
			  unsigned int ioctl_num,	/* The number of the ioctl */
			  unsigned long arg)	/* The parameter to it */
{
	struct in6_addr careofaddr;

	/* Switch according to the ioctl called */
	switch (ioctl_num) {
	case IOCTL_GET_CAREOFADDR:
		DEBUG(DBG_INFO, "IOCTL_GET_CAREOFADDR");
		/* First get home address from user and then look up 
		 * the care-of address and return it
		 */
		if (copy_from_user(&careofaddr, (struct in6_addr *)arg, 
				   sizeof(struct in6_addr)) < 0) {
			DEBUG(DBG_WARNING, "Copy from user failed");
			return -EFAULT;
		}
		mipv6_get_care_of_address(&careofaddr, &careofaddr);
		DEBUG(DBG_INFO, "COA: %x:%x:%x:%x:%x:%x:%x:%x",
		      NIPV6ADDR(&careofaddr));
		if (copy_to_user((struct in6_addr *)arg, &careofaddr,
				 sizeof(struct in6_addr)) < 0) {
			DEBUG(DBG_WARNING, "Copy to user failed");
			return -EFAULT;
		}
		break;
	case MA_IOCTL_SET_IFACE_PREFERENCE:
		DEBUG(DBG_INFO, "MA_IOCTL_SET_IFACE_PREFERENCE");
		ma_ctl_set_preference(arg);
		break;

	default:
		DEBUG(DBG_WARNING, "Unknown ioctl cmd (%d)", ioctl_num);
		return -ENOENT;
	}
	return 0;
}

struct file_operations fops = {
	owner: THIS_MODULE,
	read: NULL,
	write: NULL,
	poll: NULL,
	ioctl: mipv6_ioctl_mn,
	open: mipv6_ioctl_open,
	release: mipv6_ioctl_close
};
