/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki_pci.h,v 1.1 2002/03/04 04:43:17 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_PCI_H
#define	_MURASASKI_PCI_H

/* PCI configuration */
typedef struct {
	unsigned int vendor;
	unsigned int device;
} MU_pci_id_t;

typedef struct {
	char *name;
	unsigned int class;
	unsigned int class_mask;
	MU_pci_id_t id;
	MU_pci_id_t sub_id;
	char *slot;
} MU_pci_config_t;

extern int get_id_pci_class(MU_pci_config_t *);
extern int get_id_pci_id(MU_pci_config_t *);
extern int get_id_pci_slot(MU_pci_config_t *);

#endif	/* _MURASAKI_PCI_H */
