/*
 * BK Id: SCCS/s.ns16550.c 1.21 11/26/01 14:32:25 paulus
 */
/*
 * COM1 NS16550 support
 */

#include <linux/config.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#include <asm/serial.h>
#include <melco/melco_serial.h>

#define SERIAL_BAUD0	57600
#define SERIAL_BAUD1	9600

#define CONSOLE_PORT	0
#define AVR_PORT		1

extern void outb(int port, unsigned char val);
extern unsigned char inb(int port);
extern unsigned long ISA_io;

static struct serial_state rs_table[RS_TABLE_SIZE] = {
	SERIAL_PORT_DFNS	/* Defined in <asm/serial.h> */
};

static int shift;

unsigned long serial_init(int chan, int isConsole)
{
	unsigned long com_port;
	unsigned char lcr, dlm;

#if 0
	/* We need to find out which type io we're expecting.  If it's
	 * 'SERIAL_IO_PORT', we get an offset from the isa_io_base.
	 * If it's 'SERIAL_IO_MEM', we can the exact location.  -- Tom */
	switch (rs_table[chan].io_type) {
		case SERIAL_IO_PORT:
			com_port = rs_table[chan].port;
			break;
		case SERIAL_IO_MEM:
			com_port = (unsigned long)rs_table[chan].iomem_base;
			break;
		default:
			/* We can't deal with it. */
			return -1;
	}
#endif

	if (chan == 0)
		com_port = (unsigned long)0x80004500;
	else
		com_port = (unsigned long)0x80004600;

	/* How far apart the registers are. */
	shift = rs_table[chan].iomem_reg_shift;

	lcr = inb(com_port + UART_LCR);
	dlm = inb(com_port + UART_DLM);
	/*
	 * Test if serial port is unconfigured.
	 * We assume that no-one uses less than 110 baud or
	 * less than 7 bits per character these days.
	 *  -- paulus.
	 */

	if ((dlm <= 4) && (lcr & 2))
		/* port is configured, put the old LCR back */
		outb(com_port + UART_LCR, lcr);
	else { 
		outb(com_port + UART_LCR, 0x00);
		outb(com_port + UART_IER, 0x07);

		/* Access baud rate */
		outb(com_port + UART_LCR, 0x80);

		/* 4pin DUART mode */
		outb(com_port + UART_DCR, 0x01);

		if (isConsole == CONSOLE_PORT) {
			outb(com_port + UART_DLL, (BASE_BAUD / SERIAL_BAUD0));
			outb(com_port + UART_DLM, (BASE_BAUD / SERIAL_BAUD0) >> 8);
			outb(com_port + UART_LCR, 0x03);
		} else if (isConsole == AVR_PORT) {
			outb(com_port + UART_DLL, (BASE_BAUD / SERIAL_BAUD1));
			outb(com_port + UART_DLM, (BASE_BAUD / SERIAL_BAUD1) >> 8);
			outb(com_port + UART_LCR, 0x1b);
		}

		outb(com_port + UART_MCR, 0x00);
	}
	outb(com_port + UART_FCR, 0x07);

	return (com_port);
}

void
serial_putc(unsigned long com_port, unsigned char c)
{
	while ((inb(com_port + UART_LSR) & UART_LSR_THRE) == 0)
		;
	outb(com_port, c);
}

unsigned char
serial_getc(unsigned long com_port)
{
	while ((inb(com_port + UART_LSR) & UART_LSR_DR) == 0)
		;
	return inb(com_port);
}

int
serial_tstc(unsigned long com_port)
{
	return ((inb(com_port + UART_LSR) & UART_LSR_DR) != 0);
}
