/*
 * $Id: head.S,v 1.1 2001/12/06 00:18:15 trini Exp $
 *
 * Boot loader philosophy:
 *      ROM loads us to some arbitrary location
 *      Move the boot code to the link address (8M)
 *      Call decompress_kernel()
 *         Relocate the initrd, zimage and residual data to 8M
 *         Decompress the kernel to 0
 *      Jump to the kernel entry
 *            -- Cort
 */

#include <asm/ppc_asm.h>
#include <asm/processor.h>
#include <asm/cache.h>

	.text

	.globl	start
start:
	bl	start_
start_:
	mr	r11,r3		/* Save pointer to residual/board data */

/* check if we need to relocate ourselves to the link addr or were we
   loaded there to begin with -- Cort */
	lis	r4,start@h
	ori	r4,r4,start@l
	mflr	r3
	subi	r3,r3,4		/* we get the nip, not the ip of the branch */
	mr	r8,r3
	cmp	0,r3,r4
	bne	1010f

	b	start_ldr
1010:
/*
 * no matter where we're loaded, move ourselves to -Ttext address
 */
relocate:
	mflr	r3		/* Compute code bias */
	subi	r3,r3,4
	mr	r8,r3
	lis	r4,start@h
	ori	r4,r4,start@l
	lis	r5,end@h
	ori	r5,r5,end@l
	addi	r5,r5,3			/* Round up - just in case */
	sub	r5,r5,r4		/* Compute # longwords to move */
	srwi	r5,r5,2
	mtctr	r5
	mr	r7,r5
	li	r6,0
	subi	r3,r3,4			/* Set up for loop */
	subi	r4,r4,4
00:	lwzu	r5,4(r3)
	stwu	r5,4(r4)
	xor	r6,r6,r5
	bdnz	00b
  	lis	r3,start_ldr@h
	ori	r3,r3,start_ldr@l
	mtlr	r3			/* Easiest way to do an absolute jump */
	blr
start_ldr:
/* Compute size of whole image in words */
	lis	r4,start@h
	ori	r4,r4,start@l
	lis	r5,end@h
	ori	r5,r5,end@l
	addi	r5,r5,3		/* round up */
	sub	r5,r5,r4
	srwi	r5,r5,2
	mr	r7,r5
/* Clear all of BSS */
	lis	r3,edata@h
	ori	r3,r3,edata@l
	lis	r4,end@h
	ori	r4,r4,end@l
	subi	r3,r3,4
	subi	r4,r4,4
	li	r0,0
50:	stwu	r0,4(r3)
	cmp	0,r3,r4
	bne	50b
90:	mr	r9,r1			/* Save old stack pointer (in case it matters) */
	lis	r1,.stack@h
	ori	r1,r1,.stack@l
	addi	r1,r1,4096*2
	subi	r1,r1,256
	li	r2,0x000F		/* Mask pointer to 16-byte boundary */
	andc	r1,r1,r2
	/* Save the command line args from Smon */
	cmpwi	0,r11,0
	beq	24f
	lis	r3,cmd_buf@h
	ori	r3,r3,cmd_buf@l
	addi	r3,r3,-1
	addi	r4,r11,-1
23:	lbzu	r0,1(r4)
	cmpwi	0,r0,0
	stbu	r0,1(r3)
	bne	23b
24:
/* Run loader */
	mr	r3,r8			/* Load point */
	mr	r4,r7			/* Program length */
	bl	decompress_kernel

	/*
	 * get start address of kernel code which is stored as a coff
	 * entry.  see boot/head.S -- Cort
	 */
	li	r9,0x4
	mtlr	r9
	lis	r10,0xdeadc0de@h
	ori	r10,r10,0xdeadc0de@l
	li	r9,0
	stw	r10,0(r9)

	blr
hang:
	b	hang

/*
 * Delay for a number of microseconds
 * -- Use the BUS timer (assumes 66MHz)
 */
	.globl	udelay
udelay:
	mfspr	r4,PVR
	srwi	r4,r4,16
	cmpi	0,r4,1		/* 601 ? */
	bne	.udelay_not_601
00:	li	r0,86	/* Instructions / microsecond? */
	mtctr	r0
10:	addi	r0,r0,0 /* NOP */
	bdnz	10b
	subic.	r3,r3,1
	bne	00b
	blr

.udelay_not_601:
	mulli	r4,r3,1000	/* nanoseconds */
	addi	r4,r4,59
	li	r5,60
	divw	r4,r4,r5	/* BUS ticks */
1:	mftbu	r5
	mftb	r6
	mftbu	r7
	cmp	0,r5,r7
	bne	1b		/* Get [synced] base time */
	addc	r9,r6,r4	/* Compute end time */
	addze	r8,r5
2:	mftbu	r5
	cmp	0,r5,r8
	blt	2b
	bgt	3f
	mftb	r6
	cmp	0,r6,r9
	blt	2b
3:	blr

.globl _get_HID0
_get_HID0:
	mfspr	r3,HID0
	blr

.globl _put_HID0
_put_HID0:
	mtspr	HID0,r3
	blr

.globl _get_MSR
_get_MSR:
	mfmsr	r3
	blr

.globl _put_MSR
_put_MSR:
	mtmsr	r3
	blr

/*
 * Flush instruction cache
 * *** I'm really paranoid here!
 */
_GLOBAL(flush_instruction_cache)
	mflr	r5
	bl	flush_data_cache
	mfspr	r3,HID0	/* Caches are controlled by this register */
	li	r4,0
	ori	r4,r4,(HID0_ICE|HID0_ICFI)
	or	r3,r3,r4	/* Need to enable+invalidate to clear */
	mtspr	HID0,r3
	andc	r3,r3,r4
	ori	r3,r3,HID0_ICE	/* Enable cache */
	mtspr	HID0,r3
	mtlr	r5
	blr

#define NUM_CACHE_LINES 128*8
#define CACHE_LINE_SIZE 32
#define cache_flush_buffer 0x1000

/*
 * Flush data cache
 * *** I'm really paranoid here!
 */
_GLOBAL(flush_data_cache)
	lis	r3,cache_flush_buffer@h
	ori	r3,r3,cache_flush_buffer@l
	li	r4,NUM_CACHE_LINES
	mtctr	r4
00:	lwz	r4,0(r3)
	addi	r3,r3,CACHE_LINE_SIZE	/* Next line, please */
	bdnz	00b
10:	blr
	.comm	.stack,4096*2,4

