/*
 * arch/ppc/boot/sandpoint/head.S
 *
 * Initial board bringup code for Motorola SPS Sandpoint test platform
 *
 * Author: Mark A. Greer
 *	   mgreer@mvista.com
 * Derived from arch/ppc/boot/pcore/head.S (mporter@mvista.com)
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#include "../../kernel/ppc_defs.h"
#include "../../kernel/ppc_asm.tmpl"
#include <asm/processor.h>
#include <asm/cache.h>

#define RAM_SIZE        0x04000000
#define DEC_COUNT       0x00002000

#define WM32(address,data) \
	lis	r3, address@h; \
	ori	r3, r3, address@l; \
	lis	r4, data@h; \
	ori	r4, r4, data@l; \
	stw	r4, 0x0000(r3); \
	sync;  \
	isync;

#define WM16(address,data) \
	lis	r3, address@h; \
	ori	r3, r3, address@l; \
	li	r4, data; \
	sth	r4, 0x0000(r3); \
	sync;  \
	isync;

#define WM8(address,data) \
	lis	r3, address@h; \
	ori	r3, r3, address@l; \
	li	r4, data; \
	stb	r4, 0(r3); \
	sync;  \
	isync;

	.text

/*
 *
 *      Begin at some arbitrary location in RAM or Flash
 *	  Initialize core registers
 *	  Configure memory controller (Not executing from RAM)
 *	Move the boot code to the link address (8M)
 *	  Setup C stack
 *	  Initialize UART
 *      Decompress the kernel to 0x0
 *      Jump to the kernel entry
 *
 */

	.globl	start

#ifdef FLASH_BOOT_IMAGE
	.space	(0x100)
#endif

start:
	bl	start_ 
	
#ifdef FLASH_BOOT_IMAGE
		.space	(0x100-4)
	rfi
		.space	(0x100-4)
	rfi
		.space	(0x100-4)
	rfi
		.space	(0x100-4)
extend_int:
	stwu  r1,-16(r1)
	stw   r3,8(r1)
	stw   r4,12(r1)
	lis	r3,     0x800600a0@h
	ori	r3, r3, 0x800600a0@l
	lwz r4, 0(r3)
	WM32(0x800600b0,0xffffffff)
	lwz   r3,8(r1)
	lwz   r4,12(r1)
	la    r1,16(r1)
	rfi
extend_int_end:
		.space	(0x100-(extend_int_end-extend_int))
	rfi
		.space	(0x100-4)
	rfi
		.space	(0x100-4)
	rfi
		.space	(0x100-4)
dec_int:
		.space	(0x100-4)
#endif

start_:
	li	r3,MSR_IP|MSR_FP
	mtmsr	r3

	li      r8,0
	mtspr   DBAT0U,r8
	mtspr	DBAT0L,r8
	mtspr   DBAT1U,r8
	mtspr	DBAT1L,r8
	mtspr   DBAT2U,r8
	mtspr	DBAT2L,r8
	mtspr   DBAT3U,r8
	mtspr	DBAT3L,r8
	mtspr   IBAT0U,r8
	mtspr	IBAT0L,r8
	mtspr   IBAT1U,r8
	mtspr	IBAT1L,r8
	mtspr	IBAT2U,r8
	mtspr   IBAT2L,r8
	mtspr   IBAT3U,r8
	mtspr	IBAT3L,r8
	isync
	sync
	sync

	lis	r8, 0x8000
	isync
	mtsr	SR0,r8
	mtsr	SR1,r8
	mtsr	SR2,r8
	mtsr	SR3,r8
	mtsr	SR4,r8
	mtsr	SR5,r8
	mtsr	SR6,r8
	mtsr	SR7,r8
	mtsr	SR8,r8
	mtsr	SR9,r8
	mtsr	SR10,r8
	mtsr	SR11,r8
	mtsr	SR12,r8
	mtsr	SR13,r8
	mtsr	SR14,r8
	mtsr	SR15,r8
	isync
	sync
	sync

	li	r4,0x0000
	isync
	mtspr	HID0,r4
	sync
	isync
	
	ori	r4,r4,0x8000
	ori	r8,r4,0x0800
	isync
	mtspr	HID0,r8
	sync
	isync
	
	mtspr	HID0,r4
	sync
	isync


#ifdef FLASH_BOOT_IMAGE
melco_config_start:	
	WM32(0xFEC00000,0x0d000080)
	WM8(0xFEE00001,0x20)
	WM32(0xFEC00000,0x0c000080)
	WM8(0xFEE00000,0x08)
	WM32(0xFEC00000,0x04000080)
	WM16(0xFEE00000,0x0600)
	WM32(0xFEC00000,0xa8000080)
	lis	r3, 0xFEE00000@h 
	ori	r3, r3, 0xFEE00000@l
	
	lwz r5, 0(r3)
	lis r4, 0x0
	ori r4, r4, 0x1000
	and r5, r4, r5
		
	lis	r4, 0xd8130400@h
	ori	r4, r4, 0xd8130400@l
	or  r4, r4, r5
	
	stw	r4, 0x0000(r3)
	sync
	isync
	
	WM32(0xFEC00000,0xac000080)
	WM32(0xFEE00000,0x00000004)
	WM32(0xFEC00000,0x78000080)
	WM32(0xFEE00000,0x00000080)
	WM32(0xFEC00000,0xe0000080)
	WM8(0xFEE00000,0x20)
	WM32(0xFEC00000,0xe0000080)
	WM8(0xFEE00000,0xc0)
	WM32(0xFEC00000,0x46000080)
	WM16(0xFEE00002,0x00c0)
	WM32(0xFEC00000,0x73000080)
	WM8(0xFEE00003,0x95)
	WM32(0xFEC00000,0x76000080)
	WM8(0xFEE00002,0x00)
	WM32(0xFEC00000,0x77000080)
	WM8(0xFEE00003,0x30)
	WM32(0xFEC00000,0x80000080)
	WM32(0xFEE00000,0x00FFFFFF)
	WM32(0xFEC00000,0x84000080)
	WM32(0xFEE00000,0xFFFFFFFF)
	WM32(0xFEC00000,0x90000080)
	WM32(0xFEE00000,0x3FFFFFFF)
	WM32(0xFEC00000,0x94000080)
	WM32(0xFEE00000,0xFFFFFFFF)
	WM32(0xFEC00000,0x88000080)
	WM32(0xFEE00000,0x00030303)
	WM32(0xFEC00000,0x8C000080)
	WM32(0xFEE00000,0x03030303)
	WM32(0xFEC00000,0x98000080)
	WM32(0xFEE00000,0x00030303)
	WM32(0xFEC00000,0x9C000080)
	WM32(0xFEE00000,0x03030303)
	WM32(0xFEC00000,0xf0000080)
	WM32(0xFEE00000,0x0200A005)
	WM32(0xFEC00000,0xf4000080)
	WM32(0xFEE00000,0xe015000e)
	WM32(0xFEC00000,0xf8000080)	
	WM32(0xFEE00000,0x00000077)
	WM32(0xFEC00000,0xfc000080)
	WM32(0xFEE00000,0x29233222)
	WM32(0xFEC00000,0x73000080)
	WM8(0xFEE00003,0x95)
	WM32(0xFEC00000,0x74000080)
	WM16(0xFEE00000,0x7078)
	WM32(0xFEC00000,0xa0000080)
	WM8(0xFEE00000, 0x01)
	WM32(0xFEC00000,0xa3000080)
	WM8(0xFEE00003,0x92)
	WM32(0xFEC00000,0xd0000080)
	WM32(0xFEE00000,0xffffff85)
	WM32(0xFEC00000,0xd4000080)
	WM32(0xFEE00000,0xffffff05)
	WM32(0xFEC00000,0xd8000080)
	WM32(0xFEE00000,0x0000f80f)
	WM32(0xFEC00000,0xdc000080)
	WM32(0xFEE00000,0x0e000000)
	WM32(0xFEC00000,0xf0000080)
	WM32(0xFEE00000,0x0200A805)
	WM8(0x80004503,0x00)
	WM8(0x80004501,0x00)
	WM8(0x80004503,0x80)
	WM8(0x80004511,0x01)
	WM8(0x80004500,0x8B)
	WM8(0x80004501,0x02)
	WM8(0x80004503,0x1b)
	WM8(0x80004500,0x00)
	WM8(0x80004502,0x07)

melco_config_end:	
#endif
	
	lis r3, 0x8000
	ori r3, r3, 0x0004
	lis r4, 0xFEC0
	ori r4, r4, 0x0000
	stwbrx r4, 0, r3
	sync
	isync

	li r6, 0x0006
	lis r5, 0xFEE0
	ori r5, r5, 0x0000
	sthbrx r5, 0, r6
	sync
	isync

#ifdef FLASH_BOOT_IMAGE
check_ram:
	lis r3,     1000
	mulli	r4,r3,1000
	addi	r4,r4,59
	li	r5,60
	divw	r4,r4,r5
1:	mftbu	r5
	mftb	r6
	mftbu	r7
	cmp	0,r5,r7
	bne	1b
	addc	r9,r6,r4
	addze	r8,r5
2:	mftbu	r5
	cmp	0,r5,r8
	blt	2b
	bgt	3f
	mftb	r6
	cmp	0,r6,r9
	blt	2b
	xor r4,r4,r4
	lis r5,     RAM_SIZE@h
	ori r5, r5, RAM_SIZE@l
	lis r6,     0xaaaa
	ori r6, r6, 0xaaaa
	lis r7,     0x5555
	ori r7, r7, 0x5555
	lis r8,     0x0000
	ori r8, r8, 0x0100
check_ram_loop:	
	cmp 0,r4,r5
	beq  check_ram_end
	stw r6,0(r4)
	isync
	lwz r3,0(r4)
	isync
	cmp 0,r3,r6
	bne ram_error
	stw r7,0x00fc(r4)
	isync
	lwz r3,0x00fc(r4)
	isync
	cmp 0,r3,r7
	bne ram_error
	add r4,r4,r8
	b   check_ram_loop
ram_error:
	WM8(0x80004500,0x6F)
	b   ram_error
check_ram_end:
#endif
	lis	r4,start@h
	ori	r4,r4,start@l
	mflr	r3
	subi	r3,r3,4
	mr	r8,r3
	cmp	0,r3,r4
	bne	1010f
	lis	r4,start@h
	ori	r4,r4,start@l
	lis	r5,end@h
	ori	r5,r5,end@l
	addi	r5,r5,3
	sub	r5,r5,r4
	srwi	r5,r5,2
	mr	r7,r5
	b	start_ldr
1010:
relocate:
	mflr	r3
	subi	r3,r3,4
	mr	r8,r3
	lis	r4,start@h
	ori	r4,r4,start@l
	lis	r5,end@h
	ori	r5,r5,end@l
	addi	r5,r5,3
	sub	r5,r5,r4
	srwi	r5,r5,2
	mtctr	r5
	mr	r7,r5
	li	r6,0
	subi	r3,r3,4
	subi	r4,r4,4
00:	lwzu	r5,4(r3)
	stwu	r5,4(r4)
	xor	r6,r6,r5
	bdnz	00b
  	lis	r3,start_ldr@h
	ori	r3,r3,start_ldr@l
	mtlr	r3
	blr
start_ldr:
	lis	r3,.bss@h
	ori	r3,r3,.bss@l

	lis	r4,end@h
	ori	r4,r4,end@l
	subi	r3,r3,4
	subi	r4,r4,4
	li	r0,0
50:	stwu	r0,4(r3)
	cmp	0,r3,r4
	bne	50b
90:	mr	r9,r1
	lis	r1,.stack@h
	ori	r1,r1,.stack@l
	addi	r1,r1,4096*2
	subi	r1,r1,256
	li	r2,0x000F
	andc	r1,r1,r2
	mr	r3,r8
	mr	r4,r7
	mr	r5,r6
	bl	decompress_kernel

	lis r3, 0xff00
	ori r3, r3, 0x0001
	li r4, 0xff
	stb r4, 0(r3)
	sync
	isync

	lis	r6,cmd_line@h
	ori	r6,r6,cmd_line@l
	lwz	r6, 0(r6)
	subi	r7,r6,1
00:	lbzu	r2,1(r7)
	cmpi	0,r2,0
	bne	00b

	lis	r2,initrd_start@h
	ori	r2,r2,initrd_start@l
	lwz	r4,0(r2)
	lis	r2,initrd_end@h
	ori	r2,r2,initrd_end@l
	lwz	r5,0(r2)

	li	r9,0x4
	mtlr	r9
	li	r9,0

jump_to_kernel:
	blr

hang:
	b	hang

knock_dog_enable:
	stwu  r1,-16(r1)
	stw   r3,8(r1)
	stw   r4,12(r1)
	
	WM32(timer_proc,0x00000000)
	
	lis 	r4  , 0x0
	ori 	r4,r4,0x400 /* 1000 clock */
	sync
	isync
	WM32(0x80041020,0x000000a0)
	WM32(0x80041020,0x00000020)
	mtdec 	r4
	mfmsr	r3
	lis		r4  , 0x0
	ori		r4,r4,MSR_EE
	or		r3,r3,r4
	sync
	isync
	mtmsr	r3
	sync
	isync
	
	lwz   r3,8(r1)
	lwz   r4,12(r1)
	la    r1,16(r1)
	blr
.globl knock_dog_disable
knock_dog_disable:
	stwu  r1,-16(r1)
	stw   r3,8(r1)
	stw   r4,12(r1)
	
	mfmsr	r3
	li		r4,0
	ori		r4,r4,MSR_EE
	andc	r3,r3,r4
	sync
	isync
	mtmsr	r3
	sync
	isync
	
	lwz   r3,8(r1)
	lwz   r4,12(r1)
	la    r1,16(r1)
	blr

	.globl	udelay
udelay:
	mfspr	r4,PVR
	srwi	r4,r4,16
	cmpi	0,r4,1		/* 601 ? */
	bne	.udelay_not_601
00:	li	r0,86
	mtctr	r0
10:	addi	r0,r0,0 /* NOP */
	bdnz	10b
	subic.	r3,r3,1
	bne	00b
	blr

.udelay_not_601:
	mulli	r4,r3,1000	/* nanoseconds */
	addi	r4,r4,59
	li	r5,60
	divw	r4,r4,r5	/* BUS ticks */
1:	mftbu	r5
	mftb	r6
	mftbu	r7
	cmp	0,r5,r7
	bne	1b		/* Get [synced] base time */
	addc	r9,r6,r4	/* Compute end time */
	addze	r8,r5
2:	mftbu	r5
	cmp	0,r5,r8
	blt	2b
	bgt	3f
	mftb	r6
	cmp	0,r6,r9
	blt	2b
3:	blr

.globl _get_HID0
_get_HID0:
	mfspr	r3,HID0
	blr

.globl _put_HID0
_put_HID0:
	mtspr	HID0,r3
	blr

.globl _get_MSR
_get_MSR:
	mfmsr	r3
	blr

.globl _put_MSR
_put_MSR:
	mtmsr	r3
	blr

.global flush_instruction_cache
flush_instruction_cache:
	mflr	r5
	bl	flush_data_cache
	mfspr	r3,HID0
	li	r4,0
	ori	r4,r4,(HID0_ICE|HID0_ICFI)
	or	r3,r3,r4
	mtspr	HID0,r3
	andc	r3,r3,r4
	ori	r3,r3,HID0_ICE
	mtspr	HID0,r3
	mtlr	r5
	blr

#define NUM_CACHE_LINES 128*4
#define CACHE_LINE_SIZE 32
#define cache_flush_buffer 0x1000

.global flush_data_cache
flush_data_cache:
	lis	r3,cache_flush_buffer@h
	ori	r3,r3,cache_flush_buffer@l
	li	r4,NUM_CACHE_LINES
	mtctr	r4
00:	dcbf	r0,r3
	addi	r3,r3,CACHE_LINE_SIZE
	bdnz	00b
10:	blr
	.comm	.stack,4096*2,4

