/**************************************
 *
 * copyright @ Motorola, 1999
 *
 **************************************/
#include <linux/config.h>
#include <linux/sys.h>
#include <asm/unistd.h>
#include <asm/errno.h>
#include <asm/processor.h>
#include <asm/page.h>
#include <asm/cache.h>
#include "ppc_asm.h"


/**********************************************************
 * function: load_runtime_reg
 *
 * input:  r3 - value of eumbbar
 *         r4 - register offset in embedded utility space
 *
 * output: r3 - register content
 **********************************************************/
      .text
/*      .align 2*/
/*      .global load_runtime_reg
load_runtime_reg:*/
_GLOBAL(load_runtime_reg)

/*		  xor r5,r5,r5
*         or  r5,r5,r3
*
*	      lwbrx	r3,r4,r5
*/
		lwbrx r3, r4, r3
		SYNC
labelx:
		blr
		/*RFI
		bclr 20, 0*/

/****************************************************************
 * function: store_runtime_reg
 *
 * input: r3 - value of eumbbar
 *        r4 - register offset in embedded utility space
 *        r5 - new value to be stored
 *
 ****************************************************************/
/*           .text*/
/*           .align 2
           .global store_runtime_reg
store_runtime_reg:*/
_GLOBAL(store_runtime_reg)
		stwbrx r5, r4, r3
		SYNC
		blr
		/*bclr 20, 0*/



