
/*
 * A collection of structures, addresses, and values associated with
 * the Embedded Planet RPX6 (or RPX Super) MPC8260 board.
 * Copied from the RPX-Classic and SBS8260 stuff.
 *
 * Copyright (c) 2001 Dan Malek (dan@mvista.com)
 */
#ifdef __KERNEL__
#ifndef __MACH_ADS8260_DEFS
#define __MACH_ADS8260_DEFS

#include <linux/config.h>

#include <asm/ppcboot.h>

/* Memory map is configured by the PROM startup.
 * We just map a few things we need.  The CSR is actually 4 byte-wide
 * registers that can be accessed as 8-, 16-, or 32-bit values.
 */
#define IMAP_ADDR		((uint)0xf0000000)
#define BCSR_ADDR		((uint)0xf8000000)
#define BCSR_SIZE		((uint)(32 * 1024))

/* The ADS8260 has 16, 32-bit wide control/status registers, accessed
 * only on word boundaries.
 * Not all are used (yet), or are interesting to us (yet).
 */

/* Things of interest in the CSR.
*/
#define BCSR0_LED0		((uint)0x02000000)	/* 0 == on */
#define BCSR0_LED1		((uint)0x01000000)	/* 0 == on */
#define BCSR1_FETHIEN		((uint)0x08000000)	/* 0 == enable */
#define BCSR1_FETH_RST		((uint)0x04000000)	/* 0 == reset */
#define BCSR1_RS232_EN1		((uint)0x02000000)	/* 0 == enable */
#define BCSR1_RS232_EN2		((uint)0x01000000)	/* 0 == enable */

#define PHY_INTERRUPT	SIU_INT_IRQ7

#endif
#endif /* __KERNEL__ */
