/*
 * arch/ppc/platforms/ev64260.h
 * 
 * Definitions for Marvell/Galileo EV-64260-BP Evaluation Board.
 *
 * Author: Mark A. Greer <mgreer@mvista.com>
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

/*
 * The GT64260 has 2 PCI buses each with 1 window from the CPU bus to
 * PCI I/O space and 4 windows from the CPU bus to PCI MEM space.
 * We'll only use one PCI MEM window on each PCI bus.
 */

#ifndef __PPC_PLATFORMS_EV64260_H
#define __PPC_PLATFORMS_EV64260_H

#define	EV64260_BRIDGE_REG_BASE		0xf8000000
#define	EV64260_BRIDGE_REG_BASE_TO_TOP	0x08000000U

#define	EV64260_TODC_BASE		0xfc800000
#define	EV64260_TODC_LEN		0x00800000
#define	EV64260_TODC_END		(EV64260_TODC_BASE + \
					 EV64260_TODC_LEN - 1)

#define	EV64260_UART_BASE		0xfd000000
#define	EV64260_UART_LEN		0x00800000
#define	EV64260_UART_END		(EV64260_UART_BASE + \
					 EV64260_UART_LEN - 1)

/*
 * PCI Bus 0 Definitions
 */
#define EV64260_PCI_0_IO_SIZE		0x01000000U
#define	EV64260_PCI_0_MEM_SIZE		0x10000000U

#define	EV64260_PCI_0_CONFIG_ADDR	(EV64260_BRIDGE_REG_BASE + \
					 GT64260_PCI_0_CONFIG_ADDR)
#define	EV64260_PCI_0_CONFIG_DATA	(EV64260_BRIDGE_REG_BASE + \
					 GT64260_PCI_0_CONFIG_DATA)

/* PCI addresses */
#define	EV64260_PCI_0_IO_START		0x00000000U
#define	EV64260_PCI_0_IO_END		(EV64260_PCI_0_IO_START + \
					 EV64260_PCI_0_IO_SIZE - 1)

/* Processor Physical addresses */
#define	EV64260_PCI_0_IO_START_PROC	0xfa000000U
#define	EV64260_PCI_0_IO_END_PROC	(EV64260_PCI_0_IO_START_PROC + \
					 EV64260_PCI_0_IO_SIZE - 1)

/* PCI addresses */
#define	EV64260_PCI_0_MEM_START		0x80000000U
#define	EV64260_PCI_0_MEM_END		(EV64260_PCI_0_MEM_START + \
					 EV64260_PCI_0_MEM_SIZE - 1)

/* Processor Physical addresses */
#define	EV64260_PCI_0_MEM_START_PROC	0x80000000U
#define	EV64260_PCI_0_MEM_END_PROC	(EV64260_PCI_0_MEM_START_PROC + \
					 EV64260_PCI_0_MEM_SIZE - 1)

/* Start of System memory/RAM from PCI memory */
#define	EV64260_PCI_0_PCI_MEM_OFFSET	(EV64260_PCI_0_MEM_START_PROC - \
					 EV64260_PCI_0_MEM_START)

/*
 * PCI Bus 1 Definitions
 */
#define EV64260_PCI_1_IO_SIZE		0x01000000U
#define	EV64260_PCI_1_MEM_SIZE		0x10000000U

#define	EV64260_PCI_1_CONFIG_ADDR	(EV64260_BRIDGE_REG_BASE + \
					 GT64260_PCI_1_CONFIG_ADDR)
#define	EV64260_PCI_1_CONFIG_DATA	(EV64260_BRIDGE_REG_BASE + \
					 GT64260_PCI_1_CONFIG_DATA)

/* PCI addresses */
#define	EV64260_PCI_1_IO_START		0x01000000U
#define	EV64260_PCI_1_IO_END		(EV64260_PCI_1_IO_START + \
					 EV64260_PCI_1_IO_SIZE - 1)

/* Processor Physical addresses */
#define	EV64260_PCI_1_IO_START_PROC	0xfb000000U
#define	EV64260_PCI_1_IO_END_PROC	(EV64260_PCI_1_IO_START_PROC + \
					 EV64260_PCI_1_IO_SIZE - 1)

/* PCI addresses */
#define	EV64260_PCI_1_MEM_START		0x90000000U
#define	EV64260_PCI_1_MEM_END		(EV64260_PCI_1_MEM_START + \
					 EV64260_PCI_1_MEM_SIZE - 1)

/* Processor Physical addresses */
#define	EV64260_PCI_1_MEM_START_PROC	0x90000000U
#define	EV64260_PCI_1_MEM_END_PROC	(EV64260_PCI_1_MEM_START_PROC + \
					 EV64260_PCI_1_MEM_SIZE - 1)

/* Start of System memory/RAM from PCI memory */
#define	EV64260_PCI_1_PCI_MEM_OFFSET	(EV64260_PCI_1_MEM_START_PROC - \
					 EV64260_PCI_1_MEM_START)

#endif /* __PPC_PLATFORMS_EV64260_H */
