/*
 * include/asm-ppc/ev64260_serial.h
 * 
 * Definitions for Marvell/Galileo EV-64260-BP Evaluation Board.
 *
 * Author: Mark A. Greer <mgreer@mvista.com>
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __ASMPPC_EV64260_SERIAL_H
#define __ASMPPC_EV64260_SERIAL_H

#include <linux/config.h>
#include <platforms/ev64260.h>

#define EV64260_SERIAL_0		(EV64260_UART_BASE + 0x20)
#define EV64260_SERIAL_1		EV64260_UART_BASE

#ifdef CONFIG_SERIAL_MANY_PORTS
#define RS_TABLE_SIZE	64
#else
#define RS_TABLE_SIZE	2
#endif

/* Rate for the 1.8432 Mhz clock for the onboard serial chip */
#if 0	/* XXXX */
#define BASE_BAUD ( 1843200 / 16 )
#else
#define BASE_BAUD ( 3686400 / 16 )
#endif

#ifdef CONFIG_SERIAL_DETECT_IRQ
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST|ASYNC_AUTO_IRQ)
#else
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST)
#endif

#define STD_SERIAL_PORT_DFNS \
	{ 0, BASE_BAUD, EV64260_SERIAL_0, 85, STD_COM_FLAGS, /* ttyS0 */ \
		iomem_base: (u8 *)EV64260_SERIAL_0,			\
		iomem_reg_shift: 2,					\
		io_type: SERIAL_IO_MEM },				\
	{ 0, BASE_BAUD, EV64260_SERIAL_1, 86, STD_COM_FLAGS, /* ttyS1 */ \
		iomem_base: (u8 *)EV64260_SERIAL_1,			\
		iomem_reg_shift: 2,					\
		io_type: SERIAL_IO_MEM },

#define SERIAL_PORT_DFNS \
	STD_SERIAL_PORT_DFNS

#endif /* __ASMPPC_EV64260_SERIAL_H */
