/*
 * ibm_ips.h
 *
 *	This was dirived from the ppc4xx.h and all 405GP specific definition and board
 *	inclusions where moved here.
 *
 * 	Current Maintainer
 *      Armin Kuster akuster@mvista.com
 *      Nov, 2001
 *
 *
 * Copyright 2001 MontaVista Softare Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR   IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT,  INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	Version 1.0 (01/11/26) - A. Kuster
 *	Initial version	 -
 */


#ifdef __KERNEL__
#ifndef __ASM_IBM_IPS_H__
#define __ASM_IBM_IPS_H__

#include <linux/types.h>

#ifndef __ASSEMBLY__

 /* PCI 32 */

#define PCIL0_PMM0LA		0x00
#define PCIL0_PMM0MA		0x04
#define PCIL0_PMM0PCILA		0x08
#define PCIL0_PMM0PCIHA		0x0c

#define PCIL0_PMM1LA		0x10
#define PCIL0_PMM1MA		0x14
#define PCIL0_PMM1PCILA		0x18
#define PCIL0_PMM1PCIHA		0x1c

#define PCIL0_PMM2LA		0x20
#define PCIL0_PMM2MA		0x24
#define PCIL0_PMM2PCILA		0x28
#define PCIL0_PMM2PCIHA		0x2c

#define PCIL0_PTM1MS		0x30
#define PCIL0_PTM1LA		0x34
#define PCIL0_PTM2MS		0x38
#define PCIL0_PTM2LA		0x3c

typedef struct pcilo_regs {
	u32	pmm0la;
	u32	pmm0ma;
	u32	pmm0pcila;
	u32	pmm0pciha;
	u32	pmm1la;
	u32	pmm1ma;
	u32	pmm1pcila;
	u32	pmm1pciha;
	u32	pmm2la;
	u32	pmm2ma;
	u32	pmm2pcila;
	u32	pmm2pciha;
	u32	ptm1ma;
	u32	ptm1la;
	u32	ptm2ms;
	u32	ptm2la;
}pcilo_t;

/* Serial Ports */

#define thr rbr
#define iir fcr
#define dll rbr
#define dlm ier


typedef struct NS16550 {
  u8 rbr;  /* 0 */
  u8 ier;  /* 1 */
  u8 fcr;  /* 2 */
  u8 lcr;  /* 3 */
  u8 mcr;  /* 4 */
  u8 lsr;  /* 5 */
  u8 msr;  /* 6 */
  u8 scr;  /* 7 */
}uart_t;


/* I2c */
typedef struct iic_regs{
	u16 mdbuf;
	u16 sbbuf;
	u8 lmadr;
	u8  hmadr;
	u8  cntl;
	u8 mdcntl;
	u8 sts;
	u8 extsts;
	u8 lsadr;
	u8 hsadr;
	u8 clkdiv;
	u8 intmsk;
	u8 xfrcnt;
	u8 xtcntlss;
	u8 directcntl;
}iic_t;


/* OPB arbiter */
typedef struct opb {
	u8	pr;
	u8	cr;
}opb_t;


/* General purpose i/o */

typedef struct gpio {
	u32 or;
	u32 tcr;
	u32 pad[4];
	u32 odr;
	u32 ir;
}gpio_t;

/* Emac */
typedef struct emac_regs {
	volatile u32 em0mr0;
	volatile u32 em0mr1;
	volatile u32 em0tmr0;
	volatile u32 em0tmr1;
	volatile u32 em0rmr;
	volatile u32 em0isr;
	volatile u32 em0iser;
	volatile u32 em0iahr;
	volatile u32 em0ialr;
	volatile u32 em0vtpid;
	volatile u32 em0vtci;
	volatile u32 em0ptr;
	volatile u32 em0iaht1;
	volatile u32 em0iaht2;
	volatile u32 em0iaht3;
	volatile u32 em0iaht4;
	volatile u32 em0gaht1;
	volatile u32 em0gaht2;
	volatile u32 em0gaht3;
	volatile u32 em0gaht4;
	volatile u32 em0lsal;
	volatile u32 em0lsah;
	volatile u32 em0ipgvr;
	volatile u32 em0stacr;
	volatile u32 em0trtr;
	volatile u32 em0rwmr;
}emac_t;

/* ZMII bridge */
typedef struct zmii_regs {
	u32 fer;	/* Function enable reg */
	u32 ssr;	/* Spedd select reg */
	u32 smiirs;	/* SMII status reg */
}zmii_t;


#endif /* __ASSEMBLY__ */
#endif /* __ASM_IBM_IPS_H__ */
#endif /* __KERNEL__ */

