/*
 * BK Id: SCCS/s.ppc4xx_serial.h 1.9 11/28/01 09:55:58 paulus
 */
/*
 *    Copyright 2000 MontaVista Software Inc.
 *	PPC405GP modifications
 * 	Author: MontaVista Software, Inc.
 *         	frank_rowand@mvista.com or source@mvista.com
 * 	   	debbie_chu@mvista.com
 *
 *    Module name: ppc405_serial.h
 *
 *    Description:
 *      Macros, definitions, and data structures specific to the IBM PowerPC
 *      405 on-chip serial port devices.
 */

#ifdef __KERNEL__
#ifndef __ASMPPC_PPC4xx_SERIAL_H
#define __ASMPPC_PPC4xx_SERIAL_H

#include <linux/config.h>
#include <asm/ibm4xx.h>

#ifdef CONFIG_SERIAL_DETECT_IRQ
#define STD_COM_FLAGS	(ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST | ASYNC_AUTO_IRQ)
#define STD_COM4_FLAGS	(ASYNC_BOOT_AUTOCONF | ASYNC_AUTO_IRQ)
#else
#define STD_COM_FLAGS	(ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST)
#define STD_COM4_FLAGS	(ASYNC_BOOT_AUTOCONF)
#endif

#define STD_UART_OP(num)					\
	{ 0, BASE_BAUD, 0, UART##num##_INT, STD_COM_FLAGS,	\
		iomem_base: UART##num##_IO_BASE,		\
		io_type: SERIAL_IO_MEM},
    
#if defined(CONFIG_405GP)
#if defined(CONFIG_UART0_TTYS0)
#define SERIAL_PORT_DFNS	\
	STD_UART_OP(0)		\
	STD_UART_OP(1)
#endif

#if defined(CONFIG_UART0_TTYS1)
#define SERIAL_PORT_DFNS	\
	STD_UART_OP(1)		\
	STD_UART_OP(0)
#endif

#elif defined(CONFIG_REDWOOD_4)

#if defined(CONFIG_UART0_TTYS0)
#define SERIAL_PORT_DFNS	\
	STD_UART_OP(0)		
#endif

#if defined(CONFIG_UART0_TTYS1)
#define SERIAL_PORT_DFNS	\
	STD_UART_OP(1)		
#endif

#endif
	

#endif	/* __ASMPPC_PPC4xx_SERIAL_H */
#endif /* __KERNEL__ */
