/*
 *    Copyright 2001 MontaVista Software Inc.
 *	PPC405 modifications
 * 	Author: MontaVista Software, Inc.
 *         	frank_rowand@mvista.com or source@mvista.com
 *
 *    Module name: redwood.h
 *
 *    Description:
 *      Macros, definitions, and data structures specific to the IBM PowerPC
 *      STB03xxx "Redwood" evaluation board.
 */

#ifdef __KERNEL__
#ifndef __ASM_REDWOOD_H__
#define __ASM_REDWOOD_H__

/* Redwoods have an STB03xxx or STB04xxx core */
#include <platforms/ibmstbx.h>

typedef struct board_info {
	unsigned char	bi_s_version[4];	/* Version of this structure */
	unsigned char	bi_r_version[30];	/* Version of the IBM ROM */
	unsigned int	bi_memsize;		/* DRAM installed, in bytes */
	unsigned int	bi_dummy;		/* field shouldn't exist */
	unsigned char	bi_enetaddr[6];		/* Ethernet MAC address */
	unsigned int	bi_intfreq;		/* Processor speed, in Hz */
	unsigned int	bi_busfreq;		/* Bus speed, in Hz */
	unsigned int	bi_tbfreq;		/* Software timebase freq */
} bd_t;


/*
 * Memory map for the IBM "Redwood-4" STB03xxx evaluation board.
 *
 * The  STB03xxx internal i/o addresses don't work for us 1:1,
 * so we need to map them at a well know virtual address.
 *
 * 4000 000x   uart1           -> 0xe000 000x
 * 4001 00xx   ppu
 * 4002 00xx   smart card
 * 4003 000x   iic
 * 4004 000x   uart0
 * 4005 0xxx   timer
 * 4006 00xx   gpio
 * 4007 00xx   smart card
 * 400b 000x   iic
 * 400c 000x   scp
 * 400d 000x   modem
 */

#define PPC4xx_ONB_IO_PADDR	((uint)0x40000000)
#define PPC4xx_ONB_IO_VADDR	((uint)0xe0000000)
#define PPC4xx_ONB_IO_SIZE	((uint)14*64*1024)

/* Since we're into address mapping hacks, at least try to hide
 * it under a macro.....
 */
#define STB03xxx_MAP_IO_ADDR(a)	(((uint)(a) & 0x000fffff) + PPC4xx_ONB_IO_VADDR)

#define OAKNET_IO_PADDR		((uint)0xf2000000)
#define OAKNET_IO_VADDR		OAKNET_IO_PADDR
#define OAKNET_IO_BASE		OAKNET_IO_VADDR

/* ftr revisit- io size was 0xffff in old-line, is 0x40 in oak.h */
#define OAKNET_IO_SIZE		0xffff
#define OAKNET_INT		26	/* EXTINT1 */

#define _IO_BASE	0
#define _ISA_MEM_BASE	0
#define PCI_DRAM_OFFSET	0


/* Default reset SCCR on RW5 gives us this base baud rate clock.
*/

#define BASE_BAUD		1312500

#define RS_TABLE_SIZE		1
#define UART0_INT		20
#ifdef __BOOTER__
#define UART0_IO_BASE		(u8 *)0x40040000
#else
#define UART0_IO_BASE		(u8 *) STB03xxx_MAP_IO_ADDR(0x40040000)
#endif

#define UART1_INT		20
#ifdef __BOOTER__
#define UART1_IO_BASE		(u8 *)0x40040000
#else
#define UART1_IO_BASE		(u8 *)STB03xxx_MAP_IO_ADDR(0x40040000)
#endif

/* need to make this work in scheme - armin */

#define SICC0_INTRX		21
#define SICC0_INTTX		22
#ifdef __BOOTER__
#define SICC0_IO_BASE		0x40000000
#else
#define SICC0_IO_BASE		0x40000000
#endif

#define MAX_HWIFS 1

#define PPC4xx_MACHINE_NAME	"IBM Redwood"

#endif /* __ASM_REDWOOD_H__ */
#endif /* __KERNEL__ */
