/*
 *  LinkStation HW Control Driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */

#ifndef __MELCO_HWCTL_H__
#define __MELCO_HWCTL_H__

enum tHardwareCtlType 
{
HWTYPE_UNKNOWN,
HWTYPE_WITH_PLD_MODEL,
HWTYPE_NONE_PLD_MODEL
};

enum tLedList
{
LED_DIAG,
LED_WIRELESS,
LED_WIRELESS_EX,
LED_BLINK1,
LED_BLINK2,
LED_ALL
};

#define VID_ADMTEK		0x1317
#define DID_AN983B		0x985
#define VID_SiI			0x1095
#define DID_SiI680		0x680
#define VID_NEC			0x1033
#define DID_720101_U1	0x35
#define DID_720101_U2	0xe0

#define FLASH_CLEAR_START	0x53
#define FLASH_CLEAR_END		0x52
#define FLASH_UPDATE_START	0x55
#define FLASH_UPDATE_END	0x54
#define HDD_NOT_PRESENT		0x6D

enum tHardwareCtlType HWCtl_Init(void);
enum tHardwareCtlType HWCtl_GetType(void);
int HWCtl_Led_Up(enum tLedList);
int HWCtl_Led_Down(enum tLedList);
int HWCtl_Led_Status(enum tLedList);
int HWCtl_Rom_Write_Enable(void);
int HWCtl_Rom_Write_Disable(void);
unsigned char HWCtl_GetHardWare_ID(void);
int HWCtl_GetInitSwitch(void);
int HWCtl_Watchdog_Knock(void);
void blink_led(unsigned char state);

#endif //__MELCO_HWCTL_H__
