/*
 *  LinkStation Serial Driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */

#ifndef	_MECLO_SERIAL_H
#define	_MECLO_SERIAL_H

#define	MELCO_SERIAL_1_ADDR		0x80004500
#define	MELCO_SERIAL_2_ADDR		0x80004600

#define RS_TABLE_SIZE  2

#define BASE_BAUD  (100000000 / 16)

#ifndef SERIAL_MAGIC_KEY
#define kernel_debugger ppc_kernel_debug
#endif

#ifdef CONFIG_SERIAL_DETECT_IRQ
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST|ASYNC_AUTO_IRQ)
#else
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST)
#endif

#define EUMB_COM_FLAGS ASYNC_SKIP_TEST

#ifdef CONFIG_REVERSE_SERIAL_PORT
#define SERIAL_PORT_DFNS \
          { 0, BASE_BAUD, MELCO_SERIAL_2_ADDR, 138, EUMB_COM_FLAGS,          \
                type: PORT_16550A,                                           \
                xmit_fifo_size: 16,                                          \
                iomem_base: (u8 *)MELCO_SERIAL_2_ADDR,                       \
                io_type: SERIAL_IO_MEM },                                    \
          { 0, BASE_BAUD, MELCO_SERIAL_1_ADDR, 137, EUMB_COM_FLAGS,          \
                type: PORT_16550A,                                           \
                xmit_fifo_size: 16,                                          \
                iomem_base: (u8 *)MELCO_SERIAL_1_ADDR,                       \
                io_type: SERIAL_IO_MEM },


#else
#define SERIAL_PORT_DFNS \
          { 0, BASE_BAUD, MELCO_SERIAL_1_ADDR, 137, EUMB_COM_FLAGS,          \
                type: PORT_16550A,                                           \
                xmit_fifo_size: 16,                                          \
                iomem_base: (u8 *)MELCO_SERIAL_1_ADDR,                       \
                io_type: SERIAL_IO_MEM },                                    \
          { 0, BASE_BAUD, MELCO_SERIAL_2_ADDR, 138, EUMB_COM_FLAGS,          \
                type: PORT_16550A,                                           \
                xmit_fifo_size: 16,                                          \
                iomem_base: (u8 *)MELCO_SERIAL_2_ADDR,                       \
                io_type: SERIAL_IO_MEM },


#endif

#endif