summary: The GNU time command.
Name: hhl-target-time
Version: 1.7
Release: %{_hhl_build_id}.1
License: GPL
Group: utils 
Source: time-%{version}.tar.gz
Source1: time.tmpl
Patch: time-%{version}-diff
Patch1: time-1.7-glibc.patch
%define pkgname hhl-%{_hhl_target_arch}-time
Buildroot: %{_tmppath}/%{pkgname}-root
Prefix: %{_hhl_cross_target_dir}
%define targetroot %{_hhl_cross_target_dir}

%define _bindir %{targetroot}%{_hhl_target_bin_dir}
%define _mandir %{targetroot}%{_hhl_target_man_dir}
%define _docdir %{targetroot}%{_hhl_target_doc_dir}
%define _infodir %{targetroot}%{_hhl_target_info_dir}

%description
The `time' command runs another program, then displays information
about the resources used by that program, collected by the system while
the program was running.  You can select which information is reported
and the format in which it is shown, or have `time' save the information
in a file instead of display it on the screen.

The resources that `time' can report on fall into the general
categories of time, memory, I/O, and IPC calls.

The GNU version can format the output in arbitrary ways by using a
printf-style format string to include various resource measurements.

%package -n %{pkgname}
Summary: The GNU time command.
Group: Applications/System
AutoReqProv: no
%description -n %{pkgname}
The `time' command runs another program, then displays information
about the resources used by that program, collected by the system while
the program was running.  You can select which information is reported
and the format in which it is shown, or have `time' save the information
in a file instead of display it on the screen.

The resources that `time' can report on fall into the general
categories of time, memory, I/O, and IPC calls.

The GNU version can format the output in arbitrary ways by using a
printf-style format string to include various resource measurements.

%prep
%target_check
%setup -q -n time-%{version}
%patch -p1
%patch1 -p1

%build
%target_setup
%target_configure
%make

%install
%target_setup
rm -rf %{buildroot}

for i in %{_bindir} %{_mandir}/man1 %{_infodir} ; do
    install -d %{buildroot}$i
done

(cd objdir && install -m 755 time %{buildroot}%{_bindir}/time)
install -m 644 debian/time.1 %{buildroot}%{_mandir}/man1/time.1
install -m 644 time.info %{buildroot}%{_infodir}/time.info
gzip -9f %{buildroot}%{_mandir}/man1/*
gzip -9f %{buildroot}%{_infodir}/*.info*
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/time

%clean
rm -rf %{buildroot}

%files -n %{pkgname}
%defattr(-,root,root)
%{_bindir}/time
%doc %{_infodir}/time.info.gz
%doc %{_mandir}/man1/time.1.gz

%doc ChangeLog README NEWS LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/time

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Thu Mar 15 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file

