Summary: The GNU assembler, linker and binary utilities.
Name: hhl-target-binutils
Version: 2.11.2
Release: %{_hhl_build_id}.5

Source: ftp://ftp.gnu.org/gnu/binutils/binutils-2.11.2.tar.gz
Source1: binutils-gasp.1
Source2: binutils-readelf.1
Source3: binutils.tmpl
Source4: binutils-dev.tmpl
Source5: binutils-doc.tmpl

Patch1: binutils-nohoststrip.patch
Patch2: binutils-2.11.2-mips-mad.patch
Patch3: binutils-2.11.2-sh.patch
Patch6: binutils-2.11.2-reloc.patch
Patch7: binutils-2.10.91.0.3-sh2.patch
Patch8: binutils-2.11.2-objcopy.patch
Patch9: binutils-2.11.2-mips-debug.patch
Patch10: binutils-2.11.2-bug1347.patch

License: GPL/LGPL
Group: devel
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir		%{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}
%description
The programs in this package are used to assemble, link and manipulate
binary and object files.  They may be used in conjunction with a compiler
and various libraries to build programs for Linux.

# Target Package
%package -n hhl-%{_hhl_target_arch}-binutils
Summary: The GNU assembler, linker and binary utilities for the %{_hhl_target_arch}.
Group: devel
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-binutils
The programs in this package are used to assemble, link and manipulate
binary and object files.  They may be used in conjunction with a compiler
and various libraries to build programs for Linux.

# Devel Package
# This package is generally not to be used to build with... it is provided
# for completeness and someone might want to get tricky with the BFD 
# libraries and do something cool...
%package -n hhl-%{_hhl_target_arch}-binutils-dev
Summary: The GNU binary utilites (BFD development files)
Group: devel
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-binutils-dev
This package includes header files and static libraries necessary to build 
programs which use the GNU BFD library, which is part of binutils.

# Documentation Package
%package -n hhl-%{_hhl_target_arch}-binutils-doc
Summary: Documentation for the GNU assembler, linker and binary utilities.
Group: doc
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-binutils-doc
This package consists of the documentation for the GNU assembler,
linker and binary utilities.

%prep
%target_check
%setup -n binutils-%{version} -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1

%build
(cd gas && autoconf)
(cd bfd && autoconf)
%target_setup
%target_tool_configure --target=%{_hhl_target_toolconfig} \
	--enable-shared \
	| tee ../build.log

# Don't use %dmake for now; binutils 2.11.2 is broken w.r.t. parallel
# builds.  Fixed in later versions.
%make 2>&1 | tee -a ../build.log

%install
rm -rf %{buildroot}

cp COPYING LICENSE

%target_setup
%target_makeinstall \
	install-info 2>&1 | tee -a ../build.log
%demangle_libtool

# Add the missing man pages... The following were taken from Debian
cp %{_sourcedir}/binutils-gasp.1 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/gasp.1
cp %{_sourcedir}/binutils-readelf.1 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/readelf.1

gzip -v9 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*
gzip -v9 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

pushd %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
for i in addr2line ar as c++filt gasp gprof ld nm \
	objcopy objdump ranlib readelf strip; do 
  ln -s $i %{_hhl_target_toolprefix}$i
done
popd

install  ../include/dis-asm.h %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE5} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-doc

rm -rf %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/dir.gz

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-binutils
%defattr(-,root,root)
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/bin
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib/ldscripts
%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/bin/*
%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib/ldscripts/*
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/*.1.gz
%doc COPYING COPYING.LIB build.log
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils

%files -n hhl-%{_hhl_target_arch}-binutils-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/*
%doc LICENSE

%files -n hhl-%{_hhl_target_arch}-binutils-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-doc

%changelog
* Fri Feb 15 2002 Michael Eager <eager@mvista.com> 
- Defect 1-GE7F -- fix libtool problem.
* Wed Feb 13 2002 Michael Eager <eager@mvista.com>
- Build shared versions of libopcodes, etc.
- Include dis-asm.h in binutils-dev package. 
* Thu Nov  1 2001 Michael Eager <eager@mvista.com>
- Fix Xscale asm bug 1347.
* Tue Sep 25 2001 Michael Eager <eager@mvista.com>
- Upgrade to binutils-2.11.2
* Mon Aug 13 2001 Michael Eager <eager@mvista.com>
- Convert to use target_tool_config and  hhl_target_toolconfig.

* Wed Aug 01 2001 Daniel Jacobowitz <source@mvista.com>
- Added SH relocation fixes.
* Thu Apr 19 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Mon Feb 19 2001 Mark Hatle <source@mvista.com>
- First cut
