Summary: The Pathologically Eclectic Rubbish Lister
Name: hhl-target-perl
Version: 5.6.1
Release: %{_hhl_build_id}.3
Source0: perl_%{version}.orig.tar.gz
Source1: perl-config-defaults.sh 
Source2: perl.tmpl
Source3: hhl-perl-5.6.1-symbol.sh
Patch0: perl_5.6.1-5.diff.gz
Patch10: hhl-perl-5.6.1-cross.patch
License: Artistic/GPL
Group: interpreters
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
# The buildrequires is because we MUST have longdbl support in platformtest
#BuildRequires: hhl-host-platformtest => 0.1.2
Prefix: %{_hhl_cross_target_dir}
%define _docdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
A scripting language with delusions of full language-hood, Perl is used
in many system scripts and utilities.

Perl is optimised for scanning arbitrary text files and system
administration.  It has built-in extended regular expression matching
and replacement, a data-flow mechanism to improve security with
setuid scripts and is extensible via modules that can interface to C
libraries. However, it is particularly prone to unreadable syntax.

%package -n hhl-%{_hhl_target_arch}-perl
Summary: Practical Extracting and Reporting Language
Group: interpreters
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-perl
A scripting language with delusions of full language-hood, Perl is used
in many system scripts and utilities.

Perl is optimised for scanning arbitrary text files and system
administration.  It has built-in extended regular expression matching
and replacement, a data-flow mechanism to improve security with
setuid scripts and is extensible via modules that can interface to C
libraries. However, it is particularly prone to unreadable syntax.

# At some point in time we will probably want to expand this to
# match Debian's breakout of: perl, perl-base, perl-modules, perl-doc, 
#                             perl-suid, libperl, etc...
# (or at least match the TCT file...)
%prep
%target_check
%setup -q -n perl-%{version}
%patch0 -p1
%patch10 -p1 -b .cross

## NOTES: This spec is pure evil. Let me count the ways:
## Most evilness has been eliminated...
## 1. We need to make sure alignbytes is passed in with the right value
##    (4 is the default, this may need to be 8 on a 64-bit arch)
## 2. 64-bit arches will NOT work with the current def config.

%build
%target_setup
%target_acplatvars

# First we build a miniperl for the host...Since perl requires perl to build perl..
# I have a headache..
bash Configure -de -Duselargefiles='undef' -Dlseektype='off_t' -Dlseeksize=4 ## TODO: constants evil
%make miniperl 2>&1 | tee -a minibuild.log
mv miniperl miniperl.host
ln -sf miniperl.host miniperl
make clean
# If we don't remove the config.sh, it may pick up host defines later!
rm -f config.sh
ln -sf miniperl.host miniperl

# If you add to these subs watch that you are redirecting to the right files...
# Do HHL Substitutions
sed -e "s/%%{_hhl_target_name}/%{_hhl_target_name}/g" < %{SOURCE1} > config-defaults.sh.tmp
sed -e "s/%%{_hhl_target_config}/%{_hhl_target_config}/g" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/%%{_hhl_target_cpu}/%{_hhl_target_cpu}/g" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/%%{_hhl_target_toolprefix}/%{_hhl_target_toolprefix}/g" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s@%%{buildroot}@%{buildroot}@g" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s@%%{_hhl_cross_target_dir}@%{_hhl_cross_target_dir}@g" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s@%%{_hhl_target_prefix}@%{_hhl_target_prefix}@g" < config-defaults.sh > config-defaults.sh.tmp
cat config-defaults.sh.tmp > config-defaults.sh

# Do Arch Specific subs..
sed -e "s/doublesize='HHLDEFINE'/doublesize='${ac_cv_sizeof_double}'/" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/longdblsize='HHLDEFINE'/longdblsize='${ac_cv_sizeof_long_double}'/" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/longlongsize='HHLDEFINE'/longlongsize='${ac_cv_sizeof_long_long}'/" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/longsize='HHLDEFINE'/longsize='${ac_cv_sizeof_long}'/" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/lseeksize='HHLDEFINE'/lseeksize='${ac_cv_sizeof_off_t}'/" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/ptrsize='HHLDEFINE'/ptrsize='${ac_cv_sizeof_void_p}'/" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/shortsize='HHLDEFINE'/shortsize='${ac_cv_sizeof_short}'/" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/intsize='HHLDEFINE'/intsize='${ac_cv_sizeof_int}'/" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/fpossize='HHLDEFINE'/fpossize='${ac_cv_sizeof_fpos_t}'/" < config-defaults.sh > config-defaults.sh.tmp
sed -e "s/charsize='HHLDEFINE'/charsize='${ac_cv_sizeof_char}'/" < config-defaults.sh.tmp > config-defaults.sh
sed -e "s/nvsize='HHLDEFINE'/nvsize='${ac_cv_sizeof_double}'/" < config-defaults.sh > config-defaults.sh.tmp
cat config-defaults.sh.tmp > config-defaults.sh

# This is really annoying, all this does is work around some possible 
# issues use -f option to Configure
cp config-defaults.sh config.sh

# Add in the *symbols defines...
bash %{SOURCE3} >> config.sh

# Do the master perl configure
bash Configure -deS -O \
	-Dknowitall 2>&1 | tee -a build.log

ln -sf miniperl.host miniperl

%make -k | tee -a build.log

%install
rm -rf %{buildroot}
cp Copying LICENSE
%target_setup
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_exec_prefix}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}

./miniperl installperl
mv perl perl.target
ln -s miniperl perl
./installman

# Remove cruft
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl/%{version}/.packlist
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl/%{version}/CORE/sperl.o
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/perl/%{version}/unicode/mktables.PL

# Remove non-applicable help files
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/perlfilter.1
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/perl/%{version}/pod/perlfilter.pod

# Move perl library
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl/%{version}/CORE/libperl.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.

install -m 755 utils/pl2pm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/pl2pm
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl5
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/perl5

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/perl

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-perl
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libperl.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/perl5
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/perl
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/perl5
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/perl
%doc LICENSE
%changelog
* Fri Aug 10 2001 Mark Hatle <source@mvista.com>
- Reved the version to 5.6.1
- Remodel the build structure after a week of learning why I dislike perl.

* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files

* Tue Mar 20 2001 Charles Duffy <source@mvista.com>
- Upgrade to perl 5.6
- Fix many, many points of extreme ugliness
- Remove -doc subpackage (until documentation can be succesfully generated)

* Sun Mar 18 2001 Charles Duffy <source@mvista.com>
- First cut (based on CDKit 1.2 package due to time constraints)
