Summary: GNU awk, a pattern scanning and processing language
Name: hhl-target-gawk
Version: 3.1.0
Release: %{_hhl_build_id}.2
Source: gawk_%{version}.orig.tar.gz
Source1: gawk.tmpl
Patch: gawk_%{version}-1.diff.gz
License: GPL
Group: Applications/Text
%define pkgname hhl-%{_hhl_target_arch}-gawk
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}

%define _bindir		%{targetroot}%{_hhl_target_bin_dir}
%define _libdir		%{targetroot}%{_hhl_target_lib_dir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _infodir	%{targetroot}%{_hhl_target_info_dir}
%define _datadir	%{targetroot}%{_hhl_target_sharedstate_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}

%description
`awk', a program that you can use to select particular records in a
file and perform operations upon them.

Gawk is the GNU Project's implementation of the AWK programming language.
It conforms to the definition of the language in the POSIX 1003.2 Command
Language And Utilities Standard. This version in turn is based on the
description in The AWK Programming Language, by Aho, Kernighan, and
Weinberger, with the additional features defined in the System V Release
4 version of UNIX awk. Gawk also provides more recent Bell Labs awk
extensions, and some GNU-specific extensions.

%package -n %{pkgname}
Summary: GNU awk, a pattern scanning and processing language
Group: Applications/Text
AutoReqProv: no

%description -n %{pkgname}
`awk', a program that you can use to select particular records in a
file and perform operations upon them.

Gawk is the GNU Project's implementation of the AWK programming language.
It conforms to the definition of the language in the POSIX 1003.2 Command
Language And Utilities Standard. This version in turn is based on the
description in The AWK Programming Language, by Aho, Kernighan, and
Weinberger, with the additional features defined in the System V Release
4 version of UNIX awk. Gawk also provides more recent Bell Labs awk
extensions, and some GNU-specific extensions.

%prep
%target_check
%setup -q -n gawk-%{version}
%patch -p1

%build
%target_setup
export ac_cv_func_getpgrp_void='yes'
%target_configure --libexecdir=/usr/lib
%make

%install
rm -rf %{buildroot}
%target_setup
%target_makeinstall	datadir=%{buildroot}%{_datadir}/awk \
			libexecdir=%{buildroot}%{_libdir}/awk \
			prefix=%{buildroot}%{_datadir} \
			infodir=%{buildroot}%{_infodir} \
			exec_prefix=%{buildroot}%{targetroot}/usr


mkdir -p %{buildroot}%{targetroot}/bin

ln -s ../usr/bin/gawk %{buildroot}%{targetroot}/bin/awk

rm -f %{buildroot}%{_infodir}/dir
gzip -9f %{buildroot}%{_infodir}/*
gzip -9f %{buildroot}%{_mandir}/man*/*
cd ..
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gawk

%clean
rm -rf %{buildroot}

%files -n %{pkgname}
%defattr(-,root,root)
%{targetroot}/bin/awk
%{_bindir}/gawk
%{_bindir}/igawk
%{_bindir}/pgawk
%{_libdir}/awk/*
%{_datadir}/awk/*
%{_mandir}/man*/*
%{_infodir}/*

%doc README NEWS LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gawk

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Feb 13 2001 Matthew McLean <source@mvista.com>
- First cut
