Name: hhl-target-kernel-headers
Version: %{_hhl_kernel_base_version}_%{_hhl_kernel_hhl_version}
Release: %{_hhl_build_id}.9
#Source0 from installed package
Source10: arm_sa_le-defconfig
Source11: arm_sa_be-defconfig
Source12: arm_xscale_le-defconfig
Source13: arm_720t_le-defconfig
Source14: arm_720t_be-defconfig
Source15: arm_920t_le-defconfig
Source16: arm_920t_be-defconfig
Source17: arm_xscale_be-defconfig
Source20: mips_fp_be-defconfig
Source21: mips_fp_le-defconfig
Source22: mips_nfp_be-defconfig
Source23: mips_nfp_le-defconfig
Source24: lexra_fp_be-defconfig
Source25: mips_sb1_fp_be-defconfig
Source26: mips_sb1_fp_le-defconfig
Source27: mips_sony_fp_le-defconfig
Source30: ppc_405-defconfig
Source31: ppc_7xx-defconfig
Source32: ppc_74xx-defconfig
Source33: ppc_82xx-defconfig
Source34: ppc_8xx-defconfig
Source35: ppc_403-defconfig
Source40: sparc_ultra-defconfig
Source41: BuildASM
Source50: x86_386-defconfig
Source51: x86_486-defconfig
Source52: x86_586-defconfig
Source53: x86_athlon-defconfig
Source54: x86_crusoe-defconfig
Source55: x86_k6-defconfig
Source56: x86_pentium-defconfig
Source57: x86_pentium2-defconfig
Source58: x86_pentium3-defconfig
Source59: x86_pentium4-defconfig
Source60: sh_sh3_be-defconfig
Source61: sh_sh3_le-defconfig
Source62: sh_sh4_be-defconfig
Source63: sh_sh4_le-defconfig
License: GPL
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
BuildArchitectures: noarch
BuildRequires: hhl-rpmconfig hhl-host-kernel = %{version}
%define _docdir         %{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}

#
#  PACKAGE:  SRPM
#
Summary: Linux kernel headers for Hard Hat Linux.
Group: devel

%description
The Linux kernel headers are used by various tools, such as GCC.  They
are required if you wish to compile any software.

#
#  PACKAGE:  kernel-headers
#
%package -n hhl-%{_hhl_target_arch}-kernel-headers
Summary: Linux kernel headers for Hard Hat Linux.
Group: devel
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-kernel-headers

This package contains the C header files from the kernel source tree.
These header files are included by many of the standard C header files,
so this package is needed to build most standard applications for the
target environment.  They are required if you wish to compile any 
software.

#
#  PREP
#
%prep
%target_check

SRCDIR="$PWD"/linux
rm -rf ${SRCDIR}
mkdir -p ${SRCDIR}
cd ${SRCDIR}

CONFIG="Target Missing"

cp -a %{_hhl_kernel_dir}/linux-%{version}/* ${SRCDIR}/.

rm -f .hhl_target_cpu
echo %{_hhl_target_cpu} > .hhl_target_cpu

rm -f .hhl_cross_compile
echo %{_hhl_target_toolprefix} > .hhl_cross_compile

%if "%{_hhl_target_arch}" == "arm_sa_le"
CONFIG=%{SOURCE10}
%endif
%if "%{_hhl_target_arch}" == "arm_sa_be"
CONFIG=%{SOURCE11}
%endif
%if "%{_hhl_target_arch}" == "arm_xscale_le"
CONFIG=%{SOURCE12}
%endif
%if "%{_hhl_target_arch}" == "arm_720t_le"
CONFIG=%{SOURCE13}
%endif
%if "%{_hhl_target_arch}" == "arm_720t_be"
CONFIG=%{SOURCE14}
%endif
%if "%{_hhl_target_arch}" == "arm_920t_le"
CONFIG=%{SOURCE15}
%endif
%if "%{_hhl_target_arch}" == "arm_920t_be"
CONFIG=%{SOURCE16}
%endif
%if "%{_hhl_target_arch}" == "arm_xscale_be"
CONFIG=%{SOURCE17}
%endif
%if "%{_hhl_target_arch}" == "mips_fp_be"
CONFIG=%{SOURCE20}
%endif
%if "%{_hhl_target_arch}" == "mips_fp_le"
CONFIG=%{SOURCE21}
%endif
%if "%{_hhl_target_arch}" == "mips_nfp_be"
CONFIG=%{SOURCE22}
%endif
%if "%{_hhl_target_arch}" == "mips_nfp_le"
CONFIG=%{SOURCE23}
%endif
%if "%{_hhl_target_arch}" == "mips_lexra_fp_be"
CONFIG=%{SOURCE24}
%endif
%if "%{_hhl_target_arch}" == "mips_sb1_fp_be"
CONFIG=%{SOURCE25}
%endif
%if "%{_hhl_target_arch}" == "mips_sb1_fp_le"
CONFIG=%{SOURCE26}
%endif
%if "%{_hhl_target_arch}" == "mips_sony_fp_le"
CONFIG=%{SOURCE27}
%endif
%if "%{_hhl_target_arch}" == "ppc_405"
CONFIG=%{SOURCE30}
%endif
%if "%{_hhl_target_arch}" == "ppc_7xx"
CONFIG=%{SOURCE31}
%endif
%if "%{_hhl_target_arch}" == "ppc_74xx"
CONFIG=%{SOURCE32}
%endif
%if "%{_hhl_target_arch}" == "ppc_82xx"
CONFIG=%{SOURCE33}
%endif
%if "%{_hhl_target_arch}" == "ppc_8xx"
CONFIG=%{SOURCE34}
%endif
%if "%{_hhl_target_arch}" == "ppc_403"
CONFIG=%{SOURCE35}
%endif
%if "%{_hhl_target_arch}" == "x86_386"
CONFIG=%{SOURCE50}
%endif
%if "%{_hhl_target_arch}" == "x86_486"
CONFIG=%{SOURCE51}
%endif
%if "%{_hhl_target_arch}" == "x86_586"
CONFIG=%{SOURCE52}
%endif
%if "%{_hhl_target_arch}" == "x86_athlon"
CONFIG=%{SOURCE53}
%endif
%if "%{_hhl_target_arch}" == "x86_crusoe"
CONFIG=%{SOURCE54}
%endif
%if "%{_hhl_target_arch}" == "x86_k6"
CONFIG=%{SOURCE55}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium"
CONFIG=%{SOURCE56}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium2"
CONFIG=%{SOURCE57}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium3"
CONFIG=%{SOURCE58}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium4"
CONFIG=%{SOURCE59}
%endif
%if "%{_hhl_target_arch}" == "sh_sh3_be"
CONFIG=%{SOURCE60}
%endif
%if "%{_hhl_target_arch}" == "sh_sh3_le"
CONFIG=%{SOURCE61}
%endif
%if "%{_hhl_target_arch}" == "sh_sh4_be"
CONFIG=%{SOURCE62}
%endif
%if "%{_hhl_target_arch}" == "sh_sh4_le"
CONFIG=%{SOURCE63}
%endif

%if "%{_hhl_target_arch}" == "sparc_ultra"
# The sparc doesn't look like it needs to be configured to have valid 
# headers...
#cp %{SOURCE40} .config
CONFIG=SOURCE10

rm -rf include/asm
mkdir -p include/asm
cp %{SOURCE41} include/asm/.
chmod +x include/asm/BuildASM

%else
# Copy configuration (or fail if none available)
cp $CONFIG .config
%endif

#
#  BUILD
#
%build
%target_setup

SRCDIR="$PWD"/linux
cd ${SRCDIR}

%if "%{_hhl_target_arch}" == "sparc_ultra"
./include/asm/BuildASM ./include
%else
HHL_CONFIG_DEFAULTNEW=y %make oldconfig
%dmake include/linux/version.h
%endif

#
#  INSTALL
#
%install
%target_setup
SRCDIR="$PWD"/linux
cp ${SRCDIR}/COPYING LICENSE
cd ${SRCDIR}

rm -rf %{buildroot}
mkdir -p %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}
cp -a include/linux %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}
%if "%{_hhl_target_arch}" == "sparc_ultra"
cp -a include/asm-generic %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-sparc %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-sparc64 %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%else
ln -s asm-%{_hhl_target_cpu} %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
cp -a include/asm-generic %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-%{_hhl_target_cpu} %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%if "%{_hhl_cpu_type}" == "ppc"
cp -a include/asm-m68k %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%endif
%endif

#
#  CLEAN
#
%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-kernel-headers
%defattr(-,root,root)
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/linux
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/linux/*

%if "%{_hhl_target_arch}" == "sparc_ultra"
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc64
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc64/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic/*
%else
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic/*
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-%{_hhl_target_cpu}/*
%if "%{_hhl_cpu_type}" == "ppc"
%{_hhl_cross_target_dir}/%{_hhl_target_includedir}/asm-m68k/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_includedir}/asm-m68k
%endif
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-%{_hhl_target_cpu}
%endif
%doc LICENSE

#
#  CHANGELOG
#
%changelog
* Mon Oct 29 2001 Michael Eager <eager@mvista.com>
- Add Sibyte and PPC-403 targets.
* Mon Feb 19 2001 Mark Hatle <source@mvista.com>
- Stupid sparc requires something special to work!

* Mon Jan 22 2001 Mark Hatle <fray@mvista.com>
- Initial HHL 2.0 version

* Tue Sep 26 2000 Joe Green <jgreen@mvista.com>
- Moved into kernel directory.  Use _hhl_target_cpu instead of _hhl_cpu_type.

* Wed Jun 14 2000 Mark Hatle <mhatle@mvista.com>
- Started this package
