#ifndef _PROTO_H_
#define _PROTO_H_
/* This file is automatically generated with "make proto". DO NOT EDIT */

/* The following definitions come from client/client.c  */

void do_list __P((const char *mask,uint16 attribute,void (*fn)(file_info *),BOOL rec, BOOL dirs));
struct cli_state *do_connect __P((const char *server, const char *share));

/* The following definitions come from client/clitar.c  */

void cmd_block __P((void));
void cmd_tarmode __P((void));
void cmd_setmode __P((void));
void cmd_tar __P((void));
int process_tar __P((void));
int tar_parseargs __P((int argc, char *argv[], char *Optarg, int Optind));

/* The following definitions come from lib/access.c  */

BOOL allow_access __P((char *deny_list,char *allow_list,
		  char *cname,char *caddr));
BOOL check_access __P((int sock, char *allow_list, char *deny_list));

/* The following definitions come from lib/bitmap.c  */

struct bitmap *bitmap_allocate __P((int n));
void bitmap_free __P((struct bitmap *bm));
BOOL bitmap_set __P((struct bitmap *bm, unsigned i));
BOOL bitmap_clear __P((struct bitmap *bm, unsigned i));
BOOL bitmap_query __P((struct bitmap *bm, unsigned i));
int bitmap_find __P((struct bitmap *bm, unsigned ofs));

/* The following definitions come from lib/charcnv.c  */

char *unix2dos_format __P((char *to, const char *from));
char *dos2unix_format __P((char *to, const char *from));
void interpret_character_set __P((char *str, int codepage));

/* The following definitions come from lib/charset.c  */

void charset_initialise __P((void));
void codepage_initialise __P((int client_codepage));
void add_char_string __P((const char *s));

/* The following definitions come from lib/crc32.c  */

uint32 crc32_calc_buffer __P(( char *buffer, uint32 count));

/* The following definitions come from lib/debug.c  */

const char* debug_classname_from_index __P((int ndx));
int debug_lookup_classname __P((char* classname));
BOOL debug_parse_params __P((char **params, int *debuglevel_class));
BOOL debug_parse_levels __P((char *params_str));
void debug_message __P((int msg_type, pid_t src, void *buf, size_t len));
void debug_message_send __P((pid_t pid, int level));
void setup_logging __P((const char *pname, BOOL interactive));
BOOL reopen_logs __P(( void ));
void force_check_log_size __P(( void ));
BOOL need_to_check_log_size __P(( void ));
void check_log_size __P(( void ));
void dbgflush __P(( void ));
BOOL dbghdr __P(( int level, const char *file, const char *func, int line ));

/* The following definitions come from lib/error.c  */

NTSTATUS map_nt_error_from_unix __P((int unix_error));

/* The following definitions come from lib/fault.c  */

void fault_setup __P((void (*fn)(void *)));

/* The following definitions come from lib/fsusage.c  */

int sys_fsusage __P((const char *path, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));

/* The following definitions come from lib/genrand.c  */

void set_rand_reseed_data __P((unsigned char *data, size_t len));
void generate_random_buffer __P(( unsigned char *out, int len, BOOL do_reseed_now));
char *generate_random_str __P((size_t len));

/* The following definitions come from lib/getsmbpass.c  */

char *getsmbpass __P((const char *prompt)    );

/* The following definitions come from lib/hash.c  */

BOOL hash_table_init __P((hash_table *table, int num_buckets, compare_function compare_func));
hash_element *hash_lookup __P((hash_table *table, char *key));
hash_element *hash_insert __P((hash_table *table, char *value, char *key));
void hash_remove __P((hash_table *table, hash_element *hash_elem));
void hash_clear __P((hash_table *table));

/* The following definitions come from lib/interface.c  */

void load_interfaces __P((void));
BOOL interfaces_changed __P((void));
BOOL ismyip __P((struct in_addr ip));
BOOL is_local_net __P((struct in_addr from));
int iface_count __P((void));
BOOL we_are_multihomed __P((void));
struct interface *get_interface __P((int n));
struct in_addr *iface_n_ip __P((int n));
struct in_addr *iface_n_bcast __P((int n));
unsigned iface_hash __P((void));
struct in_addr *iface_bcast __P((struct in_addr ip));
struct in_addr *iface_ip __P((struct in_addr ip));

/* The following definitions come from lib/interfaces.c  */

int get_interfaces __P((struct iface_struct *ifaces, int max_interfaces));

/* The following definitions come from lib/kanji.c  */

int regularize_sjis  __P((int w));
void interpret_coding_system __P((const char *str));
void initialize_multibyte_vectors __P(( int client_codepage));

/* The following definitions come from lib/md4.c  */

void mdfour __P((unsigned char *out, unsigned char *in, int n));

/* The following definitions come from lib/messages.c  */

void ping_message __P((int msg_type, pid_t src, void *buf, size_t len));
void debuglevel_message __P((int msg_type, pid_t src, void *buf, size_t len));
BOOL message_init __P((void));
BOOL message_send_pid __P((pid_t pid, int msg_type, const void *buf, size_t len,
		      BOOL duplicates_allowed));
void message_dispatch __P((void));
void message_register __P((int msg_type, 
		      void (*fn)__P((int msg_type, pid_t pid, void *buf, size_t len))));
void message_deregister __P((int msg_type));
BOOL message_send_all __P((TDB_CONTEXT *conn_tdb, int msg_type,
		      const void *buf, size_t len,
		      BOOL duplicates_allowed,
		      int *n_sent));

/* The following definitions come from lib/ms_fnmatch.c  */

int ms_fnmatch __P((const char *pattern, const char *string));

/* The following definitions come from lib/pam_errors.c  */

NTSTATUS pam_to_nt_status __P((int pam_error));
int nt_status_to_pam __P((NTSTATUS nt_status));
NTSTATUS pam_to_nt_status __P((int pam_error));
int nt_status_to_pam __P((NTSTATUS nt_status));

/* The following definitions come from lib/pidfile.c  */

pid_t pidfile_pid __P((const char *name));
void pidfile_create __P((const char *name));

/* The following definitions come from lib/readline.c  */

char *smb_readline __P((char *prompt, void (*callback)(void), 
		   char **(*completion_fn)__P((const char *text, int start, int end))));
void cmd_history __P((void));

/* The following definitions come from lib/replace.c  */

char *rep_inet_ntoa __P((struct in_addr ip));

/* The following definitions come from lib/select.c  */

void sys_select_signal __P((void));
int sys_select __P((int maxfd, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *tval));
int sys_select_intr __P((int maxfd, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *tval));

/* The following definitions come from lib/sendfile.c  */

ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));
ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));
ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));
ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));
ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));
ssize_t sys_sendfile __P((int tofd, int fromfd, const DATA_BLOB *header, SMB_OFF_T offset, size_t count));

/* The following definitions come from lib/signal.c  */

void BlockSignals __P((BOOL block,int signum));
void CatchSignal __P((int signum,RETSIGTYPE (*handler)(int )));
void CatchChild __P((void));
void CatchChildLeaveStatus __P((void));

/* The following definitions come from lib/smbrun.c  */

int smbrun __P((char *cmd, int *outfd));

/* The following definitions come from lib/snprintf.c  */


/* The following definitions come from lib/substitute.c  */

void sub_set_smb_name __P((const char *name));
const char* get_remote_machine_name __P((void));
void standard_sub_basic __P((char *str, int len));
void standard_sub_advanced __P((int snum, char *user, const char *connectpath, gid_t gid, char *str, int len));
void standard_sub_conn __P((connection_struct *conn, char *str, int len));
void standard_sub_home __P((int snum, char *user, char *str, int len));
void standard_sub_snum __P((int snum, char *str, int len));
void standard_sub_vuser __P((char *str, int len, user_struct *vuser));
void standard_sub_vsnum __P((char *str, int len, user_struct *vuser, int snum));

/* The following definitions come from lib/sysacls.c  */

int sys_acl_get_entry __P(( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p));
int sys_acl_get_permset __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P(( SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P(( const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset));
int sys_acl_add_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P(( SMB_ACL_T the_acl, ssize_t *plen));
SMB_ACL_T sys_acl_init __P(( int count));
int sys_acl_create_entry __P(( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry));
int sys_acl_set_tag_type __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype));
int sys_acl_set_qualifier __P(( SMB_ACL_ENTRY_T entry, void *qual));
int sys_acl_set_permset __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset));
int sys_acl_valid __P(( SMB_ACL_T theacl ));
int sys_acl_set_file __P(( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl));
int sys_acl_set_fd __P(( int fd, SMB_ACL_T theacl));
int sys_acl_delete_def_file __P((const char *name));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T the_acl) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P(( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p));
int sys_acl_get_permset __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P(( SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P(( const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset));
int sys_acl_add_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P(( SMB_ACL_T the_acl, ssize_t *plen));
SMB_ACL_T sys_acl_init __P(( int count));
int sys_acl_create_entry __P(( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry));
int sys_acl_set_tag_type __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype));
int sys_acl_set_qualifier __P(( SMB_ACL_ENTRY_T entry, void *qual));
int sys_acl_set_permset __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset));
int sys_acl_valid __P(( SMB_ACL_T theacl ));
int sys_acl_set_file __P(( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl));
int sys_acl_set_fd __P(( int fd, SMB_ACL_T theacl));
int sys_acl_delete_def_file __P((const char *name));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T the_acl) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P((SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p));
int sys_acl_get_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P((SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P((const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset_d));
int sys_acl_add_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P((SMB_ACL_T acl_d, ssize_t *len_p));
SMB_ACL_T sys_acl_init __P((int count));
int sys_acl_create_entry __P((SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_set_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type));
int sys_acl_set_qualifier __P((SMB_ACL_ENTRY_T entry_d, void *qual_p));
int sys_acl_set_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d));
int sys_acl_valid __P((SMB_ACL_T acl_d));
int sys_acl_set_file __P((const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d));
int sys_acl_set_fd __P((int fd, SMB_ACL_T acl_d));
int sys_acl_delete_def_file __P((const char *path));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T acl_d) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P((SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p));
int sys_acl_get_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P((SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P((const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset_d));
int sys_acl_add_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P((SMB_ACL_T acl_d, ssize_t *len_p));
SMB_ACL_T sys_acl_init __P((int count));
int sys_acl_create_entry __P((SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_set_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type));
int sys_acl_set_qualifier __P((SMB_ACL_ENTRY_T entry_d, void *qual_p));
int sys_acl_set_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d));
int sys_acl_valid __P((SMB_ACL_T acl_d));
int sys_acl_set_file __P((const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d));
int sys_acl_set_fd __P((int fd, SMB_ACL_T acl_d));
int sys_acl_delete_def_file __P((const char *path));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T acl_d) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P((SMB_ACL_T acl_d, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *type_p));
int sys_acl_get_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P((SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P((const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset_d));
int sys_acl_add_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P((SMB_ACL_PERMSET_T permset_d, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P((SMB_ACL_T acl_d, ssize_t *len_p));
SMB_ACL_T sys_acl_init __P((int count));
int sys_acl_create_entry __P((SMB_ACL_T *acl_p, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_set_tag_type __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T tag_type));
int sys_acl_set_qualifier __P((SMB_ACL_ENTRY_T entry_d, void *qual_p));
int sys_acl_set_permset __P((SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T permset_d));
int sys_acl_valid __P((SMB_ACL_T acl_d));
int sys_acl_set_file __P((const char *name, SMB_ACL_TYPE_T type, SMB_ACL_T acl_d));
int sys_acl_set_fd __P((int fd, SMB_ACL_T acl_d));
int sys_acl_delete_def_file __P((const char *name));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T acl_d) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P(( SMB_ACL_T theacl, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p));
int sys_acl_get_permset __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P(( SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P(( const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset));
int sys_acl_add_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P(( SMB_ACL_T theacl, ssize_t *plen));
SMB_ACL_T sys_acl_init __P(( int count));
int sys_acl_create_entry __P(( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry));
int sys_acl_set_tag_type __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype));
int sys_acl_set_qualifier __P(( SMB_ACL_ENTRY_T entry, void *qual));
int sys_acl_set_permset __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset));
int sys_acl_valid __P(( SMB_ACL_T theacl ));
int sys_acl_set_file __P(( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl));
int sys_acl_set_fd __P(( int fd, SMB_ACL_T theacl));
int sys_acl_delete_def_file __P((const char *name));
int sys_acl_get_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
int sys_acl_free_text __P((char *text));
int sys_acl_free_acl __P((SMB_ACL_T posix_acl));
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));
int sys_acl_get_entry __P(( SMB_ACL_T the_acl, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int sys_acl_get_tag_type __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p));
int sys_acl_get_permset __P(( SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void *sys_acl_get_qualifier __P(( SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T sys_acl_get_file __P(( const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T sys_acl_get_fd __P((int fd));
int sys_acl_clear_perms __P((SMB_ACL_PERMSET_T permset));
int sys_acl_add_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
int sys_acl_get_perm __P(( SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
char *sys_acl_to_text __P(( SMB_ACL_T the_acl, ssize_t *plen));
int sys_acl_free_text __P((char *text));
SMB_ACL_T sys_acl_init __P(( int count));
int sys_acl_create_entry __P(( SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry));
int sys_acl_set_tag_type __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype));
int sys_acl_set_qualifier __P(( SMB_ACL_ENTRY_T entry, void *qual));
int sys_acl_set_permset __P(( SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset));
int sys_acl_valid __P(( SMB_ACL_T theacl ));
int sys_acl_set_file __P(( const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl));
int sys_acl_set_fd __P(( int fd, SMB_ACL_T theacl));
int sys_acl_delete_def_file __P((const char *name));
int sys_acl_free_acl __P((SMB_ACL_T the_acl) );
int sys_acl_free_qualifier __P((void *qual, SMB_ACL_TAG_T tagtype));

/* The following definitions come from lib/system.c  */

int sys_usleep __P((long usecs));
ssize_t sys_read __P((int fd, void *buf, size_t count));
ssize_t sys_write __P((int fd, const void *buf, size_t count));
ssize_t sys_send __P((int s, const void *msg, size_t len, int flags));
ssize_t sys_sendto __P((int s,  const void *msg, size_t len, int flags, const struct sockaddr *to, smb_socklen_t tolen));
ssize_t sys_recvfrom __P((int s, void *buf, size_t len, int flags, struct sockaddr *from, smb_socklen_t *fromlen));
int sys_fcntl_ptr __P((int fd, int cmd, void *arg));
int sys_fcntl_long __P((int fd, int cmd, long arg));
int sys_stat __P((const char *fname,SMB_STRUCT_STAT *sbuf));
int sys_fstat __P((int fd,SMB_STRUCT_STAT *sbuf));
int sys_lstat __P((const char *fname,SMB_STRUCT_STAT *sbuf));
int sys_ftruncate __P((int fd, SMB_OFF_T offset));
SMB_OFF_T sys_lseek __P((int fd, SMB_OFF_T offset, int whence));
int sys_fseek __P((FILE *fp, SMB_OFF_T offset, int whence));
SMB_OFF_T sys_ftell __P((FILE *fp));
int sys_creat __P((const char *path, mode_t mode));
int sys_open __P((const char *path, int oflag, mode_t mode));
FILE *sys_fopen __P((const char *path, const char *type));
SMB_STRUCT_DIRENT *sys_readdir __P((DIR *dirp));
int sys_mknod __P((const char *path, mode_t mode, SMB_DEV_T dev));
char *sys_realpath __P((const char *path, char *resolved_path));
int sys_waitpid __P((pid_t pid,int *status,int options));
char *sys_getwd __P((char *s));
int sys_symlink __P((const char *oldpath, const char *newpath));
int sys_readlink __P((const char *path, char *buf, size_t bufsiz));
int sys_link __P((const char *oldpath, const char *newpath));
int sys_chown __P((const char *fname,uid_t uid,gid_t gid));
int sys_chroot __P((const char *dname));
struct hostent *sys_gethostbyname __P((const char *name));
void oplock_set_capability __P((BOOL this_process, BOOL inherit));
long sys_random __P((void));
void sys_srandom __P((unsigned int seed));
int groups_max __P((void));
int sys_getgroups __P((int setlen, gid_t *gidset));
int sys_setgroups __P((int setlen, gid_t *gidset));
void sys_setpwent __P((void));
struct passwd *sys_getpwent __P((void));
void sys_endpwent __P((void));
struct passwd *sys_getpwnam __P((const char *name));
struct passwd *sys_getpwuid __P((uid_t uid));
int wsys_stat __P((const smb_ucs2_t *wfname,SMB_STRUCT_STAT *sbuf));
int wsys_lstat __P((const smb_ucs2_t *wfname,SMB_STRUCT_STAT *sbuf));
int wsys_creat __P((const smb_ucs2_t *wfname, mode_t mode));
int wsys_open __P((const smb_ucs2_t *wfname, int oflag, mode_t mode));
FILE *wsys_fopen __P((const smb_ucs2_t *wfname, const char *type));
DIR *wsys_opendir __P((const smb_ucs2_t *wfname));
SMB_STRUCT_WDIRENT *wsys_readdir __P((DIR *dirp));
smb_ucs2_t *wsys_getwd __P((smb_ucs2_t *s));
int wsys_chown __P((const smb_ucs2_t *wfname, uid_t uid, gid_t gid));
int wsys_chroot __P((const smb_ucs2_t *wfname));
SMB_STRUCT_WPASSWD *wsys_getpwnam __P((const smb_ucs2_t *wname));
SMB_STRUCT_WPASSWD *wsys_getpwuid __P((uid_t uid));
pid_t sys_fork __P((void));
pid_t sys_getpid __P((void));
int sys_popen __P((const char *command));
int sys_pclose __P((int fd));
void *sys_dlopen __P((const char *name, int flags));
void *sys_dlsym __P((void *handle, const char *symbol));
int sys_dlclose  __P((void *handle));
const char *sys_dlerror __P((void));
void sys_adminlog __P((int priority, const char *format_str, ...));

/* The following definitions come from lib/talloc.c  */

TALLOC_CTX *talloc_init __P((void));
void *talloc __P((TALLOC_CTX *t, size_t size));
void *talloc_realloc __P((TALLOC_CTX *t, void *ptr, size_t size));
void talloc_destroy_pool __P((TALLOC_CTX *t));
void talloc_destroy __P((TALLOC_CTX *t));
size_t talloc_pool_size __P((TALLOC_CTX *t));
const char * talloc_pool_name __P((TALLOC_CTX const *t));
void *talloc_zero __P((TALLOC_CTX *t, size_t size));
void *talloc_memdup __P((TALLOC_CTX *t, const void *p, size_t size));
char *talloc_strdup __P((TALLOC_CTX *t, const char *p));
char *talloc_describe_all __P((TALLOC_CTX *rt));
void talloc_get_allocation __P((TALLOC_CTX *t,
			   size_t *total_bytes,
			   int *n_chunks));

/* The following definitions come from lib/time.c  */

time_t get_time_t_min __P((void));
time_t get_time_t_max __P((void));
void GetTimeOfDay __P((struct timeval *tval));
void TimeInit __P((void));
void get_process_uptime __P((struct timeval *ret_time));
int TimeDiff __P((time_t t));
struct tm *LocalTime __P((time_t *t));
time_t nt_time_to_unix __P((NTTIME *nt));
time_t nt_time_to_unix_abs __P((NTTIME *nt));
time_t nt_time_to_unix_tz __P((NTTIME *nt, int tz));
time_t interpret_long_date __P((char *p));
void unix_to_nt_time __P((NTTIME *nt, time_t t));
void unix_to_nt_time_abs __P((NTTIME *nt, time_t t));
void put_long_date __P((char *p,time_t t));
BOOL null_mtime __P((time_t mtime));
void put_dos_date __P((char *buf,int offset,time_t unixdate));
void put_dos_date2 __P((char *buf,int offset,time_t unixdate));
void put_dos_date3 __P((char *buf,int offset,time_t unixdate));
time_t make_unix_date __P((void *date_ptr));
time_t make_unix_date2 __P((void *date_ptr));
time_t make_unix_date3 __P((void *date_ptr));
char *http_timestring __P((time_t t));
char *timestring __P((BOOL hires));
time_t get_create_time __P((SMB_STRUCT_STAT *st,BOOL fake_dirs));
void init_nt_time __P((NTTIME *nt));

/* The following definitions come from lib/ufc.c  */

char *ufc_crypt __P((const char *key,const char *salt));

/* The following definitions come from lib/username.c  */

BOOL name_is_local __P((const char *name));
char *get_user_home_dir __P((char *user));
char *get_user_service_home_dir __P((char *user));
BOOL map_username __P((char *user));
struct passwd *Get_Pwnam __P((char *user,BOOL allow_change));
BOOL user_in_group_list __P((char *user,char *gname));
BOOL user_in_list __P((char *user,char *list));
struct passwd *smb_getpwnam __P((char *user, BOOL allow_change));

/* The following definitions come from lib/util.c  */

const char *tmpdir __P((void));
BOOL in_group __P((gid_t group, gid_t current_gid, int ngroups, gid_t *groups));
const char *Atoic __P((const char *p, int *n, const char *c));
const char *get_numlist __P((const char *p, uint32 **num, int *count));
BOOL file_exist __P((char *fname,SMB_STRUCT_STAT *sbuf));
time_t file_modtime __P((const char *fname));
BOOL directory_exist __P((char *dname,SMB_STRUCT_STAT *st));
SMB_OFF_T get_file_size __P((char *file_name));
char *attrib_string __P((uint16 mode));
void show_msg __P((char *buf));
void smb_setlen __P((char *buf,int len));
int set_message __P((char *buf,int num_words,int num_bytes,BOOL zero));
int set_message_bcc __P((char *buf,int num_bytes));
int set_message_end __P((void *outbuf,void *end_ptr));
void dos_clean_name __P((char *s));
void unix_clean_name __P((char *s));
void make_dir_struct __P((char *buf,const char *mask,const char *fname,SMB_OFF_T size,int mode,time_t date));
void close_low_fds __P((void));
int set_blocking __P((int fd, BOOL set));
ssize_t transfer_file_internal __P((int infd, int outfd, size_t n, ssize_t (*read_fn)(int, void *, size_t),
						ssize_t (*write_fn)(int, const void *, size_t)));
SMB_OFF_T transfer_file __P((int infd,int outfd,SMB_OFF_T n));
void msleep __P((unsigned int t));
void become_daemon __P((void));
BOOL yesno __P((char *p));
void *Realloc __P((void *p,size_t size));
void safe_free __P((void *p));
BOOL get_myname __P((char *my_name));
int interpret_protocol __P((char *str,int def));
BOOL is_ipaddress __P((const char *str));
uint32 interpret_addr __P((const char *str));
struct in_addr *interpret_addr2 __P((const char *str));
BOOL is_zero_ip __P((struct in_addr ip));
void zero_ip __P((struct in_addr *ip));
char *automount_lookup __P((char *user_name));
char *automount_lookup __P((char *user_name));
BOOL same_net __P((struct in_addr ip1,struct in_addr ip2,struct in_addr mask));
BOOL process_exists __P((pid_t pid));
char *uidtoname __P((uid_t uid));
char *gidtoname __P((gid_t gid));
uid_t nametouid __P((char *name));
gid_t nametogid __P((char *name));
void smb_panic __P((const char *why));
char *readdirname __P((DIR *p));
BOOL is_in_path __P((const char *name, name_compare_entry *namelist));
void set_namearray __P((name_compare_entry **ppname_array, char *namelist));
void free_namearray __P((name_compare_entry *name_array));
BOOL fcntl_lock __P((int fd, int op, SMB_OFF_T offset, SMB_OFF_T count, int type));
BOOL is_myname __P((char *s));
const char* get_my_primary_ip  __P((void));
BOOL is_myname_or_ipaddr __P((char *s));
void set_remote_arch __P((enum remote_arch_types type));
enum remote_arch_types get_remote_arch __P((void));
void out_ascii __P((FILE *f, unsigned char *buf,int len));
void out_data __P((FILE *f,char *buf1,int len, int per_line));
void print_asc __P((int level, unsigned char *buf,int len));
void dump_data __P((int level,char *buf1,int len));
char *tab_depth __P((int depth));
int str_checksum __P((const char *s));
void zero_free __P((void *p, size_t size));
int set_maxfiles __P((int requested_max));
BOOL reg_split_key __P((const char *full_keyname, uint32 *reg_type, char *key_name));
int smb_mkstemp __P((char *template));
void *smb_xmalloc __P((size_t size));
void *smb_xmemdup __P((const void *p, size_t size));
char *smb_xstrdup __P((const char *s));
int smb_xvasprintf __P((char **ptr, const char *format, va_list ap));
void *memdup __P((void *p, size_t size));
char *myhostname __P((void));
char *lock_path __P((const char *name));
char *pid_path __P((char *name));
char *parent_dirname __P((const char *path));
BOOL ms_has_wild __P((char *s));
BOOL mask_match __P((const char *string, char *pattern, BOOL is_case_sensitive));
BOOL unix_wild_match __P((char *pattern, char *string));
DATA_BLOB data_blob __P((const void *p, size_t length));
DATA_BLOB data_blob_talloc __P((TALLOC_CTX *mem_ctx, const void *p, size_t length));
void data_blob_free __P((DATA_BLOB *d));
void data_blob_clear __P((DATA_BLOB *d));
int _Insure_trap_error __P((int a1, int a2, int a3, int a4, int a5, int a6));
BOOL am_admin __P((void));
BOOL is_user_name __P((const char *name));
void sudo_validate __P((const char *pass));
int do_sudo __P((const char *command, const char *pass));

/* The following definitions come from lib/util_file.c  */

BOOL do_file_lock __P((int fd, int waitsecs, int type));
BOOL file_lock __P((int fd, int type, int secs, int *plock_depth));
BOOL file_unlock __P((int fd, int *plock_depth));
void *startfilepwent __P((char *pfile, char *s_readbuf, int bufsize,
				int *file_lock_depth, BOOL update));
void endfilepwent __P((void *vp, int *file_lock_depth));
SMB_BIG_UINT getfilepwpos __P((void *vp));
BOOL setfilepwpos __P((void *vp, SMB_BIG_UINT tok));
int getfileline __P((void *vp, char *linebuf, int linebuf_size));
char *fgets_slash __P((char *s2,int maxlen,FILE *f));
char *file_pload __P((const char *syscmd, size_t *size));
char *fd_load __P((int fd, size_t *size));
char *file_load __P((const char *fname, size_t *size));
char **file_lines_load __P((const char *fname, int *numlines, BOOL convert));
char **fd_lines_load __P((int fd, int *numlines, BOOL convert));
char **file_lines_pload __P((const char *syscmd, int *numlines, BOOL convert));
void file_lines_free __P((char **lines));
void file_lines_slashcont __P((char **lines));

/* The following definitions come from lib/util_getent.c  */

struct sys_grent * getgrent_list __P((void));
void grent_free  __P((struct sys_grent *glist));
struct sys_pwent * getpwent_list __P((void));
void pwent_free  __P((struct sys_pwent *plist));
struct sys_userlist *get_users_in_group __P((const char *gname));
void free_userlist __P((struct sys_userlist *list_head));

/* The following definitions come from lib/util_seaccess.c  */

void se_map_generic __P((uint32 *access_mask, struct generic_mapping *mapping));
void se_map_standard __P((uint32 *access_mask, struct standard_mapping *mapping));
BOOL se_access_check __P((SEC_DESC *sd, NT_USER_TOKEN *token,
		     uint32 acc_desired, uint32 *acc_granted, 
		     NTSTATUS *status));
SEC_DESC_BUF *se_create_child_secdesc __P((TALLOC_CTX *ctx, SEC_DESC *parent_ctr, 
				      BOOL child_container));

/* The following definitions come from lib/util_sec.c  */

void sec_init __P((void));
uid_t sec_initial_uid __P((void));
gid_t sec_initial_gid __P((void));
BOOL non_root_mode __P((void));
void gain_root_privilege __P((void));
void gain_root_group_privilege __P((void));
void set_effective_uid __P((uid_t uid));
void set_effective_gid __P((gid_t gid));
void save_re_uid __P((void));
void restore_re_uid __P((void));
void save_re_gid __P((void));
void restore_re_gid __P((void));
int set_re_uid __P((void));
void become_user_permanently __P((uid_t uid, gid_t gid));
BOOL is_setuid_root __P((void) );

/* The following definitions come from lib/util_sid.c  */

void generate_wellknown_sids __P((void));
BOOL map_domain_sid_to_name __P((DOM_SID *sid, char *nt_domain));
BOOL lookup_known_rid __P((DOM_SID *sid, uint32 rid, char *name, enum SID_NAME_USE *psid_name_use));
BOOL map_domain_name_to_sid __P((DOM_SID *sid, char *nt_domain));
void split_domain_name __P((const char *fullname, char *domain, char *name));
char *sid_to_string __P((fstring sidstr_out, const DOM_SID *sid));
const char *sid_string_static __P((const DOM_SID *sid));
BOOL string_to_sid __P((DOM_SID *sidout, const char *sidstr));
BOOL sid_append_rid __P((DOM_SID *sid, uint32 rid));
BOOL sid_split_rid __P((DOM_SID *sid, uint32 *rid));
BOOL sid_peek_rid __P((DOM_SID *sid, uint32 *rid));
void sid_copy __P((DOM_SID *dst, const DOM_SID *src));
DOM_SID *sid_dup __P((DOM_SID *src));
BOOL sid_linearize __P((char *outbuf, size_t len, DOM_SID *sid));
BOOL sid_parse __P((char *inbuf, size_t len, DOM_SID *sid));
int sid_compare_auth __P((const DOM_SID *sid1, const DOM_SID *sid2));
int sid_compare __P((const DOM_SID *sid1, const DOM_SID *sid2));
int sid_compare_domain __P((const DOM_SID *sid1, const DOM_SID *sid2));
BOOL sid_equal __P((const DOM_SID *sid1, const DOM_SID *sid2));
BOOL sid_check_is_domain __P((const DOM_SID *sid));
BOOL sid_check_is_builtin __P((const DOM_SID *sid));
BOOL sid_check_is_in_our_domain __P((const DOM_SID *sid));
BOOL sid_check_is_in_builtin __P((const DOM_SID *sid));
size_t sid_size __P((DOM_SID *sid));
BOOL non_mappable_sid __P((DOM_SID *sid));
char *sid_binstring __P((DOM_SID *sid));

/* The following definitions come from lib/util_sock.c  */

BOOL is_a_socket __P((int fd));
void set_socket_options __P((int fd, const char *options));
ssize_t read_udp_socket __P((int fd,char *buf,size_t len));
ssize_t read_with_timeout __P((int fd,char *buf,size_t mincnt,size_t maxcnt,unsigned int time_out));
BOOL send_keepalive __P((int client));
ssize_t read_data __P((int fd,char *buffer,size_t N));
ssize_t write_data __P((int fd,char *buffer,size_t N));
ssize_t write_socket_data __P((int fd,char *buffer,size_t N));
ssize_t write_socket __P((int fd,char *buf,size_t len));
ssize_t read_smb_length __P((int fd,char *inbuf,unsigned int timeout));
BOOL receive_smb __P((int fd,char *buffer, unsigned int timeout));
BOOL client_receive_smb __P((int fd,char *buffer, unsigned int timeout));
BOOL send_smb __P((int fd,char *buffer));
BOOL send_one_packet __P((char *buf,int len,struct in_addr ip,int port,int type));
int open_socket_in __P(( int type, int port, int dlevel, uint32 socket_addr, BOOL rebind ));
int open_socket_out __P((int type, struct in_addr *addr, int port ,int timeout));
void client_setfd __P((int fd));
char *client_name __P((void));
char *client_addr __P((void));
char *get_socket_name __P((int fd));
char *get_socket_addr __P((int fd));
int create_pipe_sock __P((const char *socket_dir,
		     const char *socket_name,
		     mode_t dir_perms));
int sock_exec __P((const char *prog));

/* The following definitions come from lib/util_str.c  */

void set_first_token __P((char *ptr));
BOOL next_token __P((const char **ptr,char *buff,const char *sep, size_t bufsize));
char **toktocliplist __P((int *ctok, const char *sep));
int StrCmp __P((const char *s, const char *t));
int StrCaseCmp __P((const char *s, const char *t));
int StrnCaseCmp __P((const char *s, const char *t, size_t n));
BOOL strequal __P((const char *s1, const char *s2));
BOOL strequal_unix __P((const char *s1, const char *s2));
BOOL strnequal __P((const char *s1,const char *s2,size_t n));
BOOL strcsequal __P((const char *s1,const char *s2));
int strwicmp __P((const char *psz1, const char *psz2));
void strlower __P((char *s));
void strupper __P((char *s));
char *strupper_static __P((const char *s));
void strnorm __P((char *s));
BOOL strisnormal __P((char *s));
void string_replace __P((char *s,char oldc,char newc));
char *skip_string __P((char *buf,size_t n));
size_t str_charnum __P((const char *s));
BOOL trim_string __P(( char *s, long s_len,
		  const char *front, const long front_len,
		  const char *back, const long back_len ));
BOOL strhasupper __P((const char *s));
BOOL strhaslower __P((const char *s));
size_t count_chars __P((const char *s,char c));
BOOL str_is_all __P((const char *s,char c));
char *safe_strcpy __P((char *dest,const char *src, size_t maxlength));
char *safe_strcat __P((char *dest, const char *src, size_t maxlength));
char *alpha_strcpy __P((char *dest, const char *src, const char *other_safe_chars, size_t maxlength));
char *StrnCpy __P((char *dest,const char *src,size_t n));
char *strncpy_fill __P((char *dest, const char *src, size_t n));
char *strncpyn __P((char *dest, const char *src,size_t n, char c));
size_t strhex_to_str __P((char *p, size_t len, const char *strhex));
BOOL in_list __P((char *s,char *list,BOOL casesensitive));
void string_free __P((char **s));
BOOL string_set __P((char **dest,const char *src));
void string_sub __P((char *s,const char *pattern,const char *insert, size_t len, BOOL unixcode));
void fstring_sub __P((char *s,const char *pattern,const char *insert, BOOL unixcode));
void pstring_sub __P((char *s,const char *pattern,const char *insert, BOOL unixcode));
void all_string_sub __P((char *s,const char *pattern,const char *insert, size_t len));
void split_at_last_component __P((char *path, char *front, char sep, char *back));
const char *octal_string __P((int i));
char *string_truncate __P((char *s, int length));
char *binary_string __P((char *buf, int len));

/* The following definitions come from lib/util_unistr.c  */

size_t unix_PutUniCode __P((char *dst,const char *src, ssize_t len, BOOL null_terminate));
size_t dos_PutUniCode __P((char *dst,const char *src, ssize_t len, BOOL null_terminate));
void unistr_to_dos __P((char *dest, const char *src, size_t len));
char *skip_unibuf __P((char *src, size_t len));
char *dos_unistrn2 __P((uint16 *src, int len));
char *dos_unistr2 __P((uint16 *src));
char *dos_unistr2_to_str __P((UNISTR2 *str));
void ascii_to_unistr __P((uint16 *dest, const char *src, int maxlen));
void unistr_to_ascii __P((char *dest, const uint16 *src, int len));
void unistr2_to_dos __P((char *dest, const UNISTR2 *str, size_t maxlen));
void unistr2_to_unix __P((char *dest, const UNISTR2 *str, size_t maxlen));
uint32 buffer2_to_uint32 __P((BUFFER2 *str));
char *dos_buffer2_to_str __P((BUFFER2 *str));
char *dos_buffer2_to_multistr __P((BUFFER2 *str));
size_t dos_struni2 __P((char *dst, const char *src, size_t max_len));
char *dos_unistr __P((char *buf));
int unistrlen __P((uint16 *s));
int unistrcpy __P((uint16 *dst, uint16 *src));
void default_unicode_map __P((smb_ucs2_t **pp_cp_to_ucs2, uint16 **pp_ucs2_to_cp));
BOOL load_unicode_map __P((const char *codepage, smb_ucs2_t **pp_cp_to_ucs2, uint16 **pp_ucs2_to_cp));
BOOL load_dos_unicode_map __P((int codepage));
BOOL load_unix_unicode_map __P((const char *unix_char_set, BOOL override));
BOOL load_normalization_form __P((int codepage, int nf_id));
smb_ucs2_t *multibyte_to_unicode __P((smb_ucs2_t *dst, const char *src,
                                 size_t dst_len, smb_ucs2_t *cp_to_ucs2));
char *unicode_to_unix __P((char *dst, const smb_ucs2_t *src, size_t dst_len));
smb_ucs2_t *unix_to_unicode __P((smb_ucs2_t *dst, const char *src, size_t dst_len));
size_t unicode_to_unix_char __P((char *dst, const smb_ucs2_t src));
char *unicode_to_dos __P((char *dst, const smb_ucs2_t *src, size_t dst_len));
size_t unicode_to_dos_char __P((char *dst, const smb_ucs2_t src));
smb_ucs2_t *dos_to_unicode __P((smb_ucs2_t *dst, const char *src, size_t dst_len));
size_t strlen_w __P((const smb_ucs2_t *src));
smb_ucs2_t *safe_strcpy_w __P((smb_ucs2_t *dest,const smb_ucs2_t *src, size_t maxlength));
smb_ucs2_t *safe_strcat_w __P((smb_ucs2_t *dest, const smb_ucs2_t *src, size_t maxlength));
int strcmp_w __P((const smb_ucs2_t *s1, const smb_ucs2_t *s2));
int strncmp_w __P((const smb_ucs2_t *s1, const smb_ucs2_t *s2, size_t len));
smb_ucs2_t *strstr_w __P((const smb_ucs2_t *s1, const smb_ucs2_t *s2));
smb_ucs2_t *strchr_w __P((const smb_ucs2_t *s, smb_ucs2_t c));
smb_ucs2_t *strrchr_w __P((const smb_ucs2_t *s, smb_ucs2_t c));
smb_ucs2_t *strtok_w __P((smb_ucs2_t *s1, const smb_ucs2_t *s2));
smb_ucs2_t *strdup_w __P((const smb_ucs2_t *s));
int isupper_w __P(( smb_ucs2_t val));
int islower_w __P(( smb_ucs2_t val));
int isdigit_w __P(( smb_ucs2_t val));
int isxdigit_w __P(( smb_ucs2_t val));
int isspace_w __P(( smb_ucs2_t val));
int iscjk_w __P(( smb_ucs2_t val));
smb_ucs2_t toupper_w __P(( smb_ucs2_t val ));
smb_ucs2_t tolower_w __P(( smb_ucs2_t val ));
void set_first_token_w __P((smb_ucs2_t *ptr));
BOOL next_token_w __P((smb_ucs2_t **ptr, smb_ucs2_t *buff, smb_ucs2_t *sep, size_t bufsize));
smb_ucs2_t **toktocliplist_w __P((int *ctok, smb_ucs2_t *sep));
int StrCaseCmp_w __P((const smb_ucs2_t *s, const smb_ucs2_t *t));
int StrnCaseCmp_w __P((const smb_ucs2_t *s, const smb_ucs2_t *t, size_t n));
BOOL strequal_w __P((const smb_ucs2_t *s1, const smb_ucs2_t *s2));
BOOL strnequal_w __P((const smb_ucs2_t *s1,const smb_ucs2_t *s2,size_t n));
BOOL strcsequal_w __P((const smb_ucs2_t *s1,const smb_ucs2_t *s2));
void strlower_w __P((smb_ucs2_t *s));
void strupper_w __P((smb_ucs2_t *s));
void strnorm_w __P((smb_ucs2_t *s));
BOOL strisnormal_w __P((smb_ucs2_t *s));
void string_replace_w __P((smb_ucs2_t *s, smb_ucs2_t oldc, smb_ucs2_t newc));
smb_ucs2_t *skip_string_w __P((smb_ucs2_t *buf,size_t n));
size_t str_charnum_w __P((const smb_ucs2_t *s));
BOOL trim_string_w __P((smb_ucs2_t *s,const smb_ucs2_t *front,const smb_ucs2_t *back));
BOOL strhasupper_w __P((const smb_ucs2_t *s));
BOOL strhaslower_w __P((const smb_ucs2_t *s));
size_t count_chars_w __P((const smb_ucs2_t *s,smb_ucs2_t c));
BOOL str_is_all_w __P((const smb_ucs2_t *s,smb_ucs2_t c));
smb_ucs2_t *alpha_strcpy_w __P((smb_ucs2_t *dest, const smb_ucs2_t *src, const smb_ucs2_t *other_safe_chars, size_t maxlength));
smb_ucs2_t *StrnCpy_w __P((smb_ucs2_t *dest,const smb_ucs2_t *src,size_t n));
smb_ucs2_t *strncpyn_w __P((smb_ucs2_t *dest, const smb_ucs2_t *src,size_t n, smb_ucs2_t c));
size_t strhex_to_str_w __P((char *p, size_t len, const smb_ucs2_t *strhex));
BOOL in_list_w __P((smb_ucs2_t *s,smb_ucs2_t *list,BOOL casesensitive));
BOOL string_init_w __P((smb_ucs2_t **dest,const smb_ucs2_t *src));
void string_free_w __P((smb_ucs2_t **s));
BOOL string_set_w __P((smb_ucs2_t **dest,const smb_ucs2_t *src));
void string_sub_w __P((smb_ucs2_t *s,const smb_ucs2_t *pattern,const smb_ucs2_t *insert, size_t len));
void fstring_sub_w __P((smb_ucs2_t *s,const smb_ucs2_t *pattern,const smb_ucs2_t *insert));
void pstring_sub_w __P((smb_ucs2_t *s,const smb_ucs2_t *pattern,smb_ucs2_t *insert));
void all_string_sub_w __P((smb_ucs2_t *s,const smb_ucs2_t *pattern,const smb_ucs2_t *insert, size_t len));
void split_at_last_component_w __P((smb_ucs2_t *path, smb_ucs2_t *front, smb_ucs2_t sep, smb_ucs2_t *back));
smb_ucs2_t *octal_string_w __P((int i));
smb_ucs2_t *string_truncate_w __P((smb_ucs2_t *s, size_t length));
smb_ucs2_t doscp2ucs2 __P((int w));
int ucs2doscp __P((smb_ucs2_t w));
int rpcstr_pull __P((char* dest, void *src, int dest_len, int src_len, int flags));
smb_ucs2_t *normalize_ucs2 __P((smb_ucs2_t *dest, smb_ucs2_t *src, int max));
smb_ucs2_t *denormalize_ucs2 __P((smb_ucs2_t *dest, smb_ucs2_t *src, int max));

/* The following definitions come from lib/wins_srv.c  */

BOOL wins_srv_load_list __P(( const char *src ));
struct in_addr wins_srv_ip __P(( void ));
void wins_srv_died __P(( struct in_addr boothill_ip ));
unsigned long wins_srv_count __P(( void ));

/* The following definitions come from libsmb/cli_dfs.c  */

struct cli_state *cli_dfs_initialise __P((struct cli_state *cli, char *system_name,
				     struct ntuser_creds *creds));
NTSTATUS cli_dfs_exist __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                       BOOL *dfs_exists));
NTSTATUS cli_dfs_add __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                     char *entrypath, char *servername, char *sharename,
                     char *comment, uint32 flags));
NTSTATUS cli_dfs_remove __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                        char *entrypath, char *servername, char *sharename));
NTSTATUS cli_dfs_get_info __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                          char *entrypath, char *servername, char *sharename,
                          uint32 info_level, DFS_INFO_CTR *ctr));
NTSTATUS cli_dfs_enum __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                      uint32 info_level, DFS_INFO_CTR *ctr));

/* The following definitions come from libsmb/cli_lsarpc.c  */

struct cli_state *cli_lsa_initialise __P((struct cli_state *cli, char *system_name,
				     struct ntuser_creds *creds));
NTSTATUS cli_lsa_open_policy __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             BOOL sec_qos, uint32 des_access, POLICY_HND *pol));
NTSTATUS cli_lsa_open_policy2 __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              BOOL sec_qos, uint32 des_access, POLICY_HND *pol));
NTSTATUS cli_lsa_close __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                       POLICY_HND *pol));
NTSTATUS cli_lsa_lookup_sids __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *pol, int num_sids, DOM_SID *sids, 
                             char ***domains, char ***names, uint32 **types));
NTSTATUS cli_lsa_lookup_names __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              POLICY_HND *pol, int num_names, 
			      const char **names, DOM_SID **sids, 
			      uint32 **types));
NTSTATUS cli_lsa_query_info_policy __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                   POLICY_HND *pol, uint16 info_class, 
                                   fstring domain_name, DOM_SID *domain_sid));
NTSTATUS cli_lsa_enum_trust_dom __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_ctx, 
                                uint32 *num_domains, char ***domain_names, 
                                DOM_SID **domain_sids));
NTSTATUS cli_lsa_enum_privilege __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_context, uint32 pref_max_length,
				uint32 *count, char ***privs_name, uint32 **privs_high, uint32 **privs_low));
NTSTATUS cli_lsa_get_dispname __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, char *name, uint16 lang_id, uint16 lang_id_sys,
			      fstring description, uint16 *lang_id_desc));
NTSTATUS cli_lsa_enum_sids __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                POLICY_HND *pol, uint32 *enum_ctx, uint32 pref_max_length, 
                                uint32 *num_sids, DOM_SID **sids));
NTSTATUS cli_lsa_open_account __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *dom_pol, DOM_SID *sid, uint32 des_access, 
			     POLICY_HND *user_pol));
NTSTATUS cli_lsa_enum_privsaccount __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                             POLICY_HND *pol, uint32 *count, LUID_ATTR **set));
NTSTATUS cli_lsa_lookupprivvalue __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, char *name, LUID *luid));
NTSTATUS cli_lsa_query_secobj __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, uint32 sec_info, 
			      SEC_DESC_BUF **psdb));
BOOL fetch_domain_sid __P(( char *domain, char *remote_machine, DOM_SID *psid));

/* The following definitions come from libsmb/cli_netlogon.c  */

struct cli_state *cli_netlogon_initialise __P((struct cli_state *cli, 
					  char *system_name,
					  struct ntuser_creds *creds));
NTSTATUS new_cli_net_req_chal __P((struct cli_state *cli, DOM_CHAL *clnt_chal, 
                              DOM_CHAL *srv_chal));
NTSTATUS new_cli_net_auth2 __P((struct cli_state *cli, 
			   uint16 sec_chan, 
                           uint32 neg_flags, DOM_CHAL *srv_chal));
NTSTATUS new_cli_nt_setup_creds __P((struct cli_state *cli, 
				uint16 sec_chan,
                                const unsigned char mach_pwd[16]));
NTSTATUS cli_netlogon_logon_ctrl2 __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                  uint32 query_level));
NTSTATUS cli_netlogon_sam_sync __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, DOM_CRED *ret_creds,
                               uint32 database_id, uint32 *num_deltas,
                               SAM_DELTA_HDR **hdr_deltas, 
                               SAM_DELTA_CTR **deltas));
NTSTATUS cli_netlogon_sam_deltas __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 uint32 database_id, UINT64_S seqnum,
                                 uint32 *num_deltas, 
                                 SAM_DELTA_HDR **hdr_deltas, 
                                 SAM_DELTA_CTR **deltas));
NTSTATUS cli_netlogon_sam_logon __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *unix_username, const char *unix_password,
				int logon_type));
NTSTATUS cli_netlogon_sam_network_logon __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
					const char *unix_username, const char *unix_domain, const char *workstation, 
					const uint8 chal[8],
					DATA_BLOB lm_response, DATA_BLOB nt_response,
					NET_USER_INFO_3 *info3));

/* The following definitions come from libsmb/cli_pipe_util.c  */

struct cli_state *cli_pipe_initialise __P((struct cli_state *cli, char *system_name,
				      const char *pipe_name, 
                                      struct ntuser_creds *creds));
void cli_pipe_shutdown __P((struct cli_state *cli));

/* The following definitions come from libsmb/cli_reg.c  */

struct cli_state *cli_winreg_initialise __P((struct cli_state *cli, 
                                        char *system_name,
                                        struct ntuser_creds *creds));
NTSTATUS cli_reg_shutdown __P((struct cli_state * cli, TALLOC_CTX *mem_ctx,
                          const char *msg, uint32 timeout, uint16 flags));
NTSTATUS cli_reg_abort_shutdown __P((struct cli_state * cli, TALLOC_CTX *mem_ctx));

/* The following definitions come from libsmb/cli_samr.c  */

struct cli_state *cli_samr_initialise __P((struct cli_state *cli, char *system_name,
				      struct ntuser_creds *creds));
NTSTATUS cli_samr_connect __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                          uint32 access_mask, POLICY_HND *connect_pol));
NTSTATUS cli_samr_close __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                        POLICY_HND *connect_pol));
NTSTATUS cli_samr_open_domain __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                              POLICY_HND *connect_pol, uint32 access_mask, 
                              DOM_SID *domain_sid, POLICY_HND *domain_pol));
NTSTATUS cli_samr_open_user __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                            POLICY_HND *domain_pol, uint32 access_mask, 
                            uint32 user_rid, POLICY_HND *user_pol));
NTSTATUS cli_samr_open_group __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                             POLICY_HND *domain_pol, uint32 access_mask, 
                             uint32 group_rid, POLICY_HND *group_pol));
NTSTATUS cli_samr_query_userinfo __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *user_pol, uint16 switch_value, 
                                 SAM_USERINFO_CTR **ctr));
NTSTATUS cli_samr_query_groupinfo __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                  POLICY_HND *group_pol, uint32 info_level, 
                                  GROUP_INFO_CTR **ctr));
NTSTATUS cli_samr_query_usergroups __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                   POLICY_HND *user_pol, uint32 *num_groups, 
                                   DOM_GID **gid));
NTSTATUS cli_samr_query_useraliases __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                   POLICY_HND *user_pol, uint32 num_sids, DOM_SID2 *sid,
				   uint32 *num_aliases, uint32 **als_rids));
NTSTATUS cli_samr_query_groupmem __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *group_pol, uint32 *num_mem, 
                                 uint32 **rid, uint32 **attr));
NTSTATUS cli_samr_enum_dom_groups __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *pol, uint32 *start_idx, 
                                  uint32 size, struct acct_info **dom_groups,
                                  uint32 *num_dom_groups));
NTSTATUS cli_samr_enum_als_groups __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *pol, uint32 *start_idx, 
                                  uint32 size, struct acct_info **dom_groups,
                                  uint32 *num_dom_groups));
NTSTATUS cli_samr_query_aliasmem __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *alias_pol, uint32 *num_mem, 
                                 DOM_SID **sids));
NTSTATUS cli_samr_open_alias __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                             POLICY_HND *domain_pol, uint32 access_mask, 
                             uint32 alias_rid, POLICY_HND *alias_pol));
NTSTATUS cli_samr_query_dom_info __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                 POLICY_HND *domain_pol, uint16 switch_value,
                                 SAM_UNK_CTR *ctr));
void get_query_dispinfo_params __P((int loop_count, uint32 *max_entries,
			       uint32 *max_size));
NTSTATUS cli_samr_query_dispinfo __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                 POLICY_HND *domain_pol, uint32 *start_idx,
                                 uint16 switch_value, uint32 *num_entries,
                                 uint32 max_entries, uint32 max_size,
				 SAM_DISPINFO_CTR *ctr));
NTSTATUS cli_samr_lookup_rids __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                              POLICY_HND *domain_pol, uint32 flags,
                              uint32 num_rids, uint32 *rids, 
                              uint32 *num_names, char ***names,
                              uint32 **name_types));
NTSTATUS cli_samr_lookup_names __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                               POLICY_HND *domain_pol, uint32 flags,
                               uint32 num_names, const char **names,
                               uint32 *num_rids, uint32 **rids,
                               uint32 **rid_types));
NTSTATUS cli_samr_create_dom_user __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *domain_pol, char *acct_name,
                                  uint32 acb_info, uint32 unknown, 
                                  POLICY_HND *user_pol, uint32 *rid));
NTSTATUS cli_samr_set_userinfo __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                               POLICY_HND *user_pol, uint16 switch_value,
                               uchar sess_key[16], SAM_USERINFO_CTR *ctr));
NTSTATUS cli_samr_set_userinfo2 __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                POLICY_HND *user_pol, uint16 switch_value,
                                uchar sess_key[16], SAM_USERINFO_CTR *ctr));
NTSTATUS cli_samr_delete_dom_user __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
                                  POLICY_HND *user_pol));
NTSTATUS cli_samr_query_sec_obj __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
                                 POLICY_HND *user_pol, uint16 switch_value, 
                                 TALLOC_CTX *ctx, SEC_DESC_BUF **sec_desc_buf));

/* The following definitions come from libsmb/cli_spoolss.c  */

struct cli_state *cli_spoolss_initialise __P((struct cli_state *cli, 
					 char *system_name,
					 struct ntuser_creds *creds));
WERROR cli_spoolss_open_printer_ex __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
				const char *printername, const char *datatype, uint32 access_required,
				char *station, char *username, POLICY_HND *pol));
WERROR cli_spoolss_close_printer __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
				POLICY_HND *pol));
WERROR cli_spoolss_enum_printers __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint32 offered, uint32 *needed,
				 uint32 flags, uint32 level,
				 uint32 *num_printers, PRINTER_INFO_CTR *ctr));
WERROR cli_spoolss_enum_ports __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      uint32 offered, uint32 *needed,
			      uint32 level, int *num_ports, PORT_INFO_CTR *ctr));
WERROR cli_spoolss_getprinter __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      uint32 offered, uint32 *needed,
			      POLICY_HND *pol, uint32 level, 
			      PRINTER_INFO_CTR *ctr));
WERROR cli_spoolss_setprinter __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *pol, uint32 level, 
			      PRINTER_INFO_CTR *ctr, uint32 command));
WERROR cli_spoolss_getprinterdriver __P((struct cli_state *cli, 
				    TALLOC_CTX *mem_ctx, 
				    uint32 offered, uint32 *needed,
				    POLICY_HND *pol, uint32 level, 
				    const char *env, PRINTER_DRIVER_CTR *ctr));
WERROR cli_spoolss_enumprinterdrivers  __P((struct cli_state *cli, 
				       TALLOC_CTX *mem_ctx,
				       uint32 offered, uint32 *needed,
				       uint32 level, const char *env,
				       uint32 *num_drivers,
				PRINTER_DRIVER_CTR *ctr));
WERROR cli_spoolss_getprinterdriverdir  __P((struct cli_state *cli, 
					TALLOC_CTX *mem_ctx,
					uint32 offered, uint32 *needed,
					uint32 level, char *env,
					DRIVER_DIRECTORY_CTR *ctr));
WERROR cli_spoolss_addprinterdriver  __P((struct cli_state *cli, 
				     TALLOC_CTX *mem_ctx, uint32 level,
				     PRINTER_DRIVER_CTR *ctr));
WERROR cli_spoolss_addprinterex  __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
				 uint32 level, PRINTER_INFO_CTR*ctr));
WERROR cli_spoolss_deleteprinterdriver  __P((struct cli_state *cli, 
					TALLOC_CTX *mem_ctx, const char *arch,
					char *driver));
WERROR cli_spoolss_getprintprocessordirectory __P((struct cli_state *cli,
					      TALLOC_CTX *mem_ctx,
					      uint32 offered, uint32 *needed,
					      char *name, char *environment,
					      fstring procdir));
WERROR cli_spoolss_addform __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *handle, uint32 level, FORM *form));
WERROR cli_spoolss_setform __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   POLICY_HND *handle, uint32 level, char *form_name,
			   FORM *form));
WERROR cli_spoolss_getform __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			   uint32 offered, uint32 *needed,
			   POLICY_HND *handle, char *formname, uint32 level, 
			   FORM_1 *form));
WERROR cli_spoolss_deleteform __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			      POLICY_HND *handle, char *form_name));
WERROR cli_spoolss_enumforms __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
			     uint32 offered, uint32 *needed,
			     POLICY_HND *handle, int level, uint32 *num_forms,
			     FORM_1 **forms));
WERROR cli_spoolss_setprinterdata  __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
					POLICY_HND *pol, char* valname, char* value));

/* The following definitions come from libsmb/cli_srvsvc.c  */

struct cli_state *cli_svrsvc_initialise __P((struct cli_state *cli, 
					char *system_name,
					struct ntuser_creds *creds));
NTSTATUS cli_srvsvc_net_srv_get_info __P((struct cli_state *cli, 
                                     TALLOC_CTX *mem_ctx,
                                     uint32 switch_value, SRV_INFO_CTR *ctr));

/* The following definitions come from libsmb/cliconnect.c  */

BOOL cli_session_setup __P((struct cli_state *cli, 
		       const char *user, 
		       const char *pass, int passlen,
		       const char *ntpass, int ntpasslen,
		       const char *workgroup));
BOOL cli_ulogoff __P((struct cli_state *cli));
BOOL cli_send_tconX __P((struct cli_state *cli, 
		    const char *share, const char *dev, const char *pass, int passlen));
BOOL cli_tdis __P((struct cli_state *cli));
void cli_negprot_send __P((struct cli_state *cli));
BOOL cli_negprot __P((struct cli_state *cli));
BOOL cli_session_request __P((struct cli_state *cli,
			 struct nmb_name *calling, struct nmb_name *called));
BOOL cli_connect __P((struct cli_state *cli, const char *host, struct in_addr *ip));
BOOL cli_establish_connection __P((struct cli_state *cli, 
				const char *dest_host, struct in_addr *dest_ip,
				struct nmb_name *calling, struct nmb_name *called,
				const char *service, const char *service_type,
				BOOL do_shutdown, BOOL do_tcon));
NTSTATUS cli_full_connection __P((struct cli_state **output_cli, 
			     const char *my_name, const char *dest_host, 
			     struct in_addr *dest_ip, int port,
			     const char *service, const char *service_type,
			     const char *user, const char *domain, 
			     const char *password, int pass_len) );
BOOL attempt_netbios_session_request __P((struct cli_state *cli, const char *srchost, const char *desthost,
                                     struct in_addr *pdest_ip));

/* The following definitions come from libsmb/clidgram.c  */

int cli_send_mailslot __P((int dgram_sock, BOOL unique, const char *mailslot, 
		      char *buf, int len,
		      const char *srcname, int src_type, 
		      const char *dstname, int dest_type,
		      struct in_addr dest_ip, struct in_addr src_ip,
		      int dest_port, int src_port));
int cli_get_response __P((int dgram_sock, BOOL unique, const char *mailslot, char *buf, int bufsiz));
int cli_get_backup_list __P((const char *myname, const char *send_to_name));
int cli_get_backup_server __P((char *my_name, char *target, char *servername, int namesize));

/* The following definitions come from libsmb/clientgen.c  */

int cli_set_port __P((struct cli_state *cli, int port));
BOOL cli_receive_smb __P((struct cli_state *cli));
BOOL cli_send_smb __P((struct cli_state *cli));
void cli_setup_packet __P((struct cli_state *cli));
void cli_setup_bcc __P((struct cli_state *cli, void *p));
void cli_init_creds __P((struct cli_state *cli, const struct ntuser_creds *usr));
struct cli_state *cli_initialise __P((struct cli_state *cli));
void cli_close_connection __P((struct cli_state *cli));
void cli_shutdown __P((struct cli_state *cli));
void cli_sockopt __P((struct cli_state *cli, char *options));
uint16 cli_setpid __P((struct cli_state *cli, uint16 pid));
BOOL cli_send_keepalive __P((struct cli_state *cli));

/* The following definitions come from libsmb/clierror.c  */

const char *cli_errstr __P((struct cli_state *cli));
NTSTATUS cli_nt_error __P((struct cli_state *cli));
void cli_dos_error __P((struct cli_state *cli, uint8 *eclass, uint32 *ecode));
int cli_errno_from_dos __P((uint8 eclass, uint32 num));
int cli_errno_from_nt __P((NTSTATUS status));
int cli_errno __P((struct cli_state *cli));
BOOL cli_is_error __P((struct cli_state *cli));
BOOL cli_is_nt_error __P((struct cli_state *cli));
BOOL cli_is_dos_error __P((struct cli_state *cli));

/* The following definitions come from libsmb/clifile.c  */

uint32  unix_perms_to_wire __P((mode_t perms));
BOOL cli_unix_symlink __P((struct cli_state *cli, const char *fname_src, const char *fname_dst));
BOOL cli_unix_hardlink __P((struct cli_state *cli, const char *fname_src, const char *fname_dst));
BOOL cli_unix_chmod __P((struct cli_state *cli, const char *fname, mode_t mode));
BOOL cli_unix_chown __P((struct cli_state *cli, const char *fname, uid_t uid, gid_t gid));
BOOL cli_rename __P((struct cli_state *cli, const char *fname_src, const char *fname_dst));
BOOL cli_unlink __P((struct cli_state *cli, const char *fname));
BOOL cli_mkdir __P((struct cli_state *cli, const char *dname));
BOOL cli_rmdir __P((struct cli_state *cli, const char *dname));
int cli_nt_delete_on_close __P((struct cli_state *cli, int fnum, BOOL flag));
int cli_nt_create_full __P((struct cli_state *cli, const char *fname, uint32 DesiredAccess,
		 uint32 FileAttributes, uint32 ShareAccess,
		 uint32 CreateDisposition, uint32 CreateOptions));
int cli_nt_create __P((struct cli_state *cli, const char *fname, uint32 DesiredAccess));
int cli_open __P((struct cli_state *cli, const char *fname, int flags, int share_mode));
BOOL cli_close __P((struct cli_state *cli, int fnum));
NTSTATUS cli_locktype __P((struct cli_state *cli, int fnum,
		      uint32 offset, uint32 len, int timeout, unsigned char locktype));
BOOL cli_lock __P((struct cli_state *cli, int fnum, 
	      uint32 offset, uint32 len, int timeout, enum brl_type lock_type));
BOOL cli_unlock __P((struct cli_state *cli, int fnum, uint32 offset, uint32 len));
BOOL cli_lock64 __P((struct cli_state *cli, int fnum, 
		SMB_BIG_UINT offset, SMB_BIG_UINT len, int timeout, enum brl_type lock_type));
BOOL cli_unlock64 __P((struct cli_state *cli, int fnum, SMB_BIG_UINT offset, SMB_BIG_UINT len));
BOOL cli_getattrE __P((struct cli_state *cli, int fd, 
		  uint16 *attr, SMB_BIG_UINT *size, 
		  time_t *c_time, time_t *a_time, time_t *m_time));
BOOL cli_getatr __P((struct cli_state *cli, const char *fname, 
		uint16 *attr, SMB_BIG_UINT *size, time_t *t));
BOOL cli_setatr __P((struct cli_state *cli, const char *fname, uint16 attr, time_t t));
BOOL cli_chkpath __P((struct cli_state *cli, const char *path));
BOOL cli_dskattr __P((struct cli_state *cli, int *bsize, int *total, int *avail));
int cli_ctemp __P((struct cli_state *cli, const char *path, char **tmp_path));

/* The following definitions come from libsmb/clilist.c  */

int cli_list_new __P((struct cli_state *cli,const char *Mask,uint16 attribute, 
		 void (*fn)(file_info *, const char *, void *), void *state));
int cli_list_old __P((struct cli_state *cli,const char *Mask,uint16 attribute, 
		 void (*fn)(file_info *, const char *, void *), void *state));
int cli_list __P((struct cli_state *cli,const char *Mask,uint16 attribute, 
	     void (*fn)(file_info *, const char *, void *), void *state));

/* The following definitions come from libsmb/climessage.c  */

BOOL cli_message_start __P((struct cli_state *cli, char *host, char *username, 
			      int *grp));
BOOL cli_message_text __P((struct cli_state *cli, char *msg, int len, int grp));
BOOL cli_message_end __P((struct cli_state *cli, int grp));

/* The following definitions come from libsmb/clioplock.c  */

BOOL cli_oplock_ack __P((struct cli_state *cli, int fnum, unsigned char level));
void cli_oplock_handler __P((struct cli_state *cli, 
			BOOL (*handler)(struct cli_state *, int, unsigned char)));

/* The following definitions come from libsmb/cliprint.c  */

int cli_print_queue __P((struct cli_state *cli, 
		    void (*fn)(struct print_job_info *)));
int cli_printjob_del __P((struct cli_state *cli, int job));

/* The following definitions come from libsmb/clirap.c  */

BOOL cli_api_pipe __P((struct cli_state *cli, const char *pipe_name, 
                  uint16 *setup, unsigned int setup_count, unsigned int max_setup_count,
                  char *params, unsigned int param_count, unsigned int max_param_count,
                  char *data, unsigned int data_count, unsigned int max_data_count,
                  char **rparam, unsigned int *rparam_count,
                  char **rdata, unsigned int *rdata_count));
BOOL cli_api __P((struct cli_state *cli,
	     char *param, unsigned int prcnt, unsigned int mprcnt,
	     char *data, unsigned int drcnt, unsigned int mdrcnt,
	     char **rparam, unsigned int *rprcnt,
	     char **rdata, unsigned int *rdrcnt));
BOOL cli_NetWkstaUserLogon __P((struct cli_state *cli,char *user, char *workstation));
int cli_RNetShareEnum __P((struct cli_state *cli, void (*fn)(const char *, uint32, const char *, void *), void *state));
BOOL cli_NetServerEnum __P((struct cli_state *cli, char *workgroup, uint32 stype,
		       void (*fn)(const char *, uint32, const char *, void *),
		       void *state));
BOOL cli_oem_change_password __P((struct cli_state *cli, const char *user, const char *new_password,
                             const char *old_password));
BOOL cli_qpathinfo __P((struct cli_state *cli, const char *fname, 
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   SMB_BIG_UINT *size, uint16 *mode));
BOOL cli_qpathinfo2 __P((struct cli_state *cli, const char *fname, 
		    time_t *c_time, time_t *a_time, time_t *m_time, 
		    time_t *w_time, SMB_BIG_UINT *size, uint16 *mode,
		    SMB_INO_T *ino));
BOOL cli_qfileinfo __P((struct cli_state *cli, int fnum, 
		   uint16 *mode, SMB_BIG_UINT *size,
		   time_t *c_time, time_t *a_time, time_t *m_time, 
		   time_t *w_time, SMB_INO_T *ino));
BOOL cli_qfileinfo_test __P((struct cli_state *cli, int fnum, int level, char *outdata));
NTSTATUS cli_qpathinfo_alt_name __P((struct cli_state *cli, const char *fname, fstring alt_name));

/* The following definitions come from libsmb/clireadwrite.c  */

ssize_t cli_read __P((struct cli_state *cli, int fnum, char *buf, SMB_OFF_T offset, size_t size));
ssize_t cli_readraw __P((struct cli_state *cli, int fnum, char *buf, off_t offset, size_t size));
ssize_t cli_write __P((struct cli_state *cli,
		  int fnum, uint16 write_mode,
		  char *buf, SMB_OFF_T offset, size_t size));
ssize_t cli_smbwrite __P((struct cli_state *cli,
		     int fnum, char *buf, off_t offset, size_t size1));

/* The following definitions come from libsmb/clisecdesc.c  */

SEC_DESC *cli_query_secdesc __P((struct cli_state *cli, int fnum, 
			    TALLOC_CTX *mem_ctx));
BOOL cli_set_secdesc __P((struct cli_state *cli, int fnum, SEC_DESC *sd));

/* The following definitions come from libsmb/clistr.c  */

int clistr_push __P((struct cli_state *cli, void *dest, const char *src, int dest_len, int flags));
int clistr_pull __P((struct cli_state *cli, char *dest, const void *src, int dest_len, int src_len, int flags));
int clistr_align_out __P((struct cli_state *cli, const void *p, int flags));
int clistr_align_in __P((struct cli_state *cli, const void *p, int flags));

/* The following definitions come from libsmb/clitrans.c  */

BOOL cli_send_trans __P((struct cli_state *cli, int trans, 
		    const char *pipe_name, 
		    int fid, int flags,
		    uint16 *setup, unsigned int lsetup, unsigned int msetup,
		    char *param, unsigned int lparam, unsigned int mparam,
		    char *data, unsigned int ldata, unsigned int mdata));
BOOL cli_receive_trans __P((struct cli_state *cli,int trans,
                              char **param, unsigned int *param_len,
                              char **data, unsigned int *data_len));
BOOL cli_send_nt_trans __P((struct cli_state *cli, 
		       int function, 
		       int flags,
		       uint16 *setup, unsigned int lsetup, unsigned int msetup,
		       char *param, unsigned int lparam, unsigned int mparam,
		       char *data, unsigned int ldata, unsigned int mdata));
BOOL cli_receive_nt_trans __P((struct cli_state *cli,
			  char **param, unsigned int *param_len,
			  char **data, unsigned int *data_len));

/* The following definitions come from libsmb/credentials.c  */

char *credstr __P((const uchar *cred));
void cred_session_key __P((const DOM_CHAL *clnt_chal, const DOM_CHAL *srv_chal, const uchar *pass,
			uchar session_key[8]));
void cred_create __P((uchar session_key[8], DOM_CHAL *stor_cred, UTIME timestamp, 
		 DOM_CHAL *cred));
int cred_assert __P((DOM_CHAL *cred, uchar session_key[8], DOM_CHAL *stored_cred,
		UTIME timestamp));
BOOL clnt_deal_with_creds __P((uchar sess_key[8],
			  DOM_CRED *sto_clnt_cred, DOM_CRED *rcv_srv_cred));
BOOL deal_with_creds __P((uchar sess_key[8],
		     DOM_CRED *sto_clnt_cred, 
		     DOM_CRED *rcv_clnt_cred, DOM_CRED *rtn_srv_cred));

/* The following definitions come from libsmb/doserr.c  */

const char *dos_errstr __P((WERROR werror));

/* The following definitions come from libsmb/errormap.c  */

NTSTATUS dos_to_ntstatus __P((int eclass, int ecode));
void ntstatus_to_dos __P((NTSTATUS ntstatus, uint8 *eclass, uint32 *ecode));
NTSTATUS werror_to_ntstatus __P((WERROR error));
WERROR ntstatus_to_werror __P((NTSTATUS error));

/* The following definitions come from libsmb/namecache.c  */

BOOL namecache_enable __P((void));
void namecache_store __P((const char *name, int name_type,
		     int num_names, struct in_addr *ip_list));
BOOL namecache_fetch __P((const char *name, int name_type, struct in_addr **ip_list,
		     int *num_names));
void namecache_flush __P((void));

/* The following definitions come from libsmb/namequery.c  */

struct node_status *node_status_query __P((int fd,struct nmb_name *name,
				      struct in_addr to_ip, int *num_names));
BOOL name_status_find __P((const char *q_name, int q_type, int type, struct in_addr to_ip, char *name));
BOOL name_register __P((int fd, const char *name, int name_type,
		   struct in_addr name_ip, int opcode,
		   BOOL bcast, 
		   struct in_addr to_ip, int *count));
struct in_addr *name_query __P((int fd,const char *name,int name_type, 
			   BOOL bcast,BOOL recurse,
			   struct in_addr to_ip, int *count, int *flags));
FILE *startlmhosts __P((const char *fname));
BOOL getlmhostsent __P(( FILE *fp, pstring name, int *name_type, struct in_addr *ipaddr));
void endlmhosts __P((FILE *fp));
BOOL name_register_wins __P((const char *name, int name_type));
BOOL name_resolve_bcast __P((const char *name, int name_type,
			struct in_addr **return_ip_list, int *return_count));
BOOL resolve_name __P((const char *name, struct in_addr *return_ip, int name_type));
BOOL resolve_name_2 __P((const char *name, struct in_addr **return_ip, int *count, int name_type));
BOOL resolve_srv_name __P((const char* srv_name, fstring dest_host,
                                struct in_addr *ip));
BOOL find_master_ip __P((char *group, struct in_addr *master_ip));
BOOL lookup_dc_name __P((const char *srcname, const char *domain, 
		    struct in_addr *dc_ip, char *ret_name));
BOOL get_dc_list __P((BOOL pdc_only, const char *group, struct in_addr **ip_list, int *count));
BOOL get_lmb_list __P((struct in_addr **ip_list, int *count));

/* The following definitions come from libsmb/nmblib.c  */

void debug_nmb_packet __P((struct packet_struct *p));
char *nmb_namestr __P((struct nmb_name *n));
struct packet_struct *copy_packet __P((struct packet_struct *packet));
void free_packet __P((struct packet_struct *packet));
struct packet_struct *parse_packet __P((char *buf,int length,
				   enum packet_type packet_type));
struct packet_struct *read_packet __P((int fd,enum packet_type packet_type));
void make_nmb_name __P(( struct nmb_name *n, const char *name, int type));
BOOL nmb_name_equal __P((struct nmb_name *n1, struct nmb_name *n2));
int build_packet __P((char *buf, struct packet_struct *p));
BOOL send_packet __P((struct packet_struct *p));
struct packet_struct *receive_packet __P((int fd,enum packet_type type,int t));
struct packet_struct *receive_nmb_packet __P((int fd, int t, int trn_id));
struct packet_struct *receive_dgram_packet __P((int fd, int t, const char *mailslot_name));
BOOL match_mailslot_name __P((struct packet_struct *p, const char *mailslot_name));
void sort_query_replies __P((char *data, int n, struct in_addr ip));
char *dns_to_netbios_name __P((char *dns_name));
int name_mangle __P(( char *In, char *Out, char name_type ));
int name_extract __P((char *buf,int ofs,char *name));
int name_len __P((char *s1));

/* The following definitions come from libsmb/nterr.c  */

const char *get_nt_error_msg __P((NTSTATUS nt_code));
const char *nt_errstr __P((NTSTATUS nt_code));
const char *get_nt_error_c_code __P((NTSTATUS nt_code));

/* The following definitions come from libsmb/passchange.c  */

BOOL remote_password_change __P((const char *remote_machine, const char *user_name, 
			    const char *old_passwd, const char *new_passwd,
			    char *err_str, size_t err_str_len));

/* The following definitions come from libsmb/pwd_cache.c  */

void pwd_init __P((struct pwd_info *pwd));
BOOL pwd_is_nullpwd __P((const struct pwd_info *pwd));
BOOL pwd_compare __P((struct pwd_info *pwd1, struct pwd_info *pwd2));
void pwd_read __P((struct pwd_info *pwd, char *passwd_report, BOOL do_encrypt));
void pwd_set_nullpwd __P((struct pwd_info *pwd));
void pwd_set_cleartext __P((struct pwd_info *pwd, const char *clr));
void pwd_get_cleartext __P((struct pwd_info *pwd, char *clr));
void pwd_set_lm_nt_16 __P((struct pwd_info *pwd, uchar lm_pwd[16], uchar nt_pwd[16]));
void pwd_get_lm_nt_16 __P((struct pwd_info *pwd, uchar lm_pwd[16], uchar nt_pwd[16]));
void pwd_make_lm_nt_16 __P((struct pwd_info *pwd, char *clr));
void pwd_make_lm_nt_owf __P((struct pwd_info *pwd, uchar cryptkey[8]));
void pwd_get_lm_nt_owf __P((struct pwd_info *pwd, uchar lm_owf[24], uchar nt_owf[24]));

/* The following definitions come from libsmb/smbdes.c  */

void E_P16 __P((const unsigned char *p14,unsigned char *p16));
void E_P24 __P((const unsigned char *p21, const unsigned char *c8, unsigned char *p24));
void D_P16 __P((const unsigned char *p14, const unsigned char *in, unsigned char *out));
void E_old_pw_hash __P(( unsigned char *p14, const unsigned char *in, unsigned char *out));
void cred_hash1 __P((unsigned char *out, const unsigned char *in, const unsigned char *key));
void cred_hash2 __P((unsigned char *out, const unsigned char *in, const unsigned char *key));
void cred_hash3 __P((unsigned char *out, unsigned char *in, const unsigned char *key, int forw));
void SamOEMhash __P(( unsigned char *data, const unsigned char *key, int val));
void sam_pwd_hash __P((unsigned int rid, const uchar *in, uchar *out, int forw));

/* The following definitions come from libsmb/smbencrypt.c  */

void SMBencrypt __P((const char *passwd, uchar *c8, uchar *p24));
void E_md4hash __P((const char *passwd, uchar *p16));
void nt_lm_owf_gen __P((const char *pwd, uchar nt_p16[16], uchar p16[16]));
void SMBOWFencrypt __P((uchar passwd[16], uchar *c8, uchar p24[24]));
void NTLMSSPOWFencrypt __P((uchar passwd[8], uchar *ntlmchalresp, uchar p24[24]));
void SMBNTencrypt __P((const char *passwd, uchar *c8, uchar *p24));
BOOL make_oem_passwd_hash __P((char data[516], const char *passwd, uchar old_pw_hash[16], BOOL unicode));
BOOL encode_pw_buffer __P((char buffer[516], const char *new_pass,
			int new_pw_len, BOOL nt_pass_set));
BOOL decode_pw_buffer __P((char in_buffer[516], char *new_pwrd,
		      int new_pwrd_size, uint32 *new_pw_len,
		      uchar nt_p16[16], uchar p16[16]));
void nt_owf_genW __P((const UNISTR2 *pwd, uchar nt_p16[16]));

/* The following definitions come from libsmb/smberr.c  */

const char *smb_dos_err_name __P((uint8 class, uint16 num));
const char *get_dos_error_msg __P((WERROR result));
const char *smb_dos_err_class __P((uint8 class));
const char *smb_dos_errstr __P((char *inbuf));
WERROR map_werror_from_unix __P((int error));

/* The following definitions come from libsmb/unexpected.c  */

void unexpected_packet __P((struct packet_struct *p));
void clear_unexpected __P((time_t t));
struct packet_struct *receive_unexpected __P((enum packet_type packet_type, int id, 
					 const char *mailslot_name));

/* The following definitions come from locking/brlock.c  */

void brl_init __P((int read_only));
void brl_shutdown __P((int read_only));
NTSTATUS brl_lock __P((SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		  uint16 smbpid, pid_t pid, uint16 tid,
		  br_off start, br_off size, 
		  enum brl_type lock_type));
BOOL brl_unlock __P((SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		uint16 smbpid, pid_t pid, uint16 tid,
		br_off start, br_off size,
		BOOL remove_pending_locks_only));
BOOL brl_locktest __P((SMB_DEV_T dev, SMB_INO_T ino, int fnum,
		  uint16 smbpid, pid_t pid, uint16 tid,
		  br_off start, br_off size, 
		  enum brl_type lock_type, int check_self));
void brl_close __P((SMB_DEV_T dev, SMB_INO_T ino, pid_t pid, int tid, int fnum));
int brl_forall __P((BRLOCK_FN(fn)));

/* The following definitions come from locking/locking.c  */

BOOL is_locked __P((files_struct *fsp,connection_struct *conn,
	       SMB_BIG_UINT count,SMB_BIG_UINT offset, 
	       enum brl_type lock_type, BOOL check_self));
NTSTATUS do_lock_spin __P((files_struct *fsp,connection_struct *conn, uint16 lock_pid,
		 SMB_BIG_UINT count,SMB_BIG_UINT offset,enum brl_type lock_type));
NTSTATUS do_unlock __P((files_struct *fsp,connection_struct *conn, uint16 lock_pid,
		   SMB_BIG_UINT count,SMB_BIG_UINT offset));
void locking_close_file __P((files_struct *fsp));
BOOL locking_init __P((int read_only));
BOOL locking_end __P((void));
BOOL lock_share_entry __P((connection_struct *conn,
		      SMB_DEV_T dev, SMB_INO_T inode));
void unlock_share_entry __P((connection_struct *conn,
			SMB_DEV_T dev, SMB_INO_T inode));
BOOL lock_share_entry_fsp __P((files_struct *fsp));
void unlock_share_entry_fsp __P((files_struct *fsp));
int get_share_modes __P((connection_struct *conn, 
		    SMB_DEV_T dev, SMB_INO_T inode, 
		    share_mode_entry **pp_shares));
BOOL share_modes_identical __P(( share_mode_entry *e1, share_mode_entry *e2));
ssize_t del_share_entry __P(( SMB_DEV_T dev, SMB_INO_T inode,
			share_mode_entry *entry, share_mode_entry **ppse));
ssize_t del_share_mode __P((files_struct *fsp, share_mode_entry **ppse));
BOOL set_share_mode __P((files_struct *fsp, uint16 port, uint16 op_type));
BOOL remove_share_oplock __P((files_struct *fsp));
BOOL downgrade_share_oplock __P((files_struct *fsp));
BOOL modify_delete_flag __P(( SMB_DEV_T dev, SMB_INO_T inode, BOOL delete_on_close));
int share_mode_forall __P((SHAREMODE_FN(fn)));

/* The following definitions come from locking/posix.c  */

int fd_close_posix __P((struct connection_struct *conn, files_struct *fsp));
BOOL is_posix_locked __P((files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count, enum brl_type lock_type));
BOOL set_posix_lock __P((files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count, enum brl_type lock_type));
BOOL release_posix_lock __P((files_struct *fsp, SMB_BIG_UINT u_offset, SMB_BIG_UINT u_count));
void posix_locking_close_file __P((files_struct *fsp));
BOOL posix_locking_init __P((int read_only));
BOOL posix_locking_end __P((void));

/* The following definitions come from msdfs/msdfs.c  */

BOOL is_msdfs_link __P((connection_struct* conn, char* path,
		   struct referral** reflistp, int* refcnt,
		   SMB_STRUCT_STAT *sbufp));
BOOL dfs_redirect __P((char* pathname, connection_struct* conn,
		  BOOL findfirst_flag));
BOOL get_referred_path __P((char *pathname, struct junction_map* jn,
		       int* consumedcntp, BOOL* self_referralp));
int setup_dfs_referral __P((char* pathname, int max_referral_level, char** ppdata));
int dfs_path_error __P((char* inbuf, char* outbuf));
BOOL create_junction __P((char* pathname, struct junction_map* jn));
BOOL create_msdfs_link __P((struct junction_map* jn, BOOL exists));
BOOL remove_msdfs_link __P((struct junction_map* jn));
int enum_msdfs_links __P((struct junction_map* jn));

/* The following definitions come from nmbd/asyncdns.c  */

int asyncdns_fd __P((void));
void kill_async_dns_child __P((void));
void start_async_dns __P((void));
void run_dns_queue __P((void));
BOOL queue_dns_query __P((struct packet_struct *p,struct nmb_name *question,
		     struct name_record **n));
BOOL queue_dns_query __P((struct packet_struct *p,struct nmb_name *question,
		     struct name_record **n));
void kill_async_dns_child __P((void));

/* The following definitions come from nmbd/nmbd.c  */


/* The following definitions come from nmbd/nmbd_become_dmb.c  */

void add_domain_names __P((time_t t));

/* The following definitions come from nmbd/nmbd_become_lmb.c  */

void insert_permanent_name_into_unicast __P(( struct subnet_record *subrec, 
                                                struct nmb_name *nmbname, uint16 nb_type ));
void unbecome_local_master_browser __P((struct subnet_record *subrec, struct work_record *work,
                                   BOOL force_new_election));
void become_local_master_browser __P((struct subnet_record *subrec, struct work_record *work));
void set_workgroup_local_master_browser_name __P(( struct work_record *work, const char *newname));

/* The following definitions come from nmbd/nmbd_browserdb.c  */

void update_browser_death_time __P(( struct browse_cache_record *browc ));
struct browse_cache_record *create_browser_in_lmb_cache __P(( char *work_name, 
                                                         char *browser_name, 
                                                         struct in_addr ip ));
struct browse_cache_record *find_browser_in_lmb_cache __P(( char *browser_name ));
void expire_lmb_browsers __P(( time_t t ));

/* The following definitions come from nmbd/nmbd_browsesync.c  */

void dmb_expire_and_sync_browser_lists __P((time_t t));
void announce_and_sync_with_domain_master_browser __P(( struct subnet_record *subrec,
                                                   struct work_record *work));
void collect_all_workgroup_names_from_wins_server __P((time_t t));
void sync_all_dmbs __P((time_t t));

/* The following definitions come from nmbd/nmbd_elections.c  */

void check_master_browser_exists __P((time_t t));
void run_elections __P((time_t t));
void process_election __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
BOOL check_elections __P((void));
void nmbd_message_election __P((int msg_type, pid_t src, void *buf, size_t len));

/* The following definitions come from nmbd/nmbd_incomingdgrams.c  */

void tell_become_backup __P((void));
void process_host_announce __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
void process_workgroup_announce __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
void process_local_master_announce __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
void process_master_browser_announce __P((struct subnet_record *subrec, 
                                     struct packet_struct *p,char *buf));
void process_lm_host_announce __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
void process_get_backup_list_request __P((struct subnet_record *subrec,
                                     struct packet_struct *p,char *buf));
void process_reset_browser __P((struct subnet_record *subrec,
                                  struct packet_struct *p,char *buf));
void process_announce_request __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));
void process_lm_announce_request __P((struct subnet_record *subrec, struct packet_struct *p, char *buf));

/* The following definitions come from nmbd/nmbd_incomingrequests.c  */

void process_name_release_request __P((struct subnet_record *subrec, 
                                  struct packet_struct *p));
void process_name_refresh_request __P((struct subnet_record *subrec,
                                  struct packet_struct *p));
void process_name_registration_request __P((struct subnet_record *subrec, 
                                       struct packet_struct *p));
void process_node_status_request __P((struct subnet_record *subrec, struct packet_struct *p));
void process_name_query_request __P((struct subnet_record *subrec, struct packet_struct *p));

/* The following definitions come from nmbd/nmbd_lmhosts.c  */

void load_lmhosts_file __P((char *fname));
BOOL find_name_in_lmhosts __P((struct nmb_name *nmbname, struct name_record **namerecp));

/* The following definitions come from nmbd/nmbd_logonnames.c  */

void add_logon_names __P((void));

/* The following definitions come from nmbd/nmbd_mynames.c  */

void register_my_workgroup_one_subnet __P((struct subnet_record *subrec));
BOOL register_my_workgroup_and_names __P((void));
void release_my_names __P((void));
void refresh_my_names __P((time_t t));

/* The following definitions come from nmbd/nmbd_namelistdb.c  */

void set_samba_nb_type __P((void));
void remove_name_from_namelist __P(( struct subnet_record *subrec, 
                                struct name_record   *namerec ));
struct name_record *find_name_on_subnet __P(( struct subnet_record *subrec,
                                         struct nmb_name      *nmbname,
                                         BOOL                  self_only ));
struct name_record *find_name_for_remote_broadcast_subnet __P((
                                                   struct nmb_name *nmbname,
                                                   BOOL             self_only ));
void update_name_ttl __P(( struct name_record *namerec, int ttl ));
struct name_record *add_name_to_subnet __P(( struct subnet_record *subrec,
                                        const char            *name,
                                        int                   type,
                                        uint16                nb_flags,
                                        int                   ttl,
                                        enum name_source      source,
                                        int                   num_ips,
                                        struct in_addr       *iplist));
void standard_success_register __P((struct subnet_record *subrec, 
                             struct userdata_struct *userdata,
                             struct nmb_name *nmbname, uint16 nb_flags, int ttl,
                             struct in_addr registered_ip));
void standard_fail_register __P(( struct subnet_record   *subrec,
                             struct response_record *rrec,
                             struct nmb_name        *nmbname ));
BOOL find_ip_in_name_record __P(( struct name_record *namerec, struct in_addr ip ));
void add_ip_to_name_record __P(( struct name_record *namerec, struct in_addr new_ip ));
void remove_ip_from_name_record __P(( struct name_record *namerec,
                                 struct in_addr      remove_ip ));
void standard_success_release __P(( struct subnet_record   *subrec,
                               struct userdata_struct *userdata,
                               struct nmb_name        *nmbname,
                               struct in_addr          released_ip ));
void expire_names_on_subnet __P((struct subnet_record *subrec, time_t t));
void expire_names __P((time_t t));
void add_samba_names_to_subnet __P(( struct subnet_record *subrec ));
void dump_all_namelists __P((void));

/* The following definitions come from nmbd/nmbd_namequery.c  */

BOOL query_name __P((struct subnet_record *subrec, char *name, int type,
                   query_name_success_function success_fn,
                   query_name_fail_function fail_fn, 
                   struct userdata_struct *userdata));
BOOL query_name_from_wins_server __P((struct in_addr ip_to, 
                   char *name, int type,
                   query_name_success_function success_fn,
                   query_name_fail_function fail_fn, 
                   struct userdata_struct *userdata));

/* The following definitions come from nmbd/nmbd_nameregister.c  */

BOOL register_name __P((struct subnet_record *subrec,
                   const char *name, int type, uint16 nb_flags,
                   register_name_success_function success_fn,
                   register_name_fail_function fail_fn,
                   struct userdata_struct *userdata));
BOOL refresh_name __P((struct subnet_record *subrec, struct name_record *namerec,
                  refresh_name_success_function success_fn,
                  refresh_name_fail_function fail_fn,
                  struct userdata_struct *userdata));

/* The following definitions come from nmbd/nmbd_namerelease.c  */

BOOL release_name __P((struct subnet_record *subrec, struct name_record *namerec,
                   release_name_success_function success_fn,
                   release_name_fail_function fail_fn,
                   struct userdata_struct *userdata));

/* The following definitions come from nmbd/nmbd_nodestatus.c  */

BOOL node_status __P((struct subnet_record *subrec, struct nmb_name *nmbname,
                 struct in_addr send_ip, node_status_success_function success_fn, 
                 node_status_fail_function fail_fn, struct userdata_struct *userdata));

/* The following definitions come from nmbd/nmbd_packets.c  */

uint16 get_nb_flags __P((char *buf));
void set_nb_flags __P((char *buf, uint16 nb_flags));
struct response_record *queue_register_name __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          register_name_success_function success_fn,
                          register_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          uint16 nb_flags));
struct response_record *queue_register_multihomed_name __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          register_name_success_function success_fn,
                          register_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          uint16 nb_flags,
                          struct in_addr register_ip));
struct response_record *queue_release_name __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          release_name_success_function success_fn,
                          release_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          uint16 nb_flags,
                          struct in_addr release_ip));
struct response_record *queue_refresh_name __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          refresh_name_success_function success_fn,
                          refresh_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct name_record *namerec,
                          struct in_addr refresh_ip));
struct response_record *queue_query_name __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          query_name_success_function success_fn,
                          query_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname));
struct response_record *queue_query_name_from_wins_server __P(( struct in_addr to_ip,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          query_name_success_function success_fn,
                          query_name_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname));
struct response_record *queue_node_status __P(( struct subnet_record *subrec,
                          response_function resp_fn,
                          timeout_response_function timeout_fn,
                          node_status_success_function success_fn,
                          node_status_fail_function fail_fn,
                          struct userdata_struct *userdata,
                          struct nmb_name *nmbname,
                          struct in_addr send_ip));
void reply_netbios_packet __P((struct packet_struct *orig_packet,
                          int rcode, enum netbios_reply_type_code rcv_code, int opcode,
                          int ttl, char *data,int len));
void run_packet_queue __P((void));
void retransmit_or_expire_response_records __P((time_t t));
BOOL listen_for_packets __P((BOOL run_election));
BOOL send_mailslot __P((BOOL unique, const char *mailslot,char *buf,int len,
                   const char *srcname, int src_type,
                   const char *dstname, int dest_type,
                   struct in_addr dest_ip,struct in_addr src_ip,
		   int dest_port));

/* The following definitions come from nmbd/nmbd_processlogon.c  */

void process_logon_packet __P((struct packet_struct *p,char *buf,int len, 
                          const char *mailslot));

/* The following definitions come from nmbd/nmbd_responserecordsdb.c  */

void remove_response_record __P((struct subnet_record *subrec,
				struct response_record *rrec));
struct response_record *make_response_record __P(( struct subnet_record *subrec,
                    struct packet_struct *p,
                    response_function resp_fn,
                    timeout_response_function timeout_fn,
                    success_function success_fn,
                    fail_function fail_fn,
                    struct userdata_struct *userdata));
struct response_record *find_response_record __P((struct subnet_record **ppsubrec,
				uint16 id));
BOOL is_refresh_already_queued __P((struct subnet_record *subrec, struct name_record *namerec));

/* The following definitions come from nmbd/nmbd_sendannounce.c  */

void send_browser_reset __P((int reset_type, const char *to_name, int to_type, struct in_addr to_ip));
void broadcast_announce_request __P((struct subnet_record *subrec, struct work_record *work));
void announce_my_server_names __P((time_t t));
void announce_my_lm_server_names __P((time_t t));
void reset_announce_timer __P((void));
void announce_myself_to_domain_master_browser __P((time_t t));
void announce_my_servers_removed __P((void));
void announce_remote __P((time_t t));
void browse_sync_remote __P((time_t t));

/* The following definitions come from nmbd/nmbd_serverlistdb.c  */

void remove_all_servers __P((struct work_record *work));
struct server_record *find_server_in_workgroup __P((struct work_record *work, char *name));
void remove_server_from_workgroup __P((struct work_record *work, struct server_record *servrec));
struct server_record *create_server_on_workgroup __P((struct work_record *work,
                                                 char *name,int servertype, 
                                                 int ttl,char *comment));
void update_server_ttl __P((struct server_record *servrec, int ttl));
void expire_servers __P((struct work_record *work, time_t t));
void write_browse_list_entry __P((FILE *fp, fstring name, uint32 rec_type,
		fstring local_master_browser_name, fstring description));
void write_browse_list __P((time_t t, BOOL force_write));

/* The following definitions come from nmbd/nmbd_subnetdb.c  */

void close_subnet __P((struct subnet_record *subrec));
struct subnet_record *make_normal_subnet __P((struct interface *iface));
BOOL create_subnets __P((void));
BOOL we_are_a_wins_client __P((void));
struct subnet_record *get_next_subnet_maybe_unicast __P((struct subnet_record *subrec));
struct subnet_record *get_next_subnet_maybe_unicast_or_wins_server __P((struct subnet_record *subrec));

/* The following definitions come from nmbd/nmbd_synclists.c  */

void sync_browse_lists __P((struct work_record *work,
		       char *name, int nm_type, 
		       struct in_addr ip, BOOL local, BOOL servers));
void sync_check_completion __P((void));

/* The following definitions come from nmbd/nmbd_winsproxy.c  */

void make_wins_proxy_name_query_request __P(( struct subnet_record *subrec, 
                                         struct packet_struct *incoming_packet,
                                         struct nmb_name *question_name));

/* The following definitions come from nmbd/nmbd_winsserver.c  */

BOOL packet_is_for_wins_server __P((struct packet_struct *packet));
BOOL initialise_wins __P((void));
void wins_process_name_refresh_request __P((struct subnet_record *subrec,
                                            struct packet_struct *p));
void wins_process_name_registration_request __P((struct subnet_record *subrec,
                                            struct packet_struct *p));
void wins_process_multihomed_name_registration_request __P(( struct subnet_record *subrec,
                                                        struct packet_struct *p));
void send_wins_name_query_response __P((int rcode, struct packet_struct *p, 
                                          struct name_record *namerec));
void wins_process_name_query_request __P((struct subnet_record *subrec, 
                                     struct packet_struct *p));
void wins_process_name_release_request __P((struct subnet_record *subrec,
                                       struct packet_struct *p));
void initiate_wins_processing __P((time_t t));
void wins_write_database __P((BOOL background));

/* The following definitions come from nmbd/nmbd_workgroupdb.c  */

struct work_record *find_workgroup_on_subnet __P((struct subnet_record *subrec, 
                                             const char *name));
struct work_record *create_workgroup_on_subnet __P((struct subnet_record *subrec,
                                               const char *name, int ttl));
void update_workgroup_ttl __P((struct work_record *work, int ttl));
void initiate_myworkgroup_startup __P((struct subnet_record *subrec, struct work_record *work));
void dump_workgroups __P((BOOL force_write));
void expire_workgroups_and_servers __P((time_t t));

/* The following definitions come from nsswitch/wb_client.c  */

BOOL winbind_lookup_name __P((const char *dom_name, const char *name, DOM_SID *sid, 
                         enum SID_NAME_USE *name_type));
BOOL winbind_lookup_sid __P((DOM_SID *sid, 
			fstring dom_name, fstring name, 
                        enum SID_NAME_USE *name_type));
BOOL winbind_sid_to_uid __P((uid_t *puid, DOM_SID *sid));
BOOL winbind_uid_to_sid __P((DOM_SID *sid, uid_t uid));
BOOL winbind_sid_to_gid __P((gid_t *pgid, DOM_SID *sid));
BOOL winbind_gid_to_sid __P((DOM_SID *sid, gid_t gid));
int winbind_initgroups __P((char *user, gid_t gid));
int winbind_getgroups __P((const char *user, int size, gid_t *list));
BOOL winbind_uidtoname __P((fstring name, uid_t uid));
BOOL winbind_gidtoname __P((fstring name, gid_t gid));
BOOL winbind_nametouid __P((uid_t *puid, const char *name));
BOOL winbind_nametogid __P((gid_t *pgid, const char *gname));

/* The following definitions come from nsswitch/wb_common.c  */

void free_response __P((struct winbindd_response *response));
void winbind_exclude_domain __P((const char *domain));
void init_request __P((struct winbindd_request *request, int request_type));
void init_response __P((struct winbindd_response *response));
void close_sock __P((void));
int winbind_open_pipe_sock __P((void));
int write_sock __P((void *buffer, int count));
int read_reply __P((struct winbindd_response *response));

/* The following definitions come from param/loadparm.c  */

void lp_talloc_free __P((void));
char *lp_logfile __P((void));
char *lp_configfile __P((void));
char *lp_tdb_passwd_file __P((void));
char *lp_smb_passwd_file __P((void));
char *lp_serverstring __P((void));
char *lp_printcapname __P((void));
char *lp_enumports_cmd __P((void));
char *lp_addprinter_cmd __P((void));
char *lp_deleteprinter_cmd __P((void));
char *lp_os2_driver_map __P((void));
char *lp_lockdir __P((void));
char *lp_piddir __P((void));
char *lp_utmpdir __P((void));
char *lp_wtmpdir __P((void));
BOOL lp_utmp __P((void));
char *lp_rootdir __P((void));
char *lp_source_environment __P((void));
char *lp_defaultservice __P((void));
char *lp_msg_command __P((void));
char *lp_dfree_command __P((void));
char *lp_hosts_equiv __P((void));
char *lp_auto_services __P((void));
char *lp_passwd_program __P((void));
char *lp_passwd_chat __P((void));
char *lp_passwordserver __P((void));
char *lp_name_resolve_order __P((void));
char *lp_workgroup __P((void));
char *lp_username_map __P((void));
char *lp_groupname_map __P((void));
char *lp_logon_script __P((void));
char *lp_logon_path __P((void));
char *lp_logon_drive __P((void));
char *lp_logon_home __P((void));
char *lp_remote_announce __P((void));
char *lp_remote_browse_sync __P((void));
char *lp_wins_server __P((void));
char *lp_interfaces __P((void));
char *lp_socket_address __P((void));
char *lp_nis_home_map_name __P((void));
char *lp_netbios_aliases __P((void));
char *lp_panic_action __P((void));
char *lp_adduser_script __P((void));
char *lp_deluser_script __P((void));
char *lp_wins_hook __P((void));
char *lp_domain_admin_group __P((void));
char *lp_domain_guest_group __P((void));
char *lp_template_homedir __P((void));
char *lp_template_shell __P((void));
char *lp_winbind_separator __P((void));
char *lp_acl_compatibility __P((void));
BOOL lp_winbind_enum_users __P((void));
BOOL lp_winbind_enum_groups __P((void));
BOOL lp_winbind_use_default_domain __P((void));
char *lp_codepagedir __P((void));
char *lp_ldap_server __P((void));
char *lp_ldap_suffix __P((void));
char *lp_ldap_filter __P((void));
char *lp_ldap_admin_dn __P((void));
int lp_ldap_port __P((void));
int lp_ldap_ssl __P((void));
BOOL lp_ldap_referrals __P((void));
char *lp_add_share_cmd __P((void));
char *lp_change_share_cmd __P((void));
char *lp_delete_share_cmd __P((void));
char *lp_mangling_method __P((void));
int lp_ssl_version __P((void));
char *lp_ssl_hosts __P((void));
char *lp_ssl_hosts_resign __P((void));
char *lp_ssl_cacertdir __P((void));
char *lp_ssl_cacertfile __P((void));
char *lp_ssl_server_cert __P((void));
char *lp_ssl_server_privkey __P((void));
char *lp_ssl_client_cert __P((void));
char *lp_ssl_client_privkey __P((void));
char *lp_ssl_ciphers __P((void));
char *lp_ssl_egdsocket __P((void));
char *lp_ssl_entropyfile __P((void));
int lp_ssl_entropybytes __P((void));
BOOL lp_ssl_enabled __P((void));
BOOL lp_ssl_reqClientCert __P((void));
BOOL lp_ssl_reqServerCert __P((void));
BOOL lp_ssl_compatibility __P((void));
BOOL lp_ms_add_printer_wizard __P((void));
BOOL lp_dns_proxy __P((void));
BOOL lp_wins_support __P((void));
BOOL lp_we_are_a_wins_server __P((void));
BOOL lp_wins_proxy __P((void));
BOOL lp_local_master __P((void));
BOOL lp_domain_logons __P((void));
BOOL lp_load_printers __P((void));
BOOL lp_use_rhosts __P((void));
BOOL lp_readprediction __P((void));
BOOL lp_readbmpx __P((void));
BOOL lp_readraw __P((void));
BOOL lp_large_readwrite __P((void));
BOOL lp_writeraw __P((void));
BOOL lp_null_passwords __P((void));
BOOL lp_obey_pam_restrictions __P((void));
BOOL lp_strip_dot __P((void));
BOOL lp_encrypted_passwords __P((void));
BOOL lp_update_encrypted __P((void));
BOOL lp_syslog_only __P((void));
BOOL lp_admin_log __P((void));
BOOL lp_timestamp_logs __P((void));
BOOL lp_debug_hires_timestamp __P((void));
BOOL lp_debug_pid __P((void));
BOOL lp_debug_uid __P((void));
BOOL lp_browse_list __P((void));
BOOL lp_nis_home_map __P((void));
BOOL lp_bind_interfaces_only __P((void));
BOOL lp_pam_password_change __P((void));
BOOL lp_unix_password_sync __P((void));
BOOL lp_passwd_chat_debug __P((void));
BOOL lp_nt_smb_support __P((void));
BOOL lp_nt_pipe_support __P((void));
BOOL lp_nt_status_support __P((void));
BOOL lp_stat_cache __P((void));
BOOL lp_allow_trusted_domains __P((void));
BOOL lp_restrict_anonymous __P((void));
BOOL lp_lanman_auth __P((void));
BOOL lp_host_msdfs __P((void));
BOOL lp_kernel_oplocks __P((void));
BOOL lp_enhanced_browsing __P((void));
BOOL lp_use_mmap __P((void));
BOOL lp_unix_extensions __P((void));
int lp_os_level __P((void));
int lp_max_ttl __P((void));
int lp_max_wins_ttl __P((void));
int lp_min_wins_ttl __P((void));
int lp_max_log_size __P((void));
int lp_max_open_files __P((void));
int lp_maxxmit __P((void));
int lp_maxmux __P((void));
int lp_passwordlevel __P((void));
int lp_usernamelevel __P((void));
int lp_readsize __P((void));
int lp_deadtime __P((void));
int lp_maxprotocol __P((void));
int lp_minprotocol __P((void));
int lp_security __P((void));
int lp_maxdisksize __P((void));
int lp_lpqcachetime __P((void));
int lp_max_smbd_processes __P((void));
int lp_disable_spoolss __P((void));
int lp_totalprintjobs __P((void));
int lp_syslog __P((void));
int lp_client_code_page __P((void));
int lp_lm_announce __P((void));
int lp_lm_interval __P((void));
int lp_machine_password_timeout __P((void));
int lp_change_notify_timeout __P((void));
int lp_stat_cache_size __P((void));
int lp_map_to_guest __P((void));
int lp_min_passwd_length __P((void));
int lp_oplock_break_wait_time __P((void));
int lp_lock_spin_count __P((void));
int lp_lock_sleep_time __P((void));
int lp_name_cache_timeout __P((void));
char *lp_preexec __P((int ));
char *lp_postexec __P((int ));
char *lp_rootpreexec __P((int ));
char *lp_rootpostexec __P((int ));
char *lp_servicename __P((int ));
char *lp_pathname __P((int ));
char *lp_dontdescend __P((int ));
char *lp_username __P((int ));
char *lp_guestaccount __P((int ));
char *lp_invalid_users __P((int ));
char *lp_valid_users __P((int ));
char *lp_admin_users __P((int ));
char *lp_printcommand __P((int ));
char *lp_lpqcommand __P((int ));
char *lp_lprmcommand __P((int ));
char *lp_lppausecommand __P((int ));
char *lp_lpresumecommand __P((int ));
char *lp_queuepausecommand __P((int ));
char *lp_queueresumecommand __P((int ));
char *lp_driverfile __P((int ));
char *lp_printerdriver __P((int ));
char *lp_hostsallow __P((int ));
char *lp_hostsdeny __P((int ));
char *lp_magicscript __P((int ));
char *lp_magicoutput __P((int ));
char *lp_comment __P((int ));
char *lp_force_user __P((int ));
char *lp_force_group __P((int ));
char *lp_readlist __P((int ));
char *lp_writelist __P((int ));
char *lp_printer_admin __P((int ));
char *lp_fstype __P((int ));
char *lp_vfsobj __P((int ));
char *lp_vfs_options __P((int ));
char *lp_mangled_map __P((int ));
char *lp_veto_files __P((int ));
char *lp_hide_files __P((int ));
char *lp_veto_oplocks __P((int ));
char *lp_driverlocation __P((int ));
char *lp_recyclebin __P((int ));
BOOL lp_msdfs_root __P((int ));
BOOL lp_autoloaded __P((int ));
BOOL lp_preexec_close __P((int ));
BOOL lp_rootpreexec_close __P((int ));
BOOL lp_casesensitive __P((int ));
BOOL lp_preservecase __P((int ));
BOOL lp_shortpreservecase __P((int ));
BOOL lp_casemangle __P((int ));
BOOL lp_status __P((int ));
BOOL lp_hide_dot_files __P((int ));
BOOL lp_hideunreadable __P((int ));
BOOL lp_browseable __P((int ));
BOOL lp_readonly __P((int ));
BOOL lp_no_set_dir __P((int ));
BOOL lp_guest_ok __P((int ));
BOOL lp_guest_only __P((int ));
BOOL lp_print_ok __P((int ));
BOOL lp_postscript __P((int ));
BOOL lp_map_hidden __P((int ));
BOOL lp_map_archive __P((int ));
BOOL lp_locking __P((int ));
BOOL lp_strict_locking __P((int ));
BOOL lp_share_modes __P((int ));
BOOL lp_posix_locking __P((int ));
BOOL lp_oplocks __P((int ));
BOOL lp_level2_oplocks __P((int ));
BOOL lp_onlyuser __P((int ));
BOOL lp_manglednames __P((int ));
BOOL lp_widelinks __P((int ));
BOOL lp_symlinks __P((int ));
BOOL lp_syncalways __P((int ));
BOOL lp_strict_allocate __P((int ));
BOOL lp_strict_sync __P((int ));
BOOL lp_map_system __P((int ));
BOOL lp_delete_readonly __P((int ));
BOOL lp_fake_oplocks __P((int ));
BOOL lp_recursive_veto_delete __P((int ));
BOOL lp_dos_filemode __P((int ));
BOOL lp_dos_filetimes __P((int ));
BOOL lp_dos_filetime_resolution __P((int ));
BOOL lp_fake_dir_create_times __P((int ));
BOOL lp_blocking_locks __P((int ));
BOOL lp_inherit_perms __P((int ));
BOOL lp_inherit_acls __P((int ));
BOOL lp_use_client_driver __P((int ));
BOOL lp_default_devmode __P((int ));
BOOL lp_nt_acl_support __P((int ));
BOOL lp_force_unknown_acl_user __P((int ));
BOOL lp_use_sendfile __P((int ));
BOOL lp_profile_acls __P((int ));
int lp_create_mask __P((int ));
int lp_force_create_mode __P((int ));
int lp_security_mask __P((int ));
int lp_force_security_mode __P((int ));
int lp_dir_mask __P((int ));
int lp_force_dir_mode __P((int ));
int lp_dir_security_mask __P((int ));
int lp_force_dir_security_mode __P((int ));
int lp_max_connections __P((int ));
int lp_defaultcase __P((int ));
int lp_minprintspace __P((int ));
int lp_printing __P((int ));
int lp_oplock_contention_limit __P((int ));
int lp_csc_policy __P((int ));
int lp_write_cache_size __P((int ));
int lp_block_size __P((int ));
char lp_magicchar __P((int ));
int lp_winbind_cache_time __P((void));
BOOL lp_hide_local_users __P((void));
BOOL lp_add_home __P((char *pszHomename, int iDefaultService, char *pszHomedir));
int lp_add_service __P((char *pszService, int iDefaultService));
BOOL lp_add_printer __P((char *pszPrintername, int iDefaultService));
BOOL lp_file_list_changed __P((void));
BOOL lp_winbind_uid __P((uid_t *low, uid_t *high));
BOOL lp_winbind_gid __P((gid_t *low, gid_t *high));
void *lp_local_ptr __P((int snum, void *ptr));
BOOL lp_do_parameter __P((int snum, const char *pszParmName, const char *pszParmValue, BOOL unixcode));
void init_locals __P((void));
BOOL lp_is_default __P((int snum, struct parm_struct *parm));
struct parm_struct *lp_next_parameter __P((int snum, int *i, int allparameters));
BOOL lp_snum_ok __P((int iService));
void lp_add_one_printer __P((char *name, char *comment));
BOOL lp_loaded __P((void));
void lp_killunused __P((BOOL (*snumused) (int)));
void lp_killservice __P((int iServiceIn));
BOOL lp_load __P((const char *pszFname, BOOL global_only, BOOL save_defaults,
	     BOOL add_ipc));
void lp_resetnumservices __P((void));
int lp_numservices __P((void));
void lp_dump __P((FILE *f, BOOL show_defaults, int maxtoprint, char *(*dos_to_ext)(char *, const char *)));
void lp_dump_one __P((FILE * f, BOOL show_defaults, int snum, char *(*dos_to_ext)(char *, const char *)));
int lp_servicenumber __P((const char *pszServiceName));
char *volume_label __P((int snum));
int lp_server_role __P((void));
BOOL lp_domain_master __P((void));
BOOL lp_preferred_master __P((void));
void lp_remove_service __P((int snum));
void lp_copy_service __P((int snum, const char *new_name));
int lp_default_server_announce __P((void));
int lp_major_announce_version __P((void));
int lp_minor_announce_version __P((void));
void lp_set_name_resolve_order __P((char *new_order));
char *lp_printername __P((int snum));
void get_private_directory __P((pstring priv_dir));
void lp_set_logfile __P((const char *name));
const char *get_called_name __P((void));
int lp_maxprintjobs __P((int snum));

/* The following definitions come from param/params.c  */

BOOL pm_process __P(( char *FileName,
                 BOOL (*sfunc)(char *),
                 BOOL (*pfunc)(char *, char *) ));

/* The following definitions come from passdb/machine_sid.c  */

BOOL pdb_generate_sam_sid __P((void));

/* The following definitions come from passdb/pampass.c  */

BOOL smb_pam_claim_session __P((char *user, char *tty, char *rhost));
BOOL smb_pam_close_session __P((char *user, char *tty, char *rhost));
NTSTATUS smb_pam_accountcheck __P((const char * user));
NTSTATUS smb_pam_passcheck __P((char * user, char * password));
BOOL smb_pam_passchange __P((const char * user, const char * oldpassword, const char * newpassword));
NTSTATUS smb_pam_accountcheck __P((const char * user));
BOOL smb_pam_claim_session __P((char *user, char *tty, char *rhost));
BOOL smb_pam_close_session __P((char *in_user, char *tty, char *rhost));

/* The following definitions come from passdb/pass_check.c  */

void dfs_unlogin __P((void));
BOOL pass_check __P((char *user, char *password, int pwlen, struct passwd *pwd,
		BOOL (*fn) (char *, char *)));

/* The following definitions come from passdb/passdb.c  */

BOOL initialize_password_db __P((BOOL reload));
BOOL pdb_init_sam __P((SAM_ACCOUNT **user));
BOOL pdb_init_sam_pw __P((SAM_ACCOUNT **new_sam_acct, struct passwd *pwd));
BOOL pdb_reset_sam __P((SAM_ACCOUNT *user));
BOOL pdb_free_sam __P((SAM_ACCOUNT *user));
struct sam_disp_info *pdb_sam_to_dispinfo __P((SAM_ACCOUNT *user));
char *pdb_encode_acct_ctrl __P((uint16 acct_ctrl, size_t length));
uint16 pdb_decode_acct_ctrl __P((const char *p));
void pdb_sethexpwd __P((char *p, unsigned char *pwd, uint16 acct_ctrl));
BOOL pdb_gethexpwd __P((const char *p, unsigned char *pwd));
BOOL pdb_name_to_rid __P((char *user_name, uint32 *u_rid, uint32 *g_rid));
uid_t pdb_user_rid_to_uid __P((uint32 user_rid));
gid_t pdb_user_rid_to_gid __P((uint32 user_rid));
uint32 pdb_uid_to_user_rid __P((uid_t uid));
uint32 pdb_gid_to_group_rid __P((gid_t gid));
BOOL pdb_rid_is_user __P((uint32 rid));
BOOL local_lookup_rid __P((uint32 rid, char *name, enum SID_NAME_USE *psid_name_use));
BOOL local_lookup_name __P((const char *c_domain, const char *c_user, DOM_SID *psid, enum SID_NAME_USE *psid_name_use));
DOM_SID *local_uid_to_sid __P((DOM_SID *psid, uid_t uid));
BOOL local_sid_to_uid __P((uid_t *puid, DOM_SID *psid, enum SID_NAME_USE *name_type));
DOM_SID *local_gid_to_sid __P((DOM_SID *psid, gid_t gid));
BOOL local_sid_to_gid __P((gid_t *pgid, DOM_SID *psid, enum SID_NAME_USE *name_type));
void copy_id23_to_sam_passwd __P((SAM_ACCOUNT *to, SAM_USER_INFO_23 *from));
void copy_id21_to_sam_passwd __P((SAM_ACCOUNT *to, SAM_USER_INFO_21 *from));
void copy_sam_passwd __P((SAM_ACCOUNT *to, const SAM_ACCOUNT *from));
BOOL local_password_change __P((const char *user_name, int local_flags,
			   const char *new_passwd, 
			   char *err_str, size_t err_str_len,
			   char *msg_str, size_t msg_str_len));
uint16 pdb_get_acct_ctrl  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_logon_time  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_logoff_time  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_kickoff_time  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_pass_last_set_time  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_pass_can_change_time  __P((SAM_ACCOUNT *sampass));
time_t pdb_get_pass_must_change_time  __P((SAM_ACCOUNT *sampass));
uint16 pdb_get_logon_divs  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_hours_len  __P((SAM_ACCOUNT *sampass));
uint8* pdb_get_hours  __P((SAM_ACCOUNT *sampass));
uint8* pdb_get_nt_passwd  __P((SAM_ACCOUNT *sampass));
uint8* pdb_get_lanman_passwd  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_user_rid  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_group_rid  __P((SAM_ACCOUNT *sampass));
uid_t pdb_get_uid  __P((SAM_ACCOUNT *sampass));
gid_t pdb_get_gid  __P((SAM_ACCOUNT *sampass));
char* pdb_get_username  __P((SAM_ACCOUNT *sampass));
char* pdb_get_domain  __P((SAM_ACCOUNT *sampass));
char* pdb_get_nt_username  __P((SAM_ACCOUNT *sampass));
char* pdb_get_fullname  __P((SAM_ACCOUNT *sampass));
char* pdb_get_homedir  __P((SAM_ACCOUNT *sampass));
char* pdb_get_dirdrive  __P((SAM_ACCOUNT *sampass));
char* pdb_get_logon_script  __P((SAM_ACCOUNT *sampass));
char* pdb_get_profile_path  __P((SAM_ACCOUNT *sampass));
char* pdb_get_acct_desc  __P((SAM_ACCOUNT *sampass));
char* pdb_get_workstations  __P((SAM_ACCOUNT *sampass));
char* pdb_get_munged_dial  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_unknown3  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_unknown5  __P((SAM_ACCOUNT *sampass));
uint32 pdb_get_unknown6  __P((SAM_ACCOUNT *sampass));
BOOL pdb_set_acct_ctrl  __P((SAM_ACCOUNT *sampass, uint16 flags));
BOOL pdb_set_logon_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_logoff_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_kickoff_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_pass_can_change_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_pass_must_change_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_pass_last_set_time  __P((SAM_ACCOUNT *sampass, time_t mytime));
BOOL pdb_set_hours_len  __P((SAM_ACCOUNT *sampass, uint32 len));
BOOL pdb_set_logon_divs  __P((SAM_ACCOUNT *sampass, uint16 hours));
BOOL pdb_set_init_flag  __P((SAM_ACCOUNT *sampass, uint32 flag));
BOOL pdb_set_uid  __P((SAM_ACCOUNT *sampass, uid_t uid));
BOOL pdb_set_gid  __P((SAM_ACCOUNT *sampass, gid_t gid));
BOOL pdb_set_user_rid  __P((SAM_ACCOUNT *sampass, uint32 rid));
BOOL pdb_set_group_rid  __P((SAM_ACCOUNT *sampass, uint32 grid));
BOOL pdb_set_username __P((SAM_ACCOUNT *sampass, char *username));
BOOL pdb_set_domain __P((SAM_ACCOUNT *sampass, char *domain));
BOOL pdb_set_nt_username __P((SAM_ACCOUNT *sampass, char *nt_username));
BOOL pdb_set_fullname __P((SAM_ACCOUNT *sampass, char *fullname));
BOOL pdb_set_logon_script __P((SAM_ACCOUNT *sampass, char *logon_script, BOOL store));
BOOL pdb_set_profile_path  __P((SAM_ACCOUNT *sampass, char *profile_path, BOOL store));
BOOL pdb_set_dir_drive  __P((SAM_ACCOUNT *sampass, char *dir_drive, BOOL store));
BOOL pdb_set_homedir  __P((SAM_ACCOUNT *sampass, char *homedir, BOOL store));
BOOL pdb_set_acct_desc  __P((SAM_ACCOUNT *sampass, char *acct_desc));
BOOL pdb_set_workstations  __P((SAM_ACCOUNT *sampass, char *workstations));
BOOL pdb_set_munged_dial  __P((SAM_ACCOUNT *sampass, char *munged_dial));
BOOL pdb_set_nt_passwd  __P((SAM_ACCOUNT *sampass, uint8 *pwd));
BOOL pdb_set_lanman_passwd  __P((SAM_ACCOUNT *sampass, uint8 *pwd));
BOOL pdb_set_plaintext_passwd  __P((SAM_ACCOUNT *sampass, const char *plaintext));
BOOL pdb_set_unknown_3  __P((SAM_ACCOUNT *sampass, uint32 unkn));
BOOL pdb_set_unknown_5  __P((SAM_ACCOUNT *sampass, uint32 unkn));
BOOL pdb_set_unknown_6  __P((SAM_ACCOUNT *sampass, uint32 unkn));
BOOL pdb_set_hours  __P((SAM_ACCOUNT *sampass, uint8 *hours));
BOOL pdb_getsampwuid  __P((SAM_ACCOUNT* user, uid_t uid));

/* The following definitions come from passdb/pdb_ldap.c  */

BOOL pdb_setsampwent __P((BOOL update));
void pdb_endsampwent __P((void));
BOOL pdb_getsampwent __P((SAM_ACCOUNT * user));
BOOL pdb_getsampwnam __P((SAM_ACCOUNT * user, const char *sname));
BOOL pdb_getsampwrid __P((SAM_ACCOUNT * user, uint32 rid));
BOOL pdb_delete_sam_account __P((const char *sname));
BOOL pdb_update_sam_account __P((SAM_ACCOUNT * newpwd, BOOL override));
BOOL pdb_add_sam_account __P((SAM_ACCOUNT * newpwd));

/* The following definitions come from passdb/pdb_nisplus.c  */

BOOL pdb_setsampwent __P((BOOL update));
void pdb_endsampwent __P((void));
BOOL pdb_getsampwent __P((SAM_ACCOUNT *user));
BOOL pdb_getsampwnam __P((SAM_ACCOUNT * user, const char *sname));
BOOL pdb_getsampwrid __P((SAM_ACCOUNT * user, uint32 rid));
BOOL pdb_delete_sam_account __P((const char *sname));
BOOL pdb_add_sam_account __P((SAM_ACCOUNT * newpwd));
BOOL pdb_update_sam_account __P((SAM_ACCOUNT * newpwd, BOOL override));

/* The following definitions come from passdb/pdb_smbpasswd.c  */

BOOL pdb_setsampwent  __P((BOOL update));
void pdb_endsampwent  __P((void));
BOOL pdb_getsampwent __P((SAM_ACCOUNT *user));
BOOL pdb_getsampwnam __P((SAM_ACCOUNT *sam_acct, const char *username));
BOOL pdb_getsampwrid __P((SAM_ACCOUNT *sam_acct,uint32 rid));
BOOL pdb_add_sam_account __P((SAM_ACCOUNT *sampass));
BOOL pdb_update_sam_account __P((SAM_ACCOUNT *sampass, BOOL override));
BOOL pdb_delete_sam_account  __P((const char* username));

/* The following definitions come from passdb/pdb_tdb.c  */

BOOL pdb_setsampwent __P((BOOL update));
void pdb_endsampwent __P((void));
BOOL pdb_getsampwent __P((SAM_ACCOUNT *user));
BOOL pdb_getsampwnam  __P((SAM_ACCOUNT *user, const char *sname));
BOOL pdb_getsampwrid  __P((SAM_ACCOUNT *user, uint32 rid));
BOOL pdb_delete_sam_account __P((const char *sname));
BOOL pdb_update_sam_account  __P((SAM_ACCOUNT *newpwd, BOOL override));
BOOL pdb_add_sam_account  __P((SAM_ACCOUNT *newpwd));

/* The following definitions come from passdb/secrets.c  */

BOOL secrets_init __P((void));
void *secrets_fetch __P((const char *key, size_t *size));
BOOL secrets_store __P((const char *key, const void *data, size_t size));
BOOL secrets_delete __P((const char *key));
BOOL secrets_store_domain_sid __P((const char *domain, DOM_SID *sid));
BOOL secrets_fetch_domain_sid __P((const char *domain, DOM_SID *sid));
const char *trust_keystr __P((const char *domain));
BOOL secrets_lock_trust_account_password __P((const char *domain, BOOL dolock));
BOOL secrets_fetch_trust_account_password __P((const char *domain, uint8 ret_pwd[16],
					  time_t *pass_last_set_time));
BOOL secrets_store_trust_account_password __P((const char *domain, uint8 new_pwd[16]));
BOOL trust_password_delete __P((const char *domain));
void reset_globals_after_fork __P((void));
BOOL secrets_store_ldap_pw __P((const char* dn, const char* pw));
BOOL fetch_ldap_pw __P((const char *dn, char* pw, int len));
BOOL secrets_named_mutex __P((const char *name, unsigned int timeout));
void secrets_named_mutex_release __P((const char *name));

/* The following definitions come from passdb/smbpassfile.c  */

BOOL migrate_from_old_password_file __P((char *domain));

/* The following definitions come from printing/load.c  */

void add_all_printers __P((void));
void load_printers __P((void));

/* The following definitions come from printing/lpq_parse.c  */

BOOL parse_lpq_entry __P((int snum,char *line,
		     print_queue_struct *buf,
		     print_status_struct *status,BOOL first));

/* The following definitions come from printing/nt_printing.c  */

BOOL nt_printing_init __P((void));
uint32 update_c_setprinter __P((BOOL initialize));
uint32 get_c_setprinter __P((void));
int get_builtin_ntforms __P((nt_forms_struct **list));
BOOL get_a_builtin_ntform __P((UNISTR2 *uni_formname,nt_forms_struct *form));
int get_ntforms __P((nt_forms_struct **list));
int write_ntforms __P((nt_forms_struct **list, int number));
BOOL add_a_form __P((nt_forms_struct **list, const FORM *form, int *count));
BOOL delete_a_form __P((nt_forms_struct **list, UNISTR2 *del_name, int *count, WERROR *ret));
void update_a_form __P((nt_forms_struct **list, const FORM *form, int count));
int get_ntdrivers __P((fstring **list, char *architecture, uint32 version));
BOOL get_short_archi __P((char *short_archi, const char *long_archi));
WERROR clean_up_driver_struct __P((NT_PRINTER_DRIVER_INFO_LEVEL driver_abstract,
							  uint32 level, struct current_user *user));
BOOL move_driver_to_download_area __P((NT_PRINTER_DRIVER_INFO_LEVEL driver_abstract, uint32 level, 
				  struct current_user *user, WERROR *perr));
uint32 get_a_printer_driver_9x_compatible __P((pstring line, const fstring model));
uint32 del_a_printer __P((char *sharename));
void add_a_specific_param __P((NT_PRINTER_INFO_LEVEL_2 *info_2, NT_PRINTER_PARAM **param));
BOOL unlink_specific_param_if_exist __P((NT_PRINTER_INFO_LEVEL_2 *info_2, NT_PRINTER_PARAM *param));
void free_nt_printer_param __P((NT_PRINTER_PARAM **param_ptr));
NT_DEVICEMODE *construct_nt_devicemode __P((const fstring default_devicename));
NT_DEVICEMODE *dup_nt_devicemode __P((NT_DEVICEMODE *nt_devicemode));
void free_nt_devicemode __P((NT_DEVICEMODE **devmode_ptr));
void get_printer_subst_params __P((int snum, fstring *printername, fstring *sharename, fstring *portname));
WERROR mod_a_printer __P((NT_PRINTER_INFO_LEVEL printer, uint32 level));
BOOL set_driver_init __P((NT_PRINTER_INFO_LEVEL *printer, uint32 level));
BOOL del_driver_init __P((char *drivername));
uint32 update_driver_init __P((NT_PRINTER_INFO_LEVEL printer, uint32 level));
WERROR save_driver_init __P((NT_PRINTER_INFO_LEVEL *printer, uint32 level, NT_PRINTER_PARAM *param));
WERROR get_a_printer __P((NT_PRINTER_INFO_LEVEL **pp_printer, uint32 level, fstring sharename));
uint32 free_a_printer __P((NT_PRINTER_INFO_LEVEL **pp_printer, uint32 level));
uint32 add_a_printer_driver __P((NT_PRINTER_DRIVER_INFO_LEVEL driver, uint32 level));
WERROR get_a_printer_driver __P((NT_PRINTER_DRIVER_INFO_LEVEL *driver, uint32 level,
                            fstring drivername, const fstring architecture, uint32 version));
uint32 free_a_printer_driver __P((NT_PRINTER_DRIVER_INFO_LEVEL driver, uint32 level));
BOOL printer_driver_in_use  __P(( NT_PRINTER_DRIVER_INFO_LEVEL_3 *info_3 ));
WERROR delete_printer_driver __P(( NT_PRINTER_DRIVER_INFO_LEVEL_3 *info_3, struct current_user *user,
                              uint32 version, BOOL delete_files ));
BOOL get_specific_param_by_index __P((NT_PRINTER_INFO_LEVEL printer, uint32 level, uint32 param_index,
                                 fstring value, uint8 **data, uint32 *type, uint32 *len));
BOOL get_specific_param __P((NT_PRINTER_INFO_LEVEL printer, uint32 level,
                        fstring value, uint8 **data, uint32 *type, uint32 *len));
WERROR nt_printing_setsec __P((char *printername, SEC_DESC_BUF *secdesc_ctr));
BOOL nt_printing_getsec __P((TALLOC_CTX *ctx, char *printername, SEC_DESC_BUF **secdesc_ctr));
void map_printer_permissions __P((SEC_DESC *sd));
BOOL print_access_check __P((struct current_user *user, int snum, int access_type));
BOOL print_time_access_check __P((int snum));
WERROR printer_write_default_dev __P((int snum, const PRINTER_DEFAULT *printer_default));

/* The following definitions come from printing/pcap.c  */

BOOL pcap_printername_ok __P((char *pszPrintername, const char *pszPrintcapname));
void pcap_printer_fn __P((void (*fn)(char *, char *)));

/* The following definitions come from printing/print_cups.c  */

void cups_printer_fn __P((void (*fn)(char *, char *)));
int cups_printername_ok __P((const char *name));

/* The following definitions come from printing/print_generic.c  */


/* The following definitions come from printing/print_svid.c  */

void sysv_printer_fn __P((void (*fn)__P((char *, char *))));
int sysv_printername_ok __P((char *name));

/* The following definitions come from printing/printfsp.c  */

files_struct *print_fsp_open __P((connection_struct *conn, char *fname));
void print_fsp_end __P((files_struct *fsp, BOOL normal_close));

/* The following definitions come from printing/printing.c  */

BOOL print_backend_init __P((void));
BOOL print_job_exists __P((int jobid));
int print_job_snum __P((int jobid));
int print_job_fd __P((int jobid));
char *print_job_fname __P((int jobid));
BOOL print_job_set_place __P((int jobid, int place));
BOOL print_job_set_name __P((int jobid, char *name));
BOOL print_job_delete __P((struct current_user *user, int jobid, WERROR *errcode));
BOOL print_job_pause __P((struct current_user *user, int jobid, WERROR *errcode));
BOOL print_job_resume __P((struct current_user *user, int jobid, WERROR *errcode));
int print_job_write __P((int jobid, const char *buf, int size));
int print_queue_length __P((int snum, print_status_struct *pstatus));
int print_job_start __P((struct current_user *user, int snum, char *jobname));
void print_job_endpage __P((int jobid));
BOOL print_job_end __P((int jobid, BOOL normal_close));
int print_queue_status __P((int snum, 
		       print_queue_struct **queue,
		       print_status_struct *status));
int print_queue_snum __P((char *qname));
BOOL print_queue_pause __P((struct current_user *user, int snum, WERROR *errcode));
BOOL print_queue_resume __P((struct current_user *user, int snum, WERROR *errcode));
BOOL print_queue_purge __P((struct current_user *user, int snum, WERROR *errcode));

/* The following definitions come from profile/profile.c  */

void profile_message __P((int msg_type, pid_t src, void *buf, size_t len));
void reqprofile_message __P((int msg_type, pid_t src, void *buf, size_t len));
BOOL profile_setup __P((BOOL rdonly));

/* The following definitions come from rpc_client/cli_login.c  */

NTSTATUS cli_nt_setup_creds __P((struct cli_state *cli, unsigned char mach_pwd[16]));
BOOL cli_nt_srv_pwset __P((struct cli_state *cli, unsigned char *new_hashof_mach_pwd));
NTSTATUS cli_nt_login_interactive __P((struct cli_state *cli, char *unix_domain, char *unix_username, 
				uint32 smb_userid_low, char *unix_password,
				NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3));
NTSTATUS cli_nt_login_network __P((struct cli_state *cli, char *unix_domain, char *unix_username, 
				uint32 smb_userid_low, const char lm_chal[8], 
				const char *lm_chal_resp, const char *nt_chal_resp,
				NET_ID_INFO_CTR *ctr, NET_USER_INFO_3 *user_info3));
BOOL cli_nt_logoff __P((struct cli_state *cli, NET_ID_INFO_CTR *ctr));

/* The following definitions come from rpc_client/cli_netlogon.c  */

BOOL cli_net_logon_ctrl2 __P((struct cli_state *cli, NTSTATUS status_level));
NTSTATUS cli_net_auth2 __P((struct cli_state *cli, uint16 sec_chan, 
                   uint32 neg_flags, DOM_CHAL *srv_chal));
BOOL cli_net_req_chal __P((struct cli_state *cli, DOM_CHAL *clnt_chal, DOM_CHAL *srv_chal));
BOOL cli_net_srv_pwset __P((struct cli_state *cli, uint8 hashed_mach_pwd[16]));
NTSTATUS cli_net_sam_logon __P((struct cli_state *cli, NET_ID_INFO_CTR *ctr, 
                         NET_USER_INFO_3 *user_info3));
BOOL cli_net_sam_logoff __P((struct cli_state *cli, NET_ID_INFO_CTR *ctr));

/* The following definitions come from rpc_client/cli_pipe.c  */

BOOL rpc_api_pipe_req __P((struct cli_state *cli, uint8 op_num,
                      prs_struct *data, prs_struct *rdata));
BOOL rpc_pipe_bind __P((struct cli_state *cli, const char *pipe_name, char *my_name));
void cli_nt_set_ntlmssp_flgs __P((struct cli_state *cli, uint32 ntlmssp_flgs));
BOOL cli_nt_session_open __P((struct cli_state *cli, const char *pipe_name));
void cli_nt_session_close __P((struct cli_state *cli));

/* The following definitions come from rpc_client/cli_spoolss_notify.c  */

BOOL spoolss_disconnect_from_client __P(( struct cli_state *cli));
BOOL spoolss_connect_to_client __P(( struct cli_state *cli, char *remote_machine));
WERROR cli_spoolss_reply_open_printer __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
				char *printer, uint32 localprinter, uint32 type, 
				POLICY_HND *handle));
WERROR cli_spoolss_reply_close_printer __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
					POLICY_HND *handle));
WERROR cli_spoolss_routerreplyprinter  __P((struct cli_state *cli, TALLOC_CTX *mem_ctx,
					POLICY_HND *pol, uint32 condition, uint32 changd_id));
WERROR cli_spoolss_reply_rrpcn __P((struct cli_state *cli, TALLOC_CTX *mem_ctx, 
					POLICY_HND *handle, PRINTER_MESSAGE_INFO *info,
					NT_PRINTER_INFO_LEVEL *printer));

/* The following definitions come from rpc_client/cli_trust.c  */

BOOL change_trust_account_password __P(( char *domain, const char *remote_machine_list));

/* The following definitions come from rpc_parse/parse_dfs.c  */

void init_dfs_q_dfs_exist __P((DFS_Q_DFS_EXIST *q_d));
BOOL dfs_io_q_dfs_exist __P((const char *desc, DFS_Q_DFS_EXIST *q_d, prs_struct *ps, int depth));
BOOL dfs_io_r_dfs_exist __P((const char *desc, DFS_R_DFS_EXIST *q_d, prs_struct *ps, int depth));
BOOL init_dfs_q_dfs_remove __P((DFS_Q_DFS_REMOVE *q_d, const char *entrypath, 
			   const char *servername, const char *sharename));
BOOL dfs_io_q_dfs_remove __P((const char *desc, DFS_Q_DFS_REMOVE *q_d, prs_struct *ps, int depth));
BOOL dfs_io_r_dfs_remove __P((const char *desc, DFS_R_DFS_REMOVE *r_d, prs_struct *ps, int depth));
BOOL init_dfs_q_dfs_add __P((DFS_Q_DFS_ADD *q_d, const char *entrypath, const char *servername,
			const char *sharename, const char *comment, uint32 flags));
BOOL dfs_io_q_dfs_add __P((const char *desc, DFS_Q_DFS_ADD *q_d, prs_struct *ps, int depth));
BOOL dfs_io_r_dfs_add __P((const char *desc, DFS_R_DFS_ADD *r_d, prs_struct *ps, int depth));
BOOL init_dfs_q_dfs_get_info __P((DFS_Q_DFS_GET_INFO *q_d, const char *entrypath,
			     const char *servername, const char *sharename, 
			     uint32 info_level));
BOOL dfs_io_q_dfs_get_info __P((const char* desc, DFS_Q_DFS_GET_INFO* q_i, prs_struct* ps, int depth));
BOOL dfs_io_r_dfs_get_info __P((const char* desc, DFS_R_DFS_GET_INFO* r_i, prs_struct* ps, int depth));
BOOL init_dfs_q_dfs_enum __P((DFS_Q_DFS_ENUM *q_d, uint32 level, DFS_INFO_CTR *ctr));
BOOL dfs_io_q_dfs_enum __P((const char *desc, DFS_Q_DFS_ENUM *q_d, prs_struct *ps, int depth));
BOOL dfs_io_dfs_info_ctr __P((const char *desc, DFS_INFO_CTR* ctr, uint32 num_entries, uint32 level, prs_struct* ps, int depth));
BOOL dfs_io_r_dfs_enum __P((const char *desc, DFS_R_DFS_ENUM *q_d, prs_struct *ps, int depth));
BOOL dfs_io_dfs_storage_info __P((const char *desc, DFS_INFO_3* info3, prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_lsa.c  */

void init_lsa_trans_name __P((LSA_TRANS_NAME *trn, UNISTR2 *uni_name,
			 uint16 sid_name_use, const char *name, uint32 idx));
void init_lsa_sec_qos __P((LSA_SEC_QOS *qos, uint16 imp_lev, uint8 ctxt, uint8 eff));
void init_lsa_obj_attr __P((LSA_OBJ_ATTR *attr, uint32 attributes, LSA_SEC_QOS *qos));
void init_q_open_pol __P((LSA_Q_OPEN_POL *r_q, uint16 system_name,
		     uint32 attributes, uint32 desired_access,
		     LSA_SEC_QOS *qos));
BOOL lsa_io_q_open_pol __P((const char *desc, LSA_Q_OPEN_POL *r_q, prs_struct *ps, 
		       int depth));
BOOL lsa_io_r_open_pol __P((const char *desc, LSA_R_OPEN_POL *r_p, prs_struct *ps, 
		       int depth));
void init_q_open_pol2 __P((LSA_Q_OPEN_POL2 *r_q, const char *server_name,
			uint32 attributes, uint32 desired_access,
			LSA_SEC_QOS *qos));
BOOL lsa_io_q_open_pol2 __P((const char *desc, LSA_Q_OPEN_POL2 *r_q, prs_struct *ps, 
			int depth));
BOOL lsa_io_r_open_pol2 __P((const char *desc, LSA_R_OPEN_POL2 *r_p, prs_struct *ps, 
			int depth));
void init_q_query_sec_obj __P((LSA_Q_QUERY_SEC_OBJ *q_q, const POLICY_HND *hnd, 
			  uint32 sec_info));
BOOL lsa_io_q_query_sec_obj __P((const char *desc, LSA_Q_QUERY_SEC_OBJ *q_q, 
			    prs_struct *ps, int depth));
BOOL lsa_io_r_query_sec_obj __P((const char *desc, LSA_R_QUERY_SEC_OBJ *r_u, 
			    prs_struct *ps, int depth));
void init_q_query __P((LSA_Q_QUERY_INFO *q_q, POLICY_HND *hnd, uint16 info_class));
BOOL lsa_io_q_query __P((const char *desc, LSA_Q_QUERY_INFO *q_q, prs_struct *ps, 
		    int depth));
BOOL init_q_enum_trust_dom __P((LSA_Q_ENUM_TRUST_DOM * q_e, POLICY_HND *pol,
			   uint32 enum_context, uint32 preferred_len));
BOOL lsa_io_q_enum_trust_dom __P((const char *desc, LSA_Q_ENUM_TRUST_DOM *q_e, 
			     prs_struct *ps, int depth));
void init_r_enum_trust_dom __P((TALLOC_CTX *ctx, LSA_R_ENUM_TRUST_DOM *r_e, uint32 enum_context, 
			   const char *domain_name, DOM_SID *domain_sid,
                           NTSTATUS status));
BOOL lsa_io_r_enum_trust_dom __P((const char *desc, LSA_R_ENUM_TRUST_DOM *r_e, 
			     prs_struct *ps, int depth));
BOOL lsa_io_dom_query_5 __P((const char *desc, DOM_QUERY_5 *d_q, prs_struct *ps, int depth));
BOOL lsa_io_r_query __P((const char *desc, LSA_R_QUERY_INFO *r_q, prs_struct *ps,
		    int depth));
void init_lsa_sid_enum __P((TALLOC_CTX *mem_ctx, LSA_SID_ENUM *sen, 
		       int num_entries, DOM_SID *sids));
void init_q_lookup_sids __P((TALLOC_CTX *mem_ctx, LSA_Q_LOOKUP_SIDS *q_l, 
			POLICY_HND *hnd, int num_sids, DOM_SID *sids,
			uint16 level));
BOOL lsa_io_q_lookup_sids __P((const char *desc, LSA_Q_LOOKUP_SIDS *q_s, prs_struct *ps,
			  int depth));
BOOL lsa_io_r_lookup_sids __P((const char *desc, LSA_R_LOOKUP_SIDS *r_s, 
			  prs_struct *ps, int depth));
void init_q_lookup_names __P((TALLOC_CTX *mem_ctx, LSA_Q_LOOKUP_NAMES *q_l, 
			 POLICY_HND *hnd, int num_names, const char **names));
BOOL lsa_io_q_lookup_names __P((const char *desc, LSA_Q_LOOKUP_NAMES *q_r, 
			   prs_struct *ps, int depth));
BOOL lsa_io_r_lookup_names __P((const char *desc, LSA_R_LOOKUP_NAMES *r_r, 
			   prs_struct *ps, int depth));
void init_lsa_q_close __P((LSA_Q_CLOSE *q_c, POLICY_HND *hnd));
BOOL lsa_io_q_close __P((const char *desc, LSA_Q_CLOSE *q_c, prs_struct *ps, int depth));
BOOL lsa_io_r_close __P((const char *desc,  LSA_R_CLOSE *r_c, prs_struct *ps, int depth));
BOOL lsa_io_q_open_secret __P((const char *desc, LSA_Q_OPEN_SECRET *q_c, prs_struct *ps, int depth));
BOOL lsa_io_r_open_secret __P((const char *desc, LSA_R_OPEN_SECRET *r_c, prs_struct *ps, int depth));
void init_q_enum_privs __P((LSA_Q_ENUM_PRIVS *q_q, POLICY_HND *hnd, uint32 enum_context, uint32 pref_max_length));
BOOL lsa_io_q_enum_privs __P((const char *desc, LSA_Q_ENUM_PRIVS *q_q, prs_struct *ps, int depth));
void init_lsa_r_enum_privs __P((LSA_R_ENUM_PRIVS *r_u, uint32 enum_context,
			  uint32 count, LSA_PRIV_ENTRY *entries));
BOOL lsa_io_r_enum_privs __P((const char *desc, LSA_R_ENUM_PRIVS *r_q, prs_struct *ps, int depth));
void init_lsa_priv_get_dispname __P((LSA_Q_PRIV_GET_DISPNAME *trn, POLICY_HND *hnd, const char *name, uint16 lang_id, uint16 lang_id_sys));
BOOL lsa_io_q_priv_get_dispname __P((const char *desc, LSA_Q_PRIV_GET_DISPNAME *q_q, prs_struct *ps, int depth));
BOOL lsa_io_r_priv_get_dispname __P((const char *desc, LSA_R_PRIV_GET_DISPNAME *r_q, prs_struct *ps, int depth));
void init_lsa_q_enum_accounts __P((LSA_Q_ENUM_ACCOUNTS *trn, POLICY_HND *hnd, uint32 enum_context, uint32 pref_max_length));
BOOL lsa_io_q_enum_accounts __P((const char *desc, LSA_Q_ENUM_ACCOUNTS *q_q, prs_struct *ps, int depth));
void init_lsa_r_enum_accounts __P((LSA_R_ENUM_ACCOUNTS *r_u, uint32 enum_context));
BOOL lsa_io_r_enum_accounts __P((const char *desc, LSA_R_ENUM_ACCOUNTS *r_q, prs_struct *ps, int depth));
BOOL lsa_io_q_unk_get_connuser __P((const char *desc, LSA_Q_UNK_GET_CONNUSER *q_c, prs_struct *ps, int depth));
BOOL lsa_io_r_unk_get_connuser __P((const char *desc, LSA_R_UNK_GET_CONNUSER *r_c, prs_struct *ps, int depth));
void init_lsa_q_open_account __P((LSA_Q_OPENACCOUNT *trn, POLICY_HND *hnd, DOM_SID *sid, uint32 desired_access));
BOOL lsa_io_q_open_account __P((const char *desc, LSA_Q_OPENACCOUNT *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_open_account __P((const char *desc, LSA_R_OPENACCOUNT  *r_c, prs_struct *ps, int depth));
void init_lsa_q_enum_privsaccount __P((LSA_Q_ENUMPRIVSACCOUNT *trn, POLICY_HND *hnd));
BOOL lsa_io_q_enum_privsaccount __P((const char *desc, LSA_Q_ENUMPRIVSACCOUNT *r_c, prs_struct *ps, int depth));
BOOL lsa_io_luid __P((const char *desc, LUID *r_c, prs_struct *ps, int depth));
BOOL lsa_io_luid_attr __P((const char *desc, LUID_ATTR *r_c, prs_struct *ps, int depth));
BOOL lsa_io_privilege_set __P((const char *desc, PRIVILEGE_SET *r_c, prs_struct *ps, int depth));
void init_lsa_r_enum_privsaccount __P((LSA_R_ENUMPRIVSACCOUNT *r_u, LUID_ATTR *set, uint32 count, uint32 control));
BOOL lsa_io_r_enum_privsaccount __P((const char *desc, LSA_R_ENUMPRIVSACCOUNT *r_c, prs_struct *ps, int depth));
BOOL lsa_io_q_getsystemaccount __P((const char *desc, LSA_Q_GETSYSTEMACCOUNT  *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_getsystemaccount __P((const char *desc, LSA_R_GETSYSTEMACCOUNT  *r_c, prs_struct *ps, int depth));
BOOL lsa_io_q_setsystemaccount __P((const char *desc, LSA_Q_SETSYSTEMACCOUNT  *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_setsystemaccount __P((const char *desc, LSA_R_SETSYSTEMACCOUNT  *r_c, prs_struct *ps, int depth));
void init_lsa_q_lookupprivvalue __P((LSA_Q_LOOKUPPRIVVALUE *trn, POLICY_HND *hnd, const char *name));
BOOL lsa_io_q_lookupprivvalue __P((const char *desc, LSA_Q_LOOKUPPRIVVALUE  *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_lookupprivvalue __P((const char *desc, LSA_R_LOOKUPPRIVVALUE  *r_c, prs_struct *ps, int depth));
BOOL lsa_io_q_addprivs __P((const char *desc, LSA_Q_ADDPRIVS *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_addprivs __P((const char *desc, LSA_R_ADDPRIVS *r_c, prs_struct *ps, int depth));
BOOL lsa_io_q_removeprivs __P((const char *desc, LSA_Q_REMOVEPRIVS *r_c, prs_struct *ps, int depth));
BOOL lsa_io_r_removeprivs __P((const char *desc, LSA_R_REMOVEPRIVS *r_c, prs_struct *ps, int depth));
BOOL policy_handle_is_valid __P((const POLICY_HND *hnd));

/* The following definitions come from rpc_parse/parse_misc.c  */

TALLOC_CTX *get_current_rpc_talloc __P((void));
void set_current_rpc_talloc __P(( TALLOC_CTX *ctx));
void main_loop_talloc_free __P((void));
TALLOC_CTX *main_loop_talloc_get __P((void));
TALLOC_CTX *get_talloc_ctx __P((void));
BOOL smb_io_time __P((const char *desc, NTTIME *nttime, prs_struct *ps, int depth));
BOOL smb_io_lookup_level __P((const char *desc, LOOKUP_LEVEL *level, prs_struct *ps, int depth));
uint32 get_enum_hnd __P((ENUM_HND *enh));
void init_enum_hnd __P((ENUM_HND *enh, uint32 hnd));
BOOL smb_io_enum_hnd __P((const char *desc, ENUM_HND *hnd, prs_struct *ps, int depth));
BOOL smb_io_dom_sid __P((const char *desc, DOM_SID *sid, prs_struct *ps, int depth));
void init_dom_sid __P((DOM_SID *sid, const char *str_sid));
void init_dom_sid2 __P((DOM_SID2 *sid2, const DOM_SID *sid));
BOOL smb_io_dom_sid2 __P((const char *desc, DOM_SID2 *sid, prs_struct *ps, int depth));
void init_str_hdr __P((STRHDR *hdr, int max_len, int len, uint32 buffer));
BOOL smb_io_strhdr __P((const char *desc,  STRHDR *hdr, prs_struct *ps, int depth));
void init_uni_hdr __P((UNIHDR *hdr, int len));
BOOL smb_io_unihdr __P((const char *desc, UNIHDR *hdr, prs_struct *ps, int depth));
void init_buf_hdr __P((BUFHDR *hdr, int max_len, int len));
BOOL smb_io_hdrbuf_pre __P((const char *desc, BUFHDR *hdr, prs_struct *ps, int depth, uint32 *offset));
BOOL smb_io_hdrbuf_post __P((const char *desc, BUFHDR *hdr, prs_struct *ps, int depth, 
				uint32 ptr_hdrbuf, uint32 max_len, uint32 len));
BOOL smb_io_hdrbuf __P((const char *desc, BUFHDR *hdr, prs_struct *ps, int depth));
void init_uni_hdr2 __P((UNIHDR2 *hdr, int len));
BOOL smb_io_unihdr2 __P((const char *desc, UNIHDR2 *hdr2, prs_struct *ps, int depth));
void init_unistr __P((UNISTR *str, const char *buf));
BOOL smb_io_unistr __P((const char *desc, UNISTR *uni, prs_struct *ps, int depth));
void init_buffer3_uint32 __P((BUFFER3 *str, uint32 val));
void init_buffer3_str __P((BUFFER3 *str, char *buf, int len));
void init_buffer3_hex __P((BUFFER3 *str, char *buf));
void init_buffer3_bytes __P((BUFFER3 *str, uint8 *buf, int len));
BOOL smb_io_buffer3 __P((const char *desc, BUFFER3 *buf3, prs_struct *ps, int depth));
BOOL smb_io_buffer5 __P((const char *desc, BUFFER5 *buf5, prs_struct *ps, int depth));
void init_buffer2 __P((BUFFER2 *str, uint8 *buf, int len));
BOOL smb_io_buffer2 __P((const char *desc, BUFFER2 *buf2, uint32 buffer, prs_struct *ps, int depth));
void init_buf_unistr2 __P((UNISTR2 *str, uint32 *ptr, const char *buf));
void copy_unistr2 __P((UNISTR2 *str, const UNISTR2 *from));
void init_string2 __P((STRING2 *str, const char *buf, int max_len, int str_len));
BOOL smb_io_string2 __P((const char *desc, STRING2 *str2, uint32 buffer, prs_struct *ps, int depth));
void init_unistr2 __P((UNISTR2 *str, const char *buf, size_t len));
void init_unistr2_from_unistr  __P((UNISTR2 *to, UNISTR *from));
BOOL smb_io_unistr2 __P((const char *desc, UNISTR2 *uni2, uint32 buffer, prs_struct *ps, int depth));
void init_dom_rid2 __P((DOM_RID2 *rid2, uint32 rid, uint8 type, uint32 idx));
BOOL smb_io_dom_rid2 __P((const char *desc, DOM_RID2 *rid2, prs_struct *ps, int depth));
void init_dom_rid3 __P((DOM_RID3 *rid3, uint32 rid, uint8 type));
BOOL smb_io_dom_rid3 __P((const char *desc, DOM_RID3 *rid3, prs_struct *ps, int depth));
void init_dom_rid4 __P((DOM_RID4 *rid4, uint16 unknown, uint16 attr, uint32 rid));
void init_log_info __P((DOM_LOG_INFO *log, const char *logon_srv, const char *acct_name,
		uint16 sec_chan, const char *comp_name));
BOOL smb_io_log_info __P((const char *desc, DOM_LOG_INFO *log, prs_struct *ps, int depth));
BOOL smb_io_chal __P((const char *desc, DOM_CHAL *chal, prs_struct *ps, int depth));
BOOL smb_io_cred __P((const char *desc,  DOM_CRED *cred, prs_struct *ps, int depth));
void init_clnt_info2 __P((DOM_CLNT_INFO2 *clnt,
				const char *logon_srv, const char *comp_name,
				DOM_CRED *clnt_cred));
BOOL smb_io_clnt_info2 __P((const char *desc, DOM_CLNT_INFO2 *clnt, prs_struct *ps, int depth));
void init_clnt_info __P((DOM_CLNT_INFO *clnt,
		const char *logon_srv, const char *acct_name,
		uint16 sec_chan, const char *comp_name,
				DOM_CRED *cred));
BOOL smb_io_clnt_info __P((const char *desc,  DOM_CLNT_INFO *clnt, prs_struct *ps, int depth));
void init_logon_id __P((DOM_LOGON_ID *log, uint32 log_id_low, uint32 log_id_high));
BOOL smb_io_logon_id __P((const char *desc, DOM_LOGON_ID *log, prs_struct *ps, int depth));
void init_owf_info __P((OWF_INFO *hash, uint8 data[16]));
BOOL smb_io_owf_info __P((const char *desc, OWF_INFO *hash, prs_struct *ps, int depth));
BOOL smb_io_gid __P((const char *desc,  DOM_GID *gid, prs_struct *ps, int depth));
BOOL smb_io_pol_hnd __P((const char *desc, POLICY_HND *pol, prs_struct *ps, int depth));
void init_unistr3 __P((UNISTR3 *str, const char *buf));
BOOL smb_io_unistr3 __P((const char *desc, UNISTR3 *name, prs_struct *ps, int depth));
BOOL prs_uint64 __P((const char *name, prs_struct *ps, int depth, UINT64_S *data64));
BOOL smb_io_bufhdr2 __P((const char *desc, BUFHDR2 *hdr, prs_struct *ps, int depth));
BOOL smb_io_buffer4 __P((const char *desc, BUFFER4 *buf4, uint32 buffer, prs_struct *ps, int depth));
BOOL make_uni_hdr __P((UNIHDR *hdr, int len));
BOOL make_bufhdr2 __P((BUFHDR2 *hdr, uint32 info_level, uint32 length, uint32 buffer));

/* The following definitions come from rpc_parse/parse_net.c  */

BOOL net_io_q_logon_ctrl2 __P((const char *desc, NET_Q_LOGON_CTRL2 *q_l, prs_struct *ps, int depth));
void init_net_q_logon_ctrl2 __P((NET_Q_LOGON_CTRL2 *q_l, const char *srv_name,
			    uint32 query_level));
void init_net_r_logon_ctrl2 __P((NET_R_LOGON_CTRL2 *r_l, uint32 query_level,
			    uint32 flags, uint32 pdc_status, 
			    uint32 logon_attempts, uint32 tc_status, 
			    const char *trusted_domain_name));
BOOL net_io_r_logon_ctrl2 __P((const char *desc, NET_R_LOGON_CTRL2 *r_l, prs_struct *ps, int depth));
BOOL net_io_q_logon_ctrl __P((const char *desc, NET_Q_LOGON_CTRL *q_l, prs_struct *ps, 
			 int depth));
void init_net_q_logon_ctrl __P((NET_Q_LOGON_CTRL *q_l, const char *srv_name,
			   uint32 query_level));
void init_net_r_logon_ctrl __P((NET_R_LOGON_CTRL *r_l, uint32 query_level,
			   uint32 flags, uint32 pdc_status));
BOOL net_io_r_logon_ctrl __P((const char *desc, NET_R_LOGON_CTRL *r_l, prs_struct *ps, 
			 int depth));
void init_r_trust_dom __P((NET_R_TRUST_DOM_LIST *r_t,
			uint32 num_doms, const char *dom_name));
BOOL net_io_r_trust_dom __P((const char *desc, NET_R_TRUST_DOM_LIST *r_t, prs_struct *ps, int depth));
BOOL net_io_q_trust_dom __P((const char *desc, NET_Q_TRUST_DOM_LIST *q_l, prs_struct *ps, int depth));
void init_q_req_chal __P((NET_Q_REQ_CHAL *q_c,
				const char *logon_srv, const char *logon_clnt,
				DOM_CHAL *clnt_chal));
BOOL net_io_q_req_chal __P((const char *desc,  NET_Q_REQ_CHAL *q_c, prs_struct *ps, int depth));
BOOL net_io_r_req_chal __P((const char *desc, NET_R_REQ_CHAL *r_c, prs_struct *ps, int depth));
BOOL net_io_q_auth __P((const char *desc, NET_Q_AUTH *q_a, prs_struct *ps, int depth));
BOOL net_io_r_auth __P((const char *desc, NET_R_AUTH *r_a, prs_struct *ps, int depth));
void init_q_auth_2 __P((NET_Q_AUTH_2 *q_a,
		const char *logon_srv, const char *acct_name, uint16 sec_chan, const char *comp_name,
		DOM_CHAL *clnt_chal, uint32 clnt_flgs));
BOOL net_io_q_auth_2 __P((const char *desc, NET_Q_AUTH_2 *q_a, prs_struct *ps, int depth));
BOOL net_io_r_auth_2 __P((const char *desc, NET_R_AUTH_2 *r_a, prs_struct *ps, int depth));
void init_q_srv_pwset __P((NET_Q_SRV_PWSET *q_s, const char *logon_srv, const char *acct_name, 
                uint16 sec_chan, const char *comp_name, DOM_CRED *cred, char nt_cypher[16]));
BOOL net_io_q_srv_pwset __P((const char *desc, NET_Q_SRV_PWSET *q_s, prs_struct *ps, int depth));
BOOL net_io_r_srv_pwset __P((const char *desc, NET_R_SRV_PWSET *r_s, prs_struct *ps, int depth));
void init_id_info1 __P((NET_ID_INFO_1 *id, const char *domain_name,
				uint32 param_ctrl, uint32 log_id_low, uint32 log_id_high,
				const char *user_name, const char *wksta_name,
				const unsigned char *sess_key,
				unsigned char lm_cypher[16], unsigned char nt_cypher[16]));
void init_id_info2 __P((NET_ID_INFO_2 * id, const char *domain_name,
		   uint32 param_ctrl,
		   uint32 log_id_low, uint32 log_id_high,
		   const char *user_name, const char *wksta_name,
		   const uchar lm_challenge[8],
		   const uchar * lm_chal_resp, int lm_chal_resp_len,
		   const uchar * nt_chal_resp, int nt_chal_resp_len));
void init_sam_info __P((DOM_SAM_INFO *sam,
				const char *logon_srv, const char *comp_name, DOM_CRED *clnt_cred,
				DOM_CRED *rtn_cred, uint16 logon_level,
				NET_ID_INFO_CTR *ctr));
void init_net_user_info3 __P((TALLOC_CTX *ctx, NET_USER_INFO_3 *usr, SAM_ACCOUNT *sampw,
			 uint16 logon_count, uint16 bad_pw_count,
 		 	 uint32 num_groups, DOM_GID *gids,
			 uint32 user_flgs, uchar *sess_key,
 			 const char *logon_srv, const char *logon_dom,
			 DOM_SID *dom_sid, const char *other_sids));
BOOL net_io_q_sam_logon __P((const char *desc, NET_Q_SAM_LOGON *q_l, prs_struct *ps, int depth));
BOOL net_io_r_sam_logon __P((const char *desc, NET_R_SAM_LOGON *r_l, prs_struct *ps, int depth));
BOOL net_io_q_sam_logoff __P((const char *desc,  NET_Q_SAM_LOGOFF *q_l, prs_struct *ps, int depth));
BOOL net_io_r_sam_logoff __P((const char *desc, NET_R_SAM_LOGOFF *r_l, prs_struct *ps, int depth));
BOOL init_net_q_sam_sync __P((NET_Q_SAM_SYNC * q_s, const char *srv_name,
                         const char *cli_name, DOM_CRED * cli_creds, 
                         DOM_CRED *ret_creds, uint32 database_id));
BOOL net_io_q_sam_sync __P((const char *desc, NET_Q_SAM_SYNC * q_s, prs_struct *ps,
		       int depth));
BOOL make_sam_account_info __P((SAM_ACCOUNT_INFO * info,
			   const UNISTR2 *user_name,
			   const UNISTR2 *full_name,
			   uint32 user_rid, uint32 group_rid,
			   const UNISTR2 *home_dir,
			   const UNISTR2 *dir_drive,
			   const UNISTR2 *log_scr,
			   const UNISTR2 *desc,
			   uint32 acb_info,
			   const UNISTR2 *prof_path,
			   const UNISTR2 *wkstas,
			   const UNISTR2 *unk_str, const UNISTR2 *mung_dial));
BOOL net_io_r_sam_sync __P((const char *desc, uint8 sess_key[16],
		       NET_R_SAM_SYNC * r_s, prs_struct *ps, int depth));
BOOL init_net_q_sam_deltas __P((NET_Q_SAM_DELTAS *q_s, const char *srv_name, 
                           const char *cli_name, DOM_CRED *cli_creds, 
                           uint32 database_id, UINT64_S dom_mod_count));
BOOL net_io_q_sam_deltas __P((const char *desc, NET_Q_SAM_DELTAS *q_s, prs_struct *ps,
                         int depth));
BOOL net_io_r_sam_deltas __P((const char *desc, uint8 sess_key[16],
                         NET_R_SAM_DELTAS *r_s, prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_prs.c  */

void prs_dump __P((const char *name, int v, prs_struct *ps));
void prs_debug __P((prs_struct *ps, int depth, const char *desc, const char *fn_name));
BOOL prs_init __P((prs_struct *ps, uint32 size, TALLOC_CTX *ctx, BOOL io));
BOOL prs_read __P((prs_struct *ps, int fd, size_t len, int timeout));
void prs_mem_free __P((prs_struct *ps));
void prs_mem_clear __P((prs_struct *ps));
char *prs_alloc_mem __P((prs_struct *ps, size_t size));
TALLOC_CTX *prs_get_mem_context __P((prs_struct *ps));
void prs_give_memory __P((prs_struct *ps, char *buf, uint32 size, BOOL is_dynamic));
char *prs_take_memory __P((prs_struct *ps, uint32 *psize));
BOOL prs_set_buffer_size __P((prs_struct *ps, uint32 newsize));
BOOL prs_grow __P((prs_struct *ps, uint32 extra_space));
BOOL prs_force_grow __P((prs_struct *ps, uint32 extra_space));
char *prs_data_p __P((prs_struct *ps));
uint32 prs_data_size __P((prs_struct *ps));
uint32 prs_offset __P((prs_struct *ps));
BOOL prs_set_offset __P((prs_struct *ps, uint32 offset));
BOOL prs_append_prs_data __P((prs_struct *dst, prs_struct *src));
BOOL prs_append_some_prs_data __P((prs_struct *dst, prs_struct *src, int32 start, uint32 len));
BOOL prs_append_data __P((prs_struct *dst, char *src, uint32 len));
void prs_set_endian_data __P((prs_struct *ps, BOOL endian));
BOOL prs_align __P((prs_struct *ps));
BOOL prs_align_uint16 __P((prs_struct *ps));
BOOL prs_align_uint64 __P((prs_struct *ps));
BOOL prs_align_needed __P((prs_struct *ps, uint32 needed));
char *prs_mem_get __P((prs_struct *ps, uint32 extra_size));
void prs_switch_type __P((prs_struct *ps, BOOL io));
void prs_force_dynamic __P((prs_struct *ps));
BOOL prs_uint8 __P((const char *name, prs_struct *ps, int depth, uint8 *data8));
BOOL prs_uint16 __P((const char *name, prs_struct *ps, int depth, uint16 *data16));
BOOL prs_uint32 __P((const char *name, prs_struct *ps, int depth, uint32 *data32));
BOOL prs_ntstatus __P((const char *name, prs_struct *ps, int depth, NTSTATUS *status));
BOOL prs_werror __P((const char *name, prs_struct *ps, int depth, WERROR *status));
BOOL prs_uint8s __P((BOOL charmode, const char *name, prs_struct *ps, int depth, uint8 *data8s, int len));
BOOL prs_uint16s __P((BOOL charmode, const char *name, prs_struct *ps, int depth, uint16 *data16s, int len));
BOOL prs_uint16uni __P((BOOL charmode, const char *name, prs_struct *ps, int depth, uint16 *data16s, int len));
BOOL prs_uint32s __P((BOOL charmode, const char *name, prs_struct *ps, int depth, uint32 *data32s, int len));
BOOL prs_buffer5 __P((BOOL charmode, const char *name, prs_struct *ps, int depth, BUFFER5 *str));
BOOL prs_buffer2 __P((BOOL charmode, const char *name, prs_struct *ps, int depth, BUFFER2 *str));
BOOL prs_string2 __P((BOOL charmode, const char *name, prs_struct *ps, int depth, STRING2 *str));
BOOL prs_unistr2 __P((BOOL charmode, const char *name, prs_struct *ps, int depth, UNISTR2 *str));
BOOL prs_unistr3 __P((BOOL charmode, const char *name, UNISTR3 *str, prs_struct *ps, int depth));
BOOL prs_unistr __P((const char *name, prs_struct *ps, int depth, UNISTR *str));
BOOL prs_string __P((const char *name, prs_struct *ps, int depth, char *str, int len, int max_buf_size));
BOOL prs_uint16_pre __P((const char *name, prs_struct *ps, int depth, uint16 *data16, uint32 *offset));
BOOL prs_uint16_post __P((const char *name, prs_struct *ps, int depth, uint16 *data16,
				uint32 ptr_uint16, uint32 start_offset));
BOOL prs_uint32_pre __P((const char *name, prs_struct *ps, int depth, uint32 *data32, uint32 *offset));
BOOL prs_uint32_post __P((const char *name, prs_struct *ps, int depth, uint32 *data32,
				uint32 ptr_uint32, uint32 data_size));
int tdb_prs_store __P((TDB_CONTEXT *tdb, char *keystr, prs_struct *ps));
int tdb_prs_fetch __P((TDB_CONTEXT *tdb, char *keystr, prs_struct *ps, TALLOC_CTX *mem_ctx));
BOOL prs_hash1 __P((prs_struct *ps, uint32 offset, uint8 *sess_key));

/* The following definitions come from rpc_parse/parse_reg.c  */

void init_reg_q_open_hkcr __P((REG_Q_OPEN_HKCR *q_o,
				uint16 unknown_0, uint32 level));
BOOL reg_io_q_open_hkcr __P((const char *desc,  REG_Q_OPEN_HKCR *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_open_hkcr __P((const char *desc,  REG_R_OPEN_HKCR *r_r, prs_struct *ps, int depth));
void init_reg_q_open_hklm __P((REG_Q_OPEN_HKLM * q_o,
			  uint16 unknown_0, uint32 access_mask));
BOOL reg_io_q_open_hklm __P((const char *desc, REG_Q_OPEN_HKLM * r_q, prs_struct *ps,
			int depth));
BOOL reg_io_r_open_hklm __P((const char *desc, REG_R_OPEN_HKLM * r_r, prs_struct *ps,
			int depth));
void init_reg_q_flush_key __P((REG_Q_FLUSH_KEY *q_u, POLICY_HND *pol));
BOOL reg_io_q_flush_key __P((const char *desc,  REG_Q_FLUSH_KEY *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_flush_key __P((const char *desc,  REG_R_FLUSH_KEY *r_r, prs_struct *ps, int depth));
void init_reg_q_create_key __P((REG_Q_CREATE_KEY *q_c, POLICY_HND *hnd,
				const char *name, const char *class, SEC_ACCESS *sam_access,
				SEC_DESC_BUF *sec_buf));
BOOL reg_io_q_create_key __P((const char *desc,  REG_Q_CREATE_KEY *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_create_key __P((const char *desc,  REG_R_CREATE_KEY *r_r, prs_struct *ps, int depth));
void init_reg_q_delete_val __P((REG_Q_DELETE_VALUE *q_c, POLICY_HND *hnd,
				const char *name));
BOOL reg_io_q_delete_val __P((const char *desc,  REG_Q_DELETE_VALUE *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_delete_val __P((const char *desc,  REG_R_DELETE_VALUE *r_r, prs_struct *ps, int depth));
void init_reg_q_delete_key __P((REG_Q_DELETE_KEY *q_c, POLICY_HND *hnd,
				const char *name));
BOOL reg_io_q_delete_key __P((const char *desc,  REG_Q_DELETE_KEY *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_delete_key __P((const char *desc,  REG_R_DELETE_KEY *r_r, prs_struct *ps, int depth));
void init_reg_q_query_key __P((REG_Q_QUERY_KEY *q_o, POLICY_HND *hnd,
				uint32 max_class_len));
BOOL reg_io_q_query_key __P((const char *desc,  REG_Q_QUERY_KEY *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_query_key __P((const char *desc,  REG_R_QUERY_KEY *r_r, prs_struct *ps, int depth));
void init_reg_q_unk_1a __P((REG_Q_UNK_1A *q_o, POLICY_HND *hnd));
BOOL reg_io_q_unk_1a __P((const char *desc,  REG_Q_UNK_1A *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_unk_1a __P((const char *desc,  REG_R_UNK_1A *r_r, prs_struct *ps, int depth));
void init_reg_q_open_hku __P((REG_Q_OPEN_HKU *q_o,
				uint16 unknown_0, uint32 level));
BOOL reg_io_q_open_hku __P((const char *desc,  REG_Q_OPEN_HKU *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_open_hku __P((const char *desc,  REG_R_OPEN_HKU *r_r, prs_struct *ps, int depth));
void init_reg_q_close __P((REG_Q_CLOSE *q_c, POLICY_HND *hnd));
BOOL reg_io_q_close __P((const char *desc,  REG_Q_CLOSE *q_u, prs_struct *ps, int depth));
BOOL reg_io_r_close __P((const char *desc,  REG_R_CLOSE *r_u, prs_struct *ps, int depth));
void init_reg_q_set_key_sec __P((REG_Q_SET_KEY_SEC *q_i, POLICY_HND *pol, SEC_DESC_BUF *sec_desc_buf));
BOOL reg_io_q_set_key_sec __P((const char *desc,  REG_Q_SET_KEY_SEC *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_set_key_sec __P((const char *desc, REG_R_SET_KEY_SEC *r_q, prs_struct *ps, int depth));
void init_reg_q_get_key_sec __P((REG_Q_GET_KEY_SEC *q_i, POLICY_HND *pol, 
				uint32 sec_buf_size, SEC_DESC_BUF *psdb));
BOOL reg_io_q_get_key_sec __P((const char *desc,  REG_Q_GET_KEY_SEC *r_q, prs_struct *ps, int depth));
BOOL reg_io_r_get_key_sec __P((const char *desc,  REG_R_GET_KEY_SEC *r_q, prs_struct *ps, int depth));
BOOL init_reg_q_info __P((REG_Q_INFO *q_i, POLICY_HND *pol, char* val_name));
BOOL reg_io_q_info __P((const char *desc,  REG_Q_INFO *r_q, prs_struct *ps, int depth));
BOOL init_reg_r_info __P((uint32 include_keyval, REG_R_INFO *r_r,
		     BUFFER2* buf, uint32 type, NTSTATUS status));
BOOL reg_io_r_info __P((const char *desc, REG_R_INFO *r_r, prs_struct *ps, int depth));
void init_reg_q_enum_val __P((REG_Q_ENUM_VALUE *q_i, POLICY_HND *pol,
				uint32 val_idx, uint32 max_val_len,
				uint32 max_buf_len));
BOOL reg_io_q_enum_val __P((const char *desc,  REG_Q_ENUM_VALUE *q_q, prs_struct *ps, int depth));
BOOL reg_io_r_enum_val __P((const char *desc,  REG_R_ENUM_VALUE *r_q, prs_struct *ps, int depth));
void init_reg_q_create_val __P((REG_Q_CREATE_VALUE *q_i, POLICY_HND *pol,
				const char *val_name, uint32 type,
				BUFFER3 *val));
BOOL reg_io_q_create_val __P((const char *desc,  REG_Q_CREATE_VALUE *q_q, prs_struct *ps, int depth));
BOOL reg_io_r_create_val __P((const char *desc,  REG_R_CREATE_VALUE *r_q, prs_struct *ps, int depth));
void init_reg_q_enum_key __P((REG_Q_ENUM_KEY *q_i, POLICY_HND *pol, uint32 key_idx));
BOOL reg_io_q_enum_key __P((const char *desc,  REG_Q_ENUM_KEY *q_q, prs_struct *ps, int depth));
BOOL reg_io_r_enum_key __P((const char *desc,  REG_R_ENUM_KEY *r_q, prs_struct *ps, int depth));
void init_reg_q_open_entry __P((REG_Q_OPEN_ENTRY *r_q, POLICY_HND *pol,
				const char *key_name, uint32 unk));
BOOL reg_io_q_open_entry __P((const char *desc,  REG_Q_OPEN_ENTRY *r_q, prs_struct *ps, int depth));
void init_reg_r_open_entry __P((REG_R_OPEN_ENTRY *r_r,
			   POLICY_HND *pol, NTSTATUS status));
BOOL reg_io_r_open_entry __P((const char *desc,  REG_R_OPEN_ENTRY *r_r, prs_struct *ps, int depth));
void init_reg_q_shutdown __P((REG_Q_SHUTDOWN * q_s,
			 const char *msg, uint32 timeout, uint16 flags));
BOOL reg_io_q_shutdown __P((const char *desc, REG_Q_SHUTDOWN * q_s, prs_struct *ps,
		       int depth));
BOOL reg_io_r_shutdown __P((const char *desc, REG_R_SHUTDOWN * r_s, prs_struct *ps,
		       int depth));
void init_reg_q_abort_shutdown __P((REG_Q_ABORT_SHUTDOWN * q_s));
BOOL reg_io_q_abort_shutdown __P((const char *desc, REG_Q_ABORT_SHUTDOWN * q_s,
			     prs_struct *ps, int depth));
BOOL reg_io_r_abort_shutdown __P((const char *desc, REG_R_ABORT_SHUTDOWN * r_s,
			     prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_rpc.c  */

void init_rpc_hdr __P((RPC_HDR *hdr, enum RPC_PKT_TYPE pkt_type, uint8 flags,
				uint32 call_id, int data_len, int auth_len));
BOOL smb_io_rpc_hdr __P((const char *desc,  RPC_HDR *rpc, prs_struct *ps, int depth));
void init_rpc_hdr_rb __P((RPC_HDR_RB *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				uint32 num_elements, uint16 context_id, uint8 num_syntaxes,
				RPC_IFACE *abstract, RPC_IFACE *transfer));
BOOL smb_io_rpc_hdr_rb __P((const char *desc, RPC_HDR_RB *rpc, prs_struct *ps, int depth));
void init_rpc_hdr_ba __P((RPC_HDR_BA *rpc, 
				uint16 max_tsize, uint16 max_rsize, uint32 assoc_gid,
				const char *pipe_addr,
				uint8 num_results, uint16 result, uint16 reason,
				RPC_IFACE *transfer));
BOOL smb_io_rpc_hdr_ba __P((const char *desc, RPC_HDR_BA *rpc, prs_struct *ps, int depth));
void init_rpc_hdr_req __P((RPC_HDR_REQ *hdr, uint32 alloc_hint, uint16 opnum));
BOOL smb_io_rpc_hdr_req __P((const char *desc, RPC_HDR_REQ *rpc, prs_struct *ps, int depth));
BOOL smb_io_rpc_hdr_resp __P((const char *desc, RPC_HDR_RESP *rpc, prs_struct *ps, int depth));
BOOL smb_io_rpc_hdr_fault __P((const char *desc, RPC_HDR_FAULT *rpc, prs_struct *ps, int depth));
void init_rpc_hdr_autha __P((RPC_HDR_AUTHA *rai,
				uint16 max_tsize, uint16 max_rsize,
				uint8 auth_type, uint8 auth_level,
				uint8 stub_type_len));
BOOL smb_io_rpc_hdr_autha __P((const char *desc, RPC_HDR_AUTHA *rai, prs_struct *ps, int depth));
BOOL rpc_hdr_auth_chk __P((RPC_HDR_AUTH *rai));
void init_rpc_hdr_auth __P((RPC_HDR_AUTH *rai,
				uint8 auth_type, uint8 auth_level,
				uint8 stub_type_len,
				uint32 ptr));
BOOL smb_io_rpc_hdr_auth __P((const char *desc, RPC_HDR_AUTH *rai, prs_struct *ps, int depth));
BOOL rpc_auth_verifier_chk __P((RPC_AUTH_VERIFIER *rav,
				const char *signature, uint32 msg_type));
void init_rpc_auth_verifier __P((RPC_AUTH_VERIFIER *rav,
				const char *signature, uint32 msg_type));
BOOL smb_io_rpc_auth_verifier __P((const char *desc, RPC_AUTH_VERIFIER *rav, prs_struct *ps, int depth));
void init_rpc_auth_ntlmssp_neg __P((RPC_AUTH_NTLMSSP_NEG *neg,
				uint32 neg_flgs,
				fstring myname, fstring domain));
BOOL smb_io_rpc_auth_ntlmssp_neg __P((const char *desc, RPC_AUTH_NTLMSSP_NEG *neg, prs_struct *ps, int depth));
void init_rpc_auth_ntlmssp_chal __P((RPC_AUTH_NTLMSSP_CHAL *chl,
				uint32 neg_flags,
				uint8 challenge[8]));
BOOL smb_io_rpc_auth_ntlmssp_chal __P((const char *desc, RPC_AUTH_NTLMSSP_CHAL *chl, prs_struct *ps, int depth));
void init_rpc_auth_ntlmssp_resp __P((RPC_AUTH_NTLMSSP_RESP *rsp,
				uchar lm_resp[24], uchar nt_resp[24],
				const char *domain, const char *user, const char *wks,
				uint32 neg_flags));
BOOL smb_io_rpc_auth_ntlmssp_resp __P((const char *desc, RPC_AUTH_NTLMSSP_RESP *rsp, prs_struct *ps, int depth));
BOOL rpc_auth_ntlmssp_chk __P((RPC_AUTH_NTLMSSP_CHK *chk, uint32 crc32, uint32 seq_num));
void init_rpc_auth_ntlmssp_chk __P((RPC_AUTH_NTLMSSP_CHK *chk,
				uint32 ver, uint32 crc32, uint32 seq_num));
BOOL smb_io_rpc_auth_ntlmssp_chk __P((const char *desc, RPC_AUTH_NTLMSSP_CHK *chk, prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_samr.c  */

void init_samr_q_close_hnd __P((SAMR_Q_CLOSE_HND * q_c, POLICY_HND *hnd));
BOOL samr_io_q_close_hnd __P((const char *desc, SAMR_Q_CLOSE_HND * q_u,
			 prs_struct *ps, int depth));
BOOL samr_io_r_close_hnd __P((const char *desc, SAMR_R_CLOSE_HND * r_u,
			 prs_struct *ps, int depth));
void init_samr_q_lookup_domain __P((SAMR_Q_LOOKUP_DOMAIN * q_u,
			       POLICY_HND *pol, const char *dom_name));
BOOL samr_io_q_lookup_domain __P((const char *desc, SAMR_Q_LOOKUP_DOMAIN * q_u,
			     prs_struct *ps, int depth));
void init_samr_r_lookup_domain __P((SAMR_R_LOOKUP_DOMAIN * r_u,
			       DOM_SID *dom_sid, NTSTATUS status));
BOOL samr_io_r_lookup_domain __P((const char *desc, SAMR_R_LOOKUP_DOMAIN * r_u,
			     prs_struct *ps, int depth));
void init_samr_q_unknown_2d __P((SAMR_Q_UNKNOWN_2D * q_u, POLICY_HND *dom_pol, DOM_SID *sid));
BOOL samr_io_q_unknown_2d __P((const char *desc, SAMR_Q_UNKNOWN_2D * q_u,
			  prs_struct *ps, int depth));
BOOL samr_io_r_unknown_2d __P((const char *desc, SAMR_R_UNKNOWN_2D * r_u,
			  prs_struct *ps, int depth));
void init_samr_q_open_domain __P((SAMR_Q_OPEN_DOMAIN * q_u,
			     POLICY_HND *pol, uint32 flags,
			     const DOM_SID *sid));
BOOL samr_io_q_open_domain __P((const char *desc, SAMR_Q_OPEN_DOMAIN * q_u,
			   prs_struct *ps, int depth));
BOOL samr_io_r_open_domain __P((const char *desc, SAMR_R_OPEN_DOMAIN * r_u,
			   prs_struct *ps, int depth));
void init_samr_q_get_usrdom_pwinfo __P((SAMR_Q_GET_USRDOM_PWINFO * q_u,
				   POLICY_HND *user_pol));
BOOL samr_io_q_get_usrdom_pwinfo __P((const char *desc, SAMR_Q_GET_USRDOM_PWINFO * q_u,
				 prs_struct *ps, int depth));
void init_samr_r_get_usrdom_pwinfo __P((SAMR_R_GET_USRDOM_PWINFO *r_u, NTSTATUS status));
BOOL samr_io_r_get_usrdom_pwinfo __P((const char *desc, SAMR_R_GET_USRDOM_PWINFO * r_u,
				 prs_struct *ps, int depth));
void init_samr_q_query_sec_obj __P((SAMR_Q_QUERY_SEC_OBJ * q_u,
			       POLICY_HND *user_pol, uint32 sec_info));
BOOL samr_io_q_query_sec_obj __P((const char *desc, SAMR_Q_QUERY_SEC_OBJ * q_u,
			     prs_struct *ps, int depth));
void init_samr_q_query_dom_info __P((SAMR_Q_QUERY_DOMAIN_INFO * q_u,
				POLICY_HND *domain_pol, uint16 switch_value));
BOOL samr_io_q_query_dom_info __P((const char *desc, SAMR_Q_QUERY_DOMAIN_INFO * q_u,
			      prs_struct *ps, int depth));
void init_unk_info3 __P((SAM_UNK_INFO_3 *u_3, NTTIME nt_logout));
void init_unk_info6 __P((SAM_UNK_INFO_6 * u_6));
void init_unk_info7 __P((SAM_UNK_INFO_7 * u_7));
void init_unk_info12 __P((SAM_UNK_INFO_12 * u_12, NTTIME nt_lock_duration, NTTIME nt_reset_time, uint16 lockout));
void init_unk_info5 __P((SAM_UNK_INFO_5 * u_5,const char *server));
void init_unk_info2 __P((SAM_UNK_INFO_2 * u_2,
			const char *domain, const char *server,
			uint32 seq_num, uint32 num_users, uint32 num_groups, uint32 num_alias));
void init_unk_info1 __P((SAM_UNK_INFO_1 *u_1, uint16 min_pass_len, uint16 pass_hist, 
		    uint32 flag, NTTIME nt_expire, NTTIME nt_min_age));
void init_samr_r_query_dom_info __P((SAMR_R_QUERY_DOMAIN_INFO * r_u,
				uint16 switch_value, SAM_UNK_CTR * ctr,
				NTSTATUS status));
BOOL samr_io_r_query_dom_info __P((const char *desc, SAMR_R_QUERY_DOMAIN_INFO * r_u,
			      prs_struct *ps, int depth));
BOOL samr_io_r_query_sec_obj __P((const char *desc, SAMR_R_QUERY_SEC_OBJ * r_u,
			     prs_struct *ps, int depth));
void init_sam_entry __P((SAM_ENTRY * sam, uint32 len_sam_name, uint32 rid));
void init_samr_q_enum_dom_users __P((SAMR_Q_ENUM_DOM_USERS * q_e, POLICY_HND *pol,
				uint32 start_idx,
				uint16 acb_mask, uint16 unk_1, uint32 size));
BOOL samr_io_q_enum_dom_users __P((const char *desc, SAMR_Q_ENUM_DOM_USERS * q_e,
			      prs_struct *ps, int depth));
void init_samr_r_enum_dom_users __P((SAMR_R_ENUM_DOM_USERS * r_u,
				uint32 next_idx, uint32 num_sam_entries));
BOOL samr_io_r_enum_dom_users __P((const char *desc, SAMR_R_ENUM_DOM_USERS * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_query_dispinfo __P((SAMR_Q_QUERY_DISPINFO * q_e, POLICY_HND *pol,
				uint16 switch_level, uint32 start_idx,
				uint32 max_entries, uint32 max_size));
BOOL samr_io_q_query_dispinfo __P((const char *desc, SAMR_Q_QUERY_DISPINFO * q_e,
			      prs_struct *ps, int depth));
NTSTATUS init_sam_dispinfo_1 __P((TALLOC_CTX *ctx, SAM_DISPINFO_1 *sam, uint32 num_entries,
			 uint32 start_idx, DISP_USER_INFO *disp_user_info));
NTSTATUS init_sam_dispinfo_2 __P((TALLOC_CTX *ctx, SAM_DISPINFO_2 *sam, uint32 num_entries,
			 uint32 start_idx, DISP_USER_INFO *disp_user_info));
NTSTATUS init_sam_dispinfo_3 __P((TALLOC_CTX *ctx, SAM_DISPINFO_3 *sam, uint32 num_entries,
			 uint32 start_idx, DISP_GROUP_INFO *disp_group_info));
NTSTATUS init_sam_dispinfo_4 __P((TALLOC_CTX *ctx, SAM_DISPINFO_4 *sam, uint32 num_entries,
			 uint32 start_idx, DISP_USER_INFO *disp_user_info));
NTSTATUS init_sam_dispinfo_5 __P((TALLOC_CTX *ctx, SAM_DISPINFO_5 *sam, uint32 num_entries,
			 uint32 start_idx, DISP_GROUP_INFO *disp_group_info));
void init_samr_r_query_dispinfo __P((SAMR_R_QUERY_DISPINFO * r_u,
				uint32 num_entries, uint32 total_size, uint32 data_size,
				uint16 switch_level, SAM_DISPINFO_CTR * ctr,
				NTSTATUS status));
BOOL samr_io_r_query_dispinfo __P((const char *desc, SAMR_R_QUERY_DISPINFO * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_open_group __P((SAMR_Q_OPEN_GROUP * q_c,
			    POLICY_HND *hnd,
			    uint32 access_mask, uint32 rid));
BOOL samr_io_q_open_group __P((const char *desc, SAMR_Q_OPEN_GROUP * q_u,
			  prs_struct *ps, int depth));
BOOL samr_io_r_open_group __P((const char *desc, SAMR_R_OPEN_GROUP * r_u,
			  prs_struct *ps, int depth));
void init_samr_group_info1 __P((GROUP_INFO1 * gr1,
			   const char *acct_name, const char *acct_desc,
			   uint32 num_members));
BOOL samr_io_group_info1 __P((const char *desc, GROUP_INFO1 * gr1,
			 prs_struct *ps, int depth));
void init_samr_group_info3 __P((GROUP_INFO3 *gr3));
BOOL samr_io_group_info3 __P((const char *desc, GROUP_INFO3 *gr3, prs_struct *ps, int depth));
void init_samr_group_info4 __P((GROUP_INFO4 * gr4, const char *acct_desc));
BOOL samr_io_group_info4 __P((const char *desc, GROUP_INFO4 * gr4,
			 prs_struct *ps, int depth));
void init_samr_q_create_dom_group __P((SAMR_Q_CREATE_DOM_GROUP * q_e,
				  POLICY_HND *pol, const char *acct_desc,
				  uint32 access_mask));
BOOL samr_io_q_create_dom_group __P((const char *desc, SAMR_Q_CREATE_DOM_GROUP * q_e,
				prs_struct *ps, int depth));
BOOL samr_io_r_create_dom_group __P((const char *desc, SAMR_R_CREATE_DOM_GROUP * r_u,
				prs_struct *ps, int depth));
void init_samr_q_delete_dom_group __P((SAMR_Q_DELETE_DOM_GROUP * q_c,
				  POLICY_HND *hnd));
BOOL samr_io_q_delete_dom_group __P((const char *desc, SAMR_Q_DELETE_DOM_GROUP * q_u,
				prs_struct *ps, int depth));
BOOL samr_io_r_delete_dom_group __P((const char *desc, SAMR_R_DELETE_DOM_GROUP * r_u,
				prs_struct *ps, int depth));
void init_samr_q_del_groupmem __P((SAMR_Q_DEL_GROUPMEM * q_e,
			      POLICY_HND *pol, uint32 rid));
BOOL samr_io_q_del_groupmem __P((const char *desc, SAMR_Q_DEL_GROUPMEM * q_e,
			    prs_struct *ps, int depth));
void init_samr_r_del_groupmem __P((SAMR_R_DEL_GROUPMEM * r_u, POLICY_HND *pol,
			      NTSTATUS status));
BOOL samr_io_r_del_groupmem __P((const char *desc, SAMR_R_DEL_GROUPMEM * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_add_groupmem __P((SAMR_Q_ADD_GROUPMEM * q_e,
			      POLICY_HND *pol, uint32 rid));
BOOL samr_io_q_add_groupmem __P((const char *desc, SAMR_Q_ADD_GROUPMEM * q_e,
			    prs_struct *ps, int depth));
void init_samr_r_add_groupmem __P((SAMR_R_ADD_GROUPMEM * r_u, POLICY_HND *pol,
			      NTSTATUS status));
BOOL samr_io_r_add_groupmem __P((const char *desc, SAMR_R_ADD_GROUPMEM * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_set_groupinfo __P((SAMR_Q_SET_GROUPINFO * q_e,
			       POLICY_HND *pol, GROUP_INFO_CTR * ctr));
BOOL samr_io_q_set_groupinfo __P((const char *desc, SAMR_Q_SET_GROUPINFO * q_e,
			     prs_struct *ps, int depth));
void init_samr_r_set_groupinfo __P((SAMR_R_SET_GROUPINFO * r_u, NTSTATUS status));
BOOL samr_io_r_set_groupinfo __P((const char *desc, SAMR_R_SET_GROUPINFO * r_u,
			     prs_struct *ps, int depth));
void init_samr_q_query_groupinfo __P((SAMR_Q_QUERY_GROUPINFO * q_e,
				 POLICY_HND *pol, uint16 switch_level));
BOOL samr_io_q_query_groupinfo __P((const char *desc, SAMR_Q_QUERY_GROUPINFO * q_e,
			       prs_struct *ps, int depth));
void init_samr_r_query_groupinfo __P((SAMR_R_QUERY_GROUPINFO * r_u,
				 GROUP_INFO_CTR * ctr, NTSTATUS status));
BOOL samr_io_r_query_groupinfo __P((const char *desc, SAMR_R_QUERY_GROUPINFO * r_u,
			       prs_struct *ps, int depth));
void init_samr_q_query_groupmem __P((SAMR_Q_QUERY_GROUPMEM * q_c, POLICY_HND *hnd));
BOOL samr_io_q_query_groupmem __P((const char *desc, SAMR_Q_QUERY_GROUPMEM * q_u,
			      prs_struct *ps, int depth));
void init_samr_r_query_groupmem __P((SAMR_R_QUERY_GROUPMEM * r_u,
				uint32 num_entries, uint32 *rid,
				uint32 *attr, NTSTATUS status));
BOOL samr_io_r_query_groupmem __P((const char *desc, SAMR_R_QUERY_GROUPMEM * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_query_usergroups __P((SAMR_Q_QUERY_USERGROUPS * q_u,
				  POLICY_HND *hnd));
BOOL samr_io_q_query_usergroups __P((const char *desc, SAMR_Q_QUERY_USERGROUPS * q_u,
				prs_struct *ps, int depth));
void init_samr_r_query_usergroups __P((SAMR_R_QUERY_USERGROUPS * r_u,
				  uint32 num_gids, DOM_GID * gid,
				  NTSTATUS status));
BOOL samr_io_gids __P((const char *desc, uint32 *num_gids, DOM_GID ** gid,
		  prs_struct *ps, int depth));
BOOL samr_io_r_query_usergroups __P((const char *desc, SAMR_R_QUERY_USERGROUPS * r_u,
				prs_struct *ps, int depth));
void init_samr_q_enum_domains __P((SAMR_Q_ENUM_DOMAINS * q_e,
			      POLICY_HND *pol,
			      uint32 start_idx, uint32 size));
BOOL samr_io_q_enum_domains __P((const char *desc, SAMR_Q_ENUM_DOMAINS * q_e,
			    prs_struct *ps, int depth));
void init_samr_r_enum_domains __P((SAMR_R_ENUM_DOMAINS * r_u,
			      uint32 next_idx, uint32 num_sam_entries));
BOOL samr_io_r_enum_domains __P((const char *desc, SAMR_R_ENUM_DOMAINS * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_enum_dom_groups __P((SAMR_Q_ENUM_DOM_GROUPS * q_e,
				 POLICY_HND *pol,
				 uint32 start_idx, uint32 size));
BOOL samr_io_q_enum_dom_groups __P((const char *desc, SAMR_Q_ENUM_DOM_GROUPS * q_e,
			       prs_struct *ps, int depth));
void init_samr_r_enum_dom_groups __P((SAMR_R_ENUM_DOM_GROUPS * r_u,
				 uint32 next_idx, uint32 num_sam_entries));
BOOL samr_io_r_enum_dom_groups __P((const char *desc, SAMR_R_ENUM_DOM_GROUPS * r_u,
			       prs_struct *ps, int depth));
void init_samr_q_enum_dom_aliases __P((SAMR_Q_ENUM_DOM_ALIASES * q_e,
				  POLICY_HND *pol, uint32 start_idx,
				  uint32 size));
BOOL samr_io_q_enum_dom_aliases __P((const char *desc, SAMR_Q_ENUM_DOM_ALIASES * q_e,
				prs_struct *ps, int depth));
void init_samr_r_enum_dom_aliases __P((SAMR_R_ENUM_DOM_ALIASES *r_u, uint32 next_idx, uint32 num_sam_entries));
BOOL samr_io_r_enum_dom_aliases __P((const char *desc, SAMR_R_ENUM_DOM_ALIASES * r_u,
				prs_struct *ps, int depth));
void init_samr_alias_info1 __P((ALIAS_INFO1 * al1, const char *acct_name, uint32 num_member, const char *acct_desc));
BOOL samr_io_alias_info1 __P((const char *desc, ALIAS_INFO1 * al1,
			 prs_struct *ps, int depth));
void init_samr_alias_info3 __P((ALIAS_INFO3 * al3, const char *acct_desc));
BOOL samr_io_alias_info3 __P((const char *desc, ALIAS_INFO3 * al3,
			 prs_struct *ps, int depth));
BOOL samr_alias_info_ctr __P((const char *desc, ALIAS_INFO_CTR * ctr,
			 prs_struct *ps, int depth));
void init_samr_q_query_aliasinfo __P((SAMR_Q_QUERY_ALIASINFO * q_e,
				 POLICY_HND *pol, uint16 switch_level));
BOOL samr_io_q_query_aliasinfo __P((const char *desc, SAMR_Q_QUERY_ALIASINFO * q_e,
			       prs_struct *ps, int depth));
void init_samr_r_query_aliasinfo __P((SAMR_R_QUERY_ALIASINFO * r_u,
				 ALIAS_INFO_CTR * ctr, NTSTATUS status));
BOOL samr_io_r_query_aliasinfo __P((const char *desc, SAMR_R_QUERY_ALIASINFO * r_u,
			       prs_struct *ps, int depth));
void init_samr_q_set_aliasinfo __P((SAMR_Q_SET_ALIASINFO * q_u,
			       POLICY_HND *hnd, ALIAS_INFO_CTR * ctr));
BOOL samr_io_q_set_aliasinfo __P((const char *desc, SAMR_Q_SET_ALIASINFO * q_u,
			     prs_struct *ps, int depth));
BOOL samr_io_r_set_aliasinfo __P((const char *desc, SAMR_R_SET_ALIASINFO * r_u,
			     prs_struct *ps, int depth));
void init_samr_q_query_useraliases __P((SAMR_Q_QUERY_USERALIASES * q_u,
				   POLICY_HND *hnd,
				   uint32 num_sids,
				   uint32 *ptr_sid, DOM_SID2 * sid));
BOOL samr_io_q_query_useraliases __P((const char *desc, SAMR_Q_QUERY_USERALIASES * q_u,
				 prs_struct *ps, int depth));
void init_samr_r_query_useraliases __P((SAMR_R_QUERY_USERALIASES * r_u,
				   uint32 num_rids, uint32 *rid,
				   NTSTATUS status));
BOOL samr_io_rids __P((const char *desc, uint32 *num_rids, uint32 **rid,
		  prs_struct *ps, int depth));
BOOL samr_io_r_query_useraliases __P((const char *desc, SAMR_R_QUERY_USERALIASES * r_u,
				 prs_struct *ps, int depth));
void init_samr_q_open_alias __P((SAMR_Q_OPEN_ALIAS * q_u, POLICY_HND *pol,
			    uint32 access_mask, uint32 rid));
BOOL samr_io_q_open_alias __P((const char *desc, SAMR_Q_OPEN_ALIAS * q_u,
			  prs_struct *ps, int depth));
BOOL samr_io_r_open_alias __P((const char *desc, SAMR_R_OPEN_ALIAS * r_u,
			  prs_struct *ps, int depth));
void init_samr_q_lookup_rids __P((TALLOC_CTX *ctx, SAMR_Q_LOOKUP_RIDS * q_u,
			     POLICY_HND *pol, uint32 flags,
			     uint32 num_rids, uint32 *rid));
BOOL samr_io_q_lookup_rids __P((const char *desc, SAMR_Q_LOOKUP_RIDS * q_u,
			   prs_struct *ps, int depth));
void init_samr_r_lookup_rids __P((SAMR_R_LOOKUP_RIDS * r_u,
			     uint32 num_names, UNIHDR * hdr_name,
			     UNISTR2 *uni_name, uint32 *type));
BOOL samr_io_r_lookup_rids __P((const char *desc, SAMR_R_LOOKUP_RIDS * r_u,
			   prs_struct *ps, int depth));
void init_samr_q_delete_alias __P((SAMR_Q_DELETE_DOM_ALIAS * q_u, POLICY_HND *hnd));
BOOL samr_io_q_delete_alias __P((const char *desc, SAMR_Q_DELETE_DOM_ALIAS * q_u,
			    prs_struct *ps, int depth));
BOOL samr_io_r_delete_alias __P((const char *desc, SAMR_R_DELETE_DOM_ALIAS * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_create_dom_alias __P((SAMR_Q_CREATE_DOM_ALIAS * q_u,
				  POLICY_HND *hnd, const char *acct_desc));
BOOL samr_io_q_create_dom_alias __P((const char *desc, SAMR_Q_CREATE_DOM_ALIAS * q_u,
				prs_struct *ps, int depth));
BOOL samr_io_r_create_dom_alias __P((const char *desc, SAMR_R_CREATE_DOM_ALIAS * r_u,
				prs_struct *ps, int depth));
void init_samr_q_add_aliasmem __P((SAMR_Q_ADD_ALIASMEM * q_u, POLICY_HND *hnd,
			      DOM_SID *sid));
BOOL samr_io_q_add_aliasmem __P((const char *desc, SAMR_Q_ADD_ALIASMEM * q_u,
			    prs_struct *ps, int depth));
BOOL samr_io_r_add_aliasmem __P((const char *desc, SAMR_R_ADD_ALIASMEM * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_del_aliasmem __P((SAMR_Q_DEL_ALIASMEM * q_u, POLICY_HND *hnd,
			      DOM_SID *sid));
BOOL samr_io_q_del_aliasmem __P((const char *desc, SAMR_Q_DEL_ALIASMEM * q_u,
			    prs_struct *ps, int depth));
BOOL samr_io_r_del_aliasmem __P((const char *desc, SAMR_R_DEL_ALIASMEM * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_delete_dom_alias __P((SAMR_Q_DELETE_DOM_ALIAS * q_c,
				  POLICY_HND *hnd));
BOOL samr_io_q_delete_dom_alias __P((const char *desc, SAMR_Q_DELETE_DOM_ALIAS * q_u,
				prs_struct *ps, int depth));
void init_samr_r_delete_dom_alias __P((SAMR_R_DELETE_DOM_ALIAS * r_u,
				  NTSTATUS status));
BOOL samr_io_r_delete_dom_alias __P((const char *desc, SAMR_R_DELETE_DOM_ALIAS * r_u,
				prs_struct *ps, int depth));
void init_samr_q_query_aliasmem __P((SAMR_Q_QUERY_ALIASMEM * q_c,
				POLICY_HND *hnd));
BOOL samr_io_q_query_aliasmem __P((const char *desc, SAMR_Q_QUERY_ALIASMEM * q_u,
			      prs_struct *ps, int depth));
void init_samr_r_query_aliasmem __P((SAMR_R_QUERY_ALIASMEM * r_u,
				uint32 num_sids, DOM_SID2 * sid,
				NTSTATUS status));
BOOL samr_io_r_query_aliasmem __P((const char *desc, SAMR_R_QUERY_ALIASMEM * r_u,
			      prs_struct *ps, int depth));
NTSTATUS init_samr_q_lookup_names __P((TALLOC_CTX *ctx, SAMR_Q_LOOKUP_NAMES * q_u,
			      POLICY_HND *pol, uint32 flags,
			      uint32 num_names, const char **name));
BOOL samr_io_q_lookup_names __P((const char *desc, SAMR_Q_LOOKUP_NAMES * q_u,
			    prs_struct *ps, int depth));
NTSTATUS init_samr_r_lookup_names __P((TALLOC_CTX *ctx, SAMR_R_LOOKUP_NAMES * r_u,
			      uint32 num_rids,
			      uint32 *rid, uint32 *type,
			      NTSTATUS status));
BOOL samr_io_r_lookup_names __P((const char *desc, SAMR_R_LOOKUP_NAMES * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_delete_dom_user __P((SAMR_Q_DELETE_DOM_USER * q_c,
				 POLICY_HND *hnd));
BOOL samr_io_q_delete_dom_user __P((const char *desc, SAMR_Q_DELETE_DOM_USER * q_u,
			       prs_struct *ps, int depth));
BOOL samr_io_r_delete_dom_user __P((const char *desc, SAMR_R_DELETE_DOM_USER * r_u,
			       prs_struct *ps, int depth));
void init_samr_q_open_user __P((SAMR_Q_OPEN_USER * q_u,
			   POLICY_HND *pol,
			   uint32 access_mask, uint32 rid));
BOOL samr_io_q_open_user __P((const char *desc, SAMR_Q_OPEN_USER * q_u,
			 prs_struct *ps, int depth));
BOOL samr_io_r_open_user __P((const char *desc, SAMR_R_OPEN_USER * r_u,
			 prs_struct *ps, int depth));
void init_samr_q_create_user __P((SAMR_Q_CREATE_USER * q_u,
			     POLICY_HND *pol,
			     const char *name,
			     uint32 acb_info, uint32 access_mask));
BOOL samr_io_q_create_user __P((const char *desc, SAMR_Q_CREATE_USER * q_u,
			   prs_struct *ps, int depth));
BOOL samr_io_r_create_user __P((const char *desc, SAMR_R_CREATE_USER * r_u,
			   prs_struct *ps, int depth));
void init_samr_q_query_userinfo __P((SAMR_Q_QUERY_USERINFO * q_u,
				POLICY_HND *hnd, uint16 switch_value));
BOOL samr_io_q_query_userinfo __P((const char *desc, SAMR_Q_QUERY_USERINFO * q_u,
			      prs_struct *ps, int depth));
void init_sam_user_info12 __P((SAM_USER_INFO_12 * usr,
			  const uint8 lm_pwd[16], const uint8 nt_pwd[16]));
void init_sam_user_info10 __P((SAM_USER_INFO_10 * usr, uint32 acb_info));
void init_sam_user_info11 __P((SAM_USER_INFO_11 * usr,
			  NTTIME * expiry,
			  const char *mach_acct,
			  uint32 rid_user, uint32 rid_group, uint16 acct_ctrl));
void init_sam_user_info24 __P((SAM_USER_INFO_24 * usr, char newpass[516], uint16 pw_len));
void init_sam_user_info23W __P((SAM_USER_INFO_23 * usr, NTTIME * logon_time,	/* all zeros */
			NTTIME * logoff_time,	/* all zeros */
			NTTIME * kickoff_time,	/* all zeros */
			NTTIME * pass_last_set_time,	/* all zeros */
			NTTIME * pass_can_change_time,	/* all zeros */
			NTTIME * pass_must_change_time,	/* all zeros */
			UNISTR2 *user_name,
			UNISTR2 *full_name,
			UNISTR2 *home_dir,
			UNISTR2 *dir_drive,
			UNISTR2 *log_scr,
			UNISTR2 *prof_path,
			UNISTR2 *desc,
			UNISTR2 *wkstas,
			UNISTR2 *unk_str,
			UNISTR2 *mung_dial,
			uint32 user_rid,	/* 0x0000 0000 */
			uint32 group_rid,
			uint32 acb_info,
			uint32 unknown_3,
			uint16 logon_divs,
			LOGON_HRS * hrs,
			uint32 unknown_5,
			char newpass[516], uint32 unknown_6));
void init_sam_user_info23A __P((SAM_USER_INFO_23 * usr, NTTIME * logon_time,	/* all zeros */
			   NTTIME * logoff_time,	/* all zeros */
			   NTTIME * kickoff_time,	/* all zeros */
			   NTTIME * pass_last_set_time,	/* all zeros */
			   NTTIME * pass_can_change_time,	/* all zeros */
			   NTTIME * pass_must_change_time,	/* all zeros */
			   const char *user_name,	/* NULL */
			   const char *full_name,
			   const char *home_dir, const char *dir_drive, const char *log_scr,
			   const char *prof_path, const char *desc, const char *wkstas,
			   const char *unk_str, const char *mung_dial, uint32 user_rid,	/* 0x0000 0000 */
			   uint32 group_rid, uint32 acb_info,
			   uint32 unknown_3, uint16 logon_divs,
			   LOGON_HRS * hrs, uint32 unknown_5,
			   char newpass[516], uint32 unknown_6));
void init_sam_user_info21W __P((SAM_USER_INFO_21 * usr,
			   NTTIME * logon_time,
			   NTTIME * logoff_time,
			   NTTIME * kickoff_time,
			   NTTIME * pass_last_set_time,
			   NTTIME * pass_can_change_time,
			   NTTIME * pass_must_change_time,
			   UNISTR2 *user_name,
			   UNISTR2 *full_name,
			   UNISTR2 *home_dir,
			   UNISTR2 *dir_drive,
			   UNISTR2 *log_scr,
			   UNISTR2 *prof_path,
			   UNISTR2 *desc,
			   UNISTR2 *wkstas,
			   UNISTR2 *unk_str,
			   UNISTR2 *mung_dial,
			   uchar lm_pwd[16],
			   uchar nt_pwd[16],
			   uint32 user_rid,
			   uint32 group_rid,
			   uint32 acb_info,
			   uint32 unknown_3,
			   uint16 logon_divs,
			   LOGON_HRS * hrs,
			   uint32 unknown_5, uint32 unknown_6));
void init_sam_user_info21A __P((SAM_USER_INFO_21 *usr, SAM_ACCOUNT *pw));
void init_sam_user_info20A __P((SAM_USER_INFO_20 *usr, SAM_ACCOUNT *pw));
NTSTATUS make_samr_userinfo_ctr_usr21 __P((TALLOC_CTX *ctx, SAM_USERINFO_CTR * ctr,
				    uint16 switch_value,
				    SAM_USER_INFO_21 * usr));
void init_samr_userinfo_ctr __P((SAM_USERINFO_CTR * ctr, uchar * sess_key,
			    uint16 switch_value, void *info));
void init_samr_r_query_userinfo __P((SAMR_R_QUERY_USERINFO * r_u,
				SAM_USERINFO_CTR * ctr, NTSTATUS status));
BOOL samr_io_r_query_userinfo __P((const char *desc, SAMR_R_QUERY_USERINFO * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_set_userinfo __P((SAMR_Q_SET_USERINFO * q_u,
			      POLICY_HND *hnd,  unsigned char sess_key[16],
			      uint16 switch_value, void *info));
BOOL samr_io_q_set_userinfo __P((const char *desc, SAMR_Q_SET_USERINFO * q_u,
			    prs_struct *ps, int depth));
void init_samr_r_set_userinfo __P((SAMR_R_SET_USERINFO * r_u, NTSTATUS status));
BOOL samr_io_r_set_userinfo __P((const char *desc, SAMR_R_SET_USERINFO * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_set_userinfo2 __P((SAMR_Q_SET_USERINFO2 * q_u,
			       POLICY_HND *hnd, unsigned char sess_key[16],
			       uint16 switch_value, SAM_USERINFO_CTR * ctr));
BOOL samr_io_q_set_userinfo2 __P((const char *desc, SAMR_Q_SET_USERINFO2 * q_u,
			     prs_struct *ps, int depth));
void init_samr_r_set_userinfo2 __P((SAMR_R_SET_USERINFO2 * r_u, NTSTATUS status));
BOOL samr_io_r_set_userinfo2 __P((const char *desc, SAMR_R_SET_USERINFO2 * r_u,
			     prs_struct *ps, int depth));
void init_samr_q_connect __P((SAMR_Q_CONNECT * q_u,
			 const char *srv_name, uint32 access_mask));
BOOL samr_io_q_connect __P((const char *desc, SAMR_Q_CONNECT * q_u,
		       prs_struct *ps, int depth));
BOOL samr_io_r_connect __P((const char *desc, SAMR_R_CONNECT * r_u,
		       prs_struct *ps, int depth));
void init_samr_q_connect_anon __P((SAMR_Q_CONNECT_ANON * q_u));
BOOL samr_io_q_connect_anon __P((const char *desc, SAMR_Q_CONNECT_ANON * q_u,
			    prs_struct *ps, int depth));
BOOL samr_io_r_connect_anon __P((const char *desc, SAMR_R_CONNECT_ANON * r_u,
			    prs_struct *ps, int depth));
void init_samr_q_get_dom_pwinfo __P((SAMR_Q_GET_DOM_PWINFO * q_u,
				const char *srv_name));
BOOL samr_io_q_get_dom_pwinfo __P((const char *desc, SAMR_Q_GET_DOM_PWINFO * q_u,
			      prs_struct *ps, int depth));
BOOL samr_io_r_get_dom_pwinfo __P((const char *desc, SAMR_R_GET_DOM_PWINFO * r_u,
			      prs_struct *ps, int depth));
void init_enc_passwd __P((SAMR_ENC_PASSWD * pwd, char pass[512]));
BOOL samr_io_enc_passwd __P((const char *desc, SAMR_ENC_PASSWD * pwd,
			prs_struct *ps, int depth));
void init_enc_hash __P((SAMR_ENC_HASH * hsh, uchar hash[16]));
BOOL samr_io_enc_hash __P((const char *desc, SAMR_ENC_HASH * hsh,
		      prs_struct *ps, int depth));
void init_samr_q_chgpasswd_user __P((SAMR_Q_CHGPASSWD_USER * q_u,
				const char *dest_host, const char *user_name,
				char nt_newpass[516],
				uchar nt_oldhash[16],
				char lm_newpass[516],
				uchar lm_oldhash[16]));
BOOL samr_io_q_chgpasswd_user __P((const char *desc, SAMR_Q_CHGPASSWD_USER * q_u,
			      prs_struct *ps, int depth));
void init_samr_r_chgpasswd_user __P((SAMR_R_CHGPASSWD_USER * r_u, NTSTATUS status));
BOOL samr_io_r_chgpasswd_user __P((const char *desc, SAMR_R_CHGPASSWD_USER * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_unknown_2e __P((SAMR_Q_UNKNOWN_2E *q_u,
				POLICY_HND *domain_pol, uint16 switch_value));
BOOL samr_io_q_unknown_2e __P((const char *desc, SAMR_Q_UNKNOWN_2E *q_u,
			      prs_struct *ps, int depth));
void init_samr_r_samr_unknown_2e __P((SAMR_R_UNKNOWN_2E * r_u,
				uint16 switch_value, SAM_UNK_CTR * ctr,
				NTSTATUS status));
BOOL samr_io_r_samr_unknown_2e __P((const char *desc, SAMR_R_UNKNOWN_2E * r_u,
			      prs_struct *ps, int depth));
void init_samr_q_set_domain_info __P((SAMR_Q_SET_DOMAIN_INFO *q_u,
				POLICY_HND *domain_pol, uint16 switch_value, SAM_UNK_CTR *ctr));
BOOL samr_io_q_set_domain_info __P((const char *desc, SAMR_Q_SET_DOMAIN_INFO *q_u,
			      prs_struct *ps, int depth));
void init_samr_r_set_domain_info __P((SAMR_R_SET_DOMAIN_INFO * r_u, NTSTATUS status));
BOOL samr_io_r_set_domain_info __P((const char *desc, SAMR_R_SET_DOMAIN_INFO * r_u,
			      prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_sec.c  */

void init_sec_access __P((SEC_ACCESS *t, uint32 mask));
BOOL sec_io_access __P((const char *desc, SEC_ACCESS *t, prs_struct *ps, int depth));
void init_sec_ace __P((SEC_ACE *t, DOM_SID *sid, uint8 type, SEC_ACCESS mask, uint8 flag));
BOOL sec_io_ace __P((const char *desc, SEC_ACE *psa, prs_struct *ps, int depth));
SEC_ACL *make_sec_acl __P((TALLOC_CTX *ctx, uint16 revision, int num_aces, SEC_ACE *ace_list));
SEC_ACL *dup_sec_acl __P((TALLOC_CTX *ctx, SEC_ACL *src));
BOOL sec_io_acl __P((const char *desc, SEC_ACL **ppsa, prs_struct *ps, int depth));
size_t sec_desc_size __P((SEC_DESC *psd));
BOOL sec_ace_equal __P((SEC_ACE *s1, SEC_ACE *s2));
BOOL sec_acl_equal __P((SEC_ACL *s1, SEC_ACL *s2));
BOOL sec_desc_equal __P((SEC_DESC *s1, SEC_DESC *s2));
SEC_DESC_BUF *sec_desc_merge __P((TALLOC_CTX *ctx, SEC_DESC_BUF *new_sdb, SEC_DESC_BUF *old_sdb));
SEC_DESC *make_sec_desc __P((TALLOC_CTX *ctx, uint16 revision, 
			DOM_SID *owner_sid, DOM_SID *grp_sid,
			SEC_ACL *sacl, SEC_ACL *dacl, size_t *sd_size));
SEC_DESC *dup_sec_desc __P(( TALLOC_CTX *ctx, SEC_DESC *src));
SEC_DESC *make_standard_sec_desc __P((TALLOC_CTX *ctx, DOM_SID *owner_sid, DOM_SID *grp_sid,
				 SEC_ACL *dacl, size_t *sd_size));
BOOL sec_io_desc __P((const char *desc, SEC_DESC **ppsd, prs_struct *ps, int depth));
SEC_DESC_BUF *make_sec_desc_buf __P((TALLOC_CTX *ctx, size_t len, SEC_DESC *sec_desc));
SEC_DESC_BUF *dup_sec_desc_buf __P((TALLOC_CTX *ctx, SEC_DESC_BUF *src));
BOOL sec_io_desc_buf __P((const char *desc, SEC_DESC_BUF **ppsdb, prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_spoolss.c  */

BOOL make_systemtime __P((SYSTEMTIME *systime, struct tm *unixtime));
BOOL smb_io_notify_info_data_strings __P((const char *desc,SPOOL_NOTIFY_INFO_DATA *data,
                                     prs_struct *ps, int depth));
BOOL spoolss_io_devmode __P((const char *desc, prs_struct *ps, int depth, DEVICEMODE *devmode));
BOOL make_spoolss_q_open_printer_ex __P((SPOOL_Q_OPEN_PRINTER_EX *q_u,
		const char *printername, 
		const char *datatype, 
		uint32 access_required,
		const fstring clientname,
		const fstring user_name));
BOOL make_spoolss_q_addprinterex __P((
	TALLOC_CTX *mem_ctx,
	SPOOL_Q_ADDPRINTEREX *q_u, 
	const char *srv_name,
	const char* clientname, 
	const char* user_name,
	uint32 level, 
	PRINTER_INFO_CTR *ctr));
BOOL make_spoolss_printer_info_2 __P((TALLOC_CTX *mem_ctx, SPOOL_PRINTER_INFO_LEVEL_2 **spool_info2, 
				PRINTER_INFO_2 *info));
BOOL spoolss_io_q_open_printer __P((const char *desc, SPOOL_Q_OPEN_PRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_open_printer __P((const char *desc, SPOOL_R_OPEN_PRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_open_printer_ex __P((const char *desc, SPOOL_Q_OPEN_PRINTER_EX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_open_printer_ex __P((const char *desc, SPOOL_R_OPEN_PRINTER_EX *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_deleteprinterdriver __P((
	TALLOC_CTX *mem_ctx,
	SPOOL_Q_DELETEPRINTERDRIVER *q_u, 
	const char *server,
	const char* arch, 
	const char* driver 
));
BOOL make_spoolss_q_getprinterdata __P((SPOOL_Q_GETPRINTERDATA *q_u,
                                const POLICY_HND *handle,
                                UNISTR2 *valuename, uint32 size));
BOOL spoolss_io_q_getprinterdata __P((const char *desc, SPOOL_Q_GETPRINTERDATA *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_deleteprinterdata __P((const char *desc, SPOOL_Q_DELETEPRINTERDATA *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_deleteprinterdata __P((const char *desc, SPOOL_R_DELETEPRINTERDATA *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprinterdata __P((const char *desc, SPOOL_R_GETPRINTERDATA *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_closeprinter __P((SPOOL_Q_CLOSEPRINTER *q_u, POLICY_HND *hnd));
BOOL spoolss_io_q_abortprinter __P((const char *desc, SPOOL_Q_ABORTPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_abortprinter __P((const char *desc, SPOOL_R_ABORTPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_deleteprinter __P((const char *desc, SPOOL_Q_DELETEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_deleteprinter __P((const char *desc, SPOOL_R_DELETEPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_deleteprinterdriver __P((const char *desc, SPOOL_Q_DELETEPRINTERDRIVER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_deleteprinterdriver __P((const char *desc, SPOOL_R_DELETEPRINTERDRIVER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_closeprinter __P((const char *desc, SPOOL_Q_CLOSEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_closeprinter __P((const char *desc, SPOOL_R_CLOSEPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_startdocprinter __P((const char *desc, SPOOL_Q_STARTDOCPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_startdocprinter __P((const char *desc, SPOOL_R_STARTDOCPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enddocprinter __P((const char *desc, SPOOL_Q_ENDDOCPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enddocprinter __P((const char *desc, SPOOL_R_ENDDOCPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_startpageprinter __P((const char *desc, SPOOL_Q_STARTPAGEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_startpageprinter __P((const char *desc, SPOOL_R_STARTPAGEPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_endpageprinter __P((const char *desc, SPOOL_Q_ENDPAGEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_endpageprinter __P((const char *desc, SPOOL_R_ENDPAGEPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_writeprinter __P((const char *desc, SPOOL_Q_WRITEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_writeprinter __P((const char *desc, SPOOL_R_WRITEPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_rffpcnex __P((const char *desc, SPOOL_Q_RFFPCNEX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_rffpcnex __P((const char *desc, SPOOL_R_RFFPCNEX *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_rfnpcnex __P((const char *desc, SPOOL_Q_RFNPCNEX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_rfnpcnex __P((const char *desc, SPOOL_R_RFNPCNEX *r_u, prs_struct *ps, int depth));
BOOL smb_io_printer_info_0 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_0 *info, int depth));
BOOL smb_io_printer_info_1 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_1 *info, int depth));
BOOL smb_io_printer_info_2 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_2 *info, int depth));
BOOL smb_io_printer_info_3 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_3 *info, int depth));
BOOL smb_io_printer_info_4 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_4 *info, int depth));
BOOL smb_io_printer_info_5 __P((const char *desc, NEW_BUFFER *buffer, PRINTER_INFO_5 *info, int depth));
BOOL smb_io_port_info_1 __P((const char *desc, NEW_BUFFER *buffer, PORT_INFO_1 *info, int depth));
BOOL smb_io_port_info_2 __P((const char *desc, NEW_BUFFER *buffer, PORT_INFO_2 *info, int depth));
BOOL smb_io_printer_driver_info_1 __P((const char *desc, NEW_BUFFER *buffer, DRIVER_INFO_1 *info, int depth) );
BOOL smb_io_printer_driver_info_2 __P((const char *desc, NEW_BUFFER *buffer, DRIVER_INFO_2 *info, int depth) );
BOOL smb_io_printer_driver_info_3 __P((const char *desc, NEW_BUFFER *buffer, DRIVER_INFO_3 *info, int depth));
BOOL smb_io_printer_driver_info_6 __P((const char *desc, NEW_BUFFER *buffer, DRIVER_INFO_6 *info, int depth));
BOOL smb_io_job_info_1 __P((const char *desc, NEW_BUFFER *buffer, JOB_INFO_1 *info, int depth));
BOOL smb_io_job_info_2 __P((const char *desc, NEW_BUFFER *buffer, JOB_INFO_2 *info, int depth));
BOOL smb_io_form_1 __P((const char *desc, NEW_BUFFER *buffer, FORM_1 *info, int depth));
void spoolss_move_buffer __P((NEW_BUFFER *src, NEW_BUFFER **dest));
uint32 new_get_buffer_size __P((NEW_BUFFER *buffer));
BOOL smb_io_driverdir_1 __P((const char *desc, NEW_BUFFER *buffer, DRIVER_DIRECTORY_1 *info, int depth));
BOOL smb_io_port_1 __P((const char *desc, NEW_BUFFER *buffer, PORT_INFO_1 *info, int depth));
BOOL smb_io_port_2 __P((const char *desc, NEW_BUFFER *buffer, PORT_INFO_2 *info, int depth));
BOOL smb_io_printprocessor_info_1 __P((const char *desc, NEW_BUFFER *buffer, PRINTPROCESSOR_1 *info, int depth));
BOOL smb_io_printprocdatatype_info_1 __P((const char *desc, NEW_BUFFER *buffer, PRINTPROCDATATYPE_1 *info, int depth));
BOOL smb_io_printmonitor_info_1 __P((const char *desc, NEW_BUFFER *buffer, PRINTMONITOR_1 *info, int depth));
BOOL smb_io_printmonitor_info_2 __P((const char *desc, NEW_BUFFER *buffer, PRINTMONITOR_2 *info, int depth));
uint32 spoolss_size_printer_info_0 __P((PRINTER_INFO_0 *info));
uint32 spoolss_size_printer_info_1 __P((PRINTER_INFO_1 *info));
uint32 spoolss_size_printer_info_2 __P((PRINTER_INFO_2 *info));
uint32 spoolss_size_printer_info_4 __P((PRINTER_INFO_4 *info));
uint32 spoolss_size_printer_info_5 __P((PRINTER_INFO_5 *info));
uint32 spoolss_size_printer_info_3 __P((PRINTER_INFO_3 *info));
uint32 spoolss_size_printer_driver_info_1 __P((DRIVER_INFO_1 *info));
uint32 spoolss_size_printer_driver_info_2 __P((DRIVER_INFO_2 *info));
uint32 spoolss_size_string_array __P((uint16 *string));
uint32 spoolss_size_printer_driver_info_3 __P((DRIVER_INFO_3 *info));
uint32 spoolss_size_printer_driver_info_6 __P((DRIVER_INFO_6 *info));
uint32 spoolss_size_job_info_1 __P((JOB_INFO_1 *info));
uint32 spoolss_size_job_info_2 __P((JOB_INFO_2 *info));
uint32 spoolss_size_form_1 __P((FORM_1 *info));
uint32 spoolss_size_port_info_1 __P((PORT_INFO_1 *info));
uint32 spoolss_size_driverdir_info_1 __P((DRIVER_DIRECTORY_1 *info));
uint32 spoolss_size_printprocessordirectory_info_1 __P((PRINTPROCESSOR_DIRECTORY_1 *info));
uint32 spoolss_size_port_info_2 __P((PORT_INFO_2 *info));
uint32 spoolss_size_printprocessor_info_1 __P((PRINTPROCESSOR_1 *info));
uint32 spoolss_size_printprocdatatype_info_1 __P((PRINTPROCDATATYPE_1 *info));
uint32 spoolss_size_printer_enum_values __P((PRINTER_ENUM_VALUES *p));
uint32 spoolss_size_printmonitor_info_1 __P((PRINTMONITOR_1 *info));
uint32 spoolss_size_printmonitor_info_2 __P((PRINTMONITOR_2 *info));
BOOL make_spoolss_q_getprinterdriver2 __P((SPOOL_Q_GETPRINTERDRIVER2 *q_u, 
			       const POLICY_HND *hnd,
			       const char *architecture,
			       uint32 level, uint32 clientmajor, uint32 clientminor,
			       NEW_BUFFER *buffer, uint32 offered));
BOOL spoolss_io_q_getprinterdriver2 __P((const char *desc, SPOOL_Q_GETPRINTERDRIVER2 *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprinterdriver2 __P((const char *desc, SPOOL_R_GETPRINTERDRIVER2 *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_enumprinters __P((
	SPOOL_Q_ENUMPRINTERS *q_u, 
	uint32 flags, 
	fstring servername, 
	uint32 level, 
	NEW_BUFFER *buffer, 
	uint32 offered
));
BOOL make_spoolss_q_enumports __P((SPOOL_Q_ENUMPORTS *q_u, 
				fstring servername, uint32 level, 
				NEW_BUFFER *buffer, uint32 offered));
BOOL spoolss_io_q_enumprinters __P((const char *desc, SPOOL_Q_ENUMPRINTERS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprinters __P((const char *desc, SPOOL_R_ENUMPRINTERS *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprinter __P((const char *desc, SPOOL_R_GETPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_getprinter __P((const char *desc, SPOOL_Q_GETPRINTER *q_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_getprinter __P((
	TALLOC_CTX *mem_ctx,
	SPOOL_Q_GETPRINTER *q_u, 
	const POLICY_HND *hnd, 
	uint32 level, 
	NEW_BUFFER *buffer, 
	uint32 offered
));
BOOL make_spoolss_q_setprinter __P((TALLOC_CTX *mem_ctx, SPOOL_Q_SETPRINTER *q_u, 
				const POLICY_HND *hnd, uint32 level, PRINTER_INFO_CTR *info, 
				uint32 command));
BOOL spoolss_io_r_setprinter __P((const char *desc, SPOOL_R_SETPRINTER *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_setprinter __P((const char *desc, SPOOL_Q_SETPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_fcpn __P((const char *desc, SPOOL_R_FCPN *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_fcpn __P((const char *desc, SPOOL_Q_FCPN *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_addjob __P((const char *desc, SPOOL_R_ADDJOB *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_addjob __P((const char *desc, SPOOL_Q_ADDJOB *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumjobs __P((const char *desc, SPOOL_R_ENUMJOBS *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_enumjobs __P((SPOOL_Q_ENUMJOBS *q_u, const POLICY_HND *hnd,
				uint32 firstjob,
				uint32 numofjobs,
				uint32 level,
				NEW_BUFFER *buffer,
				uint32 offered));
BOOL spoolss_io_q_enumjobs __P((const char *desc, SPOOL_Q_ENUMJOBS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_schedulejob __P((const char *desc, SPOOL_R_SCHEDULEJOB *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_schedulejob __P((const char *desc, SPOOL_Q_SCHEDULEJOB *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_setjob __P((const char *desc, SPOOL_R_SETJOB *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_setjob __P((const char *desc, SPOOL_Q_SETJOB *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprinterdrivers __P((const char *desc, SPOOL_R_ENUMPRINTERDRIVERS *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_enumprinterdrivers __P((SPOOL_Q_ENUMPRINTERDRIVERS *q_u,
                                const char *name,
                                const char *environment,
                                uint32 level,
                                NEW_BUFFER *buffer, uint32 offered));
BOOL spoolss_io_q_enumprinterdrivers __P((const char *desc, SPOOL_Q_ENUMPRINTERDRIVERS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumforms __P((const char *desc, SPOOL_Q_ENUMFORMS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumforms __P((const char *desc, SPOOL_R_ENUMFORMS *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_getform __P((const char *desc, SPOOL_Q_GETFORM *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getform __P((const char *desc, SPOOL_R_GETFORM *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumports __P((const char *desc, SPOOL_R_ENUMPORTS *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumports __P((const char *desc, SPOOL_Q_ENUMPORTS *q_u, prs_struct *ps, int depth));
BOOL spool_io_printer_info_level_1 __P((const char *desc, SPOOL_PRINTER_INFO_LEVEL_1 *il, prs_struct *ps, int depth));
BOOL spool_io_printer_info_level_3 __P((const char *desc, SPOOL_PRINTER_INFO_LEVEL_3 *il, prs_struct *ps, int depth));
BOOL spool_io_printer_info_level_2 __P((const char *desc, SPOOL_PRINTER_INFO_LEVEL_2 *il, prs_struct *ps, int depth));
BOOL spool_io_printer_info_level __P((const char *desc, SPOOL_PRINTER_INFO_LEVEL *il, prs_struct *ps, int depth));
BOOL spoolss_io_q_addprinterex __P((const char *desc, SPOOL_Q_ADDPRINTEREX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_addprinterex __P((const char *desc, SPOOL_R_ADDPRINTEREX *r_u, 
			       prs_struct *ps, int depth));
BOOL spool_io_printer_driver_info_level_3 __P((const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 **q_u, 
                                          prs_struct *ps, int depth));
BOOL spool_io_printer_driver_info_level_6 __P((const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL_6 **q_u, 
                                          prs_struct *ps, int depth));
BOOL smb_io_unibuffer __P((const char *desc, UNISTR2 *buffer, prs_struct *ps, int depth));
BOOL spool_io_printer_driver_info_level __P((const char *desc, SPOOL_PRINTER_DRIVER_INFO_LEVEL *il, prs_struct *ps, int depth));
BOOL make_spoolss_q_addprinterdriver __P((TALLOC_CTX *mem_ctx,
				SPOOL_Q_ADDPRINTERDRIVER *q_u, const char* srv_name, 
				uint32 level, PRINTER_DRIVER_CTR *info));
BOOL make_spoolss_driver_info_3 __P((TALLOC_CTX *mem_ctx, 
				SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 **spool_drv_info,
				DRIVER_INFO_3 *info3));
BOOL make_spoolss_buffer5 __P((TALLOC_CTX *mem_ctx, BUFFER5 *buf5, uint32 len, uint16 *src));
BOOL spoolss_io_q_addprinterdriver __P((const char *desc, SPOOL_Q_ADDPRINTERDRIVER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_addprinterdriver __P((const char *desc, SPOOL_R_ADDPRINTERDRIVER *q_u, prs_struct *ps, int depth));
BOOL uni_2_asc_printer_driver_3 __P((SPOOL_PRINTER_DRIVER_INFO_LEVEL_3 *uni,
                                NT_PRINTER_DRIVER_INFO_LEVEL_3 **asc));
BOOL uni_2_asc_printer_driver_6 __P((SPOOL_PRINTER_DRIVER_INFO_LEVEL_6 *uni,
                                NT_PRINTER_DRIVER_INFO_LEVEL_6 **asc));
BOOL uni_2_asc_printer_info_2 __P((const SPOOL_PRINTER_INFO_LEVEL_2 *uni,
                              NT_PRINTER_INFO_LEVEL_2  **asc));
BOOL make_spoolss_q_getprinterdriverdir __P((SPOOL_Q_GETPRINTERDRIVERDIR *q_u,
                                fstring servername, fstring env_name, uint32 level,
                                NEW_BUFFER *buffer, uint32 offered));
BOOL spoolss_io_q_getprinterdriverdir __P((const char *desc, SPOOL_Q_GETPRINTERDRIVERDIR *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprinterdriverdir __P((const char *desc, SPOOL_R_GETPRINTERDRIVERDIR *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprintprocessors __P((const char *desc, SPOOL_R_ENUMPRINTPROCESSORS *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprintprocessors __P((const char *desc, SPOOL_Q_ENUMPRINTPROCESSORS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_addprintprocessor __P((const char *desc, SPOOL_Q_ADDPRINTPROCESSOR *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_addprintprocessor __P((const char *desc, SPOOL_R_ADDPRINTPROCESSOR *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprintprocdatatypes __P((const char *desc, SPOOL_R_ENUMPRINTPROCDATATYPES *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprintprocdatatypes __P((const char *desc, SPOOL_Q_ENUMPRINTPROCDATATYPES *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprintmonitors __P((const char *desc, SPOOL_Q_ENUMPRINTMONITORS *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprintmonitors __P((const char *desc, SPOOL_R_ENUMPRINTMONITORS *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprinterdata __P((const char *desc, SPOOL_R_ENUMPRINTERDATA *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprinterdata __P((const char *desc, SPOOL_Q_ENUMPRINTERDATA *q_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_enumprinterdata __P((SPOOL_Q_ENUMPRINTERDATA *q_u,
		const POLICY_HND *hnd,
		uint32 idx, uint32 valuelen, uint32 datalen));
BOOL make_spoolss_q_setprinterdata __P((SPOOL_Q_SETPRINTERDATA *q_u, TALLOC_CTX *ctx, const POLICY_HND *hnd,
				char* value, char* data));
BOOL spoolss_io_q_setprinterdata __P((const char *desc, SPOOL_Q_SETPRINTERDATA *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_setprinterdata __P((const char *desc, SPOOL_R_SETPRINTERDATA *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_resetprinter __P((const char *desc, SPOOL_Q_RESETPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_resetprinter __P((const char *desc, SPOOL_R_RESETPRINTER *r_u, prs_struct *ps, int depth));
BOOL convert_specific_param __P((NT_PRINTER_PARAM **param, const UNISTR2 *value,
				uint32 type, const uint8 *data, uint32 len));
BOOL spoolss_io_q_deleteform __P((const char *desc, SPOOL_Q_DELETEFORM *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_deleteform __P((const char *desc, SPOOL_R_DELETEFORM *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_addform __P((const char *desc, SPOOL_Q_ADDFORM *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_addform __P((const char *desc, SPOOL_R_ADDFORM *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_setform __P((const char *desc, SPOOL_Q_SETFORM *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_setform __P((const char *desc, SPOOL_R_SETFORM *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getjob __P((const char *desc, SPOOL_R_GETJOB *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_getjob __P((const char *desc, SPOOL_Q_GETJOB *q_u, prs_struct *ps, int depth));
void free_devmode __P((DEVICEMODE *devmode));
void free_printer_info_1 __P((PRINTER_INFO_1 *printer));
void free_printer_info_2 __P((PRINTER_INFO_2 *printer));
void free_printer_info_3 __P((PRINTER_INFO_3 *printer));
void free_printer_info_4 __P((PRINTER_INFO_4 *printer));
void free_printer_info_5 __P((PRINTER_INFO_5 *printer));
void free_job_info_2 __P((JOB_INFO_2 *job));
BOOL make_spoolss_q_replyopenprinter __P((SPOOL_Q_REPLYOPENPRINTER *q_u, 
			       const fstring string, uint32 printer, uint32 type));
BOOL spoolss_io_q_replyopenprinter __P((const char *desc, SPOOL_Q_REPLYOPENPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_replyopenprinter __P((const char *desc, SPOOL_R_REPLYOPENPRINTER *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_routerreplyprinter __P((SPOOL_Q_ROUTERREPLYPRINTER *q_u, POLICY_HND *hnd, 
					uint32 condition, uint32 change_id));
BOOL spoolss_io_q_routerreplyprinter  __P((const char *desc, SPOOL_Q_ROUTERREPLYPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_routerreplyprinter  __P((const char *desc, SPOOL_R_ROUTERREPLYPRINTER *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_reply_closeprinter __P((SPOOL_Q_REPLYCLOSEPRINTER *q_u, POLICY_HND *hnd));
BOOL spoolss_io_q_replycloseprinter __P((const char *desc, SPOOL_Q_REPLYCLOSEPRINTER *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_replycloseprinter __P((const char *desc, SPOOL_R_REPLYCLOSEPRINTER *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_reply_rrpcn __P((SPOOL_Q_REPLY_RRPCN *q_u, POLICY_HND *hnd,
			        uint32 change_low, uint32 change_high,
				SPOOL_NOTIFY_INFO *info));
BOOL spoolss_io_q_reply_rrpcn __P((const char *desc, SPOOL_Q_REPLY_RRPCN *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_reply_rrpcn __P((const char *desc, SPOOL_R_REPLY_RRPCN *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_getprinterdataex __P((const char *desc, SPOOL_Q_GETPRINTERDATAEX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprinterdataex __P((const char *desc, SPOOL_R_GETPRINTERDATAEX *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_setprinterdataex __P((const char *desc, SPOOL_Q_SETPRINTERDATAEX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_setprinterdataex __P((const char *desc, SPOOL_R_SETPRINTERDATAEX *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprinterkey __P((const char *desc, SPOOL_Q_ENUMPRINTERKEY *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprinterkey __P((const char *desc, SPOOL_R_ENUMPRINTERKEY *r_u, prs_struct *ps, int depth));
BOOL spoolss_io_q_enumprinterdataex __P((const char *desc, SPOOL_Q_ENUMPRINTERDATAEX *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_enumprinterdataex __P((const char *desc, SPOOL_R_ENUMPRINTERDATAEX *r_u, prs_struct *ps, int depth));
BOOL make_spoolss_q_getprintprocessordirectory __P((SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, const char *name, char *environment, int level, NEW_BUFFER *buffer, uint32 offered));
BOOL spoolss_io_q_getprintprocessordirectory __P((const char *desc, SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, prs_struct *ps, int depth));
BOOL spoolss_io_r_getprintprocessordirectory __P((const char *desc, SPOOL_R_GETPRINTPROCESSORDIRECTORY *r_u, prs_struct *ps, int depth));
BOOL smb_io_printprocessordirectory_1 __P((const char *desc, NEW_BUFFER *buffer, PRINTPROCESSOR_DIRECTORY_1 *info, int depth));
BOOL make_spoolss_q_addform __P((SPOOL_Q_ADDFORM *q_u, POLICY_HND *handle, 
			    int level, FORM *form));
BOOL make_spoolss_q_setform __P((SPOOL_Q_SETFORM *q_u, POLICY_HND *handle, 
			    int level, char *form_name, FORM *form));
BOOL make_spoolss_q_deleteform __P((SPOOL_Q_DELETEFORM *q_u, POLICY_HND *handle, char *form));
BOOL make_spoolss_q_getform __P((SPOOL_Q_GETFORM *q_u, POLICY_HND *handle, 
                            char *formname, uint32 level, NEW_BUFFER *buffer,
			    uint32 offered));
BOOL make_spoolss_q_enumforms __P((SPOOL_Q_ENUMFORMS *q_u, POLICY_HND *handle, 
			      uint32 level, NEW_BUFFER *buffer,
			      uint32 offered));

/* The following definitions come from rpc_parse/parse_srv.c  */

void init_srv_share_info1_str __P((SH_INFO_1_STR *sh1, const char *net_name, const char *remark));
void init_srv_share_info1 __P((SH_INFO_1 *sh1, const char *net_name, uint32 type, const char *remark));
void init_srv_share_info2_str __P((SH_INFO_2_STR *sh2,
				const char *net_name, const char *remark,
				const char *path, const char *passwd));
void init_srv_share_info2 __P((SH_INFO_2 *sh2,
				const char *net_name, uint32 type, const char *remark,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				const char *path, const char *passwd));
void init_srv_share_info501 __P((SH_INFO_501 *sh501, const char *net_name, uint32 type, const char *remark, uint32 csc_policy));
void init_srv_share_info501_str __P((SH_INFO_501_STR *sh501, const char *net_name, const char *remark));
void init_srv_share_info502 __P((SH_INFO_502 *sh502,
				const char *net_name, uint32 type, const char *remark,
				uint32 perms, uint32 max_uses, uint32 num_uses,
				const char *path, const char *passwd, SEC_DESC *psd, size_t sd_size));
void init_srv_share_info502_str __P((SH_INFO_502_STR *sh502str,
				SH_INFO_502 *ptrs,
				const char *net_name, const char *remark,
				const char *path, const char *passwd, SEC_DESC *psd, size_t sd_size));
void init_srv_q_net_share_enum __P((SRV_Q_NET_SHARE_ENUM *q_n, 
				const char *srv_name, uint32 info_level,
				uint32 preferred_len, ENUM_HND *hnd));
BOOL srv_io_q_net_share_enum __P((const char *desc, SRV_Q_NET_SHARE_ENUM *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_share_enum __P((const char *desc, SRV_R_NET_SHARE_ENUM *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_share_get_info __P((const char *desc, SRV_Q_NET_SHARE_GET_INFO *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_share_get_info __P((const char *desc, SRV_R_NET_SHARE_GET_INFO *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_share_set_info __P((const char *desc, SRV_Q_NET_SHARE_SET_INFO *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_share_set_info __P((const char *desc, SRV_R_NET_SHARE_SET_INFO *q_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_share_add __P((const char *desc, SRV_Q_NET_SHARE_ADD *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_share_add __P((const char *desc, SRV_R_NET_SHARE_ADD *q_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_share_del __P((const char *desc, SRV_Q_NET_SHARE_DEL *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_share_del __P((const char *desc, SRV_R_NET_SHARE_DEL *q_n, prs_struct *ps, int depth));
void init_srv_sess_info0_str __P((SESS_INFO_0_STR *ss0, const char *name));
void init_srv_sess_info0 __P((SESS_INFO_0 *ss0, const char *name));
void init_srv_sess_info1_str __P((SESS_INFO_1_STR *ss1, const char *name, const char *user));
void init_srv_sess_info1 __P((SESS_INFO_1 *ss1, 
				const char *name, const char *user,
				uint32 num_opens, uint32 open_time, uint32 idle_time,
				uint32 user_flags));
void init_srv_q_net_sess_enum __P((SRV_Q_NET_SESS_ENUM *q_n, 
				const char *srv_name, const char *qual_name,
				uint32 sess_level, SRV_SESS_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd));
BOOL srv_io_q_net_sess_enum __P((const char *desc, SRV_Q_NET_SESS_ENUM *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_sess_enum __P((const char *desc, SRV_R_NET_SESS_ENUM *r_n, prs_struct *ps, int depth));
void init_srv_conn_info0 __P((CONN_INFO_0 *ss0, uint32 id));
void init_srv_conn_info1_str __P((CONN_INFO_1_STR *ss1, const char *usr_name, const char *net_name));
void init_srv_conn_info1 __P((CONN_INFO_1 *ss1, 
				uint32 id, uint32 type,
				uint32 num_opens, uint32 num_users, uint32 open_time,
				const char *usr_name, const char *net_name));
void init_srv_q_net_conn_enum __P((SRV_Q_NET_CONN_ENUM *q_n, 
				const char *srv_name, const char *qual_name,
				uint32 conn_level, SRV_CONN_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd));
BOOL srv_io_q_net_conn_enum __P((const char *desc, SRV_Q_NET_CONN_ENUM *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_conn_enum __P((const char *desc,  SRV_R_NET_CONN_ENUM *r_n, prs_struct *ps, int depth));
void init_srv_file_info3_str __P((FILE_INFO_3_STR *fi3, const char *user_name, const char *path_name));
void init_srv_file_info3 __P((FILE_INFO_3 *fl3,
				uint32 id, uint32 perms, uint32 num_locks,
				const char *path_name, const char *user_name));
void init_srv_q_net_file_enum __P((SRV_Q_NET_FILE_ENUM *q_n, 
				const char *srv_name, const char *qual_name,
				uint32 file_level, SRV_FILE_INFO_CTR *ctr,
				uint32 preferred_len,
				ENUM_HND *hnd));
BOOL srv_io_q_net_file_enum __P((const char *desc, SRV_Q_NET_FILE_ENUM *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_file_enum __P((const char *desc, SRV_R_NET_FILE_ENUM *r_n, prs_struct *ps, int depth));
void init_srv_info_100 __P((SRV_INFO_100 *sv100, uint32 platform_id, const char *name));
void init_srv_info_101 __P((SRV_INFO_101 *sv101, uint32 platform_id, const char *name,
				uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, const char *comment));
void init_srv_info_102 __P((SRV_INFO_102 *sv102, uint32 platform_id, const char *name,
				const char *comment, uint32 ver_major, uint32 ver_minor,
				uint32 srv_type, uint32 users, uint32 disc, uint32 hidden,
				uint32 announce, uint32 ann_delta, uint32 licenses,
				const char *usr_path));
void init_srv_q_net_srv_get_info __P((SRV_Q_NET_SRV_GET_INFO *srv,
				const char *server_name, uint32 switch_value));
BOOL srv_io_q_net_srv_get_info __P((const char *desc, SRV_Q_NET_SRV_GET_INFO *q_n, prs_struct *ps, int depth));
void init_srv_r_net_srv_get_info __P((SRV_R_NET_SRV_GET_INFO *srv,
				uint32 switch_value, SRV_INFO_CTR *ctr, WERROR status));
void init_srv_r_net_srv_set_info __P((SRV_R_NET_SRV_SET_INFO *srv,
				 uint32 switch_value, WERROR status));
BOOL srv_io_q_net_srv_set_info __P((const char *desc, SRV_Q_NET_SRV_SET_INFO *q_n, 
			       prs_struct *ps, int depth));
BOOL srv_io_r_net_srv_get_info __P((const char *desc, SRV_R_NET_SRV_GET_INFO *r_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_srv_set_info __P((const char *desc, SRV_R_NET_SRV_SET_INFO *r_n, 
			       prs_struct *ps, int depth));
BOOL srv_io_q_net_remote_tod __P((const char *desc, SRV_Q_NET_REMOTE_TOD *q_n, prs_struct *ps, int depth));
void init_time_of_day_info __P((TIME_OF_DAY_INFO *tod, uint32 elapsedt, uint32 msecs,
                           uint32 hours, uint32 mins, uint32 secs, uint32 hunds,
			   uint32 zone, uint32 tintervals, uint32 day,
			   uint32 month, uint32 year, uint32 weekday));
BOOL srv_io_r_net_remote_tod __P((const char *desc, SRV_R_NET_REMOTE_TOD *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_disk_enum __P((const char *desc, SRV_Q_NET_DISK_ENUM *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_disk_enum __P((const char *desc, SRV_R_NET_DISK_ENUM *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_name_validate __P((const char *desc, SRV_Q_NET_NAME_VALIDATE *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_name_validate __P((const char *desc, SRV_R_NET_NAME_VALIDATE *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_file_query_secdesc __P((const char *desc, SRV_Q_NET_FILE_QUERY_SECDESC *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_file_query_secdesc __P((const char *desc, SRV_R_NET_FILE_QUERY_SECDESC *r_n, prs_struct *ps, int depth));
BOOL srv_io_q_net_file_set_secdesc __P((const char *desc, SRV_Q_NET_FILE_SET_SECDESC *q_n, prs_struct *ps, int depth));
BOOL srv_io_r_net_file_set_secdesc __P((const char *desc, SRV_R_NET_FILE_SET_SECDESC *r_n, prs_struct *ps, int depth));

/* The following definitions come from rpc_parse/parse_wks.c  */

void init_wks_q_query_info __P((WKS_Q_QUERY_INFO *q_u,
				const char *server, uint16 switch_value)  );
BOOL wks_io_q_query_info __P((const char *desc, WKS_Q_QUERY_INFO *q_u, prs_struct *ps, int depth));
void init_wks_info_100 __P((WKS_INFO_100 *inf,
				uint32 platform_id, uint32 ver_major, uint32 ver_minor,
				const char *my_name, const char *domain_name));
void init_wks_r_query_info __P((WKS_R_QUERY_INFO *r_u,
			   uint32 switch_value, WKS_INFO_100 *wks100,
			   NTSTATUS status)  );
BOOL wks_io_r_query_info __P((const char *desc, WKS_R_QUERY_INFO *r_u, prs_struct *ps, int depth));

/* The following definitions come from rpc_server/srv_dfs.c  */

BOOL api_netdfs_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_dfs_nt.c  */

uint32 _dfs_exist __P((pipes_struct *p, DFS_Q_DFS_EXIST *q_u, DFS_R_DFS_EXIST *r_u));
WERROR _dfs_add __P((pipes_struct *p, DFS_Q_DFS_ADD* q_u, DFS_R_DFS_ADD *r_u));
WERROR _dfs_remove __P((pipes_struct *p, DFS_Q_DFS_REMOVE *q_u, 
                   DFS_R_DFS_REMOVE *r_u));
WERROR _dfs_enum __P((pipes_struct *p, DFS_Q_DFS_ENUM *q_u, DFS_R_DFS_ENUM *r_u));
WERROR _dfs_get_info __P((pipes_struct *p, DFS_Q_DFS_GET_INFO *q_u, 
                     DFS_R_DFS_GET_INFO *r_u));

/* The following definitions come from rpc_server/srv_lsa.c  */

BOOL api_ntlsa_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_lsa_hnd.c  */

BOOL init_pipe_handle_list __P((pipes_struct *p, char *pipe_name));
BOOL create_policy_hnd __P((pipes_struct *p, POLICY_HND *hnd, void (*free_fn)(void *), void *data_ptr));
BOOL find_policy_by_hnd __P((pipes_struct *p, POLICY_HND *hnd, void **data_p));
BOOL close_policy_hnd __P((pipes_struct *p, POLICY_HND *hnd));
void close_policy_by_pipe __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_lsa_nt.c  */

NTSTATUS _lsa_open_policy2 __P((pipes_struct *p, LSA_Q_OPEN_POL2 *q_u, LSA_R_OPEN_POL2 *r_u));
NTSTATUS _lsa_open_policy __P((pipes_struct *p, LSA_Q_OPEN_POL *q_u, LSA_R_OPEN_POL *r_u));
NTSTATUS _lsa_enum_trust_dom __P((pipes_struct *p, LSA_Q_ENUM_TRUST_DOM *q_u, LSA_R_ENUM_TRUST_DOM *r_u));
NTSTATUS _lsa_query_info __P((pipes_struct *p, LSA_Q_QUERY_INFO *q_u, LSA_R_QUERY_INFO *r_u));
NTSTATUS _lsa_lookup_sids __P((pipes_struct *p, LSA_Q_LOOKUP_SIDS *q_u, LSA_R_LOOKUP_SIDS *r_u));
NTSTATUS _lsa_lookup_names __P((pipes_struct *p,LSA_Q_LOOKUP_NAMES *q_u, LSA_R_LOOKUP_NAMES *r_u));
NTSTATUS _lsa_close __P((pipes_struct *p, LSA_Q_CLOSE *q_u, LSA_R_CLOSE *r_u));
NTSTATUS _lsa_open_secret __P((pipes_struct *p, LSA_Q_OPEN_SECRET *q_u, LSA_R_OPEN_SECRET *r_u));
NTSTATUS _lsa_enum_privs __P((pipes_struct *p, LSA_Q_ENUM_PRIVS *q_u, LSA_R_ENUM_PRIVS *r_u));
NTSTATUS _lsa_priv_get_dispname __P((pipes_struct *p, LSA_Q_PRIV_GET_DISPNAME *q_u, LSA_R_PRIV_GET_DISPNAME *r_u));
NTSTATUS _lsa_unk_get_connuser __P((pipes_struct *p, LSA_Q_UNK_GET_CONNUSER *q_u, LSA_R_UNK_GET_CONNUSER *r_u));
NTSTATUS _lsa_open_account __P((pipes_struct *p, LSA_Q_OPENACCOUNT *q_u, LSA_R_OPENACCOUNT *r_u));
NTSTATUS _lsa_getsystemaccount __P((pipes_struct *p, LSA_Q_GETSYSTEMACCOUNT *q_u, LSA_R_GETSYSTEMACCOUNT *r_u));

/* The following definitions come from rpc_server/srv_netlog.c  */

BOOL api_netlog_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_netlog_nt.c  */

NTSTATUS _net_logon_ctrl __P((pipes_struct *p, NET_Q_LOGON_CTRL *q_u, 
		       NET_R_LOGON_CTRL *r_u));
NTSTATUS _net_logon_ctrl2 __P((pipes_struct *p, NET_Q_LOGON_CTRL2 *q_u, NET_R_LOGON_CTRL2 *r_u));
NTSTATUS _net_trust_dom_list __P((pipes_struct *p, NET_Q_TRUST_DOM_LIST *q_u, NET_R_TRUST_DOM_LIST *r_u));
NTSTATUS _net_req_chal __P((pipes_struct *p, NET_Q_REQ_CHAL *q_u, NET_R_REQ_CHAL *r_u));
NTSTATUS _net_auth __P((pipes_struct *p, NET_Q_AUTH *q_u, NET_R_AUTH *r_u));
NTSTATUS _net_auth_2 __P((pipes_struct *p, NET_Q_AUTH_2 *q_u, NET_R_AUTH_2 *r_u));
NTSTATUS _net_srv_pwset __P((pipes_struct *p, NET_Q_SRV_PWSET *q_u, NET_R_SRV_PWSET *r_u));
NTSTATUS _net_sam_logoff __P((pipes_struct *p, NET_Q_SAM_LOGOFF *q_u, NET_R_SAM_LOGOFF *r_u));
NTSTATUS _net_sam_logon __P((pipes_struct *p, NET_Q_SAM_LOGON *q_u, NET_R_SAM_LOGON *r_u));

/* The following definitions come from rpc_server/srv_pipe.c  */

BOOL create_next_pdu __P((pipes_struct *p));
BOOL api_pipe_bind_auth_resp __P((pipes_struct *p, prs_struct *rpc_in_p));
BOOL setup_fault_pdu __P((pipes_struct *p, NTSTATUS status));
BOOL check_bind_req __P((char* pipe_name, RPC_IFACE* abstract,
					RPC_IFACE* transfer));
BOOL api_pipe_bind_req __P((pipes_struct *p, prs_struct *rpc_in_p));
BOOL api_pipe_auth_process __P((pipes_struct *p, prs_struct *rpc_in));
struct current_user *get_current_user __P((struct current_user *user, pipes_struct *p));
BOOL api_pipe_request __P((pipes_struct *p));
BOOL api_rpcTNP __P((pipes_struct *p, const char *rpc_name, 
		struct api_struct *api_rpc_cmds));

/* The following definitions come from rpc_server/srv_pipe_hnd.c  */

pipes_struct *get_first_pipe __P((void));
pipes_struct *get_next_pipe __P((pipes_struct *p));
void set_pipe_handle_offset __P((int max_open_files));
void reset_chain_p __P((void));
void init_rpc_pipe_hnd __P((void));
pipes_struct *open_rpc_pipe_p __P((char *pipe_name, 
			      connection_struct *conn, uint16 vuid));
void free_pipe_context __P((pipes_struct *p));
ssize_t write_to_pipe __P((pipes_struct *p, char *data, size_t n));
ssize_t read_from_pipe __P((pipes_struct *p, char *data, size_t n));
BOOL wait_rpc_pipe_hnd_state __P((pipes_struct *p, uint16 priority));
BOOL set_rpc_pipe_hnd_state __P((pipes_struct *p, uint16 device_state));
BOOL close_rpc_pipe_hnd __P((pipes_struct *p, connection_struct *conn));
pipes_struct *get_rpc_pipe_p __P((char *buf, int where));
pipes_struct *get_rpc_pipe __P((int pnum));

/* The following definitions come from rpc_server/srv_reg.c  */

BOOL api_reg_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_reg_nt.c  */

NTSTATUS _reg_close __P((pipes_struct *p, REG_Q_CLOSE *q_u, REG_R_CLOSE *r_u));
NTSTATUS _reg_open __P((pipes_struct *p, REG_Q_OPEN_HKLM *q_u, REG_R_OPEN_HKLM *r_u));
NTSTATUS _reg_open_entry __P((pipes_struct *p, REG_Q_OPEN_ENTRY *q_u, REG_R_OPEN_ENTRY *r_u));
NTSTATUS _reg_info __P((pipes_struct *p, REG_Q_INFO *q_u, REG_R_INFO *r_u));

/* The following definitions come from rpc_server/srv_samr.c  */

BOOL api_samr_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_samr_nt.c  */

NTSTATUS _samr_close_hnd __P((pipes_struct *p, SAMR_Q_CLOSE_HND *q_u, SAMR_R_CLOSE_HND *r_u));
NTSTATUS _samr_open_domain __P((pipes_struct *p, SAMR_Q_OPEN_DOMAIN *q_u, SAMR_R_OPEN_DOMAIN *r_u));
NTSTATUS _samr_get_usrdom_pwinfo __P((pipes_struct *p, SAMR_Q_GET_USRDOM_PWINFO *q_u, SAMR_R_GET_USRDOM_PWINFO *r_u));
NTSTATUS _samr_query_sec_obj __P((pipes_struct *p, SAMR_Q_QUERY_SEC_OBJ *q_u, SAMR_R_QUERY_SEC_OBJ *r_u));
NTSTATUS _samr_enum_dom_users __P((pipes_struct *p, SAMR_Q_ENUM_DOM_USERS *q_u, SAMR_R_ENUM_DOM_USERS *r_u));
NTSTATUS _samr_enum_dom_groups __P((pipes_struct *p, SAMR_Q_ENUM_DOM_GROUPS *q_u, SAMR_R_ENUM_DOM_GROUPS *r_u));
NTSTATUS _samr_enum_dom_aliases __P((pipes_struct *p, SAMR_Q_ENUM_DOM_ALIASES *q_u, SAMR_R_ENUM_DOM_ALIASES *r_u));
NTSTATUS _samr_query_dispinfo __P((pipes_struct *p, SAMR_Q_QUERY_DISPINFO *q_u, SAMR_R_QUERY_DISPINFO *r_u));
NTSTATUS _samr_query_aliasinfo __P((pipes_struct *p, SAMR_Q_QUERY_ALIASINFO *q_u, SAMR_R_QUERY_ALIASINFO *r_u));
NTSTATUS _samr_lookup_names __P((pipes_struct *p, SAMR_Q_LOOKUP_NAMES *q_u, SAMR_R_LOOKUP_NAMES *r_u));
NTSTATUS _samr_chgpasswd_user __P((pipes_struct *p, SAMR_Q_CHGPASSWD_USER *q_u, SAMR_R_CHGPASSWD_USER *r_u));
NTSTATUS _samr_lookup_rids __P((pipes_struct *p, SAMR_Q_LOOKUP_RIDS *q_u, SAMR_R_LOOKUP_RIDS *r_u));
NTSTATUS _api_samr_open_user __P((pipes_struct *p, SAMR_Q_OPEN_USER *q_u, SAMR_R_OPEN_USER *r_u));
NTSTATUS _samr_query_userinfo __P((pipes_struct *p, SAMR_Q_QUERY_USERINFO *q_u, SAMR_R_QUERY_USERINFO *r_u));
NTSTATUS _samr_query_usergroups __P((pipes_struct *p, SAMR_Q_QUERY_USERGROUPS *q_u, SAMR_R_QUERY_USERGROUPS *r_u));
NTSTATUS _samr_query_dom_info __P((pipes_struct *p, SAMR_Q_QUERY_DOMAIN_INFO *q_u, SAMR_R_QUERY_DOMAIN_INFO *r_u));
NTSTATUS _api_samr_create_user __P((pipes_struct *p, SAMR_Q_CREATE_USER *q_u, SAMR_R_CREATE_USER *r_u));
NTSTATUS _samr_connect_anon __P((pipes_struct *p, SAMR_Q_CONNECT_ANON *q_u, SAMR_R_CONNECT_ANON *r_u));
NTSTATUS _samr_connect __P((pipes_struct *p, SAMR_Q_CONNECT *q_u, SAMR_R_CONNECT *r_u));
NTSTATUS _samr_lookup_domain __P((pipes_struct *p, SAMR_Q_LOOKUP_DOMAIN *q_u, SAMR_R_LOOKUP_DOMAIN *r_u));
NTSTATUS _samr_enum_domains __P((pipes_struct *p, SAMR_Q_ENUM_DOMAINS *q_u, SAMR_R_ENUM_DOMAINS *r_u));
NTSTATUS _api_samr_open_alias __P((pipes_struct *p, SAMR_Q_OPEN_ALIAS *q_u, SAMR_R_OPEN_ALIAS *r_u));
NTSTATUS _samr_set_userinfo __P((pipes_struct *p, SAMR_Q_SET_USERINFO *q_u, SAMR_R_SET_USERINFO *r_u));
NTSTATUS _samr_set_userinfo2 __P((pipes_struct *p, SAMR_Q_SET_USERINFO2 *q_u, SAMR_R_SET_USERINFO2 *r_u));
NTSTATUS _samr_query_useraliases __P((pipes_struct *p, SAMR_Q_QUERY_USERALIASES *q_u, SAMR_R_QUERY_USERALIASES *r_u));
NTSTATUS _samr_query_aliasmem __P((pipes_struct *p, SAMR_Q_QUERY_ALIASMEM *q_u, SAMR_R_QUERY_ALIASMEM *r_u));
NTSTATUS _samr_query_groupmem __P((pipes_struct *p, SAMR_Q_QUERY_GROUPMEM *q_u, SAMR_R_QUERY_GROUPMEM *r_u));
NTSTATUS _samr_add_aliasmem __P((pipes_struct *p, SAMR_Q_ADD_ALIASMEM *q_u, SAMR_R_ADD_ALIASMEM *r_u));
NTSTATUS _samr_del_aliasmem __P((pipes_struct *p, SAMR_Q_DEL_ALIASMEM *q_u, SAMR_R_DEL_ALIASMEM *r_u));
NTSTATUS _samr_add_groupmem __P((pipes_struct *p, SAMR_Q_ADD_GROUPMEM *q_u, SAMR_R_ADD_GROUPMEM *r_u));
NTSTATUS _samr_del_groupmem __P((pipes_struct *p, SAMR_Q_DEL_GROUPMEM *q_u, SAMR_R_DEL_GROUPMEM *r_u));
NTSTATUS _samr_delete_dom_user __P((pipes_struct *p, SAMR_Q_DELETE_DOM_USER *q_u, SAMR_R_DELETE_DOM_USER *r_u ));
NTSTATUS _samr_delete_dom_group __P((pipes_struct *p, SAMR_Q_DELETE_DOM_GROUP *q_u, SAMR_R_DELETE_DOM_GROUP *r_u));
NTSTATUS _samr_delete_dom_alias __P((pipes_struct *p, SAMR_Q_DELETE_DOM_ALIAS *q_u, SAMR_R_DELETE_DOM_ALIAS *r_u));
NTSTATUS _samr_create_dom_group __P((pipes_struct *p, SAMR_Q_CREATE_DOM_GROUP *q_u, SAMR_R_CREATE_DOM_GROUP *r_u));
NTSTATUS _samr_create_dom_alias __P((pipes_struct *p, SAMR_Q_CREATE_DOM_ALIAS *q_u, SAMR_R_CREATE_DOM_ALIAS *r_u));
NTSTATUS _samr_query_groupinfo __P((pipes_struct *p, SAMR_Q_QUERY_GROUPINFO *q_u, SAMR_R_QUERY_GROUPINFO *r_u));
NTSTATUS _samr_set_groupinfo __P((pipes_struct *p, SAMR_Q_SET_GROUPINFO *q_u, SAMR_R_SET_GROUPINFO *r_u));
NTSTATUS _samr_get_dom_pwinfo __P((pipes_struct *p, SAMR_Q_GET_DOM_PWINFO *q_u, SAMR_R_GET_DOM_PWINFO *r_u));
NTSTATUS _samr_open_group __P((pipes_struct *p, SAMR_Q_OPEN_GROUP *q_u, SAMR_R_OPEN_GROUP *r_u));
NTSTATUS _samr_unknown_2d __P((pipes_struct *p, SAMR_Q_UNKNOWN_2D *q_u, SAMR_R_UNKNOWN_2D *r_u));

/* The following definitions come from rpc_server/srv_spoolss.c  */

BOOL api_spoolss_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_spoolss_nt.c  */

SPOOL_NOTIFY_OPTION *dup_spool_notify_option __P((SPOOL_NOTIFY_OPTION *sp));
void do_drv_upgrade_printer __P((int msg_type, pid_t src, void *buf, size_t len));
WERROR _spoolss_open_printer __P((pipes_struct *p, SPOOL_Q_OPEN_PRINTER *q_u, SPOOL_R_OPEN_PRINTER *r_u));
WERROR _spoolss_open_printer_ex __P(( pipes_struct *p, SPOOL_Q_OPEN_PRINTER_EX *q_u, SPOOL_R_OPEN_PRINTER_EX *r_u));
BOOL convert_devicemode __P((const fstring printername, const DEVICEMODE *devmode,
				NT_DEVICEMODE **pp_nt_devmode));
WERROR _spoolss_closeprinter __P((pipes_struct *p, SPOOL_Q_CLOSEPRINTER *q_u, SPOOL_R_CLOSEPRINTER *r_u));
WERROR _spoolss_deleteprinter __P((pipes_struct *p, SPOOL_Q_DELETEPRINTER *q_u, SPOOL_R_DELETEPRINTER *r_u));
WERROR _spoolss_deleteprinterdriver __P((pipes_struct *p, SPOOL_Q_DELETEPRINTERDRIVER *q_u, 
				    SPOOL_R_DELETEPRINTERDRIVER *r_u));
WERROR _spoolss_getprinterdata __P((pipes_struct *p, SPOOL_Q_GETPRINTERDATA *q_u, SPOOL_R_GETPRINTERDATA *r_u));
WERROR _spoolss_rffpcnex __P((pipes_struct *p, SPOOL_Q_RFFPCNEX *q_u, SPOOL_R_RFFPCNEX *r_u));
void spoolss_notify_server_name __P((int snum, 
				       SPOOL_NOTIFY_INFO_DATA *data, 
				       print_queue_struct *queue,
				       NT_PRINTER_INFO_LEVEL *printer,
				       TALLOC_CTX *mem_ctx) );
void spoolss_notify_printer_name __P((int snum, 
					SPOOL_NOTIFY_INFO_DATA *data, 
					print_queue_struct *queue,
					NT_PRINTER_INFO_LEVEL *printer,
					TALLOC_CTX *mem_ctx));
void spoolss_notify_share_name __P((int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data, 
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx));
void spoolss_notify_port_name __P((int snum, 
				     SPOOL_NOTIFY_INFO_DATA *data, 
				     print_queue_struct *queue,
				     NT_PRINTER_INFO_LEVEL *printer,
				     TALLOC_CTX *mem_ctx));
void spoolss_notify_driver_name __P((int snum, 
				       SPOOL_NOTIFY_INFO_DATA *data,
				       print_queue_struct *queue,
				       NT_PRINTER_INFO_LEVEL *printer,
				       TALLOC_CTX *mem_ctx));
void spoolss_notify_comment __P((int snum, 
				   SPOOL_NOTIFY_INFO_DATA *data,
				   print_queue_struct *queue,
				   NT_PRINTER_INFO_LEVEL *printer,
				   TALLOC_CTX *mem_ctx));
void spoolss_notify_location __P((int snum, 
				    SPOOL_NOTIFY_INFO_DATA *data,
				    print_queue_struct *queue,
				    NT_PRINTER_INFO_LEVEL *printer,
				    TALLOC_CTX *mem_ctx));
void spoolss_notify_sepfile __P((int snum, 
				   SPOOL_NOTIFY_INFO_DATA *data, 
				   print_queue_struct *queue,
				   NT_PRINTER_INFO_LEVEL *printer,
				   TALLOC_CTX *mem_ctx));
void spoolss_notify_print_processor __P((int snum, 
					   SPOOL_NOTIFY_INFO_DATA *data,
					   print_queue_struct *queue,
					   NT_PRINTER_INFO_LEVEL *printer,
					   TALLOC_CTX *mem_ctx));
void spoolss_notify_parameters __P((int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data,
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx));
void spoolss_notify_datatype __P((int snum, 
				    SPOOL_NOTIFY_INFO_DATA *data,
				    print_queue_struct *queue,
				    NT_PRINTER_INFO_LEVEL *printer,
				    TALLOC_CTX *mem_ctx));
void spoolss_notify_attributes __P((int snum, 
				      SPOOL_NOTIFY_INFO_DATA *data,
				      print_queue_struct *queue,
				      NT_PRINTER_INFO_LEVEL *printer,
				      TALLOC_CTX *mem_ctx));
void spoolss_notify_cjobs __P((int snum, 
				 SPOOL_NOTIFY_INFO_DATA *data,
				 print_queue_struct *queue,
				 NT_PRINTER_INFO_LEVEL *printer, 
				 TALLOC_CTX *mem_ctx));
void construct_info_data __P((SPOOL_NOTIFY_INFO_DATA *info_data, uint16 type, uint16 field, int id));
WERROR _spoolss_rfnpcnex __P(( pipes_struct *p, SPOOL_Q_RFNPCNEX *q_u, SPOOL_R_RFNPCNEX *r_u));
WERROR _spoolss_enumprinters __P(( pipes_struct *p, SPOOL_Q_ENUMPRINTERS *q_u, SPOOL_R_ENUMPRINTERS *r_u));
WERROR _spoolss_getprinter __P((pipes_struct *p, SPOOL_Q_GETPRINTER *q_u, SPOOL_R_GETPRINTER *r_u));
WERROR _spoolss_getprinterdriver2 __P((pipes_struct *p, SPOOL_Q_GETPRINTERDRIVER2 *q_u, SPOOL_R_GETPRINTERDRIVER2 *r_u));
WERROR _spoolss_startpageprinter __P((pipes_struct *p, SPOOL_Q_STARTPAGEPRINTER *q_u, SPOOL_R_STARTPAGEPRINTER *r_u));
WERROR _spoolss_endpageprinter __P((pipes_struct *p, SPOOL_Q_ENDPAGEPRINTER *q_u, SPOOL_R_ENDPAGEPRINTER *r_u));
WERROR _spoolss_startdocprinter __P((pipes_struct *p, SPOOL_Q_STARTDOCPRINTER *q_u, SPOOL_R_STARTDOCPRINTER *r_u));
WERROR _spoolss_enddocprinter __P((pipes_struct *p, SPOOL_Q_ENDDOCPRINTER *q_u, SPOOL_R_ENDDOCPRINTER *r_u));
WERROR _spoolss_writeprinter __P((pipes_struct *p, SPOOL_Q_WRITEPRINTER *q_u, SPOOL_R_WRITEPRINTER *r_u));
WERROR _spoolss_abortprinter __P((pipes_struct *p, SPOOL_Q_ABORTPRINTER *q_u, SPOOL_R_ABORTPRINTER *r_u));
WERROR _spoolss_setprinter __P((pipes_struct *p, SPOOL_Q_SETPRINTER *q_u, SPOOL_R_SETPRINTER *r_u));
WERROR _spoolss_fcpn __P((pipes_struct *p, SPOOL_Q_FCPN *q_u, SPOOL_R_FCPN *r_u));
WERROR _spoolss_addjob __P((pipes_struct *p, SPOOL_Q_ADDJOB *q_u, SPOOL_R_ADDJOB *r_u));
WERROR _spoolss_enumjobs __P(( pipes_struct *p, SPOOL_Q_ENUMJOBS *q_u, SPOOL_R_ENUMJOBS *r_u));
WERROR _spoolss_schedulejob __P(( pipes_struct *p, SPOOL_Q_SCHEDULEJOB *q_u, SPOOL_R_SCHEDULEJOB *r_u));
WERROR _spoolss_setjob __P((pipes_struct *p, SPOOL_Q_SETJOB *q_u, SPOOL_R_SETJOB *r_u));
WERROR _spoolss_enumprinterdrivers __P(( pipes_struct *p, SPOOL_Q_ENUMPRINTERDRIVERS *q_u, SPOOL_R_ENUMPRINTERDRIVERS *r_u));
WERROR _spoolss_enumforms __P((pipes_struct *p, SPOOL_Q_ENUMFORMS *q_u, SPOOL_R_ENUMFORMS *r_u));
WERROR _spoolss_getform __P((pipes_struct *p, SPOOL_Q_GETFORM *q_u, SPOOL_R_GETFORM *r_u));
WERROR _spoolss_enumports __P(( pipes_struct *p, SPOOL_Q_ENUMPORTS *q_u, SPOOL_R_ENUMPORTS *r_u));
WERROR _spoolss_addprinterex __P(( pipes_struct *p, SPOOL_Q_ADDPRINTEREX *q_u, SPOOL_R_ADDPRINTEREX *r_u));
WERROR _spoolss_addprinterdriver __P((pipes_struct *p, SPOOL_Q_ADDPRINTERDRIVER *q_u, SPOOL_R_ADDPRINTERDRIVER *r_u));
WERROR _spoolss_getprinterdriverdirectory __P((pipes_struct *p, SPOOL_Q_GETPRINTERDRIVERDIR *q_u, SPOOL_R_GETPRINTERDRIVERDIR *r_u));
WERROR _spoolss_enumprinterdata __P((pipes_struct *p, SPOOL_Q_ENUMPRINTERDATA *q_u, SPOOL_R_ENUMPRINTERDATA *r_u));
WERROR _spoolss_setprinterdata __P(( pipes_struct *p, SPOOL_Q_SETPRINTERDATA *q_u, SPOOL_R_SETPRINTERDATA *r_u));
WERROR _spoolss_resetprinter __P((pipes_struct *p, SPOOL_Q_RESETPRINTER *q_u, SPOOL_R_RESETPRINTER *r_u));
WERROR _spoolss_deleteprinterdata __P((pipes_struct *p, SPOOL_Q_DELETEPRINTERDATA *q_u, SPOOL_R_DELETEPRINTERDATA *r_u));
WERROR _spoolss_addform __P(( pipes_struct *p, SPOOL_Q_ADDFORM *q_u, SPOOL_R_ADDFORM *r_u));
WERROR _spoolss_deleteform __P(( pipes_struct *p, SPOOL_Q_DELETEFORM *q_u, SPOOL_R_DELETEFORM *r_u));
WERROR _spoolss_setform __P((pipes_struct *p, SPOOL_Q_SETFORM *q_u, SPOOL_R_SETFORM *r_u));
WERROR _spoolss_enumprintprocessors __P((pipes_struct *p, SPOOL_Q_ENUMPRINTPROCESSORS *q_u, SPOOL_R_ENUMPRINTPROCESSORS *r_u));
WERROR _spoolss_enumprintprocdatatypes __P((pipes_struct *p, SPOOL_Q_ENUMPRINTPROCDATATYPES *q_u, SPOOL_R_ENUMPRINTPROCDATATYPES *r_u));
WERROR _spoolss_enumprintmonitors __P((pipes_struct *p, SPOOL_Q_ENUMPRINTMONITORS *q_u, SPOOL_R_ENUMPRINTMONITORS *r_u));
WERROR _spoolss_getjob __P(( pipes_struct *p, SPOOL_Q_GETJOB *q_u, SPOOL_R_GETJOB *r_u));
WERROR _spoolss_getprinterdataex __P((pipes_struct *p, SPOOL_Q_GETPRINTERDATAEX *q_u, SPOOL_R_GETPRINTERDATAEX *r_u));
WERROR _spoolss_setprinterdataex __P((pipes_struct *p, SPOOL_Q_SETPRINTERDATAEX *q_u, SPOOL_R_SETPRINTERDATAEX *r_u));
WERROR _spoolss_enumprinterkey __P((pipes_struct *p, SPOOL_Q_ENUMPRINTERKEY *q_u, SPOOL_R_ENUMPRINTERKEY *r_u));
WERROR _spoolss_enumprinterdataex __P((pipes_struct *p, SPOOL_Q_ENUMPRINTERDATAEX *q_u, SPOOL_R_ENUMPRINTERDATAEX *r_u));
WERROR _spoolss_getprintprocessordirectory __P((pipes_struct *p, SPOOL_Q_GETPRINTPROCESSORDIRECTORY *q_u, SPOOL_R_GETPRINTPROCESSORDIRECTORY *r_u));

/* The following definitions come from rpc_server/srv_srvsvc.c  */

BOOL api_srvsvc_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_srvsvc_nt.c  */

BOOL share_info_db_init __P((void));
void map_generic_share_sd_bits __P((SEC_DESC *psd));
BOOL share_access_check __P((connection_struct *conn, int snum, uint16 vuid, uint32 desired_access));
WERROR _srv_net_srv_get_info __P((pipes_struct *p, SRV_Q_NET_SRV_GET_INFO *q_u, SRV_R_NET_SRV_GET_INFO *r_u));
WERROR _srv_net_srv_set_info __P((pipes_struct *p, SRV_Q_NET_SRV_SET_INFO *q_u, SRV_R_NET_SRV_SET_INFO *r_u));
WERROR _srv_net_file_enum __P((pipes_struct *p, SRV_Q_NET_FILE_ENUM *q_u, SRV_R_NET_FILE_ENUM *r_u));
WERROR _srv_net_conn_enum __P((pipes_struct *p, SRV_Q_NET_CONN_ENUM *q_u, SRV_R_NET_CONN_ENUM *r_u));
WERROR _srv_net_sess_enum __P((pipes_struct *p, SRV_Q_NET_SESS_ENUM *q_u, SRV_R_NET_SESS_ENUM *r_u));
WERROR _srv_net_share_enum_all __P((pipes_struct *p, SRV_Q_NET_SHARE_ENUM *q_u, SRV_R_NET_SHARE_ENUM *r_u));
WERROR _srv_net_share_enum __P((pipes_struct *p, SRV_Q_NET_SHARE_ENUM *q_u, SRV_R_NET_SHARE_ENUM *r_u));
WERROR _srv_net_share_get_info __P((pipes_struct *p, SRV_Q_NET_SHARE_GET_INFO *q_u, SRV_R_NET_SHARE_GET_INFO *r_u));
WERROR _srv_net_share_set_info __P((pipes_struct *p, SRV_Q_NET_SHARE_SET_INFO *q_u, SRV_R_NET_SHARE_SET_INFO *r_u));
WERROR _srv_net_share_add __P((pipes_struct *p, SRV_Q_NET_SHARE_ADD *q_u, SRV_R_NET_SHARE_ADD *r_u));
WERROR _srv_net_share_del __P((pipes_struct *p, SRV_Q_NET_SHARE_DEL *q_u, SRV_R_NET_SHARE_DEL *r_u));
WERROR _srv_net_remote_tod __P((pipes_struct *p, SRV_Q_NET_REMOTE_TOD *q_u, SRV_R_NET_REMOTE_TOD *r_u));
WERROR _srv_net_file_query_secdesc __P((pipes_struct *p, SRV_Q_NET_FILE_QUERY_SECDESC *q_u,
			SRV_R_NET_FILE_QUERY_SECDESC *r_u));
WERROR _srv_net_file_set_secdesc __P((pipes_struct *p, SRV_Q_NET_FILE_SET_SECDESC *q_u,
									SRV_R_NET_FILE_SET_SECDESC *r_u));
WERROR _srv_net_disk_enum __P((pipes_struct *p, SRV_Q_NET_DISK_ENUM *q_u, SRV_R_NET_DISK_ENUM *r_u));
WERROR _srv_net_name_validate __P((pipes_struct *p, SRV_Q_NET_NAME_VALIDATE *q_u, SRV_R_NET_NAME_VALIDATE *r_u));

/* The following definitions come from rpc_server/srv_util.c  */

int make_dom_gids __P((TALLOC_CTX *ctx, char *gids_str, DOM_GID **ppgids));
void get_domain_user_groups __P((char *domain_groups, char *user));
NTSTATUS local_lookup_group_name __P((uint32 rid, char *group_name, uint32 *type));
NTSTATUS local_lookup_alias_name __P((uint32 rid, char *alias_name, uint32 *type));
NTSTATUS local_lookup_user_name __P((uint32 rid, char *user_name, uint32 *type));
NTSTATUS local_lookup_group_rid __P((char *group_name, uint32 *rid));
NTSTATUS local_lookup_alias_rid __P((char *alias_name, uint32 *rid));
NTSTATUS local_lookup_user_rid __P((char *user_name, uint32 *rid));

/* The following definitions come from rpc_server/srv_wkssvc.c  */

BOOL api_wkssvc_rpc __P((pipes_struct *p));

/* The following definitions come from rpc_server/srv_wkssvc_nt.c  */

NTSTATUS _wks_query_info __P((pipes_struct *p, WKS_Q_QUERY_INFO *q_u, WKS_R_QUERY_INFO *r_u));

/* The following definitions come from rpcclient/cmd_dfs.c  */


/* The following definitions come from rpcclient/cmd_lsarpc.c  */


/* The following definitions come from rpcclient/cmd_netlogon.c  */


/* The following definitions come from rpcclient/cmd_reg.c  */


/* The following definitions come from rpcclient/cmd_samr.c  */


/* The following definitions come from rpcclient/cmd_spoolss.c  */

BOOL get_short_archi __P((char *short_archi, const char *long_archi));
void set_drv_info_3_env  __P((DRIVER_INFO_3 *info, const char *arch));

/* The following definitions come from rpcclient/cmd_srvsvc.c  */


/* The following definitions come from rpcclient/display_sec.c  */

char *get_sec_mask_str __P((uint32 type));
void display_sec_access __P((SEC_ACCESS *info));
void display_sec_ace __P((SEC_ACE *ace));
void display_sec_acl __P((SEC_ACL *sec_acl));
void display_sec_desc __P((SEC_DESC *sec));

/* The following definitions come from rpcclient/rpcclient.c  */

void fetch_machine_sid __P((struct cli_state *cli));
int main __P((int argc, char *argv[]));

/* The following definitions come from smbd/blocking.c  */

BOOL push_blocking_lock_request __P(( char *inbuf, int length, int lock_timeout,
		int lock_num, uint16 lock_pid, SMB_BIG_UINT offset, SMB_BIG_UINT count));
void remove_pending_lock_requests_by_fid __P((files_struct *fsp));
void remove_pending_lock_requests_by_mid __P((int mid));
unsigned blocking_locks_timeout __P((unsigned default_timeout));
void process_blocking_lock_queue __P((time_t t));

/* The following definitions come from smbd/chgpasswd.c  */

BOOL chgpasswd __P((char *name, const char *oldpass, const char *newpass, BOOL as_root));
BOOL chgpasswd __P((char *name, const char *oldpass, const char *newpass, BOOL as_root));
BOOL check_lanman_password __P((char *user, uchar * pass1,
			   uchar * pass2, SAM_ACCOUNT **hnd));
BOOL change_lanman_password __P((SAM_ACCOUNT *sampass, uchar * pass1,
			    uchar * pass2));
BOOL pass_oem_change __P((char *user,
		     uchar * lmdata, uchar * lmhash,
		     uchar * ntdata, uchar * nthash));
BOOL check_oem_password __P((char *user,
			uchar * lmdata, uchar * lmhash,
			uchar * ntdata, uchar * nthash,
			SAM_ACCOUNT **hnd, char *new_passwd,
			int new_passwd_size));
BOOL change_oem_password __P((SAM_ACCOUNT *hnd, char *new_passwd,
			 BOOL override));
BOOL check_plaintext_password __P((char *user, char *old_passwd,
			      int old_passwd_size, SAM_ACCOUNT **hnd));

/* The following definitions come from smbd/close.c  */

int close_file __P((files_struct *fsp, BOOL normal_close));

/* The following definitions come from smbd/conn.c  */

void conn_init __P((void));
int conn_num_open __P((void));
BOOL conn_snum_used __P((int snum));
connection_struct *conn_find __P((int cnum));
connection_struct *conn_new __P((void));
void conn_close_all __P((void));
BOOL conn_idle_all __P((time_t t, int deadtime));
void conn_free __P((connection_struct *conn));
void msg_force_tdis __P((int msg_type, pid_t pid, void *buf, size_t len));

/* The following definitions come from smbd/connection.c  */

TDB_CONTEXT *conn_tdb_ctx __P((void));
BOOL yield_connection __P((connection_struct *conn,const char *name));
BOOL claim_connection __P((connection_struct *conn,const char *name,int max_connections,BOOL Clear));

/* The following definitions come from smbd/dfree.c  */

SMB_BIG_UINT sys_disk_free __P((const char *path, BOOL small_query, 
                           SMB_BIG_UINT *bsize,SMB_BIG_UINT *dfree,SMB_BIG_UINT *dsize));

/* The following definitions come from smbd/dir.c  */

void init_dptrs __P((void));
char *dptr_path __P((int key));
char *dptr_wcard __P((int key));
BOOL dptr_set_wcard __P((int key, char *wcard));
BOOL dptr_set_attr __P((int key, uint16 attr));
uint16 dptr_attr __P((int key));
void dptr_close __P((int *key));
void dptr_closecnum __P((connection_struct *conn));
void dptr_idlecnum __P((connection_struct *conn));
void dptr_closepath __P((char *path,uint16 spid));
int dptr_create __P((connection_struct *conn,char *path, BOOL old_handle, BOOL expect_close,uint16 spid));
BOOL dptr_fill __P((char *buf1,unsigned int key));
void *dptr_fetch __P((char *buf,int *num));
void *dptr_fetch_lanman2 __P((int dptr_num));
BOOL dir_check_ftype __P((connection_struct *conn,int mode,SMB_STRUCT_STAT *st,int dirtype));
BOOL get_dir_entry __P((connection_struct *conn,char *mask,int dirtype,char *fname,
                   SMB_OFF_T *size,int *mode,time_t *date,BOOL check_descend));
void *OpenDir __P((connection_struct *conn, const char *name, BOOL use_veto));
void CloseDir __P((void *p));
char *ReadDirName __P((void *p));
BOOL SeekDir __P((void *p,int pos));
int TellDir __P((void *p));
void DirCacheAdd __P(( const char *path, const char *name, const char *dname, int snum ));
char *DirCacheCheck __P(( const char *path, const char *name, int snum ));
void DirCacheFlush __P((int snum));

/* The following definitions come from smbd/dosmode.c  */

mode_t unix_mode __P((connection_struct *conn,int dosmode,const char *fname));
int dos_mode __P((connection_struct *conn,char *path,SMB_STRUCT_STAT *sbuf));
int file_chmod __P((connection_struct *conn,char *fname,int dosmode,SMB_STRUCT_STAT *st));
int file_utime __P((connection_struct *conn, char *fname, struct utimbuf *times));
BOOL set_filetime __P((connection_struct *conn, char *fname, time_t mtime));

/* The following definitions come from smbd/error.c  */

int cached_error_packet __P((char *outbuf,files_struct *fsp,int line,const char *file));
int unix_error_packet __P((char *outbuf,int def_class,uint32 def_code,
		      int line, const char *file));
int error_packet __P((char *outbuf,NTSTATUS ntstatus,
		 uint8 eclass,uint32 ecode,int line, const char *file));

/* The following definitions come from smbd/fileio.c  */

SMB_OFF_T seek_file __P((files_struct *fsp,SMB_OFF_T pos));
BOOL read_from_write_cache __P((files_struct *fsp,char *data,SMB_OFF_T pos,size_t n));
ssize_t read_file __P((files_struct *fsp,char *data,SMB_OFF_T pos,size_t n));
ssize_t write_file __P((files_struct *fsp, char *data, SMB_OFF_T pos, size_t n));
void delete_write_cache __P((files_struct *fsp));
void set_filelen_write_cache __P((files_struct *fsp, SMB_OFF_T file_size));
ssize_t flush_write_cache __P((files_struct *fsp, enum flush_reason_enum reason));
void sync_file __P((connection_struct *conn, files_struct *fsp));
int fsp_stat __P((files_struct *fsp, SMB_STRUCT_STAT *pst));

/* The following definitions come from smbd/filename.c  */

BOOL unix_convert __P((char *name,connection_struct *conn,char *saved_last_component, 
                  BOOL *bad_path, SMB_STRUCT_STAT *pst));
BOOL check_name __P((char *name,connection_struct *conn));

/* The following definitions come from smbd/files.c  */

files_struct *file_new __P((connection_struct *conn));
void file_close_conn __P((connection_struct *conn));
void file_init __P((void));
void file_close_user __P((int vuid));
files_struct *file_find_fd __P((int fd));
files_struct *file_find_dif __P((SMB_DEV_T dev, SMB_INO_T inode, unsigned long file_id));
files_struct *file_find_fsp __P((files_struct *orig_fsp));
files_struct *file_find_di_first __P((SMB_DEV_T dev, SMB_INO_T inode));
files_struct *file_find_di_next __P((files_struct *start_fsp));
files_struct *file_find_print __P((void));
void file_sync_all __P((connection_struct *conn));
void file_free __P((files_struct *fsp));
files_struct *file_fsp __P((char *buf, int where));
void file_chain_reset __P((void));
void file_chain_save __P((void));
void file_chain_restore __P((void));

/* The following definitions come from smbd/ipc.c  */

void send_trans_reply __P((char *outbuf,
				char *rparam, int rparam_len,
				char *rdata, int rdata_len,
				BOOL buffer_too_large));
int reply_trans __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int bufsize));

/* The following definitions come from smbd/lanman.c  */

int api_reply __P((connection_struct *conn,uint16 vuid,char *outbuf,char *data,char *params,
		     int tdscnt,int tpscnt,int mdrcnt,int mprcnt));

/* The following definitions come from smbd/mangle.c  */

void mangle_reset_cache __P((void));
BOOL mangle_is_mangled __P((const char *s));
BOOL mangle_is_8_3 __P((const char *fname, BOOL check_case));
BOOL mangle_is_8_3_wildcards __P((const char *fname, BOOL check_case));
BOOL mangle_check_cache __P((char *s));
void mangle_map __P((char *OutName, BOOL need83, BOOL cache83, int snum));

/* The following definitions come from smbd/mangle_hash.c  */

struct mangle_fns *mangle_hash_init __P((void));

/* The following definitions come from smbd/mangle_hash2.c  */

struct mangle_fns *mangle_hash2_init __P((void));

/* The following definitions come from smbd/mangle_map.c  */

void mangle_map_filename __P((char *fname, int snum));

/* The following definitions come from smbd/message.c  */

int reply_sends __P((connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_sendstrt __P((connection_struct *conn,
		   char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_sendtxt __P((connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_sendend __P((connection_struct *conn,
		  char *inbuf,char *outbuf, int dum_size, int dum_buffsize));

/* The following definitions come from smbd/negprot.c  */

int reply_negprot __P((connection_struct *conn, 
		  char *inbuf,char *outbuf, int dum_size, 
		  int dum_buffsize));

/* The following definitions come from smbd/notify.c  */

void remove_pending_change_notify_requests_by_fid __P((files_struct *fsp));
void remove_pending_change_notify_requests_by_mid __P((int mid));
void remove_pending_change_notify_requests_by_filename __P((files_struct *fsp));
int change_notify_timeout __P((void));
BOOL process_pending_change_notify_queue __P((time_t t));
BOOL change_notify_set __P((char *inbuf, files_struct *fsp, connection_struct *conn, uint32 flags));
BOOL init_change_notify __P((void));

/* The following definitions come from smbd/notify_hash.c  */

struct cnotify_fns *hash_notify_init __P((void) );

/* The following definitions come from smbd/notify_kernel.c  */

struct cnotify_fns *kernel_notify_init __P((void) );

/* The following definitions come from smbd/nttrans.c  */

int reply_ntcreate_and_X __P((connection_struct *conn,
			 char *inbuf,char *outbuf,int length,int bufsize));
int reply_ntcancel __P((connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize));
int reply_nttranss __P((connection_struct *conn,
		   char *inbuf,char *outbuf,int length,int bufsize));
int reply_nttrans __P((connection_struct *conn,
		  char *inbuf,char *outbuf,int length,int bufsize));

/* The following definitions come from smbd/open.c  */

int fd_close __P((struct connection_struct *conn, files_struct *fsp));
files_struct *open_file_shared __P((connection_struct *conn,char *fname, SMB_STRUCT_STAT *psbuf, 
		int share_mode,int ofun, mode_t mode,int oplock_request, int *Access,int *action));
files_struct *open_file_shared1 __P((connection_struct *conn,char *fname, SMB_STRUCT_STAT *psbuf, 
				uint32 desired_access,
				int share_mode,int ofun, mode_t mode,int oplock_request,
				int *Access,int *action));
files_struct *open_file_fchmod __P((connection_struct *conn, const char *fname, SMB_STRUCT_STAT *psbuf));
int close_file_fchmod __P((files_struct *fsp));
files_struct *open_directory __P((connection_struct *conn, char *fname, SMB_STRUCT_STAT *psbuf,
			uint32 desired_access, int share_mode, int smb_ofun, mode_t unixmode, int *action));
files_struct *open_file_stat __P((connection_struct *conn, char *fname, SMB_STRUCT_STAT *psbuf));

/* The following definitions come from smbd/oplock.c  */

int32 get_number_of_exclusive_open_oplocks __P((void));
BOOL oplock_message_waiting __P((fd_set *fds));
BOOL receive_local_message __P(( char *buffer, int buffer_len, int timeout));
BOOL set_file_oplock __P((files_struct *fsp, int oplock_type));
void release_file_oplock __P((files_struct *fsp));
BOOL remove_oplock __P((files_struct *fsp, BOOL break_to_none));
int setup_oplock_select_set __P(( fd_set *fds));
BOOL process_local_message __P((char *buffer, int buf_size));
BOOL oplock_break_level2 __P((files_struct *fsp, BOOL local_request, int token));
BOOL request_oplock_break __P((share_mode_entry *share_entry, BOOL async));
BOOL attempt_close_oplocked_file __P((files_struct *fsp));
void release_level_2_oplocks_on_change __P((files_struct *fsp));
BOOL init_oplocks __P((void));

/* The following definitions come from smbd/oplock_irix.c  */

struct kernel_oplocks *irix_init_kernel_oplocks __P((void) );

/* The following definitions come from smbd/oplock_linux.c  */

struct kernel_oplocks *linux_init_kernel_oplocks __P((void) );

/* The following definitions come from smbd/password.c  */

void generate_next_challenge __P((char *challenge));
BOOL set_challenge __P((unsigned char *challenge));
user_struct *get_valid_user_struct __P((uint16 vuid));
void invalidate_vuid __P((uint16 vuid));
void invalidate_all_vuids __P((void));
char *validated_username __P((uint16 vuid));
char *validated_domain __P((uint16 vuid));
NT_USER_TOKEN *create_nt_token __P((uid_t uid, gid_t gid, int ngroups, gid_t *groups, BOOL is_guest, NT_USER_TOKEN *sup_tok));
int register_vuid __P((uid_t uid,gid_t gid, char *unix_name, char *requested_name, 
		  char *domain,BOOL guest, NT_USER_TOKEN **pptok));
void add_session_user __P((char *user));
BOOL smb_password_check __P((char *password, unsigned char *part_passwd, unsigned char *c8));
BOOL smb_password_ok __P((SAM_ACCOUNT *sampass, uchar *chal,
                     uchar *lm_pass, uchar *nt_pass));
BOOL pass_check_smb __P((char *user, char *domain, uchar *chal, 
                    uchar *lm_pwd, uchar *nt_pwd, struct passwd *pwd));
BOOL password_ok __P((char *user, char *password, int pwlen, struct passwd *pwd));
BOOL user_ok __P((char *user,int snum));
BOOL authorise_login __P((int snum,char *user,char *password, int pwlen, 
		     BOOL *guest,BOOL *force,uint16 vuid));
BOOL check_hosts_equiv __P((char *user));
struct cli_state *server_client __P((void));
struct cli_state *server_cryptkey __P((void));
BOOL server_validate __P((char *user, char *domain, 
		     char *pass, int passlen,
		     char *ntpass, int ntpasslen));
BOOL domain_client_validate __P(( char *user, char *domain, 
                             char *smb_apasswd, int smb_apasslen, 
                             char *smb_ntpasswd, int smb_ntpasslen,
                             BOOL *user_exists, NT_USER_TOKEN **pptoken));

/* The following definitions come from smbd/pipes.c  */

int reply_open_pipe_and_X __P((connection_struct *conn,
			  char *inbuf,char *outbuf,int length,int bufsize));
int reply_pipe_write __P((char *inbuf,char *outbuf,int length,int dum_bufsize));
int reply_pipe_write_and_X __P((char *inbuf,char *outbuf,int length,int bufsize));
int reply_pipe_read_and_X __P((char *inbuf,char *outbuf,int length,int bufsize));
int reply_pipe_close __P((connection_struct *conn, char *inbuf,char *outbuf));

/* The following definitions come from smbd/posix_acls.c  */

SMB_ACL_T free_empty_sys_acl __P((connection_struct *conn, SMB_ACL_T acl));
size_t get_nt_acl __P((files_struct *fsp, SEC_DESC **ppdesc));
BOOL set_nt_acl __P((files_struct *fsp, uint32 security_info_sent, SEC_DESC *psd));
int chmod_acl __P((connection_struct *conn, const char *name, mode_t mode));
int inherit_access_acl __P((connection_struct *conn, const char *name, mode_t mode));
int fchmod_acl __P((files_struct *fsp, int fd, mode_t mode));
BOOL directory_has_default_acl __P((connection_struct *conn, const char *fname));

/* The following definitions come from smbd/process.c  */

BOOL push_oplock_pending_smb_message __P((char *buf, int msg_len));
BOOL receive_next_smb __P((char *inbuf, int bufsize, int timeout));
void respond_to_all_remaining_local_messages __P((void));
void process_smb __P((char *inbuf, char *outbuf));
const char *smb_fn_name __P((int type));
void construct_reply_common __P((char *inbuf,char *outbuf));
int chain_reply __P((char *inbuf,char *outbuf,int size,int bufsize));
void check_reload __P((int t));
void smbd_process __P((void));

/* The following definitions come from smbd/quotas.c  */

BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas __P((const char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
BOOL disk_quotas_vxfs __P((const pstring name, char *path, SMB_BIG_UINT *bsize, SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));

/* The following definitions come from smbd/reply.c  */

int reply_special __P((char *inbuf,char *outbuf));
int reply_tcon __P((connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_tcon_and_X __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_unknown __P((char *inbuf,char *outbuf));
int reply_ioctl __P((connection_struct *conn,
		char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int smb_create_user __P((char *unix_user, char *homedir));
int reply_sesssetup_and_X __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_chkpth __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_getatr __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_setatr __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_dskattr __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_search __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_fclose __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_open __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_open_and_X __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_ulogoffX __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_mknew __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_ctemp __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
NTSTATUS unlink_internals __P((connection_struct *conn, int dirtype, char *name));
int reply_unlink __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
void fail_readraw __P((void));
void send_file_readbraw __P((connection_struct *conn, files_struct *fsp, SMB_OFF_T startpos, size_t nread,
		ssize_t mincount, char *outbuf));
int reply_readbraw __P((connection_struct *conn, char *inbuf, char *outbuf, int dum_size, int dum_buffsize));
int reply_lockread __P((connection_struct *conn, char *inbuf,char *outbuf, int length, int dum_buffsiz));
int reply_read __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int send_file_readX __P((connection_struct *conn, char *inbuf,char *outbuf,int length, 
		files_struct *fsp, SMB_OFF_T startpos, size_t smb_maxcnt));
int reply_read_and_X __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_writebraw __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_writeunlock __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_write __P((connection_struct *conn, char *inbuf,char *outbuf,int size,int dum_buffsize));
int reply_write_and_X __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_lseek __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_flush __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_exit __P((connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_close __P((connection_struct *conn, char *inbuf,char *outbuf, int size,
                int dum_buffsize));
int reply_writeclose __P((connection_struct *conn,
		     char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_lock __P((connection_struct *conn,
	       char *inbuf,char *outbuf, int length, int dum_buffsize));
int reply_unlock __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_tdis __P((connection_struct *conn, 
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_echo __P((connection_struct *conn,
	       char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_printopen __P((connection_struct *conn, 
		    char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_printclose __P((connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_printqueue __P((connection_struct *conn,
		     char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_printwrite __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
NTSTATUS mkdir_internal __P((connection_struct *conn, pstring directory));
int reply_mkdir __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
BOOL rmdir_internals __P((connection_struct *conn, char *directory));
int reply_rmdir __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
NTSTATUS rename_internals __P((connection_struct *conn, char *name, char *newname, BOOL replace_if_exists));
int reply_mv __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_copy __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_setdir __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
uint16 get_lock_pid __P(( char *data, int data_offset, BOOL large_file_format));
SMB_BIG_UINT get_lock_count __P(( char *data, int data_offset, BOOL large_file_format));
SMB_BIG_UINT get_lock_offset __P(( char *data, int data_offset, BOOL large_file_format, BOOL *err));
int reply_lockingX __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_readbmpx __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_setattrE __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_writebmpx __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));
int reply_writebs __P((connection_struct *conn, char *inbuf,char *outbuf, int dum_size, int dum_buffsize));
int reply_getattrE __P((connection_struct *conn, char *inbuf,char *outbuf, int size, int dum_buffsize));

/* The following definitions come from smbd/sec_ctx.c  */

int get_current_groups __P((gid_t gid, int *p_ngroups, gid_t **p_groups));
void delete_nt_token __P((NT_USER_TOKEN **pptoken));
NT_USER_TOKEN *dup_nt_token __P((NT_USER_TOKEN *ptoken));
BOOL initialise_groups __P((char *user, uid_t uid, gid_t gid));
BOOL push_sec_ctx __P((void));
void set_sec_ctx __P((uid_t uid, gid_t gid, int ngroups, gid_t *groups, NT_USER_TOKEN *token));
void set_root_sec_ctx __P((void));
BOOL pop_sec_ctx __P((void));
void init_sec_ctx __P((void));

/* The following definitions come from smbd/server.c  */

int smbd_server_fd __P((void));
void smbd_set_server_fd __P((int fd));
BOOL allowable_number_of_smbd_processes __P((void));
BOOL reload_services __P((BOOL test));
int32 increment_smbd_process_count __P((void));
void exit_server __P((const char *reason));

/* The following definitions come from smbd/service.c  */

BOOL set_current_service __P((connection_struct *conn,BOOL do_chdir));
int add_home_service __P((char *service, char *homedir));
int find_service __P((char *service));
connection_struct *make_connection __P((char *service,char *user,char *password, int pwlen, char *dev,uint16 vuid, int *ecode));
void close_cnum __P((connection_struct *conn, uint16 vuid));

/* The following definitions come from smbd/session.c  */

BOOL session_claim __P((uint16 vuid));
void session_yield __P((uint16 vuid));

/* The following definitions come from smbd/ssl.c  */

int sslutil_init __P((int isServer));
int sslutil_accept __P((int fd));
int sslutil_fd_is_ssl __P((int fd));
int sslutil_connect __P((int fd));
int sslutil_disconnect __P((int fd));
int sslutil_negotiate_ssl __P((int fd, int msg_type));

/* The following definitions come from smbd/statcache.c  */

void stat_cache_add __P(( char *full_orig_name, char *orig_translated_path));
BOOL stat_cache_lookup __P((connection_struct *conn, char *name, char *dirpath, 
		       char **start, SMB_STRUCT_STAT *pst));
BOOL reset_stat_cache __P(( void ));

/* The following definitions come from smbd/trans2.c  */

SMB_BIG_UINT get_allocation_size __P((files_struct *fsp, SMB_STRUCT_STAT *sbuf));
time_t interpret_long_unix_date __P((char *p));
NTSTATUS set_bad_path_error __P((int err, BOOL bad_path));
NTSTATUS set_delete_on_close_internal __P((files_struct *fsp, BOOL delete_on_close));
NTSTATUS set_delete_on_close_over_all __P((files_struct *fsp, BOOL delete_on_close));
int reply_findclose __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_findnclose __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_transs2 __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));
int reply_trans2 __P((connection_struct *conn, char *inbuf,char *outbuf,int length,int bufsize));

/* The following definitions come from smbd/uid.c  */

BOOL change_to_guest __P((void));
BOOL change_to_user __P((connection_struct *conn, uint16 vuid));
BOOL change_to_root_user __P((void));
BOOL become_authenticated_pipe_user __P((pipes_struct *p));
BOOL unbecome_authenticated_pipe_user __P((void));
void init_conn_ctx __P((void));
void become_root __P((void));
void unbecome_root __P((void));
BOOL become_user __P((connection_struct *conn, uint16 vuid));
BOOL unbecome_user __P((void));
void add_supplementary_nt_login_groups __P((int *n_groups, gid_t **pp_groups, NT_USER_TOKEN **pptok));
BOOL lookup_name __P((const char *name, DOM_SID *psid, enum SID_NAME_USE *name_type));
BOOL lookup_sid __P((DOM_SID *sid, fstring dom_name, fstring name, enum SID_NAME_USE *name_type));
DOM_SID *uid_to_sid __P((DOM_SID *psid, uid_t uid));
DOM_SID *gid_to_sid __P((DOM_SID *psid, gid_t gid));
BOOL sid_to_uid __P((DOM_SID *psid, uid_t *puid, enum SID_NAME_USE *sidtype));
BOOL sid_to_gid __P((DOM_SID *psid, gid_t *pgid, enum SID_NAME_USE *sidtype));

/* The following definitions come from smbd/utmp.c  */

void sys_utmp_yield __P((const char *username, const char *hostname, 
		    const char *id_str, int id_num));
void sys_utmp_claim __P((const char *username, const char *hostname, 
		    const char *id_str, int id_num));

/* The following definitions come from smbd/vfs-wrap.c  */

int vfswrap_dummy_connect __P((connection_struct *conn, const char *service, const char *user));
void vfswrap_dummy_disconnect __P((connection_struct *conn));
SMB_BIG_UINT vfswrap_disk_free __P((connection_struct *conn, const char *path, BOOL small_query, SMB_BIG_UINT *bsize, 
			       SMB_BIG_UINT *dfree, SMB_BIG_UINT *dsize));
DIR *vfswrap_opendir __P((connection_struct *conn, const char *fname));
struct dirent *vfswrap_readdir __P((connection_struct *conn, DIR *dirp));
int vfswrap_mkdir __P((connection_struct *conn, const char *path, mode_t mode));
int vfswrap_rmdir __P((connection_struct *conn, const char *path));
int vfswrap_closedir __P((connection_struct *conn, DIR *dirp));
int vfswrap_open __P((connection_struct *conn, const char *fname, int flags, mode_t mode));
int vfswrap_close __P((files_struct *fsp, int fd));
ssize_t vfswrap_read __P((files_struct *fsp, int fd, void *data, size_t n));
ssize_t vfswrap_write __P((files_struct *fsp, int fd, const void *data, size_t n));
ssize_t vfswrap_sendfile __P((int tofd, struct files_struct *fsp, int fromfd, const DATA_BLOB *hdr,
			SMB_OFF_T offset, size_t n));
SMB_OFF_T vfswrap_lseek __P((files_struct *fsp, int filedes, SMB_OFF_T offset, int whence));
int vfswrap_rename __P((connection_struct *conn, const char *oldname, const char *newname));
int vfswrap_fsync __P((files_struct *fsp, int fd));
int vfswrap_stat __P((connection_struct *conn, const char *fname, SMB_STRUCT_STAT *sbuf));
int vfswrap_fstat __P((files_struct *fsp, int fd, SMB_STRUCT_STAT *sbuf));
int vfswrap_lstat __P((connection_struct *conn, const char *path, SMB_STRUCT_STAT *sbuf));
int vfswrap_unlink __P((connection_struct *conn, const char *path));
int vfswrap_chmod __P((connection_struct *conn, const char *path, mode_t mode));
int vfswrap_fchmod __P((files_struct *fsp, int fd, mode_t mode));
int vfswrap_chown __P((connection_struct *conn, const char *path, uid_t uid, gid_t gid));
int vfswrap_fchown __P((files_struct *fsp, int fd, uid_t uid, gid_t gid));
int vfswrap_chdir __P((connection_struct *conn, const char *path));
char *vfswrap_getwd __P((connection_struct *conn, char *path));
int vfswrap_utime __P((connection_struct *conn, const char *path, struct utimbuf *times));
int vfswrap_ftruncate __P((files_struct *fsp, int fd, SMB_OFF_T len));
BOOL vfswrap_lock __P((files_struct *fsp, int fd, int op, SMB_OFF_T offset, SMB_OFF_T count, int type));
int vfswrap_symlink __P((connection_struct *conn, const char *oldpath, const char *newpath));
int vfswrap_readlink __P((connection_struct *conn, const char *path, char *buf, size_t bufsiz));
int vfswrap_link __P((connection_struct *conn, const char *oldpath, const char *newpath));
int vfswrap_mknod __P((connection_struct *conn, const char *pathname, mode_t mode, SMB_DEV_T dev));
char *vfswrap_realpath __P((connection_struct *conn, const char *path, char *resolved_path));
size_t vfswrap_fget_nt_acl __P((files_struct *fsp, int fd, SEC_DESC **ppdesc));
size_t vfswrap_get_nt_acl __P((files_struct *fsp, const char *name, SEC_DESC **ppdesc));
BOOL vfswrap_fset_nt_acl __P((files_struct *fsp, int fd, uint32 security_info_sent, SEC_DESC *psd));
BOOL vfswrap_set_nt_acl __P((files_struct *fsp, const char *name, uint32 security_info_sent, SEC_DESC *psd));
int vfswrap_chmod_acl __P((connection_struct *conn, const char *name, mode_t mode));
int vfswrap_fchmod_acl __P((files_struct *fsp, int fd, mode_t mode));
int vfswrap_sys_acl_get_entry __P((struct connection_struct *conn, SMB_ACL_T theacl, int entry_id, SMB_ACL_ENTRY_T *entry_p));
int vfswrap_sys_acl_get_tag_type __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry_d, SMB_ACL_TAG_T *tag_type_p));
int vfswrap_sys_acl_get_permset __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry_d, SMB_ACL_PERMSET_T *permset_p));
void * vfswrap_sys_acl_get_qualifier __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry_d));
SMB_ACL_T vfswrap_sys_acl_get_file __P((struct connection_struct *conn, const char *path_p, SMB_ACL_TYPE_T type));
SMB_ACL_T vfswrap_sys_acl_get_fd __P((struct files_struct *fsp, int fd));
int vfswrap_sys_acl_clear_perms __P((struct connection_struct *conn, SMB_ACL_PERMSET_T permset));
int vfswrap_sys_acl_add_perm __P((struct connection_struct *conn, SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
char * vfswrap_sys_acl_to_text __P((struct connection_struct *conn, SMB_ACL_T theacl, ssize_t *plen));
SMB_ACL_T vfswrap_sys_acl_init __P((struct connection_struct *conn, int count));
int vfswrap_sys_acl_create_entry __P((struct connection_struct *conn, SMB_ACL_T *pacl, SMB_ACL_ENTRY_T *pentry));
int vfswrap_sys_acl_set_tag_type __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry, SMB_ACL_TAG_T tagtype));
int vfswrap_sys_acl_set_qualifier __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry, void *qual));
int vfswrap_sys_acl_set_permset __P((struct connection_struct *conn, SMB_ACL_ENTRY_T entry, SMB_ACL_PERMSET_T permset));
int vfswrap_sys_acl_valid __P((struct connection_struct *conn, SMB_ACL_T theacl ));
int vfswrap_sys_acl_set_file __P((struct connection_struct *conn, const char *name, SMB_ACL_TYPE_T acltype, SMB_ACL_T theacl));
int vfswrap_sys_acl_set_fd __P((struct files_struct *fsp, int fd, SMB_ACL_T theacl));
int vfswrap_sys_acl_delete_def_file __P((struct connection_struct *conn, const char *path));
int vfswrap_sys_acl_get_perm __P((struct connection_struct *conn, SMB_ACL_PERMSET_T permset, SMB_ACL_PERM_T perm));
int vfswrap_sys_acl_free_text __P((struct connection_struct *conn, char *text));
int vfswrap_sys_acl_free_acl __P((struct connection_struct *conn, SMB_ACL_T posix_acl));
int vfswrap_sys_acl_free_qualifier __P((struct connection_struct *conn, void *qualifier, SMB_ACL_TAG_T tagtype));

/* The following definitions come from smbd/vfs.c  */

BOOL smbd_vfs_init __P((connection_struct *conn));
BOOL vfs_directory_exist __P((connection_struct *conn, const char *dname, SMB_STRUCT_STAT *st));
int vfs_mkdir __P((connection_struct *conn, char *const fname, mode_t mode));
char *vfs_getwd __P((connection_struct *conn, char *unix_path));
BOOL vfs_object_exist __P((connection_struct *conn, const char *fname,SMB_STRUCT_STAT *sbuf));
BOOL vfs_file_exist __P((connection_struct *conn, const char *fname,SMB_STRUCT_STAT *sbuf));
ssize_t vfs_read_data __P((files_struct *fsp, char *buf, size_t byte_count));
ssize_t vfs_write_data __P((files_struct *fsp,const char *buffer,size_t N));
int vfs_allocate_file_space __P((files_struct *fsp, SMB_BIG_UINT len));
int vfs_set_filelen __P((files_struct *fsp, SMB_OFF_T len));
SMB_OFF_T vfs_transfer_file __P((files_struct *in, files_struct *out, SMB_OFF_T n));
char *vfs_readdirname __P((connection_struct *conn, void *p));
int vfs_ChDir __P((connection_struct *conn, const char *path));
char *vfs_GetWd __P((connection_struct *conn, char *path));
BOOL reduce_name __P((connection_struct *conn, char *s,char *dir,BOOL widelinks));

/* The following definitions come from smbwrapper/realcalls.c  */

int real_fcntl __P((int fd, int cmd, void *arg));
int real_utime __P((const char *name, struct utimbuf *buf));
int real_utimes __P((const char *name, struct timeval tv[2]));
DIR *real_opendir __P((const char *fname));
struct dirent *real_readdir __P((DIR *dirp));
struct dirent64 *real_readdir64 __P((DIR *dirp));
int real_closedir __P((DIR *dirp));
void real_seekdir __P((DIR *dirp, off_t offset));
off_t real_telldir __P((DIR *dirp));
char *real_getcwd __P((char *buf, size_t size));

/* The following definitions come from smbwrapper/shared.c  */

void smbw_setup_shared __P((void));
char *smbw_getshared __P((const char *name));
void smbw_setshared __P((const char *name, const char *val));
int smbw_setenv __P((const char *name, const char *value));
int smbw_shared_fd __P((int fd));

/* The following definitions come from smbwrapper/smbw.c  */

void smbw_init __P((void));
int smbw_fd __P((int fd));
int smbw_local_fd __P((int fd));
ino_t smbw_inode __P((const char *name));
void clean_fname __P((char *name));
char *smbw_parse_path __P((const char *fname, char *server, char *share, char *path));
int smbw_path __P((const char *path));
int smbw_errno __P((struct cli_state *c));
void get_envvar_auth_data __P((char *server, char *share, char **workgroup,
			  char **username, char **password));
void smbw_set_auth_data_fn __P((smbw_get_auth_data_fn fn));
struct smbw_server *smbw_server __P((char *server, char *share));
struct smbw_file *smbw_file __P((int fd));
int smbw_open __P((const char *fname, int flags, mode_t mode));
ssize_t smbw_pread __P((int fd, void *buf, size_t count, SMB_OFF_T ofs));
ssize_t smbw_read __P((int fd, void *buf, size_t count));
ssize_t smbw_write __P((int fd, void *buf, size_t count));
ssize_t smbw_pwrite __P((int fd, void *buf, size_t count, SMB_OFF_T ofs));
int smbw_close __P((int fd));
int smbw_fcntl __P((int fd, int cmd, long arg));
int smbw_access __P((const char *name, int mode));
int smbw_readlink __P((const char *path, char *buf, size_t bufsize));
int smbw_unlink __P((const char *fname));
int smbw_rename __P((const char *oldname, const char *newname));
int smbw_utime __P((const char *fname, void *buf));
int smbw_utimes __P((const char *fname, const struct timeval *buf));
int smbw_chown __P((const char *fname, uid_t owner, gid_t group));
int smbw_chmod __P((const char *fname, mode_t newmode));
off_t smbw_lseek __P((int fd, off_t offset, int whence));
int smbw_dup __P((int fd));
int smbw_dup2 __P((int fd, int fd2));
int smbw_fork __P((void));

/* The following definitions come from smbwrapper/smbw_dir.c  */

struct smbw_dir *smbw_dir __P((int fd));
int smbw_dirp __P((DIR *dirp));
int smbw_dir_open __P((const char *fname));
int smbw_dir_fstat __P((int fd, struct stat *st));
int smbw_dir_close __P((int fd));
int smbw_getdents __P((unsigned int fd, struct dirent *dirp, int count));
int smbw_getdirentries __P((int fd, char *buf, int nbytes, long *basep));
int smbw_chdir __P((const char *name));
off_t smbw_dir_lseek __P((int fd, off_t offset, int whence));
int smbw_mkdir __P((const char *fname, mode_t mode));
int smbw_rmdir __P((const char *fname));
char *smbw_getcwd __P((char *buf, size_t size));
int smbw_fchdir __P((unsigned int fd));
DIR *smbw_opendir __P((const char *fname));
struct dirent *smbw_readdir __P((DIR *dirp));
int smbw_closedir __P((DIR *dirp));
void smbw_seekdir __P((DIR *dirp, off_t offset));
off_t smbw_telldir __P((DIR *dirp));

/* The following definitions come from smbwrapper/smbw_stat.c  */

void smbw_setup_stat __P((struct stat *st, char *fname, size_t size, int mode));
BOOL smbw_getatr __P((struct smbw_server *srv, char *path, 
		 uint16 *mode, SMB_BIG_UINT *size, 
		 time_t *c_time, time_t *a_time, time_t *m_time,
		 SMB_INO_T *ino));
int smbw_stat_printjob __P((struct smbw_server *srv,char *path,
		       SMB_BIG_UINT *size, time_t *m_time));
int smbw_fstat __P((int fd, struct stat *st));
int smbw_stat __P((const char *fname, struct stat *st));

/* The following definitions come from tdb/spinlock.c  */

int tdb_spinlock __P((TDB_CONTEXT *tdb, int list, int rw_type));
int tdb_spinunlock __P((TDB_CONTEXT *tdb, int list, int rw_type));
int tdb_create_rwlocks __P((int fd, unsigned int hash_size));
int tdb_clear_spinlocks __P((TDB_CONTEXT *tdb));
int tdb_clear_spinlocks __P((TDB_CONTEXT *tdb));

/* The following definitions come from tdb/tdb.c  */

void tdb_set_lock_alarm __P((SIG_ATOMIC_T *palarm));
void tdb_dump_all __P((TDB_CONTEXT *tdb));
int tdb_printfreelist __P((TDB_CONTEXT *tdb));
enum TDB_ERROR tdb_error __P((TDB_CONTEXT *tdb));
const char *tdb_errorstr __P((TDB_CONTEXT *tdb));
TDB_DATA tdb_fetch __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_exists __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_traverse __P((TDB_CONTEXT *tdb, tdb_traverse_func fn, void *state));
TDB_DATA tdb_firstkey __P((TDB_CONTEXT *tdb));
TDB_DATA tdb_nextkey __P((TDB_CONTEXT *tdb, TDB_DATA oldkey));
int tdb_delete __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_store __P((TDB_CONTEXT *tdb, TDB_KEY key, TDB_DATA dbuf, int flag));
int tdb_append __P((TDB_CONTEXT *tdb, TDB_KEY key, TDB_DATA new_dbuf));
TDB_CONTEXT *tdb_open __P((const char *name, int hash_size, int tdb_flags,
		      int open_flags, mode_t mode));
TDB_CONTEXT *tdb_open_ex __P((const char *name, int hash_size, int tdb_flags,
			 int open_flags, mode_t mode,
			 tdb_log_func log_fn));
int tdb_close __P((TDB_CONTEXT *tdb));
int tdb_lockall __P((TDB_CONTEXT *tdb));
void tdb_unlockall __P((TDB_CONTEXT *tdb));
int tdb_lockkeys __P((TDB_CONTEXT *tdb, u32 number, TDB_KEY keys[]));
void tdb_unlockkeys __P((TDB_CONTEXT *tdb));
int tdb_chainlock __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_chainunlock __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_chainlock_read __P((TDB_CONTEXT *tdb, TDB_KEY key));
int tdb_chainunlock_read __P((TDB_CONTEXT *tdb, TDB_KEY key));
void tdb_logging_function __P((TDB_CONTEXT *tdb, void (*fn)(TDB_CONTEXT *, int , const char *, ...)));
int tdb_reopen __P((TDB_CONTEXT *tdb));
int tdb_reopen_all __P((void));

/* The following definitions come from tdb/tdbutil.c  */

int tdb_chainlock_with_timeout __P(( TDB_CONTEXT *tdb, TDB_KEY key, unsigned int timeout));
int tdb_lock_bystring __P((TDB_CONTEXT *tdb, const char *keyval, unsigned int timeout));
void tdb_unlock_bystring __P((TDB_CONTEXT *tdb, const char *keyval));
int32 tdb_fetch_int32_byblob __P((TDB_CONTEXT *tdb, const char *keyval, size_t len));
int32 tdb_fetch_int32 __P((TDB_CONTEXT *tdb, const char *keystr));
int tdb_store_int32_byblob __P((TDB_CONTEXT *tdb, const char *keystr, size_t len, int32 v));
int tdb_store_int32 __P((TDB_CONTEXT *tdb, const char *keystr, int32 v));
BOOL tdb_fetch_uint32_byblob __P((TDB_CONTEXT *tdb, const char *keyval, size_t len, uint32 *value));
BOOL tdb_fetch_uint32 __P((TDB_CONTEXT *tdb, const char *keystr, uint32 *value));
BOOL tdb_store_uint32_byblob __P((TDB_CONTEXT *tdb, const char *keystr, size_t len, uint32 value));
BOOL tdb_store_uint32 __P((TDB_CONTEXT *tdb, const char *keystr, uint32 value));
int tdb_store_by_string __P((TDB_CONTEXT *tdb, const char *keystr, void *buffer, int len));
TDB_DATA tdb_fetch_by_string __P((TDB_CONTEXT *tdb, const char *keystr));
int32 tdb_change_int32_atomic __P((TDB_CONTEXT *tdb, const char *keystr, int32 *oldval, int32 change_val));
BOOL tdb_change_uint32_atomic __P((TDB_CONTEXT *tdb, char *keystr, uint32 *oldval, uint32 change_val));
size_t tdb_pack __P((char *buf, int bufsize, const char *fmt, ...));
int tdb_unpack __P((char *buf, int bufsize, const char *fmt, ...));
TDB_CONTEXT *tdb_open_log __P((const char *name, int hash_size, int tdb_flags,
			  int open_flags, mode_t mode));
int tdb_traverse_delete_fn __P((TDB_CONTEXT *the_tdb, TDB_KEY key, TDB_DATA dbuf,
                     void *state));

/* The following definitions come from utils/nbio.c  */

void nb_setup __P((struct cli_state *cli));
void nb_unlink __P((char *fname));
void nb_open __P((char *fname, int handle, int size));
void nb_write __P((int handle, int size, int offset));
void nb_read __P((int handle, int size, int offset));
void nb_close __P((int handle));
void nb_mkdir __P((char *fname));
void nb_rmdir __P((char *fname));
void nb_rename __P((char *old, char *new));
void nb_stat __P((char *fname, int size));
void nb_create __P((char *fname, int size));

/* The following definitions come from utils/torture.c  */

int cli_setfileinfo_test __P((struct cli_state *cli, int fnum, int level, char *data, unsigned int data_len));

/* The following definitions come from web/cgi.c  */

void cgi_load_variables __P((FILE *f1));
const char *cgi_variable __P((const char *name));
BOOL am_root __P((void));
char *cgi_user_name __P((void));
void cgi_setup __P((const char *rootdir, int auth_required));
const char *cgi_baseurl __P((void));
const char *cgi_pathinfo __P((void));
char *cgi_remote_host __P((void));
char *cgi_remote_addr __P((void));
BOOL cgi_waspost __P((void));

/* The following definitions come from web/diagnose.c  */

BOOL nmbd_running __P((void));
BOOL smbd_running __P((void));

/* The following definitions come from web/neg_lang.c  */

void ln_initln __P((void));
BOOL ln_init_lang_env __P((void));
const char* ln_get_lang __P((int nLangDesc));
const char* ln_get_pref_file __P((const char* pFile,
			  SMB_STRUCT_STAT* pst, int* pLangDesc));
BOOL ln_negotiate_language __P((const char* pstrLangarray));
const char* ln_get_pref_file_n_o __P((const char* pFile));

/* The following definitions come from web/startstop.c  */

void start_smbd __P((void));
void start_nmbd __P((void));
void stop_smbd __P((void));
void stop_nmbd __P((void));
void kill_pid __P((pid_t pid));

/* The following definitions come from web/statuspage.c  */

void status_page __P((void));

/* The following definitions come from web/swat.c  */

#endif /* _PROTO_H_ */
