Summary: Wietse Venema's TCP wrappers library
Name: hhl-target-tcp-wrappers
Version: 7.6
Release: %{_hhl_build_id}.2
Source: ftp://coast.cs.purdue.edu/pub/tools/unix/netutils/tcp_wrappers/tcp_wrappers_7.6.tar.gz
Source1: libwrap.tmpl
Source2: libwrap-dev.tmpl
Source3: tcpd.tmpl
Patch: tcp-wrappers_7.6-7.diff
Patch10: tcp-wrappers-owner.diff
License: Other
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir 	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

%description
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# libwrap
%package -n hhl-%{_hhl_target_arch}-libwrap
Summary: Wietse Venema's TCP wrappers library
Group: base
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-libwrap
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# libwrap-dev
%package -n hhl-%{_hhl_target_arch}-libwrap-dev
Summary: Wietse Venema's TCP wrappers library, development files
Group: base
Requires: hhl-%{_hhl_target_arch}-libwrap = %{version}
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-libwrap-dev
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# tcpd
%package -n hhl-%{_hhl_target_arch}-tcpd
Summary: Wietse Venema's TCP wrappers utilities
Group: base
AutoReqProv: no
%description -n hhl-%{_hhl_target_arch}-tcpd
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

%prep
%target_check
%setup -q -n tcp_wrappers_%{version}
%patch -p1
%patch10 -p1

%build
%target_setup
%make 	REAL_DAEMON_DIR=%{_hhl_target_sbin_dir} \
	LIBS=-lnsl \
	ARFLAGS=rv AUX_OBJ=weak_symbols.o \
	NETGROUP=-DNETGROUP TLI= VSYSLOG= BUGS= all \
	EXTRA_CFLAGS="-DSYS_ERRLIST_DEFINED -DHAVE_WEAKSYMS -D_REENTRANT" \
	CC=%{_hhl_target_toolprefix}gcc \
	| tee ../build.log

%install
rm -rf %{buildroot}
%target_setup

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/lib
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man3
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man5
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man8
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/sbin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/lib
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/include

make install-lib DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log
make install-bin DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log
make install-dev DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log

install -m 0644 debian/try-from.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/try-from.8
install -m 0644 debian/safe_finger.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/safe_finger.8

rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so
ln -s ../../lib/libwrap.so.0 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*

cp debian/copyright LICENSE


install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tcpd

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-libwrap
%defattr(-,root,root)
%{_hhl_cross_target_dir}/lib/libwrap.so.0
%{_hhl_cross_target_dir}/lib/libwrap.so.0.7.6
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/hosts_access.5.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/hosts_options.5.gz
%doc BLURB CHANGES DISCLAIMER README README.NIS
%doc debian/README.Debian debian/changelog
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap

%files -n hhl-%{_hhl_target_arch}-libwrap-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/tcpd.h
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/hosts_access.3.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap-dev

%files -n hhl-%{_hhl_target_arch}-tcpd
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpdchk
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpdmatch
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/try-from
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/safe_finger
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpdmatch.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/try-from.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/safe_finger.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpd.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpdchk.8.gz
%doc LICENSE

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tcpd

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Thu Jan 25 2001 Mark Hatle <source@mvista.com>
- Fixed an incorrect lib .../usr/lib/libwrap.so

* Tue Jan 23 2001 Mark Hatle <source@mvista.com>
- First cut

