Summary   	: Synchronizes system time using the Network Time Protocol (NTP).
Name	  	: hhl-target-ntp
Version	  	: 4.0.99g
Release	  	: %{_hhl_build_id}.2
Source	  	: ntp_%{version}.orig.tar.gz 
Source1: ntp.tmpl
Patch		: ntp_%{version}-3.diff.gz
Patch1		: ntp-4.0.99g.time_h.patch
Patch2		: ntp-hhl.diff
License 	: Other
Group	  	: System Environment/Daemons
Buildroot 	: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix	  	: %{_hhl_cross_target_dir}
%define _defaultdocdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

#
#	SRPM
#
%description

The Network Time Protocol (NTP) is used to synchronize a computer's
time with another reference time source.  The ntp package contains
utilities and daemons which will synchronize your computer's time to
Coordinated Universal Time (UTC) via the NTP protocol and NTP servers.
The ntp package includes ntpdate (a program for retrieving the date
and time from remote machines via a network) and ntpd (a daemon which
continuously adjusts system time).

Install the ntp package if you need tools for keeping your system's
time synchronized via the NTP protocol.

#
#	RPM
#

%package -n hhl-%{_hhl_target_arch}-ntp
Summary		: Synchronizes system time using the Network Time Protocol (NTP).
Group		: System Environment/Daemons
AutoReqProv	: no

%description -n hhl-%{_hhl_target_arch}-ntp

The Network Time Protocol (NTP) is used to synchronize a computer's
time with another reference time source.  The ntp package contains
utilities and daemons which will synchronize your computer's time to
Coordinated Universal Time (UTC) via the NTP protocol and NTP servers.
The ntp package includes ntpdate (a program for retrieving the date
and time from remote machines via a network) and ntpd (a daemon which
continuously adjusts system time).

Install the ntp package if you need tools for keeping your system's
time synchronized via the NTP protocol.

%prep

%target_check
%setup -n ntp-%{version}
%patch -p1
%patch1 -p1
%patch2 -p1

%build
PATH=%{_hhl_cross_bin_dir}:$PATH

%target_setup

%target_acplatvars
export ac_cv_sizeof_signed_char=1
%if "%{_hhl_target_cpu_type}" == "mips"
export ac_cv_func_timer_create=no
export ac_cv_func_timer_settime=no
%endif

%target_configure
make CC="$CC -DCLOCK_REALTIME=0"

%install
%target_setup
PATH=%{_hhl_cross_bin_dir}:$PATH
rm -rf %{buildroot}

%target_makeinstall bindir=%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
cd ..
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/bin/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1
        for file in ntpq ntpdc ntptrace; do \
                mv %{buildroot}%{_hhl_cross_target_dir}/usr/sbin/$file %{buildroot}%{_hhl_cross_target_dir}/usr/bin/$file; \
        done
        install -m 0755 debian/configure-ntp \
                %{buildroot}%{_hhl_cross_target_dir}/usr/sbin/configure-ntp
        install -m 0644 debian/ntpdate.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpdate.1
        install -m 0644 debian/useless.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntptimeset.1
        install -m 0644 debian/configure-ntp.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/configure-ntp.1
        install -m 0644 debian/ntpd.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpd.1
        install -m 0644 debian/useless.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpdc.1

install -d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d
install -d %{buildroot}%{_hhl_cross_target_dir}/etc/cron.weekly
install -d %{buildroot}%{_hhl_cross_target_dir}/etc/cron.daily
install debian/init.d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d/ntp
install debian/cron.weekly %{buildroot}%{_hhl_cross_target_dir}/etc/cron.weekly/ntp
install debian/cron.daily %{buildroot}%{_hhl_cross_target_dir}/etc/cron.daily/ntp
install debian/ntpdate.init.d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d/ntpdate
gzip -9f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*

cp COPYRIGHT LICENSE


install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ntp

%clean
rm -rf %{buildroot}

%files -n hhl-%{_hhl_target_arch}-ntp
%defattr(-,root,root)
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.daily/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.weekly/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ntpdate
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntpdc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntpq
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntptrace
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/configure-ntp
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntpd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntpdate
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntptime
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntptimeset
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tickadj
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/configure-ntp.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpd.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpdate.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpdc.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntptimeset.1.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ntp

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Sun Apr 08 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file
