Summary: GNU dbm database routines (runtime version). 
Name: gdbm
Version: 1.7.3
Release: 3.0.0.%{_hhl_build_id}
Source: ftp://prep.ai.mit.edu/pub/gnu/gdbm-%{version}.tar.gz
Source1: libgdbm.tmpl
Source2: libgdbm-dev.tmpl
Patch0: gdbm-1.8.0-jbj.patch
Patch1: gdbm-1.8.0_Makefile.patch
License: GPL
Group: libs
%define pkgname libgdbm
Buildroot: %{_tmppath}/%{pkgname}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}

%define _libdir		%{targetroot}%{_hhl_target_lib_dir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _infodir	%{targetroot}%{_hhl_target_info_dir}
%define _includedir	%{targetroot}%{_hhl_target_include_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-gdbm

%description
GNU dbm ('gdbm') is a library of database functions that use extendible
hashing and works similarly to the standard UNIX 'dbm' functions.

The basic use of 'gdbm' is to store key/data pairs in a data file, thus
providing a persistent version of the 'dictionary' Abstract Data Type
('hash' to perl programmers).


%package -n %{pkgname}
Summary: GNU dbm database routines (runtime version). 
Group: libs
Provides: gdbm = %{version}

Obsoletes : hhl-%{_hhl_target_arch}-libgdbm

%description -n %{pkgname}
GNU dbm ('gdbm') is a library of database functions that use extendible
hashing and works similarly to the standard UNIX 'dbm' functions.

The basic use of 'gdbm' is to store key/data pairs in a data file, thus
providing a persistent version of the 'dictionary' Abstract Data Type
('hash' to perl programmers).


%package -n %{pkgname}-dev
Summary: GNU dbm database routines (development files)
Group: devel
Requires: %{pkgname}

Obsoletes : hhl-%{_hhl_target_arch}-libgdbm-dev

%description -n %{pkgname}-dev
GNU dbm ('gdbm') is a library of database functions that use extendible
hashing and works similarly to the standard UNIX 'dbm' functions.

This library is no longer supported by the FSF, and hasn't been worked on
in several years -- for new applications, please consider libdb instead, and
also consider migrating old applications.


%prep
%target_check
%setup -q -n gdbm-%{version}
%patch -p1
#%patch1 -p1

%build
%target_setup

./configure --prefix=/usr
echo "/* We use fcntl locking (POSIX) instead of flock (BSD) */" >> autoconf.h
echo "#undef HAVE_FLOCK" >> autoconf.h

mkdir -p shared static

# First build the shared library
#
cd shared
%make -f ../Makefile VPATH=".." srcdir=".." \
	CFLAGS="%{optflags} -fPIC -D_REENTRANT"
${CC} -shared -Wl,-soname,libgdbm.so.1 -o libgdbm.so.1.7.3 *.o

# Build the static library
#
cd ../static
%make -f ../Makefile VPATH=".." srcdir=".." \
	CFLAGS="%{optflags} -D_REENTRANT"

cd ..
%make gdbm.info


%install
%target_setup
rm -rf %{buildroot}

install -d %{buildroot}
for i in %{_libdir} %{_includedir} %{_mandir}/man3 %{_infodir} ; do
	(cd %{buildroot} && install -d ./$i)
done

install -m 644 shared/libgdbm.so.1.7.3 %{buildroot}%{_libdir}/libgdbm.so.1.7.3
install -m 644 static/libgdbm.a %{buildroot}%{_libdir}/libgdbm.a
install -m 644 static/gdbm.h dbm.h %{buildroot}%{_includedir}/
install -m 644 ndbm.h %{buildroot}%{_includedir}/gdbm-ndbm.h
install -m 644 gdbm.3 %{buildroot}%{_mandir}/man3/gdbm.3gdbm

gzip -9v %{buildroot}%{_mandir}/man3/*

ln -s gdbm-ndbm.h %{buildroot}%{_includedir}/ndbm.h
ln -s libgdbm.so.1.7.3 %{buildroot}%{_libdir}/libgdbm.so.1
ln -s libgdbm.so.1.7.3 %{buildroot}%{_libdir}/libgdbm.so.2
ln -s libgdbm.so.1.7.3 %{buildroot}%{_libdir}/libgdbm.so
ln -s libgdbm.so.1.7.3 %{buildroot}%{_libdir}/libdbm.so
ln -s libgdbm.a %{buildroot}%{_libdir}/libdbm.a

pushd %{buildroot}%{_mandir}/man3
for i in dbm gdbm_error gdbm_errno gdbm_open gdbm_close gdbm_store \
	gdbm_fetch gdbm_delete gdbm_firstkey gdbm_nextkey gdbm_reorganize \
	gdbm_sync gdbm_exists gdbm_strerror gdbm_setopt dbminit store \
	fetch delete firstkey nextkey dbmclose dbm_open dbm_close \
	dbm_fetch dbm_store dbm_delete dbm_firstkey dbm_nextkey \
	dbm_error dbm_clearerr dbm_pagfno dbm_dirfno dbm_rdonly ; do \
    ln -s gdbm.3gdbm.gz $i.3gdbm.gz ; \
done
popd

install -m 644 gdbm.info %{buildroot}%{_infodir}/gdbm.info
gzip -9v %{buildroot}%{_infodir}/*
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgdbm
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgdbm-dev

%clean
rm -rf %{buildroot}


%files -n %{pkgname}
%defattr(-,root,root)
%{_libdir}/libgdbm.so.1.7.3
%{_libdir}/libgdbm.so.1
%{_libdir}/libgdbm.so.2
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgdbm


%files -n %{pkgname}-dev
%defattr(-,root,root)
%{_libdir}/libdbm.a
%{_libdir}/libdbm.so
%{_libdir}/libgdbm.a
%{_libdir}/libgdbm.so
%{_includedir}/*
%{_infodir}/gdbm.info.gz
%{_mandir}/man3/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgdbm-dev
%doc LICENSE

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Mon Feb 26 2001 Matthew McLean <source@mvista.com>
- First cut


