Summary: The GNU bc arbitrary precision calculator language
Name: bc
Version: 1.06
Release: 2.0.0.%{_hhl_build_id}
Source: bc_1.06.orig.tar.gz
Source1: bc.tmpl
Source2: dc.tmpl
Patch: bc_1.06-8.diff.gz
License: GPL
Group: interpreters
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir         %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-bc
Obsoletes : hhl-%{_hhl_target_arch}-bc

%description
GNU bc is an interactive algebraic language with arbitrary precision which
follows the POSIX 1003.2 draft standard, with several extensions including
multi-character variable names, an `else' statement and full Boolean
expressions.  GNU bc does not require the separate GNU dc program.  

# Primary package

%package -n dc
Summary: The GNU dc arbitrary precision reverse-polish calculator
Group: interpreters
Provides: dc = %{version}

Obsoletes : hhl-%{_hhl_target_arch}-dc

%description -n dc
GNU dc is a reverse-polish desk calculator which supports unlimited
precision arithmetic.  It also allows you to define and call macros.

A reverse-polish calculator stores numbers on a stack. Entering a number
pushes it on the stack.  Arithmetic operations pop arguments off the
stack and push the results.


%prep
%target_check
%setup -n bc-1.06
%patch -p1


%build
%target_setup
export ac_cv_header_stddef_h=no
%target_configure --with-readline | tee ../build.log
%make CFLAGS="-O2 -g -Wall -D_POSIX_SOURCE -DDOT_IS_LAST" \
	| tee -a ../build.log

cd ..
cd doc; texi2html -monolithic -expandinfo -number dc.texi \
	| tee -a build.log


%install
rm -rf %{buildroot}
%target_setup
%target_makeinstall | tee -a build.log

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*.info
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/*

cd ..
cp -f COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/dc


%clean
rm -rf %{buildroot}


%files -n bc
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/bc
%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/bc.info.gz
%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/bc.1.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bc
%doc build.log
%doc LICENSE README NEWS FAQ


%files -n dc
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/dc
%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/dc.info.gz
%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/dc.1.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/dc
%doc LICENSE



