summary: OpenSSH Secure Shell (ssh) client and server 
Name: openssh
Version: 3.7.1p2
Release: 2.0.0.%{_hhl_build_id}
Source:  openssh-3.7.1p2.tar.gz
Source1: openssh.tmpl
Source2: openssh-clients.tmpl
Source3: openssh-server.tmpl
Patch0: openssh_3.7.1p2-1.diff.gz
Patch1: openssh-initd.diff
Patch2: openssh-force-cross.diff
Patch3: mvl-openssh-xtensa.patch
License: Other
Group: crypto
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir		%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}
BuildRequires: libwrap-dev zlib-dev openssl-dev libpam-dev

Obsoletes : hhl-target-openssh
Obsoletes : hhl-%{_hhl_target_arch}-openssh

%description
This is the portable version of OpenSSH, a free implementation of
the Secure Shell protocol as specified by the IETF secsh working
group.

Ssh (Secure Shell) is a program for logging into a remote machine
and for executing commands on a remote machine.  
It provides secure encrypted communications between two untrusted
hosts over an insecure network.  X11 connections and arbitrary TCP/IP
ports can also be forwarded over the secure channel.

# ssh

%package -n openssh-server
Summary: OpenSSH Secure Shell (ssh) server
Group: net
Obsoletes : hhl-%{_hhl_target_arch}-openssh-server

%description -n openssh-server
This packages contains files needed to run an ssh server

# ssh-clients

%package -n openssh-clients
Summary: OpenSSH Secure Shell (ssh) clients
Group: net  
Obsoletes : hhl-%{_hhl_target_arch}-openssh-clients

%description -n openssh-clients
This package contains files need to run an ssh client (ssh, scp)

# ssh-doc

%package -n openssh-doc
Summary: OpenSSH Secure Shell (ssh) doc
Group: Documentation
Obsoletes : hhl-%{_hhl_target_arch}-openssh-doc

%description -n openssh-doc
This package contains the ssh documentation


%prep
%target_check
%setup -q -n openssh-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%target_setup
%target_acplatvars

export ac_cv_func_getpgrp_void=yes
export ac_cv_file___dev_ptc_=no
export ac_cv_file___dev_urandom_=yes
export ac_cv_have_accrights_in_msghdr=no
export ac_cv_have_control_in_msghdr=yes
export enable_etc_default_login=no
export LD=${CC}

%target_configure \
	--with-tcp-wrappers --sysconfdir=%{_hhl_target_sysconf_dir}/ssh \
	--libexecdir=%{_hhl_target_lib_dir}/openssh \
	--with-md5-passwords --with-pam --with-ipv4-default --with-privsep-path=/var/run/sshd

make CFLAGS='-O2 -DBROKEN_CMSG_TYPE -Wall -DLOGIN_PROGRAM=\"/bin/login\" -DSSHD_PAM_SERVICE=\"ssh\" -D__FILE_OFFSET_BITS=64'

#make all LIBS="-lpam -ldl -lwrap -lz -lnsl  -lutil  -lcrypto"
#%make ASKPASS_PROGRAM1='/usr/bin/ssh-askpass'
#not making gnome-ssh-askpass for now..


%install
rm -rf %{buildroot}

mv LICENCE LICENSE

%target_setup

cd %{_objdir}
make DESTDIR=%{buildroot}%{_hhl_cross_target_dir} STRIP_OPT="" install-files

#pam stuff
install -d -m 755 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d
install -p -m 644 ../debian/ssh.pam %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d/ssh 
# debian init.. should we have a %_dh_installinit macro?
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/var/run/sshd
install -p -m 755 ../debian/init %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ssh

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default
echo "# Set AUTOKEYGEN=yes to make the ssh init script autogenerate" \
	> %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/ssh
echo "# the required keys if they are not on the system." \
	>> %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/ssh
echo "AUTOKEYGEN=no" \
	>> %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/ssh

rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/slogin.1
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
ln -s ssh.1.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/slogin.1.gz

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh-clients
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh-server


%clean
rm -rf %{buildroot}


%files -n openssh
%defattr(-,root,root)
%doc ChangeLog OVERVIEW README* INSTALL
%doc CREDITS LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ssh-keygen
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ssh-keyscan
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ssh-keygen.1*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ssh-keyscan.1*
%dir %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssh
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssh/moduli
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/openssh/ssh-keysign
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh
%{_hhl_cross_target_dir}%{_hhl_target_sharedstate_dir}/Ssh.bin
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ssh-keysign.8.gz


%files -n openssh-clients
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ssh
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ssh-agent
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ssh-add
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/scp
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ssh.1*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ssh-agent.1*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ssh-add.1*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/scp.1*
%config(noreplace) %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssh/ssh_config
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/slogin
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/slogin.1*
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/sftp
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/sftp.1*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/ssh_config.5.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh-clients



%files -n openssh-server
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/sshd
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/openssh/sftp-server
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/sshd.8*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/sftp-server.8*
%config(noreplace) %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/ssh/sshd_config
%config(noreplace) %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/pam.d/ssh
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ssh
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/default/ssh
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/sshd_config.5.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/openssh-server
%dir %{_hhl_cross_target_dir}/var/run/sshd

%changelog
* Mon Jun 03 2002 Joe Green <source@mvista.com>
- Added support for Xtensa architecture.
* Mon Jan 28 2002 Mark Hatle <source@mvista.com>
- Updated to 3.0.2p1
- Slightly changed the package layout to move scp under the client
- Move the moduli (replacement of the "primes" file) to the base package
* Mon Apr 23 2001 Steve Kinneberg <skinneberg@mvista.com>
- Added pkg desc file generation
* Fri Mar 02 2001 Troy Benjegerdes <tbenjegerdes@mvista.com>
- Fix cross-compile issues
* Thu Feb 22 2001 Troy Benjegerdes <tbenjegerdes@mvista.com>
- First cut


