Summary: Pluggable Authentication Modules library
Name: pam
Version: 0.72
Release: 7.0.0.%{_hhl_build_id}
Source: ftp://ftp.kernel.org/pub/linux/libs/pam/pre/library/Linux-PAM-0.72.tar.gz
Source1: hardhat.defs
Source2: libpam.tmpl
Source3: libpam-modules.tmpl
Source4: libpam-runtime.tmpl
Source5: libpam-dev.tmpl
Source6: libpam-cracklib.tmpl
Source7: pam-doc.tmpl
Patch: pam_0.72-30.diff.gz
Patch1: pam_0.72-hhl.diff
Patch2: mvl-shadow-group.diff
License: BSD/GPL
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
BuildRequires: libcap-dev
BuildRequires: cracklib-dev
BuildRequires: libdb3-dev
%define _docdir		%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-pam

%description
Linux-PAM, a suite of shared libraries that enable the local system 
administrator to choose how applications authenticate users.  In other 
words, without rewriting or recompiling a PAM-aware application, it is 
possible to switch between the authentication mechanism(s) it uses.  One 
may entirely upgrade the local authentication system without touching the
applications themselves.

# libpam package

%package -n libpam
Summary: Pluggable Authentication Modules library
Group: base
Requires: libpam-runtime
Provides: pam = %{version}

Obsoletes : hhl-%{_hhl_target_arch}-libpam

%description -n libpam
Contains the C shared library for Linux-PAM, a suite of shared
libraries that enable the local system administrator to choose how
applications authenticate users.  In other words, without rewriting
or recompiling a PAM-aware application, it is possible to switch
between the authentication mechanism(s) it uses.  One may entirely
upgrade the local authentication system without touching the
applications themselves.

# libpam-modules

%package -n libpam-modules
Summary: Pluggable Authentication Modules for PAM
Group: base
Obsoletes : hhl-%{_hhl_target_arch}-libpam-modules

%description -n libpam-modules
This package completes the set of modules for PAM. It includes the
the pam_unix_*.so module as well as some specialty modules.

# libpam-runtime

%package -n libpam-runtime
Summary: Runtime support for the PAM library
Group: base
Obsoletes : hhl-%{_hhl_target_arch}-libpam-runtime

%description -n libpam-runtime
Contains the base setup for libpam

# libpam-dev

%package -n libpam-dev
Summary: Development files for PAM
Group: devel
Obsoletes : hhl-%{_hhl_target_arch}-libpam-dev

%description -n libpam-dev
Contains C header files and development shared libraries libraries for
libpam, the pluggable authentication modules, a suite of shared libraries
that enable the local system administrator to choose how applications
authenticate users.

PAM decouples applications from the authentication mechanism, making it
possible to upgrade the authentication system without recompiling or
rewriting the applications.

# libpam-cracklib

%package -n libpam-cracklib
Summary: PAM module to enable cracklib support.
Group: libs
Obsoletes : hhl-%{_hhl_target_arch}-libpam-cracklib

%description -n libpam-cracklib
This module allows the use of cracklib in the authentication model.

# libpam-doc

%package -n pam-doc
Summary: Documentation of PAM
Group: doc
Obsoletes : hhl-%{_hhl_target_arch}-pam-doc

%description -n pam-doc
Contains documentation (in HTML, ASCII, and PostScript format) for
libpam, the Pluggable Authentication Modules library, a suite of shared
libraries that enable the local system administrator to choose how
applications authenticate users.


%prep
%target_check
%setup -q -n Linux-PAM-%{version}
%patch -p1
cp %{SOURCE1} defs
patch -p1 < debian/patches/000_libs_main
patch -p1 < debian/patches/001_modules_pam_filter
patch -p1 < debian/patches/002_install_conf
patch -p1 < debian/patches/003_doc
patch -p1 < debian/patches/004_modules_makefiles
patch -p1 < debian/patches/005_modules_pam_securetty
patch -p1 < debian/patches/006_compile_warnings
patch -p1 < debian/patches/007_modules_pam_unix
patch -p1 < debian/patches/008_modules_pam_limits
patch -p1 < debian/patches/009_modules_pam_wheel
patch -p1 < debian/patches/010_modules_pam_limits_chroot
patch -p1 < debian/patches/011_modules_pam_rhosts
patch -p1 < debian/patches/012_modules_pam_listfile
patch -p1 < debian/patches/013_source_cleanup
patch -p1 < debian/patches/014_modules_pam_rhosts
patch -p1 < debian/patches/015_cplusplus
patch -p1 < debian/patches/016_modules_pam_access
patch -p1 < debian/patches/017_modules_pam_group
patch -p1 < debian/patches/018_modules_pam_time  
patch -p1 < debian/patches/019_modules_pam_userdb
patch -p1 < debian/patches/020_hurd
patch -p1 < debian/patches/021_gcc_linker
patch -p1 < debian/patches/022_modules_pam_mkhomedir
patch -p1 < debian/patches/023_gethostname
patch -p1 < debian/patches/024_pam_env_fix
patch -p1 < debian/patches/025_pam_issue_time
patch -p1 < debian/patches/026_pam_limits_cap.diff   
patch -p1 < debian/patches/027_unix_chkpwd_null
patch -p1 < debian/patches/028_man_whatis_fix
patch -p1 < debian/patches/029_listfile_arg_fix
patch -p1 < debian/patches/030_securetty_log.diff
patch -p1 < debian/patches/031_pam_limits_group_fix.diff
patch -p1 < debian/patches/032_pam_listfile_quiet.diff
patch -p1 < debian/patches/033_man_move.diff
patch -p1 < debian/patches/034_pam_include.diff
patch -p1 < debian/patches/035_pam_userdb_db3.diff
patch -p1 < debian/patches/036_unix_nis_locking
patch -p1 < debian/patches/037_sigCHLD_blocking
patch -p1 < debian/patches/038_time_and_unknown_users
patch -p1 < debian/patches/039_clean_64bit_md5
patch -p1 < debian/patches/040_hurd_limits
%patch1 -p1
%patch2 -p1

%build
%target_setup
ln -sf defs/hardhat.defs default.defs
touch .freezemake

# Make libpam.so for linking the modules
%make  \
	ARCH=%{_hhl_target_cpu} \
	CC="%{_hhl_target_toolprefix}gcc" \
	LD=%{_hhl_target_toolprefix}gcc \
	AR="%{_hhl_target_toolprefix}ar -cr" \
	RANLIB=%{_hhl_target_toolprefix}ranlib \
	bootstrap-libpam

# Compile everything else
%make \
	ARCH=%{_hhl_target_cpu} \
	CC="%{_hhl_target_toolprefix}gcc " \
	LD=%{_hhl_target_toolprefix}gcc \
	AR="%{_hhl_target_toolprefix}ar -cr" \
	RANLIB=%{_hhl_target_toolprefix}ranlib \
	DIRS="libpam_misc modules libpam libpamc"

# Build the docs
%make \
	ARCH=%{_hhl_target_cpu} \
	CC=%{_hhl_target_toolprefix}gcc \
	LD=%{_hhl_target_toolprefix}gcc \
	AR="%{_hhl_target_toolprefix}ar -cr" \
	RANLIB=%{_hhl_target_toolprefix}ranlib \
	DIRS=doc


%install
rm -rf %{buildroot}
%target_setup

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/sgml/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/ps/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/html/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/txt/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/sgml/modules/

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/etc/pam.d
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/sbin/

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man7
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8

(cd doc
 install -m 0644 *.sgml \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/sgml/
 install -m 0644 ps/*.ps \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/ps/
 install -m 0644 html/*.html \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/html/
 install -m 0644 txts/*.txt \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/txt/
 install -m 0644 modules/*.sgml \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/sgml/modules/
)

(cd debian/local
 install -m 0644 pam-*-guide \
	%{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}/pam-doc-%{version}/
 install -m 0644 Debian-PAM-MiniPolicy \
	%{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}/pam-doc-%{version}/
)

%make \
	ARCH=%{_hhl_target_cpu} \
	CC=%{_hhl_target_toolprefix}gcc \
	LD=%{_hhl_target_toolprefix}ld \
	AR="%{_hhl_target_toolprefix}ar -cr" \
	RANLIB=%{_hhl_target_toolprefix}ranlib \
	install FAKEROOT=%{buildroot}%{_hhl_cross_target_dir} \
	DIRS="libpam libpam_misc modules libpamc"

install -m 0644 debian/local/pam.conf \
	%{buildroot}%{_hhl_cross_target_dir}/etc/

install -m 0644 debian/local/other \
	%{buildroot}%{_hhl_cross_target_dir}/etc/pam.d/

install -m 0644 doc/man/*.3 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/

install -m 0644 doc/man/*.5 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/

install -m 0644 doc/man/*.7 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man7/

install -m 0644 doc/man/*.8 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/

install -m 0644 debian/local/*.8 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/

install -m 0644 debian/local/pam-undocumented.7 \
	%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man7/

gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*

for i in pam_set_item pam_get_item pam_acct_mgmt \
    pam_putenv pam_getenv misc_conv pam_misc_paste_env \
    pam_misc_copy_env pam_misc_drop_env pam_misc_setenv ; do \
  ln -s ../man7/pam-undocumented.7.gz \
     %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/$i.3.gz ; \
done

rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam.so
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam_misc.so
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpamc.so
ln -s ../../lib/libpam.so.0.72 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam.so
ln -s ../../lib/libpam_misc.so.0.72 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam_misc.so
ln -s ../../lib/libpamc.so.0.72 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpamc.so

cp Copyright LICENSE

install  Copyright %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}/pam-doc-%{version}/LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-modules
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-runtime
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE5} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE6} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-cracklib
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE7} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/pam-doc

%clean
rm -rf %{buildroot}


%files -n libpam
%defattr(-,root,root)
%{_hhl_cross_target_dir}/lib/libpam.so.0
%{_hhl_cross_target_dir}/lib/libpam.so.0.72
%{_hhl_cross_target_dir}/lib/libpam_misc.so.0
%{_hhl_cross_target_dir}/lib/libpam_misc.so.0.72
%{_hhl_cross_target_dir}/lib/libpamc.so.0
%{_hhl_cross_target_dir}/lib/libpamc.so.0.72
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam
%doc LICENSE

%files -n libpam-modules
%defattr(-,root,root)
%config %{_hhl_cross_target_dir}/etc/security/access.conf
%config %{_hhl_cross_target_dir}/etc/security/group.conf
%config %{_hhl_cross_target_dir}/etc/security/limits.conf
%config %{_hhl_cross_target_dir}/etc/security/pam_env.conf
%config %{_hhl_cross_target_dir}/etc/security/time.conf
%{_hhl_cross_target_dir}/lib/security/pam_access.so
%{_hhl_cross_target_dir}/lib/security/pam_deny.so
%{_hhl_cross_target_dir}/lib/security/pam_env.so
%{_hhl_cross_target_dir}/lib/security/pam_filter.so
%{_hhl_cross_target_dir}/lib/security/pam_ftp.so
%{_hhl_cross_target_dir}/lib/security/pam_group.so
%{_hhl_cross_target_dir}/lib/security/pam_issue.so
%{_hhl_cross_target_dir}/lib/security/pam_lastlog.so
%{_hhl_cross_target_dir}/lib/security/pam_limits.so
%{_hhl_cross_target_dir}/lib/security/pam_listfile.so
%{_hhl_cross_target_dir}/lib/security/pam_mail.so
%{_hhl_cross_target_dir}/lib/security/pam_mkhomedir.so
%{_hhl_cross_target_dir}/lib/security/pam_motd.so
%{_hhl_cross_target_dir}/lib/security/pam_nologin.so
%{_hhl_cross_target_dir}/lib/security/pam_permit.so
%{_hhl_cross_target_dir}/lib/security/pam_rhosts_auth.so
%{_hhl_cross_target_dir}/lib/security/pam_rootok.so
%{_hhl_cross_target_dir}/lib/security/pam_securetty.so
%{_hhl_cross_target_dir}/lib/security/pam_shells.so
%{_hhl_cross_target_dir}/lib/security/pam_stress.so
%{_hhl_cross_target_dir}/lib/security/pam_tally.so
%{_hhl_cross_target_dir}/lib/security/pam_time.so
%{_hhl_cross_target_dir}/lib/security/pam_unix.so
%{_hhl_cross_target_dir}/lib/security/pam_unix_acct.so
%{_hhl_cross_target_dir}/lib/security/pam_unix_auth.so
%{_hhl_cross_target_dir}/lib/security/pam_unix_passwd.so
%{_hhl_cross_target_dir}/lib/security/pam_unix_session.so
%{_hhl_cross_target_dir}/lib/security/pam_userdb.so
%{_hhl_cross_target_dir}/lib/security/pam_warn.so
%{_hhl_cross_target_dir}/lib/security/pam_wheel.so
%{_hhl_cross_target_dir}/sbin/unix_chkpwd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/pam_tally
#%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/pam_tally.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/unix_chkpwd.8.gz

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-modules


%files -n libpam-runtime
%defattr(-,root,root)
%config %{_hhl_cross_target_dir}/etc/pam.conf
%config %{_hhl_cross_target_dir}/etc/pam.d/other
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man7/*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/pam.d.8.gz

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-runtime


%files -n libpam-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/security/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam_misc.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpam_misc.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpamc.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpamc.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-dev
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/*

%doc LICENSE


%files -n libpam-cracklib
%defattr(-,root,root)
%{_hhl_cross_target_dir}/lib/security/pam_cracklib.so

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libpam-cracklib


%files -n pam-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}/pam-doc-%{version}/
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/pam-doc


%changelog
* Fri Aug 3 2001 Daniel Jacobowitz <source@mvista.com>
- Build with $(CC) instead of $(LD).
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Mar 06 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file



