Summary: A CRT screen handling and optimization package.
Name: ncurses
Version: 5.2
Release: 6.0.0.%{_hhl_build_id}
Source: ncurses-%{version}.tar.gz
Source1: hhl-libopt-build-ncurses
Source2: libncurses.tmpl
Source3: libncurses-dev.tmpl
Source4: libncurses-dbg.tmpl
Source5: libncurses-pic.tmpl
Source6: libncurses-libopt.tmpl
Source7: ncurses-bin.tmpl
Source8: ncurses-base.tmpl
Source9: ncurses-term.tmpl
Patch: ncurses-5.2-20010714.patch.gz
Patch1: ncurses_%{version}-pic.diff
Patch2: ncurses_%{version}-crosslib.diff
Patch3: ncurses_%{version}-tichack.diff
Patch4: mvl-ncurses-config_xtensa.patch
License: Other
Group: libs
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
BuildRequires: cross-%{_hhl_target_arch}-libopt
%define _docdir		%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-ncurses

%description
The curses library routines are a terminal-independent method of
updating character screens with reasonable optimization.  The ncurses
(new curses) library is a freely distributable replacement for the
discontinued 4.4BSD classic curses library.

Ncurses also contains libtermcap functionality and should be linked
into programs instead of libtermcap.

# libncurses

%package -n libncurses
Summary: Shared libraries for terminal handling
Group: base
Requires: ncurses-base = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libncurses

%description -n libncurses
This package contains the shared libraries necessary to run programs
compiled with ncurses.

# libncurses-dev

%package -n libncurses-dev
Summary: Developer's libraries for ncurses
Group: devel
Requires: libncurses = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libncurses-dev

%description -n libncurses-dev
This package contains the header files, static libraries
and symbolic links that developers using ncurses will need.

# libncurses-dbg

%package -n libncurses-dbg
Summary: Debugging/profiling libraries for ncurses
Group: devel
Requires: libncurses-dev = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libncurses-dbg

%description -n libncurses-dbg
This package contains the static debugging and profiling libraries and
symbolic links that developers using ncurses will need.

# libncurses-pic

%package -n libncurses-pic
Summary: Ncurses PIC archive library
Group: devel
Requires: libncurses = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libncurses-pic

%description -n libncurses-pic
This package contains an archive file (ar file) componed of individual 
shared objects.  This is used for creating a library which is a smaller 
subset of the standard ncurses shared library.

# libncurses-libopt

%package -n libncurses-libopt
Summary: Ncurses Library Optimizer information
Group: devel
Requires: libncurses = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libncurses-libopt

%description -n libncurses-libopt
Contains information for the Library Optimizer Tool.
This is used for creating a library which is a smaller 
subset of the standard ncurses shared library.

# ncurses-bin

%package -n ncurses-bin
Summary: Terminal-related programs and man pages
Group: devel
Requires: libncurses = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-ncurses-bin

%description -n ncurses-bin
This package contains the programs used for manipulating the terminfo
database and individual terminfo entries, as well as some programs for
resetting terminals and such.

# ncurses-base

%package -n ncurses-base
Summary: Descriptions of common terminal types
Group: base
Obsoletes : hhl-%{_hhl_target_arch}-ncurses-base

%description -n ncurses-base
This package contains what should be a reasonable subset of terminal
definitions, including: ansi, dumb, linux, rxvt, screen, sun, vt100,
vt102, vt220, vt52, and xterm.

# ncurses-term

%package -n ncurses-term
Summary: Additional terminal type definitions
Group: base
Requires: ncurses-base = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-ncurses-term

%description -n ncurses-term
This package contains all of the terminal definitions not found in
the ncurses-base package.  There are far too many to list here.


%prep
%target_check
%setup -q -n ncurses-%{version}
gunzip -c %PATCH0 |  patch -l -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1


%build
# We build a full version for the host... easy way to get a runable tic
mkdir HOSTOBJDIR
cd HOSTOBJDIR
../configure --disable-shared --without-cxx --without-cxx-binding \
	--without-ada --without-curses-h --disable-termcap | tee ../build.log
%make | tee -a ../build.log
cd ..

%target_setup
%target_configure \
	--with-install-prefix=%{buildroot}%{_hhl_cross_target_dir} \
	--with-profile \
	--with-shared \
	--disable-rpath --enable-echo --enable-overwrite \
	--disable-termcap \
	--with-terminfo-dirs="/etc/terminfo:/usr/share/terminfo" \
	| tee -a ../build.log

%make HOSTCC=gcc | tee -a ../build.log


%install
rm -rf %{buildroot}
#cp tack/COPYING LICENSE
echo "Ncurses is coveried by a variety of licenses, please see the " > LICENSE
echo "the source code for more information." >> LICENSE

%target_setup
cd %{_objdir}

%make GZIP='-9' install | tee -a ../build.log

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/lib
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses.so.5 %{buildroot}%{_hhl_cross_target_dir}/lib/libncurses.so.5
mv %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses.so.5.2 %{buildroot}%{_hhl_cross_target_dir}/lib/libncurses.so.5.2
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses.so
rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcurses.so
ln -s ../../lib/libncurses.so.5 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses.so
ln -s ../../lib/libncurses.so.5 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libcurses.so

cp lib/*_pic.a %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/.

gzip -9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/man/man1/tack.1

echo "%defattr(-,root,root)" > ncurses-base.filelist
echo "%defattr(-,root,root)" > ncurses-term.filelist
echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_data_dir}/tabset" >> ncurses-base.filelist
echo "%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/tabset/*" >> ncurses-base.filelist
echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_data_dir}/terminfo" >> ncurses-base.filelist
echo "%dir %{_hhl_cross_target_dir}%{_hhl_target_data_dir}/terminfo/*" >> ncurses-base.filelist

for i in `find %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/terminfo -type f | sed -e s,%{buildroot},,`; do
 case "$i" in \
 */ansi | \
 */dumb | \
 */linux | \
 */rxvt | \
 */screen | */screen-w | \
 */sun | \
 */vt100 | */vt102 | */vt220 | */vt52 | \
 */xterm | */xterm-color | */xterm-r5 | */xterm-r6 | */xterm-vt220 | \
 */xterm-xfree86) echo "%attr(0644,root,root) $i" >> ncurses-base.filelist;; \
 *) echo "%attr(0644,root,root) $i" >> ncurses-term.filelist;; \
 esac
done

# Install Library Optimizer information
%define _optdir %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo
install -d -m 755 %{_optdir}/ncurses
install -m 755 %{SOURCE1} %{_optdir}/ncurses/build

OBJECTDIR=`/bin/pwd`
NCURSESLIBPATH=/lib/libncurses.so.%{version}
(cd %{_optdir}/ncurses; umask 022; %{_hhl_target_toolprefix}ar x %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses_pic.a)
(cd %{_optdir}/ncurses; umask 022; %{_hhl_target_toolprefix}libindex %{buildroot}%{_hhl_cross_target_dir}$NCURSESLIBPATH *.o > index)
(umask 022; echo $NCURSESLIBPATH > %{_optdir}/ncurses/path)


install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-dbg
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE5} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-pic
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE6} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-libopt
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE7} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-bin
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE8} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-base
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE9} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-term

%clean
rm -rf %{buildroot}


%files -n libncurses
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libform.so.5
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libform.so.5.2
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libmenu.so.5
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libmenu.so.5.2
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpanel.so.5
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpanel.so.5.2
%{_hhl_cross_target_dir}/lib/libncurses.so.5
%{_hhl_cross_target_dir}/lib/libncurses.so.5.2
%doc ANNOUNCE NEWS README TO-DO build.log 
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses
%doc LICENSE

%files -n libncurses-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/*.h
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libncurses++.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libform.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libmenu.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libpanel.a
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/*

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-dev
%doc LICENSE

%files -n libncurses-dbg
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*_g.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*_p.a

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-dbg
%doc LICENSE

%files -n libncurses-pic
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/*_pic.a

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-pic
%doc LICENSE

%files -n libncurses-libopt
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/optinfo/ncurses
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libncurses-libopt


%files -n ncurses-bin
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/captoinfo
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/clear
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/infocmp
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/infotocap
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/reset
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tack
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tic
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/toe
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tput
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/tset
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man7/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-bin


%files -n ncurses-base -f %{_objdir}/ncurses-base.filelist
%defattr(-,root,root)
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-base


%files -n ncurses-term -f %{_objdir}/ncurses-term.filelist
%defattr(-,root,root)
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ncurses-term


%changelog
* Wed Feb 27 2002 Joe Green <source@mvista.com>
- Add support for "xtensa" architecture.

* Fri Apr 20 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files

* Thu Apr 12 2001 Joe Green <source@mvista.com>
- Added Library Optimizer information package.

* Wed Jan 24 2001 Mark Hatle <source@mvista.com>
- First cut


